/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import java.lang.reflect.Type;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Binding {
    static final Logger LOG = Logger.getInstance(Binding.class);
    protected final MutableAccessor myAccessor;

    protected Binding(MutableAccessor accessor) {
        this.myAccessor = accessor;
    }

    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/Binding", "getAccessor"));
        }
        return mutableAccessor;
    }

    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/Binding", "deserialize"));
        }
        return context;
    }

    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/Binding", "isBoundTo"));
        }
        return false;
    }

    void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/Binding", "init"));
        }
    }

    @Nullable
    public static Object deserializeList(@NotNull Binding binding, Object context, @NotNull List<Element> nodes) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/util/xmlb/Binding", "deserializeList"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/Binding", "deserializeList"));
        }
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)((Object)binding)).deserializeList(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserialize(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }
}

