var test = require('tap').test
var url = require('url')

// var server = require('./lib/server.js')
var Client = require('../')

test('defaulted initialization', function (t) {
  var client = new Client()
  var options = client.initialize(
    'http://localhost:1337/',
    'GET',
    'application/json',
    {}
  )

  t.equal(options.url, 'http://localhost:1337/', 'URLs match')
  t.equal(options.method, 'GET', 'methods match')
  t.equal(options.proxy, undefined, "proxy won't overwrite environment")
  t.equal(options.localAddress, undefined, 'localAddress has no default value')
  t.equal(options.strictSSL, true, 'SSL is strict by default')

  t.equal(options.headers.accept, 'application/json', 'accept header set')
  t.equal(
    options.headers.version,
    require('../package.json').version,
    'npm-registry-client version is present in headers'
  )
  t.ok(options.headers['npm-session'], 'request ID generated')
  t.ok(options.headers['user-agent'], 'user-agent preset')

  var HttpAgent = require('http').Agent
  t.ok(options.agent instanceof HttpAgent, 'got an HTTP agent for an HTTP URL')
  t.equal(options.agent.maxSockets, 50, 'maxSockets set to a reasonable default')

  t.end()
})

test('intializing with maxSockets set works for http', function (t) {
  var client = new Client({ maxSockets: Infinity })
  var options = client.initialize(
    url.parse('http://localhost:1337/'),
    'GET',
    'application/json',
    {}
  )

  var HttpAgent = require('http').Agent
  t.ok(options.agent instanceof HttpAgent, 'got an HTTP agent for an HTTP URL')
  t.equal(options.agent.maxSockets, Infinity, 'request uses configured value for maxSockets')

  t.end()
})

test('intializing with maxSockets set works for https', function (t) {
  var client = new Client({ maxSockets: Infinity })
  var options = client.initialize(
    url.parse('https://localhost:1337/'),
    'GET',
    'application/json',
    {}
  )

  var HttpsAgent = require('https').Agent
  t.ok(options.agent instanceof HttpsAgent, 'got an HTTPS agent for an HTTPS URL')
  t.equal(options.agent.maxSockets, Infinity, 'request uses configured value for maxSockets')

  t.end()
})

test('referer set on client', function (t) {
  var client = new Client()
  client.refer = 'xtestx'
  var options = client.initialize(
    'http://localhost:1337/',
    'GET',
    'application/json',
    {}
  )

  t.equal(options.headers.referer, 'xtestx', 'referer header set')

  t.end()
})

test('initializing with proxy explicitly disabled', function (t) {
  var client = new Client({ proxy: { http: false }})
  var options = client.initialize(
    'http://localhost:1337/',
    'GET',
    'application/json',
    {}
  )
  t.ok('proxy' in options, 'proxy overridden by explicitly setting to false')
  t.equal(options.proxy, null, 'request will override proxy when empty proxy passed in')
  t.end()
})

test('initializing with proxy undefined', function (t) {
  var client = new Client({ proxy: { http: undefined }})
  var options = client.initialize(
    'http://localhost:1337/',
    'GET',
    'application/json',
    {}
  )
  t.notOk('proxy' in options, 'proxy can be read from env.PROXY by request')
  t.end()
})

test('initializing with a certificate should map down to the https agent', function (t) {
  var certificate = '-----BEGIN CERTIFICATE----- TEST\nTEST -----END CERTIFICATE-----\n'
  var client = new Client({
    ssl: {
      certificate: certificate
    }
  })
  var options = client.initialize(
    { protocol: 'https:' },
    'GET',
    'application/json',
    {}
  )
  t.equal(options.agent.options.cert, certificate, 'certificate will be saved properly on agent')
  t.end()
})
