/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.CurveSegment;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;

public class ArcSegment
extends CurveSegment {
    private IomObject segment = null;
    private Coordinate startPoint = null;
    private Coordinate midPoint = null;
    private Coordinate endPoint = null;

    public ArcSegment(Coordinate startPoint, IomObject value) throws Iox2jtsException {
        double arcPt_ho;
        double arcPt_re;
        double pt2_ho;
        double pt2_re;
        this.startPoint = startPoint;
        this.segment = value;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        String a1 = value.getattrvalue("A1");
        String a2 = value.getattrvalue("A2");
        try {
            pt2_re = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            pt2_ho = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C2 <" + c2 + ">", ex);
        }
        try {
            arcPt_re = Double.parseDouble(a1);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read A1 <" + a1 + ">", ex);
        }
        try {
            arcPt_ho = Double.parseDouble(a2);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read A2 <" + a2 + ">", ex);
        }
        this.midPoint = new Coordinate(arcPt_re, arcPt_ho);
        this.endPoint = new Coordinate(pt2_re, pt2_ho);
    }

    @Override
    public Coordinate getEndPoint() throws Iox2jtsException {
        return this.endPoint;
    }

    @Override
    public Coordinate getStartPoint() throws Iox2jtsException {
        return this.startPoint;
    }

    private static double dist(double re1, double ho1, double re2, double ho2) {
        double ret = Math.hypot(re2 - re1, ho2 - ho1);
        return ret;
    }

    private void arc2straight(double p) throws Iox2jtsException {
        double pti_ho;
        double pti_re;
        int i;
        double ri;
        CoordinateList ret = new CoordinateList();
        Coordinate p1 = null;
        p1 = this.startPoint;
        double pt1_re = p1.x;
        double pt1_ho = p1.y;
        double arcPt_re = this.midPoint.x;
        double arcPt_ho = this.midPoint.y;
        double pt2_re = this.endPoint.x;
        double pt2_ho = this.endPoint.y;
        double a = ArcSegment.dist(pt1_re, pt1_ho, arcPt_re, arcPt_ho);
        double b = ArcSegment.dist(arcPt_re, arcPt_ho, pt2_re, pt2_ho);
        double c = ArcSegment.dist(pt1_re, pt1_ho, pt2_re, pt2_ho);
        double s = (a + b + c) / 2.0;
        double ds = Math.atan2(pt2_re - arcPt_re, pt2_ho - arcPt_ho) - Math.atan2(pt1_re - arcPt_re, pt1_ho - arcPt_ho);
        double rSign = Math.sin(ds) > 0.0 ? -1.0 : 1.0;
        double r = a * b * c / 4.0 / Math.sqrt(s * (s - a) * (s - b) * (s - c)) * rSign;
        double thetaM = Math.atan2(arcPt_re - pt1_re, arcPt_ho - pt1_ho) + Math.acos(a / 2.0 / r);
        double reM = pt1_re + r * Math.sin(thetaM);
        double hoM = pt1_ho + r * Math.cos(thetaM);
        double theta = 2.0 * Math.acos(1.0 - p / Math.abs(r));
        if (a > 2.0 * p) {
            double alpha = 2.0 * Math.asin(a / 2.0 / Math.abs(r));
            int alphan = (int)Math.ceil(alpha / theta);
            double alphai = alpha / (double)(alphan * (r > 0.0 ? 1 : -1));
            ri = Math.atan2(pt1_re - reM, pt1_ho - hoM);
            i = 1;
            while (i < alphan) {
                pti_re = reM + Math.abs(r) * Math.sin(ri += alphai);
                pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                ret.add((Object)new Coordinate(pti_re, pti_ho));
                ++i;
            }
        }
        ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
        if (b > 2.0 * p) {
            double beta = 2.0 * Math.asin(b / 2.0 / Math.abs(r));
            int betan = (int)Math.ceil(beta / theta);
            double betai = beta / (double)(betan * (r > 0.0 ? 1 : -1));
            ri = Math.atan2(arcPt_re - reM, arcPt_ho - hoM);
            i = 1;
            while (i < betan) {
                pti_re = reM + Math.abs(r) * Math.sin(ri += betai);
                pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                ret.add((Object)new Coordinate(pti_re, pti_ho));
                ++i;
            }
        }
        ret.add((Object)new Coordinate(pt2_re, pt2_ho));
    }
}

