/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.view.SingleColumnTableModel;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class PolicyManagerDialog
extends StandardFieldsDialog {
    private static final long serialVersionUID = 1L;
    private JButton addButton = null;
    private JButton modifyButton = null;
    private JButton removeButton = null;
    private JButton importButton = null;
    private JButton exportButton = null;
    private JTable paramsTable = null;
    private SingleColumnTableModel paramsModel = null;
    private ExtensionActiveScan extension;
    private static final Logger logger = Logger.getLogger(PolicyManagerDialog.class);

    public PolicyManagerDialog(Frame frame) {
        super(frame, "ascan.policymgr.title", new Dimension(512, 400));
    }

    public void init(ExtensionActiveScan extensionActiveScan) {
        this.extension = extensionActiveScan;
        this.removeAllFields();
        this.getParamsModel().setLines(extensionActiveScan.getPolicyManager().getAllPolicyNames());
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.getAddButton());
        arrayList.add(this.getModifyButton());
        arrayList.add(this.getRemoveButton());
        arrayList.add(this.getImportButton());
        arrayList.add(this.getExportButton());
        this.addTableField(this.getParamsTable(), arrayList);
    }

    @Override
    public boolean hasCancelSaveButtons() {
        return false;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicymgr";
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(Constant.messages.getString("ascan.policymgr.button.add"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this);
                    }
                    catch (ConfigurationException configurationException) {
                        logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getModifyButton() {
        if (this.modifyButton == null) {
            this.modifyButton = new JButton(Constant.messages.getString("ascan.policymgr.button.modify"));
            this.modifyButton.setEnabled(false);
            this.modifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (string != null) {
                        try {
                            PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this, string);
                        }
                        catch (ConfigurationException configurationException) {
                            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                        }
                    }
                }
            });
        }
        return this.modifyButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(Constant.messages.getString("ascan.policymgr.button.remove"));
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (string != null && View.getSingleton().showConfirmDialog(PolicyManagerDialog.this, Constant.messages.getString("ascan.policymgr.warn.delete")) == 0) {
                        PolicyManagerDialog.this.extension.getPolicyManager().deletePolicy(string);
                        PolicyManagerDialog.this.policyNamesChanged();
                    }
                }
            });
        }
        return this.removeButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(Constant.messages.getString("ascan.policymgr.button.import"));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(Constant.getZapHome());
                    jFileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            return file.isFile() && file.getName().endsWith(".policy");
                        }

                        @Override
                        public String getDescription() {
                            return Constant.messages.getString("file.format.zap.policy");
                        }
                    });
                    File file = null;
                    int n = jFileChooser.showOpenDialog(View.getSingleton().getMainFrame());
                    if (n == 0) {
                        file = jFileChooser.getSelectedFile();
                        if (file == null) {
                            return;
                        }
                        try {
                            PolicyManagerDialog.this.extension.getPolicyManager().importPolicy(file);
                            PolicyManagerDialog.this.policyNamesChanged();
                        }
                        catch (IOException | ConfigurationException throwable) {
                            logger.error((Object)throwable.getMessage(), throwable);
                            View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.load.error"));
                        }
                    }
                }
            });
        }
        return this.importButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton(Constant.messages.getString("ascan.policymgr.button.export"));
            this.exportButton.setEnabled(false);
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (string != null) {
                        JFileChooser jFileChooser = new JFileChooser(Constant.getPoliciesDir());
                        File file = new File(Constant.getZapHome(), string + ".policy");
                        jFileChooser.setSelectedFile(file);
                        jFileChooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                return file.isFile() && file.getName().endsWith(".policy");
                            }

                            @Override
                            public String getDescription() {
                                return Constant.messages.getString("file.format.zap.policy");
                            }
                        });
                        int n = jFileChooser.showSaveDialog(View.getSingleton().getMainFrame());
                        if (n == 0) {
                            file = jFileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            try {
                                ScanPolicy scanPolicy = PolicyManagerDialog.this.extension.getPolicyManager().getPolicy(string);
                                if (scanPolicy != null) {
                                    PolicyManagerDialog.this.extension.getPolicyManager().exportPolicy(scanPolicy, file);
                                }
                            }
                            catch (ConfigurationException configurationException) {
                                logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                                View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.load.error"));
                            }
                        }
                    }
                }
            });
        }
        return this.exportButton;
    }

    @Override
    public void save() {
    }

    @Override
    public String validateFields() {
        return null;
    }

    private SingleColumnTableModel getParamsModel() {
        if (this.paramsModel == null) {
            this.paramsModel = new SingleColumnTableModel(Constant.messages.getString("ascan.policymgr.table.policy"));
            this.paramsModel.setEditable(false);
        }
        return this.paramsModel;
    }

    private JTable getParamsTable() {
        if (this.paramsTable == null) {
            this.paramsTable = new JTable();
            this.paramsTable.setModel(this.getParamsModel());
            this.paramsTable.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    String string;
                    int n;
                    if (mouseEvent.getClickCount() >= 2 && (n = PolicyManagerDialog.this.paramsTable.rowAtPoint(mouseEvent.getPoint())) >= 0 && (string = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(n, 0)) != null) {
                        try {
                            PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this, string);
                        }
                        catch (ConfigurationException configurationException) {
                            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            this.paramsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (PolicyManagerDialog.this.getParamsTable().getSelectedRowCount() == 0) {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(false);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(false);
                        PolicyManagerDialog.this.getExportButton().setEnabled(false);
                    } else if (PolicyManagerDialog.this.getParamsTable().getSelectedRowCount() == 1) {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(true);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(PolicyManagerDialog.this.getParamsModel().getRowCount() > 1);
                        PolicyManagerDialog.this.getExportButton().setEnabled(true);
                    } else {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(false);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(false);
                        PolicyManagerDialog.this.getExportButton().setEnabled(false);
                    }
                }
            });
        }
        return this.paramsTable;
    }

    protected void policyNamesChanged() {
        this.getParamsModel().setLines(this.extension.getPolicyManager().getAllPolicyNames());
    }
}

