/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz;

import org.owasp.jbrofuzz.fuzz.SocketConnection;

class SocketTimer
extends Thread {
    private static final int m_rate = 127;
    private final transient int m_length;
    private transient int tElapsed;
    private final transient SocketConnection sConnection;

    protected SocketTimer(SocketConnection sConnection, int timeInMS) {
        this.sConnection = sConnection;
        this.m_length = timeInMS;
        this.tElapsed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        SocketTimer socketTimer = this;
        synchronized (socketTimer) {
            this.tElapsed = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(127L);
            }
            catch (InterruptedException ioe) {
                continue;
            }
            SocketTimer socketTimer = this;
            synchronized (socketTimer) {
                this.tElapsed += 127;
                if (this.tElapsed > this.m_length) {
                    this.sConnection.close();
                    break;
                }
            }
        }
    }
}

