#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * SwCollectionsIface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _SwCollectionsIface SwCollectionsIface;

/**
 * SwCollectionsIfaceClass:
 *
 * The class of SwCollectionsIface.
 */
typedef struct _SwCollectionsIfaceClass SwCollectionsIfaceClass;

GType sw_collections_iface_get_type (void);
#define SW_TYPE_COLLECTIONS_IFACE \
  (sw_collections_iface_get_type ())
#define SW_COLLECTIONS_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), SW_TYPE_COLLECTIONS_IFACE, SwCollectionsIface))
#define SW_IS_COLLECTIONS_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), SW_TYPE_COLLECTIONS_IFACE))
#define SW_COLLECTIONS_IFACE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), SW_TYPE_COLLECTIONS_IFACE, SwCollectionsIfaceClass))


typedef void (*sw_collections_iface_get_list_impl) (SwCollectionsIface *self,
    DBusGMethodInvocation *context);
void sw_collections_iface_implement_get_list (SwCollectionsIfaceClass *klass, sw_collections_iface_get_list_impl impl);
/**
 * sw_collections_iface_return_from_get_list:
 * @context: The D-Bus method invocation context
 * @out_collection_list: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_collections_iface_return_from_get_list (DBusGMethodInvocation *context,
    const GPtrArray *out_collection_list);
static inline void
sw_collections_iface_return_from_get_list (DBusGMethodInvocation *context,
    const GPtrArray *out_collection_list)
{
  dbus_g_method_return (context,
      out_collection_list);
}

typedef void (*sw_collections_iface_get_details_impl) (SwCollectionsIface *self,
    const gchar *in_collection_id,
    DBusGMethodInvocation *context);
void sw_collections_iface_implement_get_details (SwCollectionsIfaceClass *klass, sw_collections_iface_get_details_impl impl);
/**
 * sw_collections_iface_return_from_get_details:
 * @context: The D-Bus method invocation context
 * @out_collection_details: const GValueArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_collections_iface_return_from_get_details (DBusGMethodInvocation *context,
    const GValueArray *out_collection_details);
static inline void
sw_collections_iface_return_from_get_details (DBusGMethodInvocation *context,
    const GValueArray *out_collection_details)
{
  dbus_g_method_return (context,
      out_collection_details);
}

typedef void (*sw_collections_iface_create_impl) (SwCollectionsIface *self,
    const gchar *in_collection_name,
    guint in_supported_types,
    const gchar *in_collection_parent,
    GHashTable *in_extra_parameters,
    DBusGMethodInvocation *context);
void sw_collections_iface_implement_create (SwCollectionsIfaceClass *klass, sw_collections_iface_create_impl impl);
/**
 * sw_collections_iface_return_from_create:
 * @context: The D-Bus method invocation context
 * @out_collection_id: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_collections_iface_return_from_create (DBusGMethodInvocation *context,
    const gchar *out_collection_id);
static inline void
sw_collections_iface_return_from_create (DBusGMethodInvocation *context,
    const gchar *out_collection_id)
{
  dbus_g_method_return (context,
      out_collection_id);
}

typedef void (*sw_collections_iface_get_creatable_types_impl) (SwCollectionsIface *self,
    DBusGMethodInvocation *context);
void sw_collections_iface_implement_get_creatable_types (SwCollectionsIfaceClass *klass, sw_collections_iface_get_creatable_types_impl impl);
/**
 * sw_collections_iface_return_from_get_creatable_types:
 * @context: The D-Bus method invocation context
 * @out_media_types_list: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_collections_iface_return_from_get_creatable_types (DBusGMethodInvocation *context,
    const GArray *out_media_types_list);
static inline void
sw_collections_iface_return_from_get_creatable_types (DBusGMethodInvocation *context,
    const GArray *out_media_types_list)
{
  dbus_g_method_return (context,
      out_media_types_list);
}



G_END_DECLS
