/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transport.http.ApacheDirectoryListingParser;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResourceLister
implements ExternalResourceLister {
    private HttpResourceAccessor accessor;

    public HttpResourceLister(HttpResourceAccessor accessor) {
        this.accessor = accessor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> list(URI directory) {
        HttpResponseResource response = this.accessor.openResource(directory);
        if (response == null) {
            return null;
        }
        try {
            try {
                String contentType = response.getMetaData().getContentType();
                ApacheDirectoryListingParser directoryListingParser = new ApacheDirectoryListingParser();
                InputStream inputStream = response.openStream();
                try {
                    List<String> list = directoryListingParser.parse(directory, inputStream, contentType);
                    return list;
                }
                catch (Exception e) {
                    throw new ResourceException(directory, String.format("Unable to parse HTTP directory listing for '%s'.", directory), (Throwable)e);
                }
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed((URI)directory, (Throwable)e);
        }
    }
}

