/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, PutMappingResponse> {
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public TransportPutMappingAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutMappingRequest.class);
        this.metaDataMappingService = metaDataMappingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected PutMappingResponse newResponse() {
        return new PutMappingResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndices(state, request));
    }

    @Override
    protected void masterOperation(final PutMappingRequest request, ClusterState state, final ActionListener<PutMappingResponse> listener) {
        try {
            final String[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
            PutMappingClusterStateUpdateRequest updateRequest = ((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).type(request.type()).updateAllTypes(request.updateAllTypes()).source(request.source());
            this.metaDataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                @Override
                public void onResponse(ClusterStateUpdateResponse response) {
                    listener.onResponse(new PutMappingResponse(response.isAcknowledged()));
                }

                @Override
                public void onFailure(Throwable t) {
                    TransportPutMappingAction.this.logger.debug("failed to put mappings on indices [{}], type [{}]", t, concreteIndices, request.type());
                    listener.onFailure(t);
                }
            });
        }
        catch (IndexNotFoundException ex) {
            this.logger.debug("failed to put mappings on indices [{}], type [{}]", ex, request.indices(), request.type());
            throw ex;
        }
    }
}

