/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexResponse
extends ActionWriteResponse {
    private String index;
    private String id;
    private String type;
    private long version;
    private boolean created;

    public IndexResponse() {
    }

    public IndexResponse(String index, String type, String id, long version, boolean created) {
        this.index = index;
        this.id = id;
        this.type = type;
        this.version = version;
        this.created = created;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.version = in.readLong();
        this.created = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.created);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.index);
        builder.append(",type=").append(this.type);
        builder.append(",id=").append(this.id);
        builder.append(",version=").append(this.version);
        builder.append(",created=").append(this.created);
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }
}

