/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.BufferSegment;

class ContentManager {
    private static final char[] EMPTY_TEXT = new char[0];
    private char[] text = EMPTY_TEXT;
    private int gapStart;
    private int length;

    ContentManager() {
    }

    public final int getLength() {
        return this.length;
    }

    public String getText(int n, int n2) {
        if (n >= this.gapStart) {
            return new String(this.text, n + this.gapLength(), n2);
        }
        if (n + n2 <= this.gapStart) {
            return new String(this.text, n, n2);
        }
        return new String(this.text, n, this.gapStart - n).concat(new String(this.text, this.gapEnd(), n + n2 - this.gapStart));
    }

    public void getText(int n, int n2, Segment segment) {
        if (n >= this.gapStart) {
            segment.array = this.text;
            segment.offset = n + this.gapLength();
            segment.count = n2;
        } else if (n + n2 <= this.gapStart) {
            segment.array = this.text;
            segment.offset = n;
            segment.count = n2;
        } else {
            segment.array = new char[n2];
            System.arraycopy(this.text, n, segment.array, 0, this.gapStart - n);
            System.arraycopy(this.text, this.gapEnd(), segment.array, this.gapStart - n, n2 + n - this.gapStart);
            segment.offset = 0;
            segment.count = n2;
        }
    }

    public CharSequence getSegment(int n, int n2) {
        if (n >= this.gapStart) {
            return new BufferSegment(this.text, n + this.gapLength(), n2);
        }
        if (n + n2 <= this.gapStart) {
            return new BufferSegment(this.text, n, n2);
        }
        return new BufferSegment(this.text, n, this.gapStart - n, new BufferSegment(this.text, this.gapEnd(), n + n2 - this.gapStart));
    }

    public void insert(int n, String string) {
        int n2 = string.length();
        this.prepareGapForInsertion(n, n2);
        string.getChars(0, n2, this.text, n);
        this.gapStart += n2;
        this.length += n2;
    }

    public void insert(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        this.prepareGapForInsertion(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.text[n + i] = charSequence.charAt(i);
        }
        this.gapStart += n2;
        this.length += n2;
    }

    public void insert(int n, Segment segment) {
        this.prepareGapForInsertion(n, segment.count);
        System.arraycopy(segment.array, segment.offset, this.text, n, segment.count);
        this.gapStart += segment.count;
        this.length += segment.count;
    }

    public void _setContent(char[] cArray, int n) {
        assert (cArray != null);
        assert (cArray.length >= n);
        this.text = cArray;
        this.gapStart = n;
        this.length = n;
    }

    public void remove(int n, int n2) {
        this.moveGapStart(n);
        this.length -= n2;
    }

    private int gapEnd() {
        return this.gapStart + this.gapLength();
    }

    private int gapLength() {
        return this.text.length - this.length;
    }

    private void moveGapStart(int n) {
        int n2 = this.gapEnd();
        int n3 = n2 + (n - this.gapStart);
        if (n != this.gapStart) {
            if (n > this.gapStart) {
                System.arraycopy(this.text, n2, this.text, this.gapStart, n - this.gapStart);
            } else if (n < this.gapStart) {
                System.arraycopy(this.text, n, this.text, n3, this.gapStart - n);
            }
        }
        this.gapStart = n;
    }

    private void ensureCapacity(int n) {
        if (n >= this.text.length) {
            int n2 = this.gapEnd();
            char[] cArray = new char[n * 2];
            System.arraycopy(this.text, 0, cArray, 0, this.text.length);
            this.text = cArray;
            int n3 = this.gapEnd();
            System.arraycopy(this.text, n2, this.text, n3, this.text.length - n3);
        }
    }

    private void prepareGapForInsertion(int n, int n2) {
        this.moveGapStart(n);
        if (this.gapLength() < n2) {
            this.ensureCapacity(this.length + n2);
        }
    }
}

