/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpproceduraldb_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_PROCEDURAL_DB_PDB_H__
#define __GIMP_PROCEDURAL_DB_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gchar*                   gimp_procedural_db_temp_name     (void);
gboolean                 gimp_procedural_db_dump          (const gchar       *filename);
gboolean                 gimp_procedural_db_query         (const gchar       *name,
                                                           const gchar       *blurb,
                                                           const gchar       *help,
                                                           const gchar       *author,
                                                           const gchar       *copyright,
                                                           const gchar       *date,
                                                           const gchar       *proc_type,
                                                           gint              *num_matches,
                                                           gchar           ***procedure_names);
gboolean                 gimp_procedural_db_proc_exists   (const gchar       *procedure_name);
G_GNUC_INTERNAL gboolean _gimp_procedural_db_proc_info    (const gchar       *procedure_name,
                                                           gchar            **blurb,
                                                           gchar            **help,
                                                           gchar            **author,
                                                           gchar            **copyright,
                                                           gchar            **date,
                                                           GimpPDBProcType   *proc_type,
                                                           gint              *num_args,
                                                           gint              *num_values);
gboolean                 gimp_procedural_db_proc_arg      (const gchar       *procedure_name,
                                                           gint               arg_num,
                                                           GimpPDBArgType    *arg_type,
                                                           gchar            **arg_name,
                                                           gchar            **arg_desc);
gboolean                 gimp_procedural_db_proc_val      (const gchar       *procedure_name,
                                                           gint               val_num,
                                                           GimpPDBArgType    *val_type,
                                                           gchar            **val_name,
                                                           gchar            **val_desc);
G_GNUC_INTERNAL gboolean _gimp_procedural_db_get_data     (const gchar       *identifier,
                                                           gint              *bytes,
                                                           guint8           **data);
gint                     gimp_procedural_db_get_data_size (const gchar       *identifier);
G_GNUC_INTERNAL gboolean _gimp_procedural_db_set_data     (const gchar       *identifier,
                                                           gint               bytes,
                                                           const guint8      *data);


G_END_DECLS

#endif /* __GIMP_PROCEDURAL_DB_PDB_H__ */
