/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;
import sun.nio.cs.US_ASCII;

public class FastCharsetProvider
extends CharsetProvider {
    private Map<String, String> classMap;
    private Map<String, String> aliasMap;
    private Map<String, Charset> cache;
    private String packagePrefix;

    protected FastCharsetProvider(String pp, Map<String, String> am, Map<String, String> cm, Map<String, Charset> c) {
        this.packagePrefix = pp;
        this.aliasMap = am;
        this.classMap = cm;
        this.cache = c;
    }

    private String canonicalize(String csn) {
        String acn = this.aliasMap.get(csn);
        return acn != null ? acn : csn;
    }

    private static String toLower(String s) {
        int n = s.length();
        boolean allLower = true;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ((c - 65 | 90 - c) < 0) continue;
            allLower = false;
            break;
        }
        if (allLower) {
            return s;
        }
        char[] ca = new char[n];
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            ca[i] = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : (char)c;
        }
        return new String(ca);
    }

    private Charset lookup(String charsetName) {
        String csn = this.canonicalize(FastCharsetProvider.toLower(charsetName));
        Charset cs = this.cache.get(csn);
        if (cs != null) {
            return cs;
        }
        String cln = this.classMap.get(csn);
        if (cln == null) {
            return null;
        }
        if (cln.equals("US_ASCII")) {
            cs = new US_ASCII();
            this.cache.put(csn, cs);
            return cs;
        }
        try {
            Class<?> c = Class.forName(this.packagePrefix + "." + cln, true, this.getClass().getClassLoader());
            cs = (Charset)c.newInstance();
            this.cache.put(csn, cs);
            return cs;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
        catch (IllegalAccessException x) {
            return null;
        }
        catch (InstantiationException x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Charset charsetForName(String charsetName) {
        FastCharsetProvider fastCharsetProvider = this;
        synchronized (fastCharsetProvider) {
            return this.lookup(this.canonicalize(charsetName));
        }
    }

    @Override
    public final Iterator<Charset> charsets() {
        return new Iterator<Charset>(){
            Iterator<String> i;
            {
                this.i = FastCharsetProvider.this.classMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Charset next() {
                String csn = this.i.next();
                return FastCharsetProvider.this.lookup(csn);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

