/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.net.URL;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;

class LocateJnlpClassLoader {
    LocateJnlpClassLoader() {
    }

    static JNLPClassLoader getLoaderByJnlpFile(JNLPClassLoader rootClassLoader, URL urlToJnlpFile) {
        if (rootClassLoader == null) {
            return null;
        }
        JNLPFile file = rootClassLoader.getJNLPFile();
        if (urlToJnlpFile == null) {
            urlToJnlpFile = rootClassLoader.getJNLPFile().getFileLocation();
        }
        if (file.getFileLocation().equals(urlToJnlpFile)) {
            return rootClassLoader;
        }
        for (JNLPClassLoader loader : rootClassLoader.getLoaders()) {
            JNLPClassLoader foundLoader;
            if (rootClassLoader == loader || (foundLoader = LocateJnlpClassLoader.getLoaderByJnlpFile(loader, urlToJnlpFile)) == null) continue;
            return foundLoader;
        }
        return null;
    }

    static JNLPClassLoader getLoaderByResourceUrl(JNLPClassLoader rootClassLoader, URL ref, String version) {
        Version resourceVersion = version == null ? null : new Version(version);
        for (JNLPClassLoader loader : rootClassLoader.getLoaders()) {
            ResourcesDesc resources = loader.getJNLPFile().getResources();
            for (JARDesc eachJar : resources.getJARs()) {
                if (!ref.equals(eachJar.getLocation()) || resourceVersion != null && !resourceVersion.equals(eachJar.getVersion())) continue;
                return loader;
            }
        }
        for (JNLPClassLoader loader : rootClassLoader.getLoaders()) {
            JNLPClassLoader foundLoader;
            if (rootClassLoader == loader || (foundLoader = LocateJnlpClassLoader.getLoaderByResourceUrl(loader, ref, version)) == null) continue;
            return foundLoader;
        }
        return null;
    }
}

