/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.RegistryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterInfoReader {
    private static final String TAG_CONVERTER = "converter";
    private static final String ATTRIB_OFFICE_TYPE = "type";
    private static final String ATTRIB_VERSION = "version";
    private static final String TAG_NAME = "converter-display-name";
    private static final String TAG_DESC = "converter-description";
    private static final String TAG_VENDOR = "converter-vendor";
    private static final String TAG_CLASS_IMPL = "converter-class-impl";
    private static final String TAG_TARGET = "converter-target";
    private static final String ATTRIB_DEVICE_TYPE = "type";
    private static final String TAG_XSLT_DESERIAL = "converter-xslt-deserialize";
    private static final String TAG_XSLT_SERIAL = "converter-xslt-serialize";
    private final String jarfilename;
    private final Document document;
    private final ArrayList<ConverterInfo> converterInfoList = new ArrayList();

    public ConverterInfoReader(String jar, boolean shouldvalidate) throws IOException, ParserConfigurationException, SAXException, RegistryException {
        this.jarfilename = jar;
        URL url = new URL("jar:" + jar + "!/META-INF/converter.xml");
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        JarEntry jarentry = jarConnection.getJarEntry();
        JarFile jarfile = jarConnection.getJarFile();
        InputStream istream = jarfile.getInputStream(jarentry);
        InputSource isource = new InputSource(istream);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        if (shouldvalidate) {
            System.out.println("Validating xml...");
            builderFactory.setValidating(true);
        }
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this.document = builder.parse(isource);
        this.parseDocument();
    }

    private void parseDocument() throws RegistryException {
        NodeList converterNodes = this.document.getElementsByTagName(TAG_CONVERTER);
        for (int i = 0; i < converterNodes.getLength(); ++i) {
            Node converterNode = converterNodes.item(i);
            if (converterNode.getNodeType() != 1) continue;
            this.parseConverterNode((Element)converterNode);
        }
    }

    private void parseConverterNode(Element e) throws RegistryException {
        String officeMime = null;
        ArrayList<String> deviceMime = new ArrayList<String>();
        String name = null;
        String desc = null;
        String version = null;
        String vendor = null;
        String classImpl = null;
        String xsltSerial = null;
        String xsltDeserial = null;
        String temp = e.getAttribute("type");
        if (temp.length() != 0) {
            officeMime = temp;
        }
        if ((temp = e.getAttribute(ATTRIB_VERSION)).length() != 0) {
            version = temp;
        }
        NodeList detailNodes = e.getChildNodes();
        for (int i = 0; i < detailNodes.getLength(); ++i) {
            Node detailNode = detailNodes.item(i);
            if (detailNode.getNodeType() != 1) continue;
            Element detailElement = (Element)detailNode;
            String elementTagName = detailElement.getTagName();
            if (TAG_NAME.equalsIgnoreCase(elementTagName)) {
                name = this.getTextValue(detailElement);
                continue;
            }
            if (TAG_DESC.equalsIgnoreCase(elementTagName)) {
                desc = this.getTextValue(detailElement);
                continue;
            }
            if (TAG_VENDOR.equalsIgnoreCase(elementTagName)) {
                vendor = this.getTextValue(detailElement);
                continue;
            }
            if (TAG_XSLT_SERIAL.equalsIgnoreCase(elementTagName)) {
                xsltSerial = this.getTextValue(detailElement);
                continue;
            }
            if (TAG_XSLT_DESERIAL.equalsIgnoreCase(elementTagName)) {
                xsltDeserial = this.getTextValue(detailElement);
                continue;
            }
            if (TAG_CLASS_IMPL.equalsIgnoreCase(elementTagName)) {
                classImpl = this.getTextValue(detailElement);
                continue;
            }
            if (!TAG_TARGET.equalsIgnoreCase(elementTagName) || (temp = detailElement.getAttribute("type")).length() == 0) continue;
            deviceMime.add(temp);
        }
        ConverterInfo converterInfo = xsltSerial == null || xsltDeserial == null ? new ConverterInfo(this.jarfilename, officeMime, deviceMime, name, desc, version, vendor, classImpl) : new ConverterInfo(this.jarfilename, officeMime, deviceMime, name, desc, version, vendor, classImpl, xsltSerial, xsltDeserial);
        this.converterInfoList.add(converterInfo);
    }

    private String getTextValue(Element e) {
        NodeList tempNodes = e.getChildNodes();
        String text = null;
        for (int j = 0; j < tempNodes.getLength(); ++j) {
            Node tempNode = tempNodes.item(j);
            if (tempNode.getNodeType() != 3) continue;
            text = tempNode.getNodeValue().trim();
            break;
        }
        return text;
    }

    public Iterator<ConverterInfo> getConverterInfoEnumeration() {
        return this.converterInfoList.iterator();
    }
}

