/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
Preferences.PreferenceChangedListener,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    public static boolean fireDeprecatedListenerOnAdd;
    public boolean viewportFollowing;
    private final MainLayerManager layerManager;
    public transient PlayHeadMarker playHeadMarker;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private final transient Set<MapViewPaintable> temporaryLayers = new LinkedHashSet<MapViewPaintable>();
    private transient BufferedImage nonChangedLayersBuffer;
    private transient BufferedImage offscreenBuffer;
    private final transient List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private transient Layer changedLayer;
    private int lastViewID;
    private boolean paintPreferencesChanged = true;
    private Rectangle lastClipBounds = new Rectangle();
    private transient MapMover mapMover;
    private final LayerInvalidatedListener invalidatedListener = new LayerInvalidatedListener();
    private final HashMap<Layer, MapViewPaintable.LayerPainter> registeredLayers = new HashMap();
    private Dimension oldSize;
    private Point oldLoc;
    private boolean virtualNodesEnabled;
    private final transient SelectionChangedListener repaintSelectionChangedListener = new SelectionChangedListener(){

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            MapView.this.repaint();
        }
    };
    private final transient CopyOnWriteArrayList<RepaintListener> repaintListeners = new CopyOnWriteArrayList();

    @Deprecated
    public static void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        block5: {
            LayerChangeAdapter layerChangeAdapter;
            block4: {
                layerChangeAdapter = new LayerChangeAdapter(layerChangeListener);
                try {
                    Main.getLayerManager().removeLayerChangeListener(layerChangeAdapter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Main.isDebugEnabled()) break block4;
                    Main.debug(illegalArgumentException.getMessage());
                }
            }
            try {
                Main.getLayerManager().removeActiveLayerChangeListener(layerChangeAdapter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!Main.isDebugEnabled()) break block5;
                Main.debug(illegalArgumentException.getMessage());
            }
        }
    }

    @Deprecated
    public static void removeEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        block2: {
            try {
                Main.getLayerManager().removeActiveLayerChangeListener(new EditLayerChangeAdapter(editLayerChangeListener));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!Main.isDebugEnabled()) break block2;
                Main.debug(illegalArgumentException.getMessage());
            }
        }
    }

    @Deprecated
    public static void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (fireDeprecatedListenerOnAdd) {
            Main.warn("Plugin seems to be adding listener during mapFrameInitialized(): " + BugReport.getCallingMethod(2) + ". Layer listeners should be set on plugin load.");
        }
        MapView.addLayerChangeListener(layerChangeListener, fireDeprecatedListenerOnAdd);
    }

    @Deprecated
    public static void addLayerChangeListener(LayerChangeListener layerChangeListener, boolean bl) {
        if (layerChangeListener != null) {
            bl = bl && (Main.isDisplayingMapView() || fireDeprecatedListenerOnAdd);
            LayerChangeAdapter layerChangeAdapter = new LayerChangeAdapter(layerChangeListener, bl);
            Main.getLayerManager().addLayerChangeListener(layerChangeAdapter, bl);
            if (bl) {
                Main.getLayerManager().addAndFireActiveLayerChangeListener(layerChangeAdapter);
            } else {
                Main.getLayerManager().addActiveLayerChangeListener(layerChangeAdapter);
            }
            layerChangeAdapter.receiveOneInitialFire = false;
        }
    }

    @Deprecated
    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener, boolean bl) {
        if (editLayerChangeListener != null) {
            boolean bl2;
            boolean bl3 = bl2 = bl && Main.isDisplayingMapView() && Main.getLayerManager().getEditLayer() != null;
            if (bl2) {
                Main.getLayerManager().addAndFireActiveLayerChangeListener(new EditLayerChangeAdapter(editLayerChangeListener));
            } else {
                Main.getLayerManager().addActiveLayerChangeListener(new EditLayerChangeAdapter(editLayerChangeListener));
            }
        }
    }

    @Deprecated
    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        MapView.addEditLayerChangeListener(editLayerChangeListener, false);
    }

    public MapView(MainLayerManager mainLayerManager, final JPanel jPanel, ViewportData viewportData) {
        this.layerManager = mainLayerManager;
        this.initialViewport = viewportData;
        mainLayerManager.addLayerChangeListener(this, true);
        mainLayerManager.addActiveLayerChangeListener(this);
        Main.pref.addPreferenceChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapView.this.mapMover = new MapMover(MapView.this, jPanel);
            }
        });
        DataSet.addSelectionListener(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MapView.this.requestFocus();
            }
        });
        if (Shortcut.findShortcut(9, 0) != null) {
            this.setFocusTraversalKeysEnabled(false);
        }
        for (JComponent jComponent : MapView.getMapNavigationComponents(this)) {
            this.add(jComponent);
        }
    }

    public static List<? extends JComponent> getMapNavigationComponents(MapView mapView) {
        MapSlider mapSlider = new MapSlider(mapView);
        Dimension dimension = mapSlider.getPreferredSize();
        mapSlider.setSize(dimension);
        mapSlider.setLocation(3, 0);
        mapSlider.setFocusTraversalKeysEnabled(Shortcut.findShortcut(9, 0) == null);
        MapScaler mapScaler = new MapScaler(mapView);
        mapScaler.setPreferredLineLength(dimension.width - 10);
        mapScaler.setSize(mapScaler.getPreferredSize());
        mapScaler.setLocation(3, dimension.height);
        return Arrays.asList(mapSlider, mapScaler);
    }

    public void rememberLastPositionOnScreen() {
        this.oldSize = this.getSize();
        this.oldLoc = this.getLocationOnScreen();
    }

    @Deprecated
    public void addLayer(Layer layer) {
        this.layerManager.addLayer(layer);
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
        try {
            Layer layer = layerAddEvent.getAddedLayer();
            this.registeredLayers.put(layer, new WarningLayerPainter(layer));
            MapViewPaintable.LayerPainter layerPainter = layer.attachToMapView(new MapViewPaintable.MapViewEvent(this, false));
            if (!this.registeredLayers.containsKey(layer)) {
                Main.warn("Layer was removed during attachToMapView()");
            } else {
                this.registeredLayers.put(layer, layerPainter);
                ProjectionBounds projectionBounds = layer.getViewProjectionBounds();
                if (projectionBounds != null) {
                    this.scheduleZoomTo(new ViewportData(projectionBounds));
                }
                layer.addPropertyChangeListener(this);
                Main.addProjectionChangeListener(layer);
                this.invalidatedListener.addTo(layer);
                AudioPlayer.reset();
                this.repaint();
            }
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("layer", layerAddEvent.getAddedLayer());
        }
    }

    @Override
    @Deprecated
    protected DataSet getCurrentDataSet() {
        return this.layerManager.getEditDataSet();
    }

    public boolean isActiveLayerDrawable() {
        return this.getEditLayer() != null;
    }

    public boolean isActiveLayerVisible() {
        OsmDataLayer osmDataLayer = this.getEditLayer();
        return osmDataLayer != null && osmDataLayer.isVisible();
    }

    @Deprecated
    protected Layer determineNextActiveLayer(List<Layer> list) {
        for (Layer layer : list) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Deprecated
    public void removeLayer(Layer layer) {
        this.layerManager.removeLayer(layer);
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        Layer layer = layerRemoveEvent.getRemovedLayer();
        MapViewPaintable.LayerPainter layerPainter = this.registeredLayers.remove(layer);
        if (layerPainter == null) {
            Main.error("The painter for layer " + layer + " was not registered.");
            return;
        }
        layerPainter.detachFromMapView(new MapViewPaintable.MapViewEvent(this, false));
        Main.removeProjectionChangeListener(layer);
        layer.removePropertyChangeListener(this);
        this.invalidatedListener.removeFrom(layer);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        this.layerManager.moveLayer(layer, n);
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        AudioPlayer.reset();
        this.repaint();
    }

    @Deprecated
    public int getLayerPos(Layer layer) {
        int n = this.layerManager.getLayers().indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        return n;
    }

    @Deprecated
    public List<Layer> getVisibleLayersInZOrder() {
        return this.layerManager.getVisibleLayersInZOrder();
    }

    private void paintLayer(Layer layer, Graphics2D graphics2D, Bounds bounds) {
        try {
            MapViewPaintable.LayerPainter layerPainter = this.registeredLayers.get(layer);
            if (layerPainter == null) {
                throw new IllegalArgumentException("Cannot paint layer, it is not registered.");
            }
            MapViewState.MapViewRectangle mapViewRectangle = this.getState().getViewArea(graphics2D.getClipBounds());
            MapViewGraphics mapViewGraphics = new MapViewGraphics(this, graphics2D, mapViewRectangle);
            if (layer.getOpacity() < 1.0) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
            }
            layerPainter.paint(mapViewGraphics);
            graphics2D.setPaintMode();
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("layer", layer).put("bounds", bounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics graphics) {
        double d;
        int n;
        int d2;
        Graphics2D object3;
        boolean bl;
        if (!this.prepareToDraw()) {
            return;
        }
        List<Layer> list = this.layerManager.getVisibleLayersInZOrder();
        int n3 = 0;
        for (Layer object2 : list) {
            if (object2.isChanged() || object2 == this.changedLayer) break;
            ++n3;
        }
        MapView i = this;
        synchronized (i) {
            bl = !this.paintPreferencesChanged;
            this.paintPreferencesChanged = false;
        }
        boolean bl2 = bl = bl && this.nonChangedLayers.size() <= n3 && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(graphics.getClipBounds());
        if (bl) {
            void var5_9;
            boolean graphics2D2 = false;
            while (var5_9 < this.nonChangedLayers.size()) {
                if (list.get((int)var5_9) != this.nonChangedLayers.get((int)var5_9)) {
                    bl = false;
                    break;
                }
                ++var5_9;
            }
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(graphics.getClip());
        Bounds bounds = this.getLatLonBounds(graphics.getClipBounds());
        if (!bl || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != this.getWidth() || this.nonChangedLayersBuffer.getHeight() != this.getHeight()) {
                this.nonChangedLayersBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            }
            object3 = this.nonChangedLayersBuffer.createGraphics();
            object3.setClip(graphics.getClip());
            object3.setColor(PaintColors.getBackgroundColor());
            object3.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (d2 = 0; d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), object3, bounds);
            }
        } else if (this.nonChangedLayers.size() != n3) {
            object3 = this.nonChangedLayersBuffer.createGraphics();
            object3.setClip(graphics.getClip());
            for (d2 = this.nonChangedLayers.size(); d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), object3, bounds);
            }
        }
        this.nonChangedLayers.clear();
        this.changedLayer = null;
        for (n = 0; n < n3; ++n) {
            this.nonChangedLayers.add(list.get(n));
        }
        this.lastViewID = this.getViewID();
        this.lastClipBounds = graphics.getClipBounds();
        graphics2D.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        for (n = n3; n < list.size(); ++n) {
            this.paintLayer(list.get(n), graphics2D, bounds);
        }
        Object object = this.temporaryLayers;
        synchronized (object) {
            for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
                mapViewPaintable.paint(graphics2D, this, bounds);
            }
        }
        graphics2D.setColor(Color.WHITE);
        object = this.getProjection().getWorldBoundsLatLon();
        double d3 = ((Bounds)object).getMinLon();
        Point point = this.getPoint(((Bounds)object).getMin());
        GeneralPath generalPath = new GeneralPath();
        double d4 = 1.0;
        generalPath.moveTo(point.x, point.y);
        double d5 = ((Bounds)object).getMax().lat();
        for (d = ((Bounds)object).getMinLat(); d <= d5; d += d4) {
            point = this.getPoint(new LatLon(d >= d5 ? d5 : d, d3));
            generalPath.lineTo(point.x, point.y);
        }
        d = d5;
        d5 = ((Bounds)object).getMax().lon();
        while (d3 <= d5) {
            point = this.getPoint(new LatLon(d, d3 >= d5 ? d5 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 += d4;
        }
        d3 = d5;
        d5 = ((Bounds)object).getMinLat();
        while (d >= d5) {
            point = this.getPoint(new LatLon(d <= d5 ? d5 : d, d3));
            generalPath.lineTo(point.x, point.y);
            d -= d4;
        }
        d = d5;
        d5 = ((Bounds)object).getMinLon();
        while (d3 >= d5) {
            point = this.getPoint(new LatLon(d, d3 <= d5 ? d5 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 -= d4;
        }
        int n2 = this.getWidth();
        int n4 = this.getHeight();
        Area area = new Area(generalPath);
        Area area2 = new Area(new Rectangle(-1, -1, n2 + 2, n4 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
        if (Main.isDisplayingMapView() && Main.map.filterDialog != null) {
            Main.map.filterDialog.drawOSDText(graphics2D);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        try {
            graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        }
        catch (ClassCastException classCastException) {
            Main.error(classCastException);
        }
        super.paint(graphics);
    }

    public boolean prepareToDraw() {
        this.updateLocationState();
        if (this.initialViewport != null) {
            this.zoomTo(this.initialViewport);
            this.initialViewport = null;
        }
        if (BugReportExceptionHandler.exceptionHandlingInProgress()) {
            return false;
        }
        if (this.getCenter() == null) {
            return false;
        }
        if (this.oldLoc != null && this.oldSize != null) {
            Point point = this.getLocationOnScreen();
            EastNorth eastNorth = new EastNorth(this.getCenter().getX() + ((double)(point.x - this.oldLoc.x) - (double)(this.oldSize.width - this.getWidth()) / 2.0) * this.getScale(), this.getCenter().getY() + ((double)(this.oldLoc.y - point.y) + (double)(this.oldSize.height - this.getHeight()) / 2.0) * this.getScale());
            this.oldLoc = null;
            this.oldSize = null;
            this.zoomTo(eastNorth);
        }
        return true;
    }

    @Deprecated
    public Collection<Layer> getAllLayers() {
        return this.layerManager.getLayers();
    }

    @Deprecated
    public List<Layer> getAllLayersAsList() {
        return this.layerManager.getLayers();
    }

    @Deprecated
    public <T extends Layer> List<T> getLayersOfType(Class<T> clazz) {
        return this.layerManager.getLayersOfType(clazz);
    }

    @Deprecated
    public int getNumLayers() {
        return this.getAllLayers().size();
    }

    @Deprecated
    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    @Deprecated
    public void setActiveLayer(Layer layer) {
        this.layerManager.setActiveLayer(layer);
    }

    @Deprecated
    public Layer getActiveLayer() {
        return this.layerManager.getActiveLayer();
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        if (Main.map != null) {
            for (AbstractButton abstractButton : Main.map.allMapModeButtons) {
                MapMode mapMode = (MapMode)abstractButton.getAction();
                boolean bl = mapMode.layerIsSupported(this.layerManager.getActiveLayer());
                if (bl) {
                    Main.registerActionShortcut(mapMode, mapMode.getShortcut());
                } else {
                    Main.unregisterShortcut(mapMode.getShortcut());
                }
                abstractButton.setEnabled(bl);
            }
        }
        AudioPlayer.reset();
        this.repaint();
    }

    @Deprecated
    public OsmDataLayer getEditLayer() {
        return this.layerManager.getEditLayer();
    }

    @Deprecated
    public boolean hasLayer(Layer layer) {
        return this.layerManager.containsLayer(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean bl = this.temporaryLayers.add(mapViewPaintable);
            if (bl) {
                this.invalidatedListener.addTo(mapViewPaintable);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean bl = this.temporaryLayers.remove(mapViewPaintable);
            if (bl) {
                this.invalidatedListener.removeFrom(mapViewPaintable);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MapViewPaintable> getTemporaryLayers() {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<MapViewPaintable>(this.temporaryLayers));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Layer layer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((propertyChangeEvent.getPropertyName().equals(Layer.OPACITY_PROP) || propertyChangeEvent.getPropertyName().equals(Layer.FILTER_STATE_PROP)) && (layer = (Layer)propertyChangeEvent.getSource()).isVisible()) {
            this.changedLayer = layer;
            this.repaint();
        }
    }

    @Deprecated
    protected void refreshTitle() {
        if (Main.parent != null) {
            ((MainFrame)Main.parent).refreshTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        MapView mapView = this;
        synchronized (mapView) {
            this.paintPreferencesChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.layerManager.removeLayerChangeListener(this, true);
        this.layerManager.removeActiveLayerChangeListener(this);
        Main.pref.removePreferenceChangeListener(this);
        DataSet.removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear(this);
        if (this.mapMover != null) {
            this.mapMover.destroy();
        }
        this.nonChangedLayers.clear();
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            this.temporaryLayers.clear();
        }
        this.nonChangedLayersBuffer = null;
    }

    public String getLayerInformationForSourceTag() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.getLayersOfType(GpxLayer.class).isEmpty()) {
            arrayList.add("survey");
        }
        for (GeoImageLayer layer : this.getLayersOfType(GeoImageLayer.class)) {
            if (!layer.isVisible()) continue;
            arrayList.add(layer.getName());
        }
        for (ImageryLayer imageryLayer : this.getLayersOfType(ImageryLayer.class)) {
            if (!imageryLayer.isVisible()) continue;
            arrayList.add(ImageryInfo.ImageryType.BING.equals((Object)imageryLayer.getInfo().getImageryType()) ? "Bing" : imageryLayer.getName());
        }
        return Utils.join("; ", arrayList);
    }

    public void addRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.add(repaintListener);
    }

    public void removeRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.remove(repaintListener);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.repaintListeners != null) {
            for (RepaintListener repaintListener : this.repaintListeners) {
                repaintListener.repaint(l, n, n2, n3, n4);
            }
        }
        super.repaint(l, n, n2, n3, n4);
    }

    @Override
    public void repaint() {
        if (Main.isTraceEnabled()) {
            this.invalidatedListener.traceRandomRepaint();
        }
        super.repaint();
    }

    public final MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    public void scheduleZoomTo(ViewportData viewportData) {
        this.initialViewport = viewportData;
    }

    public static interface RepaintListener {
        public void repaint(long var1, int var3, int var4, int var5, int var6);
    }

    private static class WarningLayerPainter
    implements MapViewPaintable.LayerPainter {
        boolean warningPrinted = false;
        private Layer layer;

        WarningLayerPainter(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void paint(MapViewGraphics mapViewGraphics) {
            if (!this.warningPrinted) {
                Main.debug("A layer triggered a repaint while being added: " + this.layer);
                this.warningPrinted = true;
            }
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        }
    }

    protected static class EditLayerChangeAdapter
    implements MainLayerManager.ActiveLayerChangeListener {
        private final EditLayerChangeListener wrapped;

        public EditLayerChangeAdapter(EditLayerChangeListener editLayerChangeListener) {
            this.wrapped = editLayerChangeListener;
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            OsmDataLayer osmDataLayer;
            OsmDataLayer osmDataLayer2 = activeLayerChangeEvent.getPreviousEditLayer();
            if (osmDataLayer2 != (osmDataLayer = activeLayerChangeEvent.getSource().getEditLayer())) {
                this.wrapped.editLayerChanged(osmDataLayer2, osmDataLayer);
            }
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EditLayerChangeAdapter editLayerChangeAdapter = (EditLayerChangeAdapter)object;
            return !(this.wrapped == null ? editLayerChangeAdapter.wrapped != null : !this.wrapped.equals(editLayerChangeAdapter.wrapped));
        }

        public String toString() {
            return "EditLayerChangeAdapter [wrapped=" + this.wrapped + ']';
        }
    }

    protected static class LayerChangeAdapter
    implements MainLayerManager.ActiveLayerChangeListener,
    LayerManager.LayerChangeListener {
        private final LayerChangeListener wrapped;
        private boolean receiveOneInitialFire;

        public LayerChangeAdapter(LayerChangeListener layerChangeListener) {
            this.wrapped = layerChangeListener;
        }

        public LayerChangeAdapter(LayerChangeListener layerChangeListener, boolean bl) {
            this(layerChangeListener);
            this.receiveOneInitialFire = bl;
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
            this.wrapped.layerAdded(layerAddEvent.getAddedLayer());
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
            this.wrapped.layerRemoved(layerRemoveEvent.getRemovedLayer());
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            Layer layer;
            Layer layer2 = this.receiveOneInitialFire ? null : activeLayerChangeEvent.getPreviousActiveLayer();
            if (layer2 != (layer = activeLayerChangeEvent.getSource().getActiveLayer())) {
                this.wrapped.activeLayerChange(layer2, layer);
            }
            this.receiveOneInitialFire = false;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LayerChangeAdapter layerChangeAdapter = (LayerChangeAdapter)object;
            return !(this.wrapped == null ? layerChangeAdapter.wrapped != null : !this.wrapped.equals(layerChangeAdapter.wrapped));
        }

        public String toString() {
            return "LayerChangeAdapter [wrapped=" + this.wrapped + ']';
        }
    }

    private class LayerInvalidatedListener
    implements MapViewPaintable.PaintableInvalidationListener {
        private boolean ignoreRepaint;

        private LayerInvalidatedListener() {
        }

        @Override
        public void paintablInvalidated(MapViewPaintable.PaintableInvalidationEvent paintableInvalidationEvent) {
            this.ignoreRepaint = true;
            MapView.this.repaint();
        }

        public void addTo(MapViewPaintable mapViewPaintable) {
            if (mapViewPaintable instanceof AbstractMapViewPaintable) {
                ((AbstractMapViewPaintable)mapViewPaintable).addInvalidationListener(this);
            }
        }

        public void removeFrom(MapViewPaintable mapViewPaintable) {
            if (mapViewPaintable instanceof AbstractMapViewPaintable) {
                ((AbstractMapViewPaintable)mapViewPaintable).removeInvalidationListener(this);
            }
        }

        protected synchronized void traceRandomRepaint() {
            if (!this.ignoreRepaint) {
                System.err.println("Repaint:");
                Thread.dumpStack();
            }
            this.ignoreRepaint = false;
        }
    }

    @Deprecated
    public static interface EditLayerChangeListener {
        public void editLayerChanged(OsmDataLayer var1, OsmDataLayer var2);
    }

    @Deprecated
    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

