/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.Locale;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public abstract class RotationAngle {
    public abstract double getRotationAngle(OsmPrimitive var1);

    public static RotationAngle buildStaticRotation(final double d) {
        return new RotationAngle(){

            @Override
            public double getRotationAngle(OsmPrimitive osmPrimitive) {
                return d;
            }

            public String toString() {
                return d + "rad";
            }
        };
    }

    public static RotationAngle buildStaticRotation(String string) {
        try {
            return RotationAngle.buildStaticRotation(RotationAngle.parseCardinalRotation(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid string: " + string, illegalArgumentException);
        }
    }

    public static double parseCardinalRotation(String string) {
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "n": 
            case "north": {
                return 0.0;
            }
            case "ne": 
            case "northeast": {
                return Math.toRadians(45.0);
            }
            case "e": 
            case "east": {
                return Math.toRadians(90.0);
            }
            case "se": 
            case "southeast": {
                return Math.toRadians(135.0);
            }
            case "s": 
            case "south": {
                return Math.PI;
            }
            case "sw": 
            case "southwest": {
                return Math.toRadians(225.0);
            }
            case "w": 
            case "west": {
                return Math.toRadians(270.0);
            }
            case "nw": 
            case "northwest": {
                return Math.toRadians(315.0);
            }
        }
        throw new IllegalArgumentException("Unexpected cardinal direction " + string);
    }

    public static RotationAngle buildWayDirectionRotation() {
        return new RotationAngle(){

            @Override
            public double getRotationAngle(OsmPrimitive osmPrimitive) {
                if (!(osmPrimitive instanceof Node)) {
                    return 0.0;
                }
                Node node = (Node)osmPrimitive;
                SubclassFilteredCollection<OsmPrimitive, Way> subclassFilteredCollection = Utils.filteredCollection(node.getReferrers(), Way.class);
                if (subclassFilteredCollection.isEmpty()) {
                    return 0.0;
                }
                Way way = subclassFilteredCollection.iterator().next();
                int n = way.getNodes().indexOf(node);
                if (n == 0) {
                    return -Geometry.getSegmentAngle(node.getEastNorth(), way.getNode(n + 1).getEastNorth());
                }
                return -Geometry.getSegmentAngle(way.getNode(n - 1).getEastNorth(), node.getEastNorth());
            }

            public String toString() {
                return "way-direction";
            }
        };
    }
}

