/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String executor;
    final String shardActionName;

    protected TransportInstanceSingleOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.executor = this.executor();
        this.shardActionName = actionName + "[s]";
        transportService.registerRequestHandler(this.shardActionName, request, this.executor, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract String executor();

    protected abstract void shardOperation(Request var1, ActionListener<Response> var2);

    protected abstract Response newResponse();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, Request request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ((InstanceShardOperationRequest)request).concreteIndex());
    }

    protected abstract void resolveRequest(ClusterState var1, Request var2);

    protected boolean retryOnFailure(Throwable e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2);

    private class ShardTransportHandler
    extends TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            TransportInstanceSingleOperationAction.this.shardOperation(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportInstanceSingleOperationAction.this.logger.warn("failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private ShardIterator shardIt;
        private DiscoveryNodes nodes;
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
        }

        public void start() {
            this.observer = new ClusterStateObserver(this.this$0.clusterService, ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.logger);
            this.doStart();
        }

        protected void doStart() {
            this.nodes = this.observer.observedState().nodes();
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState());
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                ((InstanceShardOperationRequest)this.request).concreteIndex(this.this$0.indexNameExpressionResolver.concreteSingleIndex(this.observer.observedState(), (IndicesRequest)this.request));
                this.this$0.resolveRequest(this.observer.observedState(), this.request);
                blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(this.observer.observedState(), this.request);
            }
            catch (Throwable e) {
                this.listener.onFailure(e);
                return;
            }
            if (this.shardIt.size() == 0) {
                this.retry(null);
                return;
            }
            assert (this.shardIt.size() == 1);
            ShardRouting shard = this.shardIt.nextOrNull();
            assert (shard != null);
            if (!shard.active()) {
                this.retry(null);
                return;
            }
            ((InstanceShardOperationRequest)this.request).shardId = this.shardIt.shardId().id();
            DiscoveryNode node = this.nodes.get(shard.currentNodeId());
            this.this$0.transportService.sendRequest(node, this.this$0.shardActionName, (TransportRequest)this.request, this.this$0.transportOptions(), new BaseTransportResponseHandler<Response>(){

                @Override
                public Response newInstance() {
                    return AsyncSingleAction.this.this$0.newResponse();
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    AsyncSingleAction.this.listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    Throwable cause = exp.unwrapCause();
                    if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure(exp)) {
                        AsyncSingleAction.this.retry(cause);
                    } else {
                        AsyncSingleAction.this.listener.onFailure(exp);
                    }
                }
            });
        }

        void retry(@Nullable Throwable failure) {
            if (this.observer.isTimedOut()) {
                Throwable listenFailure = failure;
                if (listenFailure == null) {
                    listenFailure = this.shardIt == null ? new UnavailableShardsException(new ShardId(((InstanceShardOperationRequest)this.request).concreteIndex(), -1), "Timeout waiting for [{}], request: {}", ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName) : new UnavailableShardsException(this.shardIt.shardId(), "[{}] shardIt, [{}] active : Timeout waiting for [{}], request: {}", this.shardIt.size(), this.shardIt.sizeActive(), ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName);
                }
                this.listener.onFailure(listenFailure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart();
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.nodes.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.doStart();
                }
            }, ((InstanceShardOperationRequest)this.request).timeout());
        }
    }
}

