/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.settings.IndexSettingsService;

public final class MergePolicyConfig
implements IndexSettingsService.Listener {
    private final TieredMergePolicy mergePolicy = new TieredMergePolicy();
    private final ESLogger logger;
    private final boolean mergesEnabled;
    private volatile double noCFSRatio;
    public static final double DEFAULT_EXPUNGE_DELETES_ALLOWED = 10.0;
    public static final ByteSizeValue DEFAULT_FLOOR_SEGMENT = new ByteSizeValue(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 10;
    public static final int DEFAULT_MAX_MERGE_AT_ONCE_EXPLICIT = 30;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = new ByteSizeValue(5L, ByteSizeUnit.GB);
    public static final double DEFAULT_SEGMENTS_PER_TIER = 10.0;
    public static final double DEFAULT_RECLAIM_DELETES_WEIGHT = 2.0;
    public static final String INDEX_COMPOUND_FORMAT = "index.compound_format";
    public static final String INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED = "index.merge.policy.expunge_deletes_allowed";
    public static final String INDEX_MERGE_POLICY_FLOOR_SEGMENT = "index.merge.policy.floor_segment";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE = "index.merge.policy.max_merge_at_once";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT = "index.merge.policy.max_merge_at_once_explicit";
    public static final String INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT = "index.merge.policy.max_merged_segment";
    public static final String INDEX_MERGE_POLICY_SEGMENTS_PER_TIER = "index.merge.policy.segments_per_tier";
    public static final String INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT = "index.merge.policy.reclaim_deletes_weight";
    public static final String INDEX_MERGE_ENABLED = "index.merge.enabled";

    public MergePolicyConfig(ESLogger logger, Settings indexSettings) {
        this.logger = logger;
        this.noCFSRatio = MergePolicyConfig.parseNoCFSRatio(indexSettings.get(INDEX_COMPOUND_FORMAT, Double.toString(0.1)));
        double forceMergeDeletesPctAllowed = indexSettings.getAsDouble(INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED, (Double)10.0);
        ByteSizeValue floorSegment = indexSettings.getAsBytesSize(INDEX_MERGE_POLICY_FLOOR_SEGMENT, DEFAULT_FLOOR_SEGMENT);
        int maxMergeAtOnce = indexSettings.getAsInt(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE, (Integer)10);
        int maxMergeAtOnceExplicit = indexSettings.getAsInt(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT, (Integer)30);
        ByteSizeValue maxMergedSegment = indexSettings.getAsBytesSize(INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT, DEFAULT_MAX_MERGED_SEGMENT);
        double segmentsPerTier = indexSettings.getAsDouble(INDEX_MERGE_POLICY_SEGMENTS_PER_TIER, (Double)10.0);
        double reclaimDeletesWeight = indexSettings.getAsDouble(INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT, (Double)2.0);
        this.mergesEnabled = indexSettings.getAsBoolean(INDEX_MERGE_ENABLED, (Boolean)true);
        if (!this.mergesEnabled) {
            logger.warn("[{}] is set to false, this should only be used in tests and can cause serious problems in production environments", INDEX_MERGE_ENABLED);
        }
        maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
        this.mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.mergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.mergePolicy.setFloorSegmentMB(floorSegment.mbFrac());
        this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
        this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.mbFrac());
        this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
        logger.debug("using [tiered] merge mergePolicy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merge_at_once_explicit[{}], max_merged_segment[{}], segments_per_tier[{}], reclaim_deletes_weight[{}]", forceMergeDeletesPctAllowed, floorSegment, maxMergeAtOnce, maxMergeAtOnceExplicit, maxMergedSegment, segmentsPerTier, reclaimDeletesWeight);
    }

    private int adjustMaxMergeAtOnceIfNeeded(int maxMergeAtOnce, double segmentsPerTier) {
        if (!(segmentsPerTier >= (double)maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", maxMergeAtOnce, newMaxMergeAtOnce, segmentsPerTier);
            maxMergeAtOnce = newMaxMergeAtOnce;
        }
        return maxMergeAtOnce;
    }

    public MergePolicy getMergePolicy() {
        return this.mergesEnabled ? this.mergePolicy : NoMergePolicy.INSTANCE;
    }

    @Override
    public void onRefreshSettings(Settings settings) {
        double noCFSRatio;
        double oldReclaimDeletesWeight;
        double reclaimDeletesWeight;
        int oldMaxMergeAtOnceExplicit;
        int maxMergeAtOnceExplicit;
        int oldMaxMergeAtOnce;
        int maxMergeAtOnce;
        double oldSegmentsPerTier;
        double segmentsPerTier;
        double oldExpungeDeletesPctAllowed = this.mergePolicy.getForceMergeDeletesPctAllowed();
        double expungeDeletesPctAllowed = settings.getAsDouble(INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED, (Double)oldExpungeDeletesPctAllowed);
        if (expungeDeletesPctAllowed != oldExpungeDeletesPctAllowed) {
            this.logger.info("updating [expunge_deletes_allowed] from [{}] to [{}]", oldExpungeDeletesPctAllowed, expungeDeletesPctAllowed);
            this.mergePolicy.setForceMergeDeletesPctAllowed(expungeDeletesPctAllowed);
        }
        double oldFloorSegmentMB = this.mergePolicy.getFloorSegmentMB();
        ByteSizeValue floorSegment = settings.getAsBytesSize(INDEX_MERGE_POLICY_FLOOR_SEGMENT, null);
        if (floorSegment != null && floorSegment.mbFrac() != oldFloorSegmentMB) {
            this.logger.info("updating [floor_segment] from [{}mb] to [{}]", oldFloorSegmentMB, floorSegment);
            this.mergePolicy.setFloorSegmentMB(floorSegment.mbFrac());
        }
        if ((segmentsPerTier = settings.getAsDouble(INDEX_MERGE_POLICY_SEGMENTS_PER_TIER, (Double)(oldSegmentsPerTier = this.mergePolicy.getSegmentsPerTier())).doubleValue()) != oldSegmentsPerTier) {
            this.logger.info("updating [segments_per_tier] from [{}] to [{}]", oldSegmentsPerTier, segmentsPerTier);
            this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
        }
        if ((maxMergeAtOnce = settings.getAsInt(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE, (Integer)(oldMaxMergeAtOnce = this.mergePolicy.getMaxMergeAtOnce())).intValue()) != oldMaxMergeAtOnce) {
            this.logger.info("updating [max_merge_at_once] from [{}] to [{}]", oldMaxMergeAtOnce, maxMergeAtOnce);
            maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
            this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        }
        if ((maxMergeAtOnceExplicit = settings.getAsInt(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT, (Integer)(oldMaxMergeAtOnceExplicit = this.mergePolicy.getMaxMergeAtOnceExplicit())).intValue()) != oldMaxMergeAtOnceExplicit) {
            this.logger.info("updating [max_merge_at_once_explicit] from [{}] to [{}]", oldMaxMergeAtOnceExplicit, maxMergeAtOnceExplicit);
            this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
        }
        double oldMaxMergedSegmentMB = this.mergePolicy.getMaxMergedSegmentMB();
        ByteSizeValue maxMergedSegment = settings.getAsBytesSize(INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT, null);
        if (maxMergedSegment != null && maxMergedSegment.mbFrac() != oldMaxMergedSegmentMB) {
            this.logger.info("updating [max_merged_segment] from [{}mb] to [{}]", oldMaxMergedSegmentMB, maxMergedSegment);
            this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.mbFrac());
        }
        if ((reclaimDeletesWeight = settings.getAsDouble(INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT, (Double)(oldReclaimDeletesWeight = this.mergePolicy.getReclaimDeletesWeight())).doubleValue()) != oldReclaimDeletesWeight) {
            this.logger.info("updating [reclaim_deletes_weight] from [{}] to [{}]", oldReclaimDeletesWeight, reclaimDeletesWeight);
            this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
        }
        if ((noCFSRatio = MergePolicyConfig.parseNoCFSRatio(settings.get(INDEX_COMPOUND_FORMAT, Double.toString(this.noCFSRatio)))) != this.noCFSRatio) {
            this.logger.info("updating index.compound_format from [{}] to [{}]", MergePolicyConfig.formatNoCFSRatio(this.noCFSRatio), MergePolicyConfig.formatNoCFSRatio(noCFSRatio));
            this.mergePolicy.setNoCFSRatio(noCFSRatio);
            this.noCFSRatio = noCFSRatio;
        }
    }

    public static double parseNoCFSRatio(String noCFSRatio) {
        if ((noCFSRatio = noCFSRatio.trim()).equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (noCFSRatio.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            double value = Double.parseDouble(noCFSRatio);
            if (value < 0.0 || value > 1.0) {
                throw new IllegalArgumentException("NoCFSRatio must be in the interval [0..1] but was: [" + value + "]");
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expected a boolean or a value in the interval [0..1] but was: [" + noCFSRatio + "]", ex);
        }
    }

    public static String formatNoCFSRatio(double ratio) {
        if (ratio == 1.0) {
            return Boolean.TRUE.toString();
        }
        if (ratio == 0.0) {
            return Boolean.FALSE.toString();
        }
        return Double.toString(ratio);
    }
}

