// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CHILDPROXY_H
#define _GSTREAMERMM_CHILDPROXY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <glibmm/interface.h>
#include <gstreamermm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstChildProxy GstChildProxy;
typedef struct _GstChildProxyClass GstChildProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class ChildProxy_Class; } // namespace Gst
namespace Gst
{

/** An interface for multi child elements.
 * This interface abstracts handling of property sets for child elements.
 * Imagine elements such as mixers or polyphonic generators. They all have
 * multiple Gst::Pad or some kind of voice objects. The element acts as a
 * parent for those child objects. Each child has the same properties.
 *
 * By implementing this interface the child properties can be accessed from
 * the parent element by using get_proxy_property() and set_proxy_property().
 *
 * Property names are written as "child-name::property-name". The whole naming
 * scheme is recursive. Thus "child1::child2::property" is valid too, if
 * "child1" also implements the Gst::ChildProxy interface.
 * @ingroup GstInterfaces
 */

class ChildProxy : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ChildProxy CppObjectType;
  typedef ChildProxy_Class CppClassType;
  typedef GstChildProxy BaseObjectType;
  typedef GstChildProxyInterface BaseClassType;

private:
  friend class ChildProxy_Class;
  static CppClassType childproxy_class_;

  // noncopyable
  ChildProxy(const ChildProxy&);
  ChildProxy& operator=(const ChildProxy&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  ChildProxy();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit ChildProxy(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ChildProxy(GstChildProxy* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ChildProxy();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstChildProxy*       gobj()       { return reinterpret_cast<GstChildProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstChildProxy* gobj() const { return reinterpret_cast<GstChildProxy*>(gobject_); }

private:


public:
  
  /** Gets the number of child objects this parent contains.
   * 
   * @return The number of child objects
   * 
   * MT safe.
   */
  guint get_children_count() const;

 
  /** Looks up a child element by the given name.
   * 
   * This virtual method has a default implementation that uses Gst::Object
   * together with Gst::Object::get_name(). If the interface is to be used with
   * Objects, this methods needs to be overridden.
   * 
   * @param name The childs name.
   * @return The child object or <tt>0</tt> if not found. Unref
   * after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Object> get_child(const Glib::ustring& name);
  
  /** Looks up a child element by the given name.
   * 
   * This virtual method has a default implementation that uses Gst::Object
   * together with Gst::Object::get_name(). If the interface is to be used with
   * Objects, this methods needs to be overridden.
   * 
   * @param name The childs name.
   * @return The child object or <tt>0</tt> if not found. Unref
   * after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Object> get_child(const Glib::ustring& name) const;

  
  /** Fetches a child by its number.
   * 
   * @param index The childs position in the child list.
   * @return The child object or <tt>0</tt> if not found (index
   * too high). Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Glib::Object> get_child(guint index);
  
  /** Fetches a child by its number.
   * 
   * @param index The childs position in the child list.
   * @return The child object or <tt>0</tt> if not found (index
   * too high). Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Glib::Object> get_child(guint index) const;

  
  /** Looks up which object and ParamSpec would be effected by the given @a name.
   * 
   * MT safe.
   * 
   * @param name Name of the property to look up.
   * @param target Pointer to a Object that
   * takes the real object to set property on.
   * @param pspec Pointer to take the ParamSpec
   * describing the property.
   * @return <tt>true</tt> if @a target and @a pspec could be found. <tt>false</tt> otherwise. In that
   * case the values for @a pspec and @a target are not modified. Unref @a target after
   * usage. For plain GObjects @a target is the same as @a object.
   */

  //TODO: Maybe GParamSpec should be wrapped in glibmm?
  static bool lookup(const Glib::RefPtr<Gst::ChildProxy>& object, const Glib::ustring& name, Glib::RefPtr<Glib::Object>& target, GParamSpec*& pspec);

  /** Gets a single property using the Gst::ChildProxy mechanism.
   * @param name The property to get.
   * @param value An empty Glib::ValueBase in which to store the property.
   * @return This Gst::ChildProxy so more properties can be retrieved if
   * needed.
   */
  Glib::RefPtr<Gst::ChildProxy> get_proxy_property(const Glib::ustring& name, Glib::ValueBase& value);
  

  /** Gets a single property using the Gst::ChildProxy mechanism.
   * @param name The property to get.
   * @param value An empty Glib::ValueBase in which to store the property.
   * @return This Gst::ChildProxy so more properties can be retrieved if
   * needed.
   */
  Glib::RefPtr<const Gst::ChildProxy> get_proxy_property(const Glib::ustring& name, Glib::ValueBase& value) const;


  /** Sets a single property using the Gst::ChildProxy mechanism.
   * @param name The property to get.
   * @param value The Glib::ValueBase to set the property to (non-empty).
   * @return This Gst::ChildProxy so more properties can be set.
   */
  Glib::RefPtr<Gst::ChildProxy> set_proxy_property(const Glib::ustring& name, const Glib::ValueBase& value);
  

  /** Emits the "child-added" signal.
   * 
   * @param child The newly added child.
   * @param name The name of the new child.
   */
  void child_added(const Glib::RefPtr<Gst::Object>& child, const Glib::ustring& name);
  
  /** Emits the "child-removed" signal.
   * 
   * @param child The removed child.
   * @param name The name of the old child.
   */
  void child_removed(const Glib::RefPtr<Gst::Object>& child, const Glib::ustring& name);

 
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%child_added(const Glib::RefPtr<Gst::Object>& object, const Glib::ustring& name)</tt>
   *
   * Will be emitted after the @a object was added to the @a child_proxy.
   * 
   * @param object The Object that was added.
   * @param name The name of the new child.
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gst::Object>&,const Glib::ustring& > signal_child_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%child_removed(const Glib::RefPtr<Gst::Object>& object, const Glib::ustring& name)</tt>
   *
   * Will be emitted after the @a object was removed from the @a child_proxy.
   * 
   * @param object The Object that was removed.
   * @param name The name of the old child.
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gst::Object>&,const Glib::ustring& > signal_child_removed();


  /** Virtual method to fetch the child.
   */
    virtual Glib::RefPtr<Glib::Object> get_child_by_index_vfunc(guint index) const;


  /** Virtual method to get the children count.
   */
    virtual guint get_children_count_vfunc() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_child_added().
  virtual void on_child_added(const Glib::RefPtr<Gst::Object>& object, const Glib::ustring& name);
  /// This is a default handler for the signal signal_child_removed().
  virtual void on_child_removed(const Glib::RefPtr<Gst::Object>& object, const Glib::ustring& name);


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ChildProxy
   */
  Glib::RefPtr<Gst::ChildProxy> wrap(GstChildProxy* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_CHILDPROXY_H */

