// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESGeom_RuledSurface_HeaderFile
#define _IGESGeom_RuledSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESGeom_RuledSurface.hxx>

#include <Handle_IGESData_IGESEntity.hxx>
#include <Standard_Integer.hxx>
#include <IGESData_IGESEntity.hxx>
#include <Standard_Boolean.hxx>
class IGESData_IGESEntity;


//! defines IGESRuledSurface, Type <118> Form <0-1>
//! in package IGESGeom
//! A ruled surface is formed by moving a line connecting points
//! of equal relative arc length or equal relative parametric
//! value on two parametric curves from a start point to a
//! terminate point on the curves. The parametric curves may be
//! points, lines, circles, conics, rational B-splines,
//! parametric splines or any parametric curve defined in
//! the IGES specification.
class IGESGeom_RuledSurface : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESGeom_RuledSurface();
  
  //! This method is used to set the fields of the class
  //! RuledSurface
  //! - aCurve       : First parametric curve
  //! - anotherCurve : Second parametric curve
  //! - aDirFlag     : Direction Flag
  //! 0 = Join first to first, last to last
  //! 1 = Join first to last, last to first
  //! - aDevFlag     : Developable Surface Flag
  //! 1 = Developable
  //! 0 = Possibly not
  Standard_EXPORT   void Init (const Handle(IGESData_IGESEntity)& aCurve, const Handle(IGESData_IGESEntity)& anotherCurve, const Standard_Integer aDirFlag, const Standard_Integer aDevFlag) ;
  
  //! Sets <me> to be Ruled by Parameter (Form 1) if <mode> is
  //! True, or Ruled by Length (Form 0) else
  Standard_EXPORT   void SetRuledByParameter (const Standard_Boolean mode) ;
  
  //! Returns True if Form is 1
  Standard_EXPORT   Standard_Boolean IsRuledByParameter()  const;
  
  //! returns the first curve
  Standard_EXPORT   Handle(IGESData_IGESEntity) FirstCurve()  const;
  
  //! returns the second curve
  Standard_EXPORT   Handle(IGESData_IGESEntity) SecondCurve()  const;
  
  //! return the sense of direction
  //! 0 = Join first to first, last to last
  //! 1 = Join first to last, last to first
  Standard_EXPORT   Standard_Integer DirectionFlag()  const;
  
  //! returns True if developable else False
  Standard_EXPORT   Standard_Boolean IsDevelopable()  const;




  DEFINE_STANDARD_RTTI(IGESGeom_RuledSurface)

protected:




private: 


  Handle(IGESData_IGESEntity) theCurve1;
  Handle(IGESData_IGESEntity) theCurve2;
  Standard_Integer theDirFlag;
  Standard_Integer theDevFlag;


};







#endif // _IGESGeom_RuledSurface_HeaderFile
