/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class VariableInstruction
extends Instruction {
    public boolean wide;
    public int variableIndex;
    public int constant;

    public VariableInstruction() {
    }

    public VariableInstruction(boolean bl) {
        this.wide = bl;
    }

    public VariableInstruction(byte by) {
        this(by, VariableInstruction.embeddedVariable(by), 0);
    }

    public VariableInstruction(byte by, int n) {
        this(by, n, 0);
    }

    public VariableInstruction(byte by, int n, int n2) {
        this.opcode = by;
        this.variableIndex = n;
        this.constant = n2;
        this.wide = this.requiredVariableIndexSize() > 1 || this.requiredConstantSize() > 1;
    }

    public VariableInstruction copy(VariableInstruction variableInstruction) {
        this.opcode = variableInstruction.opcode;
        this.variableIndex = variableInstruction.variableIndex;
        this.constant = variableInstruction.constant;
        this.wide = variableInstruction.wide;
        return this;
    }

    private static int embeddedVariable(byte by) {
        switch (by) {
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                return 1;
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                return 2;
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                return 3;
            }
        }
        return 0;
    }

    public boolean isStore() {
        return this.opcode >= 54 || this.opcode == -124;
    }

    public boolean isLoad() {
        return this.opcode < 54;
    }

    @Override
    public byte canonicalOpcode() {
        switch (this.opcode) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return 21;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return 22;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 23;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 24;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 25;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return 54;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return 55;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return 56;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return 57;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return 58;
            }
        }
        return this.opcode;
    }

    @Override
    public Instruction shrink() {
        this.opcode = this.canonicalOpcode();
        if (this.variableIndex <= 3) {
            switch (this.opcode) {
                case 21: {
                    this.opcode = (byte)(26 + this.variableIndex);
                    break;
                }
                case 22: {
                    this.opcode = (byte)(30 + this.variableIndex);
                    break;
                }
                case 23: {
                    this.opcode = (byte)(34 + this.variableIndex);
                    break;
                }
                case 24: {
                    this.opcode = (byte)(38 + this.variableIndex);
                    break;
                }
                case 25: {
                    this.opcode = (byte)(42 + this.variableIndex);
                    break;
                }
                case 54: {
                    this.opcode = (byte)(59 + this.variableIndex);
                    break;
                }
                case 55: {
                    this.opcode = (byte)(63 + this.variableIndex);
                    break;
                }
                case 56: {
                    this.opcode = (byte)(67 + this.variableIndex);
                    break;
                }
                case 57: {
                    this.opcode = (byte)(71 + this.variableIndex);
                    break;
                }
                case 58: {
                    this.opcode = (byte)(75 + this.variableIndex);
                }
            }
        }
        this.wide = this.requiredVariableIndexSize() > 1 || this.requiredConstantSize() > 1;
        return this;
    }

    @Override
    protected boolean isWide() {
        return this.wide;
    }

    @Override
    protected void readInfo(byte[] byArray, int n) {
        int n2 = this.variableIndexSize();
        int n3 = this.constantSize();
        if (n2 == 0) {
            this.variableIndex = this.opcode < 59 ? this.opcode - 26 & 3 : this.opcode - 59 & 3;
        } else {
            this.variableIndex = VariableInstruction.readValue(byArray, n, n2);
            n += n2;
        }
        this.constant = VariableInstruction.readSignedValue(byArray, n, n3);
    }

    @Override
    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.variableIndexSize();
        int n3 = this.constantSize();
        if (this.requiredVariableIndexSize() > n2) {
            throw new IllegalArgumentException("Instruction has invalid variable index size (" + this.toString(n) + ")");
        }
        if (this.requiredConstantSize() > n3) {
            throw new IllegalArgumentException("Instruction has invalid constant size (" + this.toString(n) + ")");
        }
        VariableInstruction.writeValue(byArray, n, this.variableIndex, n2);
        VariableInstruction.writeSignedValue(byArray, n += n2, this.constant, n3);
    }

    @Override
    public int length(int n) {
        return (this.wide ? 2 : 1) + this.variableIndexSize() + this.constantSize();
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, n, this);
    }

    public String toString() {
        return this.getName() + (this.wide ? "_w" : "") + " v" + this.variableIndex + (this.constantSize() > 0 ? ", " + this.constant : "");
    }

    private int variableIndexSize() {
        return this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78 ? 0 : (this.wide ? 2 : 1);
    }

    private int requiredVariableIndexSize() {
        return (this.variableIndex & 3) == this.variableIndex ? 0 : ((this.variableIndex & 0xFF) == this.variableIndex ? 1 : ((this.variableIndex & 0xFFFF) == this.variableIndex ? 2 : 4));
    }

    private int constantSize() {
        return this.opcode != -124 ? 0 : (this.wide ? 2 : 1);
    }

    private int requiredConstantSize() {
        return this.opcode != -124 ? 0 : ((byte)this.constant == this.constant ? 1 : ((short)this.constant == this.constant ? 2 : 4));
    }
}

