/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.util.ListUtil;

final class MemberSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final boolean isField;
    private final JRadioButton[] publicRadioButtons;
    private final JRadioButton[] privateRadioButtons;
    private final JRadioButton[] protectedRadioButtons;
    private final JRadioButton[] staticRadioButtons;
    private final JRadioButton[] finalRadioButtons;
    private final JRadioButton[] syntheticRadioButtons;
    private JRadioButton[] volatileRadioButtons;
    private JRadioButton[] transientRadioButtons;
    private JRadioButton[] synchronizedRadioButtons;
    private JRadioButton[] nativeRadioButtons;
    private JRadioButton[] abstractRadioButtons;
    private JRadioButton[] strictRadioButtons;
    private JRadioButton[] bridgeRadioButtons;
    private JRadioButton[] varargsRadioButtons;
    private final JTextField annotationTypeTextField = new JTextField(20);
    private final JTextField nameTextField = new JTextField(20);
    private final JTextField typeTextField = new JTextField(20);
    private final JTextField argumentTypesTextField = new JTextField(20);
    private int returnValue;

    public MemberSpecificationDialog(JDialog jDialog, boolean bl) {
        super(jDialog, MemberSpecificationDialog.msg(bl ? "specifyFields" : "specifyMethods"), true);
        this.setResizable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 10;
        gridBagConstraints7.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.anchor = 10;
        gridBagConstraints8.insets = gridBagConstraints7.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.anchor = 16;
        gridBagConstraints9.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = gridBagConstraints9.insets;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.anchor = 14;
        gridBagConstraints11.insets = gridBagConstraints10.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Border border = BorderFactory.createEtchedBorder(0);
        this.isField = bl;
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(border, MemberSpecificationDialog.msg("access")));
        jPanel.add(Box.createGlue(), gridBagConstraints7);
        jPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("required")), "requiredTip"), gridBagConstraints7);
        jPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("not")), "notTip"), gridBagConstraints7);
        jPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("dontCare")), "dontCareTip"), gridBagConstraints7);
        jPanel.add(Box.createGlue(), gridBagConstraints4);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", jPanel);
        this.privateRadioButtons = this.addRadioButtonTriplet("Private", jPanel);
        this.protectedRadioButtons = this.addRadioButtonTriplet("Protected", jPanel);
        this.staticRadioButtons = this.addRadioButtonTriplet("Static", jPanel);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", jPanel);
        this.syntheticRadioButtons = this.addRadioButtonTriplet("Synthetic", jPanel);
        if (bl) {
            this.volatileRadioButtons = this.addRadioButtonTriplet("Volatile", jPanel);
            this.transientRadioButtons = this.addRadioButtonTriplet("Transient", jPanel);
        } else {
            this.synchronizedRadioButtons = this.addRadioButtonTriplet("Synchronized", jPanel);
            this.nativeRadioButtons = this.addRadioButtonTriplet("Native", jPanel);
            this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", jPanel);
            this.strictRadioButtons = this.addRadioButtonTriplet("Strict", jPanel);
            this.bridgeRadioButtons = this.addRadioButtonTriplet("Bridge", jPanel);
            this.varargsRadioButtons = this.addRadioButtonTriplet("Varargs", jPanel);
        }
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, MemberSpecificationDialog.msg(bl ? "fieldType" : "returnType")));
        jPanel2.add((Component)MemberSpecificationDialog.tip(this.typeTextField, "typeTip"), gridBagConstraints4);
        final JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createTitledBorder(border, MemberSpecificationDialog.msg("annotation")));
        jPanel3.add((Component)MemberSpecificationDialog.tip(this.annotationTypeTextField, "classNameTip"), gridBagConstraints4);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createTitledBorder(border, MemberSpecificationDialog.msg("name")));
        jPanel4.add((Component)MemberSpecificationDialog.tip(this.nameTextField, bl ? "fieldNameTip" : "methodNameTip"), gridBagConstraints4);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createTitledBorder(border, MemberSpecificationDialog.msg("argumentTypes")));
        jPanel5.add((Component)MemberSpecificationDialog.tip(this.argumentTypesTextField, "argumentTypes2Tip"), gridBagConstraints4);
        final JButton jButton = new JButton(MemberSpecificationDialog.msg("basic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !jPanel3.isVisible();
                jPanel3.setVisible(bl);
                jButton.setText(MemberSpecificationDialog.msg(bl ? "basic" : "advanced"));
                MemberSpecificationDialog.this.pack();
            }
        });
        jButton.doClick();
        JButton jButton2 = new JButton(MemberSpecificationDialog.msg("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberSpecificationDialog.this.returnValue = 0;
                MemberSpecificationDialog.this.hide();
            }
        });
        JButton jButton3 = new JButton(MemberSpecificationDialog.msg("cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberSpecificationDialog.this.hide();
            }
        });
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.add((Component)MemberSpecificationDialog.tip(jPanel, "accessTip"), gridBagConstraints5);
        jPanel6.add((Component)MemberSpecificationDialog.tip(jPanel3, "annotationTip"), gridBagConstraints5);
        jPanel6.add((Component)MemberSpecificationDialog.tip(jPanel2, bl ? "fieldTypeTip" : "returnTypeTip"), gridBagConstraints5);
        jPanel6.add((Component)MemberSpecificationDialog.tip(jPanel4, "nameTip"), gridBagConstraints5);
        if (!bl) {
            jPanel6.add((Component)MemberSpecificationDialog.tip(jPanel5, "argumentTypesTip"), gridBagConstraints5);
        }
        jPanel6.add((Component)MemberSpecificationDialog.tip(jButton, "advancedTip"), gridBagConstraints9);
        jPanel6.add((Component)jButton2, gridBagConstraints10);
        jPanel6.add((Component)jButton3, gridBagConstraints11);
        this.getContentPane().add(new JScrollPane(jPanel6));
    }

    private JRadioButton[] addRadioButtonTriplet(String string, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        jPanel.add((Component)jRadioButton, gridBagConstraints2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints2);
        jPanel.add((Component)jRadioButton3, gridBagConstraints2);
        jPanel.add(Box.createGlue(), gridBagConstraints3);
        return new JRadioButton[]{jRadioButton, jRadioButton2, jRadioButton3};
    }

    public void setMemberSpecification(MemberSpecification memberSpecification) {
        String string = memberSpecification.annotationType;
        String string2 = memberSpecification.name;
        String string3 = memberSpecification.descriptor;
        this.annotationTypeTextField.setText(string == null ? "" : ClassUtil.externalType(string));
        this.setMemberSpecificationRadioButtons(memberSpecification, 1, this.publicRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 2, this.privateRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 4, this.protectedRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 8, this.staticRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 16, this.finalRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 4096, this.syntheticRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 64, this.volatileRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 128, this.transientRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 32, this.synchronizedRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 256, this.nativeRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 1024, this.abstractRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 2048, this.strictRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 64, this.bridgeRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 128, this.varargsRadioButtons);
        this.nameTextField.setText(string2 == null ? "*" : string2);
        if (this.isField) {
            this.typeTextField.setText(string3 == null ? "***" : ClassUtil.externalType(string3));
        } else {
            this.typeTextField.setText(string3 == null ? "***" : ClassUtil.externalMethodReturnType(string3));
            this.argumentTypesTextField.setText(string3 == null ? "..." : ClassUtil.externalMethodArguments(string3));
        }
    }

    public MemberSpecification getMemberSpecification() {
        String string = this.annotationTypeTextField.getText();
        String string2 = this.nameTextField.getText();
        String string3 = this.typeTextField.getText();
        String string4 = this.argumentTypesTextField.getText();
        String string5 = string = string.equals("") || string.equals("***") ? null : ClassUtil.internalType(string);
        if (string2.equals("") || string2.equals("*")) {
            string2 = null;
        }
        if (this.isField) {
            string3 = string3.equals("") || string3.equals("***") ? null : ClassUtil.internalType(string3);
        } else {
            if (string3.equals("")) {
                string3 = "void";
            }
            string3 = string3.equals("***") && string4.equals("...") ? null : ClassUtil.internalMethodDescriptor(string3, ListUtil.commaSeparatedList(string4));
        }
        MemberSpecification memberSpecification = new MemberSpecification(0, 0, string, string2, string3);
        this.getMemberSpecificationRadioButtons(memberSpecification, 1, this.publicRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 2, this.privateRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 4, this.protectedRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 8, this.staticRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 16, this.finalRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 4096, this.syntheticRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 64, this.volatileRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 128, this.transientRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 32, this.synchronizedRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 256, this.nativeRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 1024, this.abstractRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 2048, this.strictRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 64, this.bridgeRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 128, this.varargsRadioButtons);
        return memberSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setMemberSpecificationRadioButtons(MemberSpecification memberSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            int n2 = (memberSpecification.requiredSetAccessFlags & n) != 0 ? 0 : ((memberSpecification.requiredUnsetAccessFlags & n) != 0 ? 1 : 2);
            jRadioButtonArray[n2].setSelected(true);
        }
    }

    private void getMemberSpecificationRadioButtons(MemberSpecification memberSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            if (jRadioButtonArray[0].isSelected()) {
                memberSpecification.requiredSetAccessFlags |= n;
            } else if (jRadioButtonArray[1].isSelected()) {
                memberSpecification.requiredUnsetAccessFlags |= n;
            }
        }
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(MemberSpecificationDialog.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }
}

