/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.plaf.basic.core.BasicTransferable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.TextAnchor;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ResponseCountSnapshot;
import org.zaproxy.zap.extension.ascan.ScanProgressActionIcon;
import org.zaproxy.zap.extension.ascan.ScanProgressItem;
import org.zaproxy.zap.extension.ascan.ScanProgressTableModel;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.LayoutHelper;

public class ScanProgressDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ScanProgressDialog.class);
    private transient Color JTABLE_ALTERNATE_BACKGROUND = (Color)LookAndFeel.getDesktopPropertyValue("Table.alternateRowColor", new Color(0xF2F2F2));
    private ExtensionActiveScan extension;
    private JScrollPane jScrollPane = null;
    private JTable table;
    private ScanProgressTableModel model;
    private JButton closeButton = null;
    private JButton copyToClipboardButton;
    private JComboBox<String> hostSelect = null;
    private String site = null;
    private ActiveScan scan = null;
    private boolean stopThread = false;
    private JFreeChart chart;
    private List<String> labelsAdded = new ArrayList<String>();
    private TimeSeries seriesTotal;
    private TimeSeries series100;
    private TimeSeries series200;
    private TimeSeries series300;
    private TimeSeries series400;
    private TimeSeries series500;
    private double lastCentre = -1.0;

    public ScanProgressDialog(Frame frame, String string, ExtensionActiveScan extensionActiveScan) {
        super(frame, false);
        this.site = string;
        this.extension = extensionActiveScan;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(580, 504));
        if (this.site != null) {
            this.setTitle(MessageFormat.format(Constant.messages.getString("ascan.progress.title"), this.site));
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)new JLabel(Constant.messages.getString("ascan.progress.label.host")), LayoutHelper.getGBC(0, 0, 1, 0.4));
        jPanel2.add(this.getHostSelect(), LayoutHelper.getGBC(1, 0, 1, 0.6));
        jPanel.add((Component)jPanel2, LayoutHelper.getGBC(0, 0, 3, 1.0, 0.0));
        jPanel.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 0));
        jPanel3.add(this.getCopyToClipboardButton());
        jPanel3.add(this.getCloseButton());
        jPanel.add((Component)jPanel3, LayoutHelper.getGBC(0, 2, 3, 1.0));
        jTabbedPane.insertTab(Constant.messages.getString("ascan.progress.tab.progress"), null, jPanel, null, 0);
        this.add(jTabbedPane);
        int n = this.extension.getScannerParam().getMaxChartTimeInMins();
        if (n > 0) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            this.seriesTotal = new TimeSeries((Comparable)((Object)"TotalResponses"));
            TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(this.seriesTotal);
            this.series100 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.1xx")));
            this.series200 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.2xx")));
            this.series300 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.3xx")));
            this.series400 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.4xx")));
            this.series500 = new TimeSeries((Comparable)((Object)Constant.messages.getString("ascan.progress.chart.5xx")));
            this.seriesTotal.setMaximumItemAge((long)(n * 60));
            this.series100.setMaximumItemAge((long)(n * 60));
            this.series200.setMaximumItemAge((long)(n * 60));
            this.series300.setMaximumItemAge((long)(n * 60));
            this.series400.setMaximumItemAge((long)(n * 60));
            this.series500.setMaximumItemAge((long)(n * 60));
            timeSeriesCollection.addSeries(this.series100);
            timeSeriesCollection.addSeries(this.series200);
            timeSeriesCollection.addSeries(this.series300);
            timeSeriesCollection.addSeries(this.series400);
            timeSeriesCollection.addSeries(this.series500);
            this.chart = this.createChart((XYDataset)timeSeriesCollection);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(0, (Paint)Color.BLACK);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(1, (Paint)Color.GRAY);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(2, (Paint)Color.GREEN);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(3, (Paint)Color.BLUE);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(4, (Paint)Color.MAGENTA);
            this.chart.getXYPlot().getRenderer(0).setSeriesPaint(5, (Paint)Color.RED);
            ChartPanel chartPanel = new ChartPanel(this.chart);
            jPanel4.add((Component)chartPanel, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            jTabbedPane.insertTab(Constant.messages.getString("ascan.progress.tab.chart"), null, jPanel4, null, 1);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ScanProgressDialog.this.stopThread = true;
            }
        });
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(null, (String)Constant.messages.getString("ascan.progress.chart.time"), (String)Constant.messages.getString("ascan.progress.chart.responses"), (XYDataset)xYDataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setAutoRange(true);
        valueAxis.setAutoRangeMinimumSize(60000.0);
        xYPlot.getRangeAxis().setAutoRangeMinimumSize(20.0);
        return jFreeChart;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getMainPanel());
            this.jScrollPane.setName("ScanProgressScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.jScrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Constant.messages.getString("all.button.close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanProgressDialog.this.dispatchEvent(new WindowEvent(ScanProgressDialog.this, 201));
                }
            });
        }
        return this.closeButton;
    }

    private JButton getCopyToClipboardButton() {
        if (this.copyToClipboardButton == null) {
            this.copyToClipboardButton = new JButton(Constant.messages.getString("ascan.progress.copyclipboard.button.label"));
            this.copyToClipboardButton.setToolTipText(Constant.messages.getString("ascan.progress.copyclipboard.button.tooltip"));
            this.copyToClipboardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("<html>\n<body>\n<table>\n");
                    TableModel tableModel = ScanProgressDialog.this.getMainPanel().getModel();
                    stringBuilder2.append("<tr>\n");
                    for (n = 0; n < tableModel.getColumnCount(); ++n) {
                        String string = tableModel.getColumnName(n);
                        stringBuilder.append(string).append('\t');
                        stringBuilder2.append("  <td>").append(string).append("</td>\n");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1).append("\n");
                    stringBuilder2.append("</tr>\n");
                    for (n = 0; n < tableModel.getRowCount(); ++n) {
                        stringBuilder2.append("<tr>\n");
                        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                            Object object = tableModel.getValueAt(n, i);
                            String string = object == null ? "" : object.toString();
                            stringBuilder.append(string).append('\t');
                            stringBuilder2.append("  <td>").append(string).append("</td>\n");
                        }
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1).append("\n");
                        stringBuilder2.append("</tr>\n");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder2.append("</table>\n</body>\n</html>");
                    BasicTransferable basicTransferable = new BasicTransferable(stringBuilder.toString(), stringBuilder2.toString());
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)basicTransferable, null);
                    }
                    catch (IllegalStateException illegalStateException) {
                        View.getSingleton().showWarningDialog(ScanProgressDialog.this, Constant.messages.getString("ascan.progress.copyclipboard.error"));
                        log.warn((Object)"Failed to copy the contents to clipboard:", (Throwable)illegalStateException);
                    }
                }
            });
        }
        return this.copyToClipboardButton;
    }

    private JTable getMainPanel() {
        if (this.table == null) {
            this.model = new ScanProgressTableModel();
            this.table = new JTable();
            this.table.setModel(this.model);
            this.table.setRowSelectionAllowed(false);
            this.table.setColumnSelectionAllowed(false);
            this.table.setDoubleBuffered(true);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(256);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(2).setCellRenderer(new ScanProgressBarRenderer());
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(0);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(85);
            this.table.getColumnModel().getColumn(3).setCellRenderer(defaultTableCellRenderer);
            DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
            defaultTableCellRenderer2.setHorizontalAlignment(4);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(4).setCellRenderer(defaultTableCellRenderer2);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.table.getColumnModel().getColumn(5).setCellRenderer(new ScanProgressActionRenderer());
            ScanProgressActionListener scanProgressActionListener = new ScanProgressActionListener(this.table);
            this.table.addMouseListener(scanProgressActionListener);
            this.table.addMouseMotionListener(scanProgressActionListener);
        }
        return this.table;
    }

    private void showProgress() {
        HostProcess hostProcess = this.getSelectedHostProcess();
        if (this.scan.getHostProcesses() != null && hostProcess != null) {
            this.model.updateValues(this.scan, hostProcess);
            if (this.scan.isStopped()) {
                this.stopThread = true;
            }
            if (this.chart != null) {
                ResponseCountSnapshot responseCountSnapshot = this.scan.getRequestHistory();
                while (responseCountSnapshot != null) {
                    try {
                        Second second = new Second(responseCountSnapshot.getDate());
                        this.seriesTotal.add((RegularTimePeriod)second, (double)responseCountSnapshot.getTotal());
                        this.series100.add((RegularTimePeriod)second, (double)responseCountSnapshot.getResp100());
                        this.series200.add((RegularTimePeriod)second, (double)responseCountSnapshot.getResp200());
                        this.series300.add((RegularTimePeriod)second, (double)responseCountSnapshot.getResp300());
                        this.series400.add((RegularTimePeriod)second, (double)responseCountSnapshot.getResp400());
                        this.series500.add((RegularTimePeriod)second, (double)responseCountSnapshot.getResp500());
                        responseCountSnapshot = this.scan.getRequestHistory();
                        for (Plugin plugin : this.scan.getHostProcesses().get(0).getRunning()) {
                            List list;
                            if (this.labelsAdded.contains(plugin.getName())) continue;
                            ValueMarker valueMarker = new ValueMarker((double)plugin.getTimeStarted().getTime());
                            double d = this.chart.getXYPlot().getRangeAxis().getRange().getCentralValue();
                            if (this.lastCentre != d) {
                                if (this.lastCentre != -1.0) {
                                    list = this.chart.getXYPlot().getAnnotations();
                                    for (Object e : list) {
                                        if (!(e instanceof XYTextAnnotation)) continue;
                                        XYTextAnnotation xYTextAnnotation = (XYTextAnnotation)e;
                                        xYTextAnnotation.setY(d);
                                    }
                                }
                                this.lastCentre = d;
                            }
                            list = new XYTextAnnotation(plugin.getName(), (double)plugin.getTimeStarted().getTime(), d);
                            list.setFont(FontUtils.getFont("Sans Serif"));
                            list.setRotationAnchor(TextAnchor.BASELINE_CENTER);
                            list.setTextAnchor(TextAnchor.BASELINE_CENTER);
                            list.setRotationAngle(-1.57);
                            list.setPaint(Color.black);
                            this.chart.getXYPlot().addDomainMarker((Marker)valueMarker, Layer.BACKGROUND);
                            this.chart.getXYPlot().addAnnotation((XYAnnotation)list);
                            this.labelsAdded.add(plugin.getName());
                        }
                    }
                    catch (Exception exception) {
                        log.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
    }

    private HostProcess getSelectedHostProcess() {
        String string = (String)this.getHostSelect().getSelectedItem();
        if (string == null) {
            return null;
        }
        for (HostProcess hostProcess : this.scan.getHostProcesses()) {
            if (!string.equals(hostProcess.getHostAndPort())) continue;
            return hostProcess;
        }
        return null;
    }

    public void setActiveScan(ActiveScan activeScan) {
        this.scan = activeScan;
        if (activeScan == null) {
            return;
        }
        this.getHostSelect().removeAll();
        for (HostProcess hostProcess : activeScan.getHostProcesses()) {
            this.getHostSelect().addItem(hostProcess.getHostAndPort());
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!ScanProgressDialog.this.stopThread) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ScanProgressDialog.this.showProgress();
                        }
                    });
                    try {
                        4.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
    }

    private JComboBox<String> getHostSelect() {
        if (this.hostSelect == null) {
            this.hostSelect = new JComboBox();
            this.hostSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanProgressDialog.this.showProgress();
                }
            });
        }
        return this.hostSelect;
    }

    private class ScanProgressActionListener
    implements MouseListener,
    MouseMotionListener {
        private JTable table;

        public ScanProgressActionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.invokeAction();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.setPressed();
                scanProgressActionIcon.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                scanProgressActionIcon.setReleased();
                scanProgressActionIcon.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ScanProgressActionIcon scanProgressActionIcon = this.getScanProgressAction(mouseEvent);
            if (scanProgressActionIcon != null) {
                ScanProgressDialog.this.model.setFocusedAction(scanProgressActionIcon);
                scanProgressActionIcon.repaint();
            } else if (ScanProgressDialog.this.model.getFocusedAction() != null) {
                ScanProgressDialog.this.model.setFocusedAction(scanProgressActionIcon);
                this.table.repaint();
            }
        }

        private ScanProgressActionIcon getScanProgressAction(MouseEvent mouseEvent) {
            Object object;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 < this.table.getRowCount() && n2 >= 0 && n < this.table.getColumnCount() && n >= 0 && (object = this.table.getValueAt(n2, n)) instanceof ScanProgressActionIcon) {
                return (ScanProgressActionIcon)object;
            }
            return null;
        }
    }

    private class ScanProgressActionRenderer
    implements TableCellRenderer {
        private ScanProgressActionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (object != null) {
                ScanProgressActionIcon scanProgressActionIcon = (ScanProgressActionIcon)object;
                if (scanProgressActionIcon == ScanProgressDialog.this.model.getFocusedAction()) {
                    scanProgressActionIcon.setOver();
                } else {
                    scanProgressActionIcon.setNormal();
                }
                jComponent = scanProgressActionIcon;
            } else {
                jComponent = (JComponent)Box.createGlue();
            }
            jComponent.setOpaque(true);
            jComponent.setBackground(ScanProgressDialog.this.JTABLE_ALTERNATE_BACKGROUND);
            return jComponent;
        }
    }

    private class ScanProgressBarRenderer
    implements TableCellRenderer {
        private ScanProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (object != null) {
                ScanProgressItem scanProgressItem = (ScanProgressItem)object;
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setMaximum(100);
                jProgressBar.setValue(scanProgressItem.getProgressPercentage());
                jComponent = jProgressBar;
            } else {
                jComponent = (JComponent)Box.createGlue();
            }
            jComponent.setOpaque(true);
            jComponent.setBackground(ScanProgressDialog.this.JTABLE_ALTERNATE_BACKGROUND);
            return jComponent;
        }
    }
}

