/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ThrowStatement
extends Statement {
    public Expression exception;
    public TypeBinding exceptionType;

    public ThrowStatement(Expression expression, int n, int n2) {
        this.exception = expression;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.exception.analyseCode(blockScope, flowContext, flowInfo);
        this.exception.checkNPE(blockScope, flowContext, flowInfo);
        flowContext.checkExceptionHandlers(this.exceptionType, (ASTNode)this, flowInfo, blockScope);
        blockScope.checkUnclosedCloseables(flowInfo, flowContext, this, blockScope);
        flowContext.recordAbruptExit();
        return FlowInfo.DEAD_END;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        this.exception.generateCode(blockScope, codeStream, true);
        codeStream.athrow();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ThrowStatement.printIndent(n, stringBuffer).append("throw ");
        this.exception.printExpression(0, stringBuffer);
        return stringBuffer.append(';');
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.exceptionType = this.exception.resolveType(blockScope);
        this.recordExceptionsForEnclosingLambda(blockScope, this.exceptionType);
        if (this.exceptionType != null && this.exceptionType.isValidBinding()) {
            if (this.exceptionType == TypeBinding.NULL) {
                if (blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
                    blockScope.problemReporter().cannotThrowNull(this.exception);
                }
            } else if (this.exceptionType.findSuperTypeOriginatingFrom(21, true) == null) {
                blockScope.problemReporter().cannotThrowType(this.exception, this.exceptionType);
            }
            this.exception.computeConversion(blockScope, this.exceptionType, this.exceptionType);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.exception.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

