/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.profiling.presets.ProfilerMemorySettings;
import com.sun.tools.visualvm.profiling.presets.ProfilerPreset;
import com.sun.tools.visualvm.uisupport.JExtendedSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class ProfilerMemoryPanel
extends JPanel {
    private JRadioButton allocRadioButton;
    private JRadioButton livenessRadioButton;
    private JCheckBox stackTracesCheckBox;
    private JLabel trackEveryLabel1;
    private JLabel trackEveryLabel2;
    private JSpinner trackEverySpinner;
    private boolean internalChange;

    public ProfilerMemoryPanel() {
        this(false);
    }

    ProfilerMemoryPanel(boolean mnemonics) {
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = this.allocRadioButton.isSelected() ? ProfilingSettingsPresets.createMemoryPreset((int)2) : ProfilingSettingsPresets.createMemoryPreset((int)4);
        settings.setAllocStackTraceLimit(this.stackTracesCheckBox.isSelected() ? -1 : 0);
        settings.setAllocTrackEvery(((Integer)this.trackEverySpinner.getValue()).intValue());
        return settings;
    }

    public boolean settingsValid() {
        return true;
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.allocRadioButton.setSelected(!preset.getMemoryModeP());
        this.livenessRadioButton.setSelected(preset.getMemoryModeP());
        this.stackTracesCheckBox.setSelected(preset.getStacksP());
        this.trackEverySpinner.setValue(preset.getAllocP());
        this.internalChange = false;
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setMemoryModeP(this.livenessRadioButton.isSelected());
        preset.setStacksP(this.stackTracesCheckBox.isSelected());
        preset.setAllocP((Integer)this.trackEverySpinner.getValue());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JLabel referenceLabel = new JLabel("X");
        ButtonGroup modesRadioGroup = new ButtonGroup();
        this.allocRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        ProfilerMemoryPanel.setText(this.allocRadioButton, NbBundle.getMessage(ProfilerMemorySettings.class, (String)"LBL_Profile_Allocations"), mnemonics);
        this.allocRadioButton.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Allocations"));
        this.allocRadioButton.setOpaque(false);
        this.allocRadioButton.setBorder(referenceLabel.getBorder());
        modesRadioGroup.add(this.allocRadioButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.allocRadioButton, constraints);
        this.livenessRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        ProfilerMemoryPanel.setText(this.livenessRadioButton, NbBundle.getMessage(ProfilerMemorySettings.class, (String)"LBL_Profile_AllocationsGC"), mnemonics);
        this.livenessRadioButton.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Allocations_GC"));
        this.livenessRadioButton.setOpaque(false);
        this.livenessRadioButton.setBorder(referenceLabel.getBorder());
        modesRadioGroup.add(this.livenessRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.livenessRadioButton, constraints);
        JPanel trackEveryContainer = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.trackEveryLabel1 = new JLabel();
        ProfilerMemoryPanel.setText(this.trackEveryLabel1, NbBundle.getMessage(ProfilerMemorySettings.class, (String)"LBL_Track_Every1"), mnemonics);
        this.trackEveryLabel1.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel1.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        trackEveryContainer.add((Component)this.trackEveryLabel1, constraints);
        this.trackEverySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        this.trackEverySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProfilerMemoryPanel.this.syncUI();
            }
        });
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.trackEverySpinner.getEditor();
        editor.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    ProfilerMemoryPanel.this.trackEverySpinner.commitEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    ProfilerMemoryPanel.this.trackEverySpinner.commitEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    ProfilerMemoryPanel.this.trackEverySpinner.commitEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.trackEverySpinner.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel1.setLabelFor(this.trackEverySpinner);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        trackEveryContainer.add((Component)this.trackEverySpinner, constraints);
        this.trackEveryLabel2 = new JLabel(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"LBL_Track_Every2"));
        this.trackEveryLabel2.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel2.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        trackEveryContainer.add((Component)this.trackEveryLabel2, constraints);
        trackEveryContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)trackEveryContainer, constraints);
        this.stackTracesCheckBox = new JCheckBox(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        ProfilerMemoryPanel.setText(this.stackTracesCheckBox, NbBundle.getMessage(ProfilerMemorySettings.class, (String)"LBL_Record_Stacktraces"), mnemonics);
        this.stackTracesCheckBox.setToolTipText(NbBundle.getMessage(ProfilerMemorySettings.class, (String)"TOOLTIP_Stack_Traces"));
        this.stackTracesCheckBox.setOpaque(false);
        this.stackTracesCheckBox.setBorder(referenceLabel.getBorder());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.stackTracesCheckBox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Spacer.create(), constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static void setText(AbstractButton b, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((AbstractButton)b, (String)text);
        } else {
            b.setText(text.replace("&", ""));
        }
    }
}

