/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemProperties {
    private static final Set<String> STANDARD_PROPERTIES = ImmutableSet.of("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", new String[]{"java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"});
    private static final Set<String> IMPORTANT_NON_STANDARD_PROPERTIES = ImmutableSet.of("java.runtime.version");
    private static final SystemProperties INSTANCE = new SystemProperties();
    private final Lock lock = new ReentrantLock();

    public static SystemProperties getInstance() {
        return INSTANCE;
    }

    public Map<String, String> asMap() {
        return System.getProperties();
    }

    public String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public String getJavaIoTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getUserHome() {
        return System.getProperty("user.home");
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public File getCurrentDir() {
        return new File(System.getProperty("user.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getJavaHomeDir() {
        File javaHomeDir;
        this.lock.lock();
        try {
            javaHomeDir = new File(System.getProperty("java.home"));
        }
        finally {
            this.lock.unlock();
        }
        return javaHomeDir;
    }

    public <T> T withJavaHome(File javaHomeDir, Factory<T> factory) {
        return this.withSystemProperty("java.home", javaHomeDir.getAbsolutePath(), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withSystemProperty(String propertyName, String value, Factory<T> factory) {
        this.lock.lock();
        String originalValue = System.getProperty(propertyName);
        System.setProperty(propertyName, value);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            if (originalValue != null) {
                System.setProperty(propertyName, originalValue);
            } else {
                System.clearProperty(propertyName);
            }
            this.lock.unlock();
        }
    }

    public Set<String> getStandardProperties() {
        return STANDARD_PROPERTIES;
    }

    public Set<String> getNonStandardImportantProperties() {
        return IMPORTANT_NON_STANDARD_PROPERTIES;
    }
}

