#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: haskell-src-exts
version: 1.17.1
id: haskell-src-exts-1.17.1-84GJDAJ2Zmm6szDkDVLEjE
key: haskell-src-exts-1.17.1-84GJDAJ2Zmm6szDkDVLEjE
license: BSD3
maintainer: Niklas Broberg <niklas.broberg@chalmers.se>, Roman Cheplyaka <roma@ro-che.info>
stability: Stable
homepage: https://github.com/haskell-suite/haskell-src-exts
synopsis: Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer
description:
    Haskell-Source with Extensions (HSE, haskell-src-exts)
    is an extension of the standard haskell-src package,
    and handles most registered syntactic extensions to Haskell, including:
    .
    * Multi-parameter type classes with functional dependencies
    .
    * Indexed type families (including associated types)
    .
    * Empty data declarations
    .
    * GADTs
    .
    * Implicit parameters
    .
    * Template Haskell
    .
    and a few more. All extensions implemented in GHC are supported.
    Apart from these standard extensions,
    it also handles regular patterns as per the HaRP extension
    as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
exposed: True
exposed-modules:
    Language.Haskell.Exts Language.Haskell.Exts.Lexer
    Language.Haskell.Exts.Parser Language.Haskell.Exts.Pretty
    Language.Haskell.Exts.Syntax Language.Haskell.Exts.Extension
    Language.Haskell.Exts.Build Language.Haskell.Exts.Fixity
    Language.Haskell.Exts.Comments Language.Haskell.Exts.SrcLoc
    Language.Haskell.Exts.Annotated
    Language.Haskell.Exts.Annotated.Syntax
    Language.Haskell.Exts.Annotated.Fixity
    Language.Haskell.Exts.Annotated.Build
    Language.Haskell.Exts.Annotated.ExactPrint
    Language.Haskell.Exts.Annotated.Simplify
    Language.Haskell.Exts.Annotated.Parser
    Language.Haskell.Exts.Annotated.Comments
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.InternalLexer
                Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
abi: 1661587999d35097ba318a0c60cdb597
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/haskell-src-exts-1.17.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/haskell-src-exts-1.17.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/haskell-src-exts-1.17.1
hs-libraries: HShaskell-src-exts-1.17.1-84GJDAJ2Zmm6szDkDVLEjE
depends:
    array-0.5.1.1 base-4.9.0.0 cpphs-1.20.1-IcrYuzpjU6YKBdwhEUNDVf
    ghc-prim-0.5.0.0 pretty-1.1.3.3
haddock-interfaces: /usr/share/doc/haskell-src-exts/html/haskell-src-exts.haddock
haddock-html: /usr/share/doc/haskell-src-exts/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
