/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmWriter
extends XmlWriter
implements PrimitiveVisitor {
    public static final String DEFAULT_API_VERSION = "0.6";
    private final boolean osmConform;
    private boolean withBody = true;
    private boolean isOsmChange;
    private String version;
    private Changeset changeset;
    protected static final Comparator<AbstractPrimitive> byIdComparator = new Comparator<AbstractPrimitive>(){

        @Override
        public int compare(AbstractPrimitive abstractPrimitive, AbstractPrimitive abstractPrimitive2) {
            long l = abstractPrimitive.getUniqueId();
            long l2 = abstractPrimitive2.getUniqueId();
            if (l < 0L && l2 < 0L) {
                return Long.compare(l2, l);
            }
            return Long.compare(l, l2);
        }
    };
    protected static final Comparator<Map.Entry<String, String>> byKeyComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };

    protected OsmWriter(PrintWriter printWriter, boolean bl, String string) {
        super(printWriter);
        this.osmConform = bl;
        this.version = string == null ? DEFAULT_API_VERSION : string;
    }

    public void setWithBody(boolean bl) {
        this.withBody = bl;
    }

    public void setIsOsmChange(boolean bl) {
        this.isOsmChange = bl;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void header() {
        this.header(null);
    }

    public void header(Boolean bl) {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        if (bl != null) {
            this.out.print("' upload='");
            this.out.print(bl);
        }
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    protected <T extends OsmPrimitive> Collection<T> sortById(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        arrayList.addAll(collection);
        Collections.sort(arrayList, byIdComparator);
        return arrayList;
    }

    public void writeLayer(OsmDataLayer osmDataLayer) {
        this.header(!osmDataLayer.isUploadDiscouraged());
        this.writeDataSources(osmDataLayer.data);
        this.writeContent(osmDataLayer.data);
        this.footer();
    }

    public void writeContent(DataSet dataSet) {
        this.writeNodes(dataSet.getNodes());
        this.writeWays(dataSet.getWays());
        this.writeRelations(dataSet.getRelations());
    }

    public void writeNodes(Collection<Node> collection) {
        for (Node node : this.sortById(collection)) {
            if (!this.shouldWrite(node)) continue;
            this.visit(node);
        }
    }

    public void writeWays(Collection<Way> collection) {
        for (Way way : this.sortById(collection)) {
            if (!this.shouldWrite(way)) continue;
            this.visit(way);
        }
    }

    public void writeRelations(Collection<Relation> collection) {
        for (Relation relation : this.sortById(collection)) {
            if (!this.shouldWrite(relation)) continue;
            this.visit(relation);
        }
    }

    protected boolean shouldWrite(OsmPrimitive osmPrimitive) {
        return !osmPrimitive.isNewOrUndeleted() || !osmPrimitive.isDeleted();
    }

    public void writeDataSources(DataSet dataSet) {
        for (DataSource dataSource : dataSet.dataSources) {
            this.out.println("  <bounds minlat='" + dataSource.bounds.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "' minlon='" + dataSource.bounds.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "' maxlat='" + dataSource.bounds.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES) + "' maxlon='" + dataSource.bounds.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "' origin='" + XmlWriter.encode(dataSource.origin) + "' />");
        }
    }

    @Override
    public void visit(INode iNode) {
        if (iNode.isIncomplete()) {
            return;
        }
        this.addCommon(iNode, "node");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            if (iNode.getCoor() != null) {
                this.out.print(" lat='" + LatLon.cDdHighPecisionFormatter.format(iNode.getCoor().lat()) + "' lon='" + LatLon.cDdHighPecisionFormatter.format(iNode.getCoor().lon()) + '\'');
            }
            this.addTags(iNode, "node", true);
        }
    }

    @Override
    public void visit(IWay iWay) {
        if (iWay.isIncomplete()) {
            return;
        }
        this.addCommon(iWay, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < iWay.getNodesCount(); ++i) {
                this.out.println("    <nd ref='" + iWay.getNodeId(i) + "' />");
            }
            this.addTags(iWay, "way", false);
        }
    }

    @Override
    public void visit(IRelation iRelation) {
        if (iRelation.isIncomplete()) {
            return;
        }
        this.addCommon(iRelation, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < iRelation.getMembersCount(); ++i) {
                this.out.print("    <member type='");
                this.out.print(iRelation.getMemberType(i).getAPIName());
                this.out.println("' ref='" + iRelation.getMemberId(i) + "' role='" + XmlWriter.encode(iRelation.getRole(i)) + "' />");
            }
            this.addTags(iRelation, "relation", false);
        }
    }

    public void visit(Changeset changeset) {
        this.out.print("  <changeset id='" + changeset.getId() + '\'');
        if (changeset.getUser() != null) {
            this.out.print(" user='" + XmlWriter.encode(changeset.getUser().getName()) + '\'');
            this.out.print(" uid='" + changeset.getUser().getId() + '\'');
        }
        if (changeset.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(changeset.getCreatedAt()) + '\'');
        }
        if (changeset.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(changeset.getClosedAt()) + '\'');
        }
        this.out.print(" open='" + (changeset.isOpen() ? "true" : "false") + '\'');
        if (changeset.getMin() != null) {
            this.out.print(" min_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + '\'');
            this.out.print(" min_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + '\'');
        }
        if (changeset.getMax() != null) {
            this.out.print(" max_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + '\'');
            this.out.print(" max_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + '\'');
        }
        this.out.println(">");
        this.addTags(changeset, "changeset", false);
    }

    protected void addTags(Tagged tagged, String string, boolean bl) {
        if (tagged.hasKeys()) {
            if (bl) {
                this.out.println(">");
            }
            ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(tagged.getKeys().entrySet());
            Collections.sort(arrayList, byKeyComparator);
            for (Map.Entry entry : arrayList) {
                this.out.println("    <tag k='" + XmlWriter.encode((String)entry.getKey()) + "' v='" + XmlWriter.encode((String)entry.getValue()) + "' />");
            }
            this.out.println("  </" + string + '>');
        } else if (bl) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + string + '>');
        }
    }

    protected void addCommon(IPrimitive iPrimitive, String string) {
        this.out.print("  <" + string);
        if (iPrimitive.getUniqueId() == 0L) {
            throw new IllegalStateException(I18n.tr("Unexpected id 0 for osm primitive found", new Object[0]));
        }
        this.out.print(" id='" + iPrimitive.getUniqueId() + '\'');
        if (!this.isOsmChange) {
            if (!this.osmConform) {
                String string2 = null;
                if (iPrimitive.isDeleted()) {
                    string2 = "delete";
                } else if (iPrimitive.isModified()) {
                    string2 = "modify";
                }
                if (string2 != null) {
                    this.out.print(" action='" + string2 + '\'');
                }
            }
            if (!iPrimitive.isTimestampEmpty()) {
                this.out.print(" timestamp='" + DateUtils.fromTimestamp(iPrimitive.getRawTimestamp()) + '\'');
            }
            if (iPrimitive.getUser() != null) {
                if (iPrimitive.getUser().isLocalUser()) {
                    this.out.print(" user='" + XmlWriter.encode(iPrimitive.getUser().getName()) + '\'');
                } else if (iPrimitive.getUser().isOsmUser()) {
                    this.out.print(" uid='" + iPrimitive.getUser().getId() + '\'');
                    this.out.print(" user='" + XmlWriter.encode(iPrimitive.getUser().getName()) + '\'');
                }
            }
            this.out.print(" visible='" + iPrimitive.isVisible() + '\'');
        }
        if (iPrimitive.getVersion() != 0) {
            this.out.print(" version='" + iPrimitive.getVersion() + '\'');
        }
        if (this.changeset != null && this.changeset.getId() != 0) {
            this.out.print(" changeset='" + this.changeset.getId() + '\'');
        } else if (iPrimitive.getChangesetId() > 0 && !iPrimitive.isNew()) {
            this.out.print(" changeset='" + iPrimitive.getChangesetId() + '\'');
        }
    }
}

