/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.io.remotecontrol.DNSName;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class RemoteControlHttpsServer
extends Thread {
    private final ServerSocket server;
    private static volatile RemoteControlHttpsServer instance4;
    private static volatile RemoteControlHttpsServer instance6;
    private SSLContext sslContext;
    private static final int HTTPS_PORT = 8112;
    public static final String KEYSTORE_FILENAME = "josm.keystore";
    public static final StringProperty KEYSTORE_PASSWORD;
    public static final StringProperty KEYENTRY_PASSWORD;
    public static final String ENTRY_ALIAS = "josm_localhost";

    private static GeneralName createGeneralName(String string, String string2) throws IOException {
        GeneralNameInterface generalNameInterface;
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "uri": {
                generalNameInterface = new URIName(string2);
                break;
            }
            case "dns": {
                generalNameInterface = new DNSName(string2);
                break;
            }
            case "ip": {
                generalNameInterface = new IPAddressName(string2);
                break;
            }
            default: {
                generalNameInterface = new OIDName(string2);
            }
        }
        return new GeneralName(generalNameInterface);
    }

    private static X509Certificate generateCertificate(String string, KeyPair keyPair, int n, String string2, String string3) throws GeneralSecurityException, IOException {
        Object object;
        X509CertInfo x509CertInfo = new X509CertInfo();
        Date date = new Date();
        Date date2 = new Date(date.getTime() + (long)n * 86400000L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        BigInteger bigInteger = new BigInteger(64, new SecureRandom());
        X500Name x500Name = new X500Name(string);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(bigInteger));
        if (!Main.isJava8orLater()) {
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
            x509CertInfo.set("issuer", new CertificateIssuerName(x500Name));
        } else {
            x509CertInfo.set("subject", x500Name);
            x509CertInfo.set("issuer", x500Name);
        }
        x509CertInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        x509CertInfo.set("version", new CertificateVersion(2));
        AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(Boolean.TRUE, false, 0));
        certificateExtensions.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension(Boolean.TRUE, new Vector<ObjectIdentifier>(Arrays.asList(new ObjectIdentifier("1.3.6.1.5.5.7.3.1")))));
        if (string3 != null) {
            object = string3.split(",");
            GeneralNames generalNames = new GeneralNames();
            for (String string4 : object) {
                int n2 = string4.indexOf(58);
                if (n2 < 0) {
                    throw new IllegalArgumentException("Illegal item " + string4 + " in " + string3);
                }
                String string5 = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1);
                generalNames.add(RemoteControlHttpsServer.createGeneralName(string5, string6));
            }
            certificateExtensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(Boolean.FALSE, generalNames));
        }
        x509CertInfo.set("extensions", certificateExtensions);
        PrivateKey privateKey = keyPair.getPrivate();
        object = new X509CertImpl(x509CertInfo);
        object.sign(privateKey, string2);
        algorithmId = (AlgorithmId)object.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        object = new X509CertImpl(x509CertInfo);
        object.sign(privateKey, string2);
        return object;
    }

    public static Path setupJosmKeystore() throws IOException, GeneralSecurityException {
        Path path = Paths.get(RemoteControl.getRemoteControlDir(), new String[0]);
        Path path2 = path.resolve(KEYSTORE_FILENAME);
        Files.createDirectories(path, new FileAttribute[0]);
        if (!Files.exists(path2, new LinkOption[0])) {
            Main.debug("No keystore found, creating a new one");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509Certificate x509Certificate = RemoteControlHttpsServer.generateCertificate("CN=localhost, OU=JOSM, O=OpenStreetMap", keyPair, 1825, "SHA256withRSA", "dns:localhost,ip:127.0.0.1,dns:127.0.0.1,ip:::1,uri:https://127.0.0.1:8112,uri:https://::1:8112");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            SecureRandom secureRandom = new SecureRandom();
            KEYSTORE_PASSWORD.put(new BigInteger(130, secureRandom).toString(32));
            KEYENTRY_PASSWORD.put(new BigInteger(130, secureRandom).toString(32));
            char[] cArray = KEYSTORE_PASSWORD.get().toCharArray();
            char[] cArray2 = KEYENTRY_PASSWORD.get().toCharArray();
            keyStore.setKeyEntry(ENTRY_ALIAS, keyPair.getPrivate(), cArray2, new Certificate[]{x509Certificate});
            keyStore.store(Files.newOutputStream(path2, StandardOpenOption.CREATE), cArray);
        }
        return path2;
    }

    public static KeyStore loadJosmKeystore() throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(RemoteControlHttpsServer.setupJosmKeystore(), new OpenOption[0]);){
            Object object;
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, KEYSTORE_PASSWORD.get().toCharArray());
            if (Main.isDebugEnabled()) {
                object = keyStore.aliases();
                while (object.hasMoreElements()) {
                    Main.debug("Alias in JOSM keystore: " + (String)object.nextElement());
                }
            }
            object = keyStore;
            return object;
        }
    }

    private void initialize() throws IOException, GeneralSecurityException {
        KeyStore keyStore = RemoteControlHttpsServer.loadJosmKeystore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, KEYENTRY_PASSWORD.get().toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        if (Main.isTraceEnabled()) {
            Main.trace("SSL Context protocol: " + this.sslContext.getProtocol());
            Main.trace("SSL Context provider: " + this.sslContext.getProvider());
        }
        RemoteControlHttpsServer.setupPlatform(keyStore);
    }

    public static boolean setupPlatform(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Enumeration<String> enumeration = keyStore.aliases();
        if (enumeration.hasMoreElements()) {
            return Main.platform.setupHttpsCertificate(ENTRY_ALIAS, new KeyStore.TrustedCertificateEntry(keyStore.getCertificate(enumeration.nextElement())));
        }
        return false;
    }

    public static void restartRemoteControlHttpsServer() {
        block5: {
            RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            if (RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.get().booleanValue()) {
                int n = Main.pref.getInteger("remote.control.https.port", 8112);
                try {
                    instance4 = new RemoteControlHttpsServer(n, false);
                    instance4.start();
                }
                catch (IOException | GeneralSecurityException exception) {
                    Main.warn(I18n.marktr("Cannot start IPv4 remotecontrol https server on port {0}: {1}"), Integer.toString(n), exception.getLocalizedMessage());
                }
                try {
                    instance6 = new RemoteControlHttpsServer(n, true);
                    instance6.start();
                }
                catch (IOException | GeneralSecurityException exception) {
                    if (instance4 != null) break block5;
                    Main.warn(I18n.marktr("Cannot start IPv6 remotecontrol https server on port {0}: {1}"), Integer.toString(n), exception.getLocalizedMessage());
                }
            }
        }
    }

    public static void stopRemoteControlHttpsServer() {
        if (instance4 != null) {
            try {
                instance4.stopServer();
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
            instance4 = null;
        }
        if (instance6 != null) {
            try {
                instance6.stopServer();
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
            instance6 = null;
        }
    }

    public RemoteControlHttpsServer(int n, boolean bl) throws IOException, NoSuchAlgorithmException, GeneralSecurityException {
        super("RemoteControl HTTPS Server");
        this.setDaemon(true);
        this.initialize();
        SSLServerSocketFactory sSLServerSocketFactory = this.sslContext.getServerSocketFactory();
        if (Main.isTraceEnabled()) {
            Main.trace("SSL factory - Supported Cipher suites: " + Arrays.toString(sSLServerSocketFactory.getSupportedCipherSuites()));
        }
        this.server = sSLServerSocketFactory.createServerSocket(n, 1, bl ? RemoteControl.getInet6Address() : RemoteControl.getInet4Address());
        if (Main.isTraceEnabled() && this.server instanceof SSLServerSocket) {
            SSLServerSocket sSLServerSocket = (SSLServerSocket)this.server;
            Main.trace("SSL server - Enabled Cipher suites: " + Arrays.toString(sSLServerSocket.getEnabledCipherSuites()));
            Main.trace("SSL server - Enabled Protocols: " + Arrays.toString(sSLServerSocket.getEnabledProtocols()));
            Main.trace("SSL server - Enable Session Creation: " + sSLServerSocket.getEnableSessionCreation());
            Main.trace("SSL server - Need Client Auth: " + sSLServerSocket.getNeedClientAuth());
            Main.trace("SSL server - Want Client Auth: " + sSLServerSocket.getWantClientAuth());
            Main.trace("SSL server - Use Client Mode: " + sSLServerSocket.getUseClientMode());
        }
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting secure remote connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    if (Main.isTraceEnabled() && socket instanceof SSLSocket) {
                        SSLSocket sSLSocket = (SSLSocket)socket;
                        Main.trace("SSL socket - Enabled Cipher suites: " + Arrays.toString(sSLSocket.getEnabledCipherSuites()));
                        Main.trace("SSL socket - Enabled Protocols: " + Arrays.toString(sSLSocket.getEnabledProtocols()));
                        Main.trace("SSL socket - Enable Session Creation: " + sSLSocket.getEnableSessionCreation());
                        Main.trace("SSL socket - Need Client Auth: " + sSLSocket.getNeedClientAuth());
                        Main.trace("SSL socket - Want Client Auth: " + sSLSocket.getWantClientAuth());
                        Main.trace("SSL socket - Use Client Mode: " + sSLSocket.getUseClientMode());
                        Main.trace("SSL socket - Session: " + sSLSocket.getSession());
                    }
                    RequestProcessor.processRequest(socket);
                }
            }
            catch (SocketException socketException) {
                if (this.server.isClosed()) continue;
                Main.error(socketException);
                continue;
            }
            catch (IOException iOException) {
                Main.error(iOException);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        Main.info(I18n.marktr("RemoteControl::Server {0}:{1} stopped."), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        this.server.close();
    }

    static {
        KEYSTORE_PASSWORD = new StringProperty("remotecontrol.https.keystore.password", "");
        KEYENTRY_PASSWORD = new StringProperty("remotecontrol.https.keyentry.password", "");
    }
}

