/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.Runtime;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.cast.DefaultValueNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.platform.posix.ClockGetTime;
import org.jruby.truffle.platform.posix.TimeSpec;
import org.jruby.truffle.platform.signal.Signal;

@CoreClass(value="Process")
public abstract class ProcessNodes {
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_REALTIME = 2;
    public static final int CLOCK_THREAD_CPUTIME = 3;
    public static final int CLOCK_MONOTONIC_RAW = 4;

    @CoreMethod(names={"pid"}, onSingleton=true)
    public static abstract class PidNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int pid() {
            return this.posix().getpid();
        }
    }

    @CoreMethod(names={"kill"}, onSingleton=true, required=2, unsafe={UnsafeGroup.PROCESSES, UnsafeGroup.SIGNALS})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(signalName)"})
        public int kill(DynamicObject signalName, int pid) {
            int self = this.posix().getpid();
            if (self == pid) {
                return this.raise(Layouts.SYMBOL.getString(signalName));
            }
            throw new UnsupportedOperationException();
        }

        @CompilerDirectives.TruffleBoundary
        private int raise(String signalName) {
            Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(signalName);
            try {
                this.getContext().getNativePlatform().getSignalManager().raise(signal);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return 1;
        }
    }

    @CoreMethod(names={"clock_gettime"}, onSingleton=true, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="clock_id"), @NodeChild(type=RubyNode.class, value="unit")})
    public static abstract class ClockGetTimeNode
    extends CoreMethodNode {
        public static final int CLOCK_THREAD_CPUTIME_ID = 3;
        public static final int CLOCK_MONOTONIC_RAW_ID = 4;
        private final DynamicObject floatSecondSymbol = this.getSymbol("float_second");
        private final DynamicObject floatMicrosecondSymbol = this.getSymbol("float_microsecond");
        private final DynamicObject nanosecondSymbol = this.getSymbol("nanosecond");

        public ClockGetTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"unit"})
        public RubyNode coerceUnit(RubyNode unit) {
            return DefaultValueNodeGen.create(null, null, this.floatSecondSymbol, unit);
        }

        @Specialization(guards={"isMonotonic(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_monotonic(int clock_id, DynamicObject unit) {
            long time = System.nanoTime();
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isRealtime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_realtime(int clock_id, DynamicObject unit) {
            long time = System.currentTimeMillis() * 1000000L;
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isThreadCPUTime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_thread_cputime(int clock_id, DynamicObject unit) {
            return this.clock_gettime_clock_id(3, unit);
        }

        @Specialization(guards={"isMonotonicRaw(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_monotonic_raw(int clock_id, DynamicObject unit) {
            return this.clock_gettime_clock_id(4, unit);
        }

        @CompilerDirectives.TruffleBoundary
        private Object clock_gettime_clock_id(int clock_id, DynamicObject unit) {
            TimeSpec timeSpec;
            ClockGetTime libCClockGetTime = this.getContext().getNativePlatform().getClockGetTime();
            int r = libCClockGetTime.clock_gettime(clock_id, timeSpec = new TimeSpec(Runtime.getRuntime((Object)libCClockGetTime)));
            if (r != 0) {
                throw new RaiseException(this.coreExceptions().systemCallError("clock_gettime failed: " + r, this));
            }
            long nanos = timeSpec.getTVsec() * 1000000000L + timeSpec.getTVnsec();
            return this.timeToUnit(nanos, unit);
        }

        private Object timeToUnit(long time, DynamicObject unit) {
            assert (RubyGuards.isRubySymbol(unit));
            if (unit == this.nanosecondSymbol) {
                return time;
            }
            if (unit == this.floatMicrosecondSymbol) {
                return (double)time / 1000.0;
            }
            if (unit == this.floatSecondSymbol) {
                return (double)time / 1.0E9;
            }
            throw new UnsupportedOperationException(Layouts.SYMBOL.getString(unit));
        }

        protected static boolean isMonotonic(int clock_id) {
            return clock_id == 1;
        }

        protected static boolean isRealtime(int clock_id) {
            return clock_id == 2;
        }

        protected static boolean isThreadCPUTime(int clock_id) {
            return clock_id == 3;
        }

        protected static boolean isMonotonicRaw(int clock_id) {
            return clock_id == 4;
        }
    }
}

