/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.dir;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.platform.UnsafeGroup;

public abstract class DirNodes {

    @Primitive(name="dir_close", unsafe={UnsafeGroup.IO})
    public static abstract class DirClosePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject open(DynamicObject dir) {
            return this.nil();
        }
    }

    @Primitive(name="dir_control", unsafe={UnsafeGroup.IO})
    public static abstract class DirControlPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object control(DynamicObject dir, int kind, int position) {
            switch (kind) {
                case 0: {
                    Layouts.DIR.setPosition(dir, position);
                    return true;
                }
                case 1: {
                    Layouts.DIR.setPosition(dir, -2);
                    return true;
                }
                case 2: {
                    return Layouts.DIR.getPosition(dir);
                }
            }
            return this.nil();
        }
    }

    @Primitive(name="dir_read", unsafe={UnsafeGroup.IO})
    public static abstract class DirReadPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object read(DynamicObject dir) {
            int position = Layouts.DIR.getPosition(dir);
            Layouts.DIR.setPosition(dir, position + 1);
            if (position == -2) {
                return this.create7BitString(".", (Encoding)UTF8Encoding.INSTANCE);
            }
            if (position == -1) {
                return this.create7BitString("..", (Encoding)UTF8Encoding.INSTANCE);
            }
            String[] contents = (String[])Layouts.DIR.getContents(dir);
            if (position < contents.length) {
                return this.createString(StringOperations.encodeRope(contents[position], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.nil();
        }
    }

    @Primitive(name="dir_open", unsafe={UnsafeGroup.IO})
    public static abstract class DirOpenPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isNil(encoding)"})
        public DynamicObject open(DynamicObject dir, DynamicObject path, DynamicObject encoding) {
            File file = new File(path.toString());
            if (!file.isDirectory()) {
                throw new RaiseException(this.coreExceptions().errnoError(Errno.ENOTDIR.intValue(), this));
            }
            String[] contents = file.list();
            if (contents == null) {
                throw new UnsupportedOperationException();
            }
            Layouts.DIR.setContents(dir, contents);
            Layouts.DIR.setPosition(dir, -2);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyEncoding(encoding)"})
        public DynamicObject openEncoding(DynamicObject dir, DynamicObject path, DynamicObject encoding) {
            return this.open(dir, path, this.nil());
        }
    }

    @Primitive(name="dir_allocate")
    public static abstract class DirAllocatePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public DirAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject dirClass) {
            return this.allocateNode.allocate(dirClass, null, 0);
        }
    }
}

