/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.yield.YieldNode;

class TracePointEventNode
extends ExecutionEventNode {
    private final ConditionProfile inTraceFuncProfile = ConditionProfile.createBinaryProfile();
    private final RubyContext context;
    private final DynamicObject tracePoint;
    @Node.Child
    private YieldNode yieldNode;
    @CompilerDirectives.CompilationFinal
    private DynamicObject path;
    @CompilerDirectives.CompilationFinal
    private int line;

    public TracePointEventNode(RubyContext context, DynamicObject tracePoint) {
        this.context = context;
        this.tracePoint = tracePoint;
    }

    @Override
    protected void onEnter(VirtualFrame frame) {
        if (this.inTraceFuncProfile.profile(Layouts.TRACE_POINT.getInsideProc(this.tracePoint))) {
            return;
        }
        Layouts.TRACE_POINT.setEvent(this.tracePoint, this.context.getCoreStrings().LINE.getSymbol());
        Layouts.TRACE_POINT.setPath(this.tracePoint, this.getPath());
        Layouts.TRACE_POINT.setLine(this.tracePoint, this.getLine());
        Layouts.TRACE_POINT.setBinding(this.tracePoint, Layouts.BINDING.createBinding(this.context.getCoreLibrary().getBindingFactory(), frame.materialize()));
        Layouts.TRACE_POINT.setInsideProc(this.tracePoint, true);
        try {
            this.getYieldNode().dispatch(frame, Layouts.TRACE_POINT.getProc(this.tracePoint), this.tracePoint);
        }
        finally {
            Layouts.TRACE_POINT.setInsideProc(this.tracePoint, false);
        }
    }

    private DynamicObject getPath() {
        if (this.path == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.path = StringOperations.createString(this.context, this.context.getRopeTable().getRopeUTF8(this.getEncapsulatingSourceSection().getSource().getName()));
        }
        return this.path;
    }

    private int getLine() {
        if (this.line == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.line = this.getEncapsulatingSourceSection().getStartLine();
        }
        return this.line;
    }

    protected YieldNode getYieldNode() {
        if (this.yieldNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.yieldNode = this.insert(new YieldNode(this.context));
        }
        return this.yieldNode;
    }
}

