/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.math.BigInteger;
import org.jruby.RubyBignum;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Bignum
extends ImmutableLiteral {
    public final BigInteger value;

    public Bignum(BigInteger value2) {
        this.value = value2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.BIGNUM;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return RubyBignum.newBignum(context.runtime, this.value);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Bignum(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.value.toString());
    }

    public static Bignum decode(IRReaderDecoder d) {
        return new Bignum(new BigInteger(d.decodeString()));
    }

    public String toString() {
        return "Bignum:" + this.value;
    }
}

