/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.xml.sax.SAXException;

public class XmlRuleDisambiguator
implements Disambiguator {
    private static final String DISAMBIGUATION_FILE = "disambiguation.xml";
    private final List<DisambiguationPatternRule> disambiguationRules;

    public XmlRuleDisambiguator(Language language) {
        Objects.requireNonNull(language);
        String disambiguationFile = language.getShortName() + "/" + DISAMBIGUATION_FILE;
        try {
            this.disambiguationRules = this.loadPatternRules(disambiguationFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with loading disambiguation file: " + disambiguationFile, e);
        }
    }

    @Override
    public AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        AnalyzedSentence sentence = input;
        for (DisambiguationPatternRule patternRule : this.disambiguationRules) {
            sentence = patternRule.replace(sentence);
        }
        return sentence;
    }

    protected List<DisambiguationPatternRule> loadPatternRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        DisambiguationRuleLoader ruleLoader = new DisambiguationRuleLoader();
        return ruleLoader.getRules(JLanguageTool.getDataBroker().getFromResourceDirAsStream(filename));
    }
}

