/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.EncogError;
import org.encog.mathutil.randomize.factory.BasicRandomFactory;
import org.encog.mathutil.randomize.factory.RandomFactory;
import org.encog.ml.CalculateScore;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.population.PopulationGenerator;
import org.encog.ml.ea.species.Species;
import org.encog.ml.genetic.GeneticError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.ml.prg.generator.GenerateWorker;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.ml.prg.train.ZeroEvalScoreFunction;
import org.encog.util.concurrency.MultiThreadable;

public abstract class AbstractGenerator
implements PopulationGenerator,
MultiThreadable {
    private CalculateScore score = new ZeroEvalScoreFunction();
    private final EncogProgramContext context;
    private final int maxDepth;
    private final List<ProgramExtensionTemplate> leaves = new ArrayList<ProgramExtensionTemplate>();
    private double minConst = -10.0;
    private double maxConst = 10.0;
    private final boolean hasEnum;
    private int actualThreads;
    private int threads;
    private final Set<String> contents = new HashSet<String>();
    private RandomFactory randomFactory = new BasicRandomFactory();

    public AbstractGenerator(EncogProgramContext theContext, int theMaxDepth) {
        if (theContext.getFunctions().size() == 0) {
            throw new EncogError("There are no opcodes defined");
        }
        this.context = theContext;
        this.maxDepth = theMaxDepth;
        this.hasEnum = this.context.hasEnum();
        for (ProgramExtensionTemplate temp : this.context.getFunctions().getOpCodes()) {
            if (temp.getChildNodeCount() != 0) continue;
            this.leaves.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopulationMember(PrgPopulation population, EncogProgram prg) {
        AbstractGenerator abstractGenerator = this;
        synchronized (abstractGenerator) {
            Species defaultSpecies = population.getSpecies().get(0);
            prg.setSpecies(defaultSpecies);
            defaultSpecies.add(prg);
            this.contents.add(prg.dumpAsCommonExpression());
        }
    }

    public EncogProgram attemptCreateGenome(Random rnd, Population pop) {
        boolean done = false;
        EncogProgram result = null;
        boolean tries = false;
        while (!done) {
            double s;
            result = this.generate(rnd);
            result.setPopulation(pop);
            try {
                s = this.score.calculateScore(result);
            }
            catch (EARuntimeError e) {
                s = Double.NaN;
            }
            if (Double.isNaN(s) || Double.isInfinite(s) || this.contents.contains(result.dumpAsCommonExpression())) continue;
            done = true;
        }
        return result;
    }

    public ProgramNode createLeafNode(Random rnd, EncogProgram program) {
        ProgramExtensionTemplate temp = this.generateRandomOpcode(rnd, this.leaves);
        ProgramNode result = new ProgramNode(program, temp, new ProgramNode[0]);
        temp.randomize(rnd, result, this.minConst, this.maxConst);
        return result;
    }

    public abstract ProgramNode createNode(Random var1, EncogProgram var2, int var3);

    @Override
    public EncogProgram generate(Random rnd) {
        EncogProgram program = new EncogProgram(this.context);
        program.setRootNode(this.createNode(rnd, program, 0));
        return program;
    }

    public ProgramNode generate(Random rnd, EncogProgram program) {
        return this.createNode(rnd, program, 0);
    }

    @Override
    public void generate(Random rnd, Population pop) {
        this.contents.clear();
        pop.getSpecies().clear();
        Species defaultSpecies = pop.createSpecies();
        this.actualThreads = this.score.requireSingleThreaded() ? 1 : (this.threads == 0 ? Runtime.getRuntime().availableProcessors() : this.threads);
        ExecutorService taskExecutor = null;
        taskExecutor = this.threads == 1 ? Executors.newSingleThreadScheduledExecutor() : Executors.newFixedThreadPool(this.actualThreads);
        for (int i = 0; i < pop.getPopulationSize(); ++i) {
            taskExecutor.execute(new GenerateWorker(this, (PrgPopulation)pop));
        }
        taskExecutor.shutdown();
        try {
            taskExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new GeneticError(e);
        }
        defaultSpecies.setLeader(defaultSpecies.getMembers().get(0));
    }

    public ProgramExtensionTemplate generateRandomOpcode(Random rnd, List<ProgramExtensionTemplate> opcodes) {
        int maxOpCode = opcodes.size();
        int tries = 10000;
        ProgramExtensionTemplate result = null;
        while (result == null) {
            int opcode = rnd.nextInt(maxOpCode);
            result = opcodes.get(opcode);
            if (!this.hasEnum && result == StandardExtensions.EXTENSION_CONST_ENUM_SUPPORT) {
                result = null;
            }
            if (--tries >= 0) continue;
            throw new EACompileError("Could not generate an opcode.  Make sure you have valid opcodes defined.");
        }
        return result;
    }

    public EncogProgramContext getContext() {
        return this.context;
    }

    public List<ProgramExtensionTemplate> getLeaves() {
        return this.leaves;
    }

    public double getMaxConst() {
        return this.maxConst;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public double getMinConst() {
        return this.minConst;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public CalculateScore getScore() {
        return this.score;
    }

    @Override
    public int getThreadCount() {
        return this.threads;
    }

    public boolean isHasEnum() {
        return this.hasEnum;
    }

    public void setMaxConst(double maxConst) {
        this.maxConst = maxConst;
    }

    public void setMinConst(double minConst) {
        this.minConst = minConst;
    }

    public void setRandomFactory(RandomFactory randomFactory) {
        this.randomFactory = randomFactory;
    }

    public void setScore(CalculateScore score) {
        this.score = score;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threads = numThreads;
    }
}

