/*
 * Decompiled with CFR 0.152.
 */
package org.encog.platformspecific.j2se.data.image;

import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.neural.NeuralNetworkError;
import org.encog.platformspecific.j2se.data.image.ImageMLData;
import org.encog.util.downsample.Downsample;

public class ImageMLDataSet
extends BasicMLDataSet {
    private static final long serialVersionUID = 3368190842312829906L;
    public static final String MUST_USE_IMAGE = "This data set only supports ImageNeuralData or Image objects.";
    private final Downsample downsampler;
    private int height;
    private int width;
    private final boolean findBounds;
    private final double hi;
    private final double lo;

    public ImageMLDataSet(Downsample theDownsampler, boolean theFindBounds, double theHi, double theLo) {
        this.downsampler = theDownsampler;
        this.findBounds = theFindBounds;
        this.height = -1;
        this.width = -1;
        this.hi = theHi;
        this.lo = theLo;
    }

    public final void downsample(int theHeight, int theWidth) {
        this.height = theHeight;
        this.width = theWidth;
        for (MLDataPair pair : this) {
            if (!(pair.getInput() instanceof ImageMLData)) {
                throw new NeuralNetworkError("Invalid class type found in ImageNeuralDataSet, only ImageNeuralData items are allowed.");
            }
            ImageMLData input = (ImageMLData)pair.getInput();
            input.downsample(this.downsampler, this.findBounds, this.height, this.width, this.hi, this.lo);
        }
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }
}

