/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

public class NameRecord {
    private short platformId;
    private short encodingId;
    private short languageId;
    private short nameId;
    private short stringLength;
    private short stringOffset;
    private String record;

    protected NameRecord(RandomAccessFile randomAccessFile) throws IOException {
        this.platformId = randomAccessFile.readShort();
        this.encodingId = randomAccessFile.readShort();
        this.languageId = randomAccessFile.readShort();
        this.nameId = randomAccessFile.readShort();
        this.stringLength = randomAccessFile.readShort();
        this.stringOffset = randomAccessFile.readShort();
    }

    public short getEncodingId() {
        return this.encodingId;
    }

    public short getLanguageId() {
        return this.languageId;
    }

    public short getNameId() {
        return this.nameId;
    }

    public short getPlatformId() {
        return this.platformId;
    }

    public String getRecordString() {
        return this.record;
    }

    protected void loadString(RandomAccessFile randomAccessFile, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        randomAccessFile.seek(n + this.stringOffset);
        if (this.platformId == 0) {
            for (int i = 0; i < this.stringLength / 2; ++i) {
                stringBuffer.append(randomAccessFile.readChar());
            }
        } else if (this.platformId == 1) {
            for (int i = 0; i < this.stringLength; ++i) {
                stringBuffer.append((char)randomAccessFile.readByte());
            }
        } else if (this.platformId == 2) {
            for (int i = 0; i < this.stringLength; ++i) {
                stringBuffer.append((char)randomAccessFile.readByte());
            }
        } else if (this.platformId == 3) {
            for (int i = 0; i < this.stringLength / 2; ++i) {
                char c = randomAccessFile.readChar();
                stringBuffer.append(c);
            }
        }
        this.record = stringBuffer.toString();
    }
}

