/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import sun.security.provider.SecureRandom;
import sun.security.provider.SunEntries;
import sun.security.util.Debug;

public final class NativePRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -6599091113397072932L;
    private static final Debug debug = Debug.getInstance("provider");
    private static final String NAME_RANDOM = "/dev/random";
    private static final String NAME_URANDOM = "/dev/urandom";
    private static final RandomIO INSTANCE = NativePRNG.initIO(Variant.MIXED);

    private static URL getEgdUrl() {
        URL uRL;
        block5: {
            String string = SunEntries.getSeedSource();
            if (string.length() != 0) {
                if (debug != null) {
                    debug.println("NativePRNG egdUrl: " + string);
                }
                try {
                    uRL = new URL(string);
                    if (!uRL.getProtocol().equalsIgnoreCase("file")) {
                        return null;
                    }
                    break block5;
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            uRL = null;
        }
        return uRL;
    }

    private static RandomIO initIO(final Variant variant) {
        return AccessController.doPrivileged(new PrivilegedAction<RandomIO>(){

            @Override
            public RandomIO run() {
                File file;
                File file2;
                switch (variant) {
                    case MIXED: {
                        File file3 = null;
                        URL uRL = NativePRNG.getEgdUrl();
                        if (uRL != null) {
                            try {
                                file3 = SunEntries.getDeviceFile(uRL);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        file2 = file3 != null && file3.canRead() ? file3 : new File(NativePRNG.NAME_RANDOM);
                        file = new File(NativePRNG.NAME_URANDOM);
                        break;
                    }
                    case BLOCKING: {
                        file2 = new File(NativePRNG.NAME_RANDOM);
                        file = new File(NativePRNG.NAME_RANDOM);
                        break;
                    }
                    case NONBLOCKING: {
                        file2 = new File(NativePRNG.NAME_URANDOM);
                        file = new File(NativePRNG.NAME_URANDOM);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (debug != null) {
                    debug.println("NativePRNG." + (Object)((Object)variant) + " seedFile: " + file2 + " nextFile: " + file);
                }
                if (!file2.canRead() || !file.canRead()) {
                    if (debug != null) {
                        debug.println("NativePRNG." + (Object)((Object)variant) + " Couldn't read Files.");
                    }
                    return null;
                }
                try {
                    return new RandomIO(file2, file);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static boolean isAvailable() {
        return INSTANCE != null;
    }

    public NativePRNG() {
        if (INSTANCE == null) {
            throw new AssertionError((Object)"NativePRNG not available");
        }
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        NativePRNG.INSTANCE.implSetSeed(byArray);
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        NativePRNG.INSTANCE.implNextBytes(byArray);
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        return NativePRNG.INSTANCE.implGenerateSeed(n);
    }

    static /* synthetic */ RandomIO access$600(Variant variant) {
        return NativePRNG.initIO(variant);
    }

    private static class RandomIO {
        private static final long MAX_BUFFER_TIME = 100L;
        private static final int BUFFER_SIZE = 32;
        File seedFile;
        private final InputStream seedIn;
        private final InputStream nextIn;
        private OutputStream seedOut;
        private boolean seedOutInitialized;
        private volatile SecureRandom mixRandom;
        private final byte[] nextBuffer;
        private int buffered;
        private long lastRead;
        private final Object LOCK_GET_BYTES = new Object();
        private final Object LOCK_GET_SEED = new Object();
        private final Object LOCK_SET_SEED = new Object();

        private RandomIO(File file, File file2) throws IOException {
            this.seedFile = file;
            this.seedIn = new FileInputStream(file);
            this.nextIn = new FileInputStream(file2);
            this.nextBuffer = new byte[32];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecureRandom getMixRandom() {
            SecureRandom secureRandom = this.mixRandom;
            if (secureRandom == null) {
                Object object = this.LOCK_GET_BYTES;
                synchronized (object) {
                    secureRandom = this.mixRandom;
                    if (secureRandom == null) {
                        secureRandom = new SecureRandom();
                        try {
                            byte[] byArray = new byte[20];
                            RandomIO.readFully(this.nextIn, byArray);
                            secureRandom.engineSetSeed(byArray);
                        }
                        catch (IOException iOException) {
                            throw new ProviderException("init failed", iOException);
                        }
                        this.mixRandom = secureRandom;
                    }
                }
            }
            return secureRandom;
        }

        private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
            int n;
            int n2;
            int n3 = 0;
            for (n = byArray.length; n > 0; n -= n2) {
                n2 = inputStream.read(byArray, n3, n);
                if (n2 <= 0) {
                    throw new EOFException("File(s) closed?");
                }
                n3 += n2;
            }
            if (n > 0) {
                throw new IOException("Could not read from file(s)");
            }
        }

        private byte[] implGenerateSeed(int n) {
            Object object = this.LOCK_GET_SEED;
            synchronized (object) {
                try {
                    byte[] byArray = new byte[n];
                    RandomIO.readFully(this.seedIn, byArray);
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new ProviderException("generateSeed() failed", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implSetSeed(byte[] byArray) {
            Object object = this.LOCK_SET_SEED;
            synchronized (object) {
                if (!this.seedOutInitialized) {
                    this.seedOutInitialized = true;
                    this.seedOut = AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                        @Override
                        public OutputStream run() {
                            try {
                                return new FileOutputStream(seedFile, true);
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    });
                }
                if (this.seedOut != null) {
                    try {
                        this.seedOut.write(byArray);
                    }
                    catch (IOException iOException) {
                        throw new ProviderException("setSeed() failed", iOException);
                    }
                }
                this.getMixRandom().engineSetSeed(byArray);
            }
        }

        private void ensureBufferValid() throws IOException {
            long l = System.currentTimeMillis();
            if (this.buffered > 0 && l - this.lastRead < 100L) {
                return;
            }
            this.lastRead = l;
            RandomIO.readFully(this.nextIn, this.nextBuffer);
            this.buffered = this.nextBuffer.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implNextBytes(byte[] byArray) {
            Object object = this.LOCK_GET_BYTES;
            synchronized (object) {
                try {
                    this.getMixRandom().engineNextBytes(byArray);
                    int n = byArray.length;
                    int n2 = 0;
                    while (n > 0) {
                        this.ensureBufferValid();
                        int n3 = this.nextBuffer.length - this.buffered;
                        while (n > 0 && this.buffered > 0) {
                            int n4 = n2++;
                            byArray[n4] = (byte)(byArray[n4] ^ this.nextBuffer[n3++]);
                            --n;
                            --this.buffered;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new ProviderException("nextBytes() failed", iOException);
                }
            }
        }
    }

    public static final class NonBlocking
    extends SecureRandomSpi {
        private static final long serialVersionUID = -1102062982994105487L;
        private static final RandomIO INSTANCE = NativePRNG.access$600(Variant.NONBLOCKING);

        static boolean isAvailable() {
            return INSTANCE != null;
        }

        public NonBlocking() {
            if (INSTANCE == null) {
                throw new AssertionError((Object)"NativePRNG$NonBlocking not available");
            }
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
            NonBlocking.INSTANCE.implSetSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            NonBlocking.INSTANCE.implNextBytes(byArray);
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return NonBlocking.INSTANCE.implGenerateSeed(n);
        }
    }

    public static final class Blocking
    extends SecureRandomSpi {
        private static final long serialVersionUID = -6396183145759983347L;
        private static final RandomIO INSTANCE = NativePRNG.access$600(Variant.BLOCKING);

        static boolean isAvailable() {
            return INSTANCE != null;
        }

        public Blocking() {
            if (INSTANCE == null) {
                throw new AssertionError((Object)"NativePRNG$Blocking not available");
            }
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
            Blocking.INSTANCE.implSetSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            Blocking.INSTANCE.implNextBytes(byArray);
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return Blocking.INSTANCE.implGenerateSeed(n);
        }
    }

    private static enum Variant {
        MIXED,
        BLOCKING,
        NONBLOCKING;

    }
}

