#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.13';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 98 => 0x69 },
	'about' => { 423 => 'about' },
	'aboutcvterm' => { 415 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 415 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 415 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 415 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 415 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 429 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 73 => 0x518 },
	'accelerometer' => { 335 => 0x3 },
	'accelerometerx' => { 274 => 0x8d },
	'accelerometery' => { 274 => 0x8e },
	'accelerometerz' => { 274 => 0x8c },
	'accessoryserialnumber' => { 274 => 0x54 },
	'accessorytype' => { 274 => 0x53 },
	'acedemicfield' => { 419 => 'acedemicField' },
	'actionadvised' => { 114 => 0x2a },
	'activearea' => { 106 => 0xc68d },
	'actived-lighting' => { 194 => 0x22, 230 => 0x24 },
	'actived-lightingmode' => { 230 => 0x25 },
	'adaptervoltage' => { 120 => 0x407 },
	'addaspectratioinfo' => { 73 => 0x80e },
	'additionalmodelinformation' => { 415 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 73 => 0x80f, 74 => 0x11, 75 => 0x13, 78 => 0x14 },
	'address' => { 141 => 'Address' },
	'adjustmentmode' => { 341 => 0x15 },
	'adobe' => { 107 => 'Adobe' },
	'adultcontentwarning' => { 263 => 'AdultContentWarning', 422 => 'adultContentWarning' },
	'advancedfilter' => { 111 => 0x1201 },
	'advancedraw' => { 232 => 0x76a43203 },
	'advancedscenetype' => { 274 => 0x3d },
	'advisory' => { 427 => 'Advisory' },
	'ae_iso' => { 281 => 0x2, 282 => 0x4, 283 => 0x12 },
	'aeaperture' => { 281 => 0x1, 282 => 0x3, 283 => 0x11 },
	'aeaperturesteps' => { 281 => 0x8, 282 => 0xb },
	'aebautocancel' => { 73 => 0x104 },
	'aebbracketvalue' => { 67 => 0x11 },
	'aebsequence' => { 73 => 0x105 },
	'aebsequenceautocancel' => { 71 => 0x9, 72 => 0x9, 74 => 0x8, 75 => 0x9, 78 => 0x9, 79 => 0x7 },
	'aebshotcount' => { 73 => 0x106 },
	'aebxv' => { 281 => 0x4, 282 => 0x6 },
	'aeerror' => { 282 => 0x8 },
	'aeexposuretime' => { 281 => 0x0, 282 => 0x2, 283 => 0x10 },
	'aelbutton' => { 161 => 0x45 },
	'aelexposureindicator' => { 161 => 0x51 },
	'aelock' => { 161 => 0x5b, 241 => '4.2', 248 => '4.2', 253 => 0x201, 307 => 0x48, 349 => 0x40, 350 => 0x40, 351 => [0x86,0x286] },
	'aelockbutton' => { 239 => '16.1', 241 => '4.1', 243 => '15.1', 244 => '16.1', 245 => '16.1', 246 => '30.1', 247 => '16.1', 248 => '4.1', 250 => '17.1', 251 => '17.1' },
	'aelockbuttonplusdials' => { 239 => '16.2', 246 => '32.1', 250 => '44.1' },
	'aelockformb-d80' => { 251 => '3.1' },
	'aemaxaperture' => { 281 => 0x9, 282 => 0x10, 283 => 0x1c },
	'aemaxaperture2' => { 281 => 0xa, 282 => 0x11, 283 => 0x1d },
	'aemeteringmode' => { 281 => 0xc },
	'aemeteringmode2' => { 281 => '13.1' },
	'aemeteringsegments' => { 164 => 0x628, 307 => 0x209 },
	'aemicroadjustment' => { 73 => 0x110 },
	'aeminaperture' => { 281 => 0xb, 282 => 0x12, 283 => 0x1e },
	'aeminexposuretime' => { 281 => 0x5, 282 => 0x13, 283 => 0x1f },
	'aeprogrammode' => { 281 => 0x6 },
	'aeprojectlink' => { 404 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 404 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 404 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 404 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 404 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 404 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 31 => 0x21 },
	'aewhitebalance' => { 281 => 0xd },
	'aexv' => { 281 => 0x3, 282 => 0x5 },
	'af-cpriorityselection' => { 239 => '1.1', 240 => '1.1', 242 => '1.1', 244 => '0.1', 245 => '0.1', 246 => '1.1', 247 => '0.1', 250 => '1.1' },
	'af-onbutton' => { 242 => '70.1' },
	'af-onformb-d10' => { 239 => '3.3', 246 => '3.2' },
	'af-onformb-d11' => { 247 => '2.2' },
	'af-onformb-d12' => { 250 => '50.1' },
	'af-spriorityselection' => { 239 => '1.2', 240 => '1.2', 242 => '1.4', 246 => '1.2', 247 => '0.2', 250 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 239 => '2.1', 240 => '2.1', 242 => '78.3', 246 => '2.1', 250 => '2.1' },
	'afadjustment' => { 307 => 0x72 },
	'afandmeteringbuttons' => { 73 => 0x701 },
	'afaperture' => { 190 => 0x5, 191 => 0x5 },
	'afareaheight' => { 170 => 0x1a },
	'afareaillumination' => { 161 => 0x4b, 248 => '15.3' },
	'afareamode' => { 157 => 0x33, 161 => 0xe, 169 => 0x0, 170 => 0x5, 274 => 0xf, 332 => 0x1205, 342 => [0xa,0x3a], 349 => 0x11, 350 => 0x10, 351 => 0x24, 361 => 0xb043, 381 => 0x17 },
	'afareamodesetting' => { 241 => '11.1', 243 => '0.1', 248 => '16.1', 251 => '2.1', 361 => 0x201c },
	'afareas' => { 253 => 0x304 },
	'afareaselectmethod' => { 73 => 0x51b },
	'afareawidth' => { 170 => 0x18 },
	'afareaxposition' => { 170 => 0x14, 332 => 0x1203 },
	'afareaxposition1' => { 332 => 0x1201 },
	'afareayposition' => { 170 => 0x16, 332 => 0x1204 },
	'afareayposition1' => { 332 => 0x1202 },
	'afassist' => { 71 => 0x5, 79 => 0x5, 161 => 0x48, 239 => '2.5', 241 => '0.2', 243 => '0.2', 244 => '1.1', 245 => '1.1', 246 => '2.4', 247 => '1.4', 248 => '0.2', 250 => '2.4', 251 => '2.3' },
	'afassistbeam' => { 73 => 0x50e, 74 => 0x4, 75 => 0x5, 76 => 0x4, 77 => 0x4, 78 => 0x5 },
	'afassistlamp' => { 274 => 0x31 },
	'afbuttonpressed' => { 351 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 284 => 0x6 },
	'afduringliveview' => { 73 => 0x511 },
	'affinea' => { 398 => 'AffineA' },
	'affineb' => { 398 => 'AffineB' },
	'affinec' => { 398 => 'AffineC' },
	'affined' => { 398 => 'AffineD' },
	'affinetune' => { 171 => 0x0, 253 => 0x306 },
	'affinetuneadj' => { 171 => 0x2, 204 => 0x2d1, 205 => 0x2dc, 253 => 0x307 },
	'affinetuneindex' => { 171 => 0x1 },
	'affinex' => { 398 => 'AffineX' },
	'affiney' => { 398 => 'AffineY' },
	'afhold' => { 284 => 0x1fd },
	'afilluminator' => { 349 => 0x29, 361 => 0xb044 },
	'afimageheight' => { 170 => 0x12 },
	'afimagewidth' => { 170 => 0x10 },
	'afintegrationtime' => { 284 => 0x7 },
	'afmicroadj' => { 342 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 346 => 0x131 },
	'afmicroadjregisteredlenses' => { 346 => '305.1' },
	'afmicroadjustment' => { 73 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 346 => 0x130 },
	'afmode' => { 102 => 0x3009, 111 => 0x1022, 157 => 0x16, 341 => 0x5 },
	'afmoderestrictions' => { 240 => '50.3', 242 => '48.3', 250 => '48.3' },
	'afonaelockbuttonswitch' => { 73 => 0x702 },
	'afonbutton' => { 239 => '3.1', 240 => '47.1' },
	'afpoint' => { 31 => 0x13, 101 => 0x18, 157 => 0x15, 169 => 0x1, 256 => 0x308, 341 => 0x1f, 342 => [0x37,0x7], 346 => 0x19, 347 => 0x18, 348 => [0x18,0x20] },
	'afpointactivationarea' => { 72 => 0x11, 78 => 0x11 },
	'afpointareaexpansion' => { 73 => 0x508 },
	'afpointatshutterrelease' => { 342 => [0x39,0x9] },
	'afpointautoselection' => { 73 => 0x50b },
	'afpointbrightness' => { 73 => 0x50d, 239 => '2.4', 240 => '46.5', 242 => '2.2', 250 => '2.3' },
	'afpointdisplayduringfocus' => { 73 => 0x50c },
	'afpointillumination' => { 72 => 0xa, 239 => '2.3', 240 => '46.2', 242 => '47.2', 246 => '2.3', 247 => '1.3', 250 => '47.2', 251 => '2.4' },
	'afpointinfocus' => { 342 => [0x38,0x8] },
	'afpointmode' => { 288 => 0x3 },
	'afpointposition' => { 102 => 0x2021, 274 => 0x4d },
	'afpointregistration' => { 71 => 0x7 },
	'afpoints' => { 160 => 0x10 },
	'afpointselected' => { 161 => 0xd, 253 => 0x305, 307 => 0xe, 346 => 0x15, 347 => 0x14, 348 => [0x14,0x1c], 361 => 0x201e },
	'afpointselected2' => { 288 => 0x4 },
	'afpointselection' => { 72 => 0xb, 239 => '1.3', 240 => '1.3', 246 => '1.3', 250 => '1.3' },
	'afpointselectionmethod' => { 73 => 0x50f, 74 => 0xc, 75 => 0xd, 78 => 0xd },
	'afpointsetting' => { 349 => 0x12, 350 => 0x11 },
	'afpointsinfocus' => { 67 => 0xe, 169 => 0x2, 284 => 0xb, 307 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 72 => 0xd },
	'afpointsselected' => { 388 => 0x4 },
	'afpointsunknown1' => { 284 => 0x0 },
	'afpointsunknown2' => { 284 => 0x2 },
	'afpointsused' => { 170 => 0x8, 342 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 284 => 0x4 },
	'afresponse' => { 194 => 0xad },
	'afresult' => { 258 => 0x1038 },
	'afsearch' => { 253 => 0x303 },
	'afsensoractive' => { 157 => 0x1 },
	'afstatus' => { 332 => 0x1200 },
	'afstatus_00_b4' => { 345 => 0x0 },
	'afstatus_01_c4' => { 345 => 0x2 },
	'afstatus_02_d4' => { 345 => 0x4 },
	'afstatus_03_e4' => { 345 => 0x6 },
	'afstatus_04_f4' => { 345 => 0x8 },
	'afstatus_05_g4' => { 345 => 0xa },
	'afstatus_06_h4' => { 345 => 0xc },
	'afstatus_07_b3' => { 345 => 0xe },
	'afstatus_08_c3' => { 345 => 0x10 },
	'afstatus_09_d3' => { 345 => 0x12 },
	'afstatus_10_e3' => { 345 => 0x14 },
	'afstatus_11_f3' => { 345 => 0x16 },
	'afstatus_12_g3' => { 345 => 0x18 },
	'afstatus_13_h3' => { 345 => 0x1a },
	'afstatus_14_b2' => { 345 => 0x1c },
	'afstatus_15_c2' => { 345 => 0x1e },
	'afstatus_16_d2' => { 345 => 0x20 },
	'afstatus_17_e2' => { 345 => 0x22 },
	'afstatus_18_f2' => { 345 => 0x24 },
	'afstatus_19_g2' => { 345 => 0x26 },
	'afstatus_20_h2' => { 345 => 0x28 },
	'afstatus_21_c1' => { 345 => 0x2a },
	'afstatus_22_d1' => { 345 => 0x2c },
	'afstatus_23_e1' => { 345 => 0x2e },
	'afstatus_24_f1' => { 345 => 0x30 },
	'afstatus_25_g1' => { 345 => 0x32 },
	'afstatus_26_a7_vertical' => { 345 => 0x34 },
	'afstatus_27_a6_vertical' => { 345 => 0x36 },
	'afstatus_28_a5_vertical' => { 345 => 0x38 },
	'afstatus_29_c7_vertical' => { 345 => 0x3a },
	'afstatus_30_c6_vertical' => { 345 => 0x3c },
	'afstatus_31_c5_vertical' => { 345 => 0x3e },
	'afstatus_32_e7_vertical' => { 345 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 345 => 0x42 },
	'afstatus_34_e5_vertical' => { 345 => 0x44 },
	'afstatus_35_g7_vertical' => { 345 => 0x46 },
	'afstatus_36_g6_vertical' => { 345 => 0x48 },
	'afstatus_37_g5_vertical' => { 345 => 0x4a },
	'afstatus_38_i7_vertical' => { 345 => 0x4c },
	'afstatus_39_i6_vertical' => { 345 => 0x4e },
	'afstatus_40_i5_vertical' => { 345 => 0x50 },
	'afstatus_41_a7' => { 345 => 0x52 },
	'afstatus_42_b7' => { 345 => 0x54 },
	'afstatus_43_c7' => { 345 => 0x56 },
	'afstatus_44_d7' => { 345 => 0x58 },
	'afstatus_45_e7' => { 345 => 0x5a },
	'afstatus_46_f7' => { 345 => 0x5c },
	'afstatus_47_g7' => { 345 => 0x5e },
	'afstatus_48_h7' => { 345 => 0x60 },
	'afstatus_49_i7' => { 345 => 0x62 },
	'afstatus_50_a6' => { 345 => 0x64 },
	'afstatus_51_b6' => { 345 => 0x66 },
	'afstatus_52_c6' => { 345 => 0x68 },
	'afstatus_53_d6' => { 345 => 0x6a },
	'afstatus_54_e6_center' => { 345 => 0x6c },
	'afstatus_55_f6' => { 345 => 0x6e },
	'afstatus_56_g6' => { 345 => 0x70 },
	'afstatus_57_h6' => { 345 => 0x72 },
	'afstatus_58_i6' => { 345 => 0x74 },
	'afstatus_59_a5' => { 345 => 0x76 },
	'afstatus_60_b5' => { 345 => 0x78 },
	'afstatus_61_c5' => { 345 => 0x7a },
	'afstatus_62_d5' => { 345 => 0x7c },
	'afstatus_63_e5' => { 345 => 0x7e },
	'afstatus_64_f5' => { 345 => 0x80 },
	'afstatus_65_g5' => { 345 => 0x82 },
	'afstatus_66_h5' => { 345 => 0x84 },
	'afstatus_67_i5' => { 345 => 0x86 },
	'afstatus_68_c11' => { 345 => 0x88 },
	'afstatus_69_d11' => { 345 => 0x8a },
	'afstatus_70_e11' => { 345 => 0x8c },
	'afstatus_71_f11' => { 345 => 0x8e },
	'afstatus_72_g11' => { 345 => 0x90 },
	'afstatus_73_b10' => { 345 => 0x92 },
	'afstatus_74_c10' => { 345 => 0x94 },
	'afstatus_75_d10' => { 345 => 0x96 },
	'afstatus_76_e10' => { 345 => 0x98 },
	'afstatus_77_f10' => { 345 => 0x9a },
	'afstatus_78_g10' => { 345 => 0x9c },
	'afstatus_79_h10' => { 345 => 0x9e },
	'afstatus_80_b9' => { 345 => 0xa0 },
	'afstatus_81_c9' => { 345 => 0xa2 },
	'afstatus_82_d9' => { 345 => 0xa4 },
	'afstatus_83_e9' => { 345 => 0xa6 },
	'afstatus_84_f9' => { 345 => 0xa8 },
	'afstatus_85_g9' => { 345 => 0xaa },
	'afstatus_86_h9' => { 345 => 0xac },
	'afstatus_87_b8' => { 345 => 0xae },
	'afstatus_88_c8' => { 345 => 0xb0 },
	'afstatus_89_d8' => { 345 => 0xb2 },
	'afstatus_90_e8' => { 345 => 0xb4 },
	'afstatus_91_f8' => { 345 => 0xb6 },
	'afstatus_92_g8' => { 345 => 0xb8 },
	'afstatus_93_h8' => { 345 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 345 => 0xbc },
	'afstatusactivesensor' => { 157 => 0x2, 342 => [0x4,0x3b], 346 => 0x1e, 347 => 0x1b, 348 => [0x1b,0x21] },
	'afstatusbottom' => { 157 => 0x8, 346 => 0x2a, 347 => 0x21, 348 => 0x21 },
	'afstatusbottom-left' => { 157 => 0x12, 347 => 0x2b, 348 => 0x2b },
	'afstatusbottom-right' => { 157 => 0x6, 347 => 0x1f, 348 => 0x1f },
	'afstatusbottomassist-left' => { 346 => 0x28 },
	'afstatusbottomassist-right' => { 346 => 0x2c },
	'afstatusbottomhorizontal' => { 343 => 0x10, 344 => 0x1c },
	'afstatusbottomvertical' => { 343 => 0x16, 344 => 0x26 },
	'afstatuscenter-10' => { 346 => 0x34 },
	'afstatuscenter-11' => { 346 => 0x36 },
	'afstatuscenter-12' => { 346 => 0x38 },
	'afstatuscenter-14' => { 346 => 0x3c },
	'afstatuscenter-7' => { 346 => 0x2e },
	'afstatuscenter-9' => { 346 => 0x32 },
	'afstatuscenter-horizontal' => { 346 => 0x30 },
	'afstatuscenter-vertical' => { 346 => 0x3a },
	'afstatuscenterf2-8' => { 346 => 0x4c },
	'afstatuscenterhorizontal' => { 157 => 0x2f, 343 => 0xc, 344 => 0x18, 347 => 0x2f, 348 => 0x2f },
	'afstatuscentervertical' => { 157 => 0xc, 343 => 0x14, 344 => 0x22, 347 => 0x25, 348 => 0x25 },
	'afstatusfarleft' => { 343 => 0x6, 346 => 0x26 },
	'afstatusfarlefthorizontal' => { 344 => 0x4 },
	'afstatusfarleftvertical' => { 344 => 0x12 },
	'afstatusfarright' => { 343 => 0x18, 346 => 0x44 },
	'afstatusfarrighthorizontal' => { 344 => 0x2c },
	'afstatusfarrightvertical' => { 344 => 0x34 },
	'afstatusleft' => { 157 => 0x2d, 343 => 0x2, 346 => 0x22, 347 => 0x2d, 348 => 0x2d },
	'afstatuslefthorizontal' => { 344 => 0x6 },
	'afstatusleftvertical' => { 344 => 0xe },
	'afstatuslower-left' => { 343 => 0x4, 346 => 0x24 },
	'afstatuslower-lefthorizontal' => { 344 => 0xa },
	'afstatuslower-leftvertical' => { 344 => 0x10 },
	'afstatuslower-middle' => { 343 => 0x22, 344 => 0x24 },
	'afstatuslower-right' => { 343 => 0x1e, 346 => 0x4a },
	'afstatuslower-righthorizontal' => { 344 => 0x32 },
	'afstatuslower-rightvertical' => { 344 => 0x3a },
	'afstatuslowerfarleft' => { 344 => 0x8 },
	'afstatuslowerfarright' => { 344 => 0x30 },
	'afstatusmiddlehorizontal' => { 157 => 0xa, 347 => 0x23, 348 => 0x23 },
	'afstatusnearleft' => { 343 => 0xe, 344 => 0x1a },
	'afstatusnearright' => { 343 => 0xa, 344 => 0x16 },
	'afstatusright' => { 157 => 0x31, 343 => 0x1c, 346 => 0x48, 347 => 0x31, 348 => 0x31 },
	'afstatusrighthorizontal' => { 344 => 0x2e },
	'afstatusrightvertical' => { 344 => 0x38 },
	'afstatustop' => { 157 => 0xe, 346 => 0x40, 347 => 0x27, 348 => 0x27 },
	'afstatustop-left' => { 157 => 0x10, 347 => 0x29, 348 => 0x29 },
	'afstatustop-right' => { 157 => 0x4, 347 => 0x1d, 348 => 0x1d },
	'afstatustopassist-left' => { 346 => 0x3e },
	'afstatustopassist-right' => { 346 => 0x42 },
	'afstatustophorizontal' => { 343 => 0x8, 344 => 0x14 },
	'afstatustopvertical' => { 343 => 0x12, 344 => 0x1e },
	'afstatusupper-left' => { 343 => 0x0, 346 => 0x20 },
	'afstatusupper-lefthorizontal' => { 344 => 0x2 },
	'afstatusupper-leftvertical' => { 344 => 0xc },
	'afstatusupper-middle' => { 343 => 0x20, 344 => 0x20 },
	'afstatusupper-right' => { 343 => 0x1a, 346 => 0x46 },
	'afstatusupper-righthorizontal' => { 344 => 0x2a },
	'afstatusupper-rightvertical' => { 344 => 0x36 },
	'afstatusupperfarleft' => { 344 => 0x0 },
	'afstatusupperfarright' => { 344 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 342 => 0x2 },
	'afwithshutter' => { 349 => 0x2a },
	'afzoneselected' => { 361 => 0x201e },
	'aggregateissuenumber' => { 419 => 'aggregateIssueNumber' },
	'aggregationtype' => { 419 => 'aggregationType' },
	'agreement' => { 422 => 'agreement' },
	'aiservocontinuousshooting' => { 72 => 0x15 },
	'aiservofirstimagepriority' => { 73 => 0x519 },
	'aiservoimagepriority' => { 73 => 0x503 },
	'aiservosecondimagepriority' => { 73 => 0x51a },
	'aiservotrackingmethod' => { 73 => 0x504 },
	'aiservotrackingsensitivity' => { 72 => 0x14, 73 => 0x502 },
	'album' => { 429 => 'album' },
	'alreadyapplied' => { 405 => 'AlreadyApplied' },
	'alternatetitle' => { 419 => 'alternateTitle' },
	'alternatetitlea-lang' => { 419 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 419 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 419 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 172 => 0x6 },
	'alttapename' => { 429 => 'altTapeName' },
	'alttimecode' => { 429 => 'altTimecode' },
	'alttimecodetimeformat' => { 429 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 429 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 429 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 328 => 0x14, 381 => 0x4 },
	'ambienttemperaturefahrenheit' => { 328 => 0x13 },
	'analogbalance' => { 106 => 0xc627 },
	'angleadj' => { 92 => 0x10003, 98 => 0x8b },
	'angleinforoll' => { 400 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 400 => 'AngleInfoYaw' },
	'anti-blur' => { 361 => 0xb04b },
	'antialiasstrength' => { 106 => 0xc632 },
	'aperturelock' => { 240 => '38.2', 242 => '38.2', 250 => '38.2' },
	'aperturerange' => { 73 => 0x10d },
	'apertureringuse' => { 288 => '1.4' },
	'aperturesetting' => { 161 => 0x7, 349 => 0x30, 350 => 0x29, 351 => 0x1 },
	'aperturevalue' => { 82 => 0x2, 106 => 0x9202, 258 => 0x1002, 316 => 0x401, 409 => 'ApertureValue' },
	'applekeywords' => { 262 => 'AAPL:Keywords' },
	'applicationnotes' => { 106 => 0x2bc, 278 => 0x2bc },
	'applicationrecordversion' => { 114 => 0x0 },
	'applyshootingmeteringmode' => { 73 => 0x10e },
	'approved' => { 411 => 'Approved' },
	'approvedby' => { 411 => 'ApprovedBy' },
	'approximatefnumber' => { 270 => 0x313, 276 => 0x3406 },
	'approximatefocusdistance' => { 401 => 'ApproximateFocusDistance' },
	'aquahsl' => { 92 => 0x20913 },
	'armidentifier' => { 115 => 0x78 },
	'armversion' => { 115 => 0x7a },
	'artfilter' => { 253 => 0x529 },
	'artfiltereffect' => { 253 => 0x52f },
	'artist' => { 106 => 0x13b, 266 => 'Artist', 307 => 0x22e, 425 => 'Artist', 429 => 'artist' },
	'artmode' => { 102 => 0x301b },
	'artmodeparameters' => { 102 => 0x310b },
	'artworkcircadatecreated' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 415 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 415 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 257 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 257 => 0x1112, 307 => 0x80, 349 => 0x55, 350 => 0x55, 351 => 0xa },
	'asshoticcprofile' => { 106 => 0xc68f },
	'asshotneutral' => { 106 => 0xc628 },
	'asshotpreprofilematrix' => { 106 => 0xc690 },
	'asshotprofilename' => { 106 => 0xc6f6 },
	'asshotwhitexy' => { 106 => 0xc629 },
	'assignbktbutton' => { 239 => '4.2', 240 => '16.1', 242 => '16.1', 250 => '16.1' },
	'assignfuncbutton' => { 73 => 0x70b },
	'assignmb-d17af-onbutton' => { 242 => '79.1' },
	'assignmb-d17funcbutton' => { 242 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 242 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 242 => '75.1' },
	'assignmoviefunc2button' => { 242 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 242 => '75.2' },
	'assignmovierecordbutton' => { 240 => '43.2', 250 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 242 => '45.1' },
	'assignmoviesubselector' => { 242 => '74.1' },
	'assignmoviesubselectorplusdials' => { 242 => '76.1' },
	'assignremotefnbutton' => { 240 => '54.1', 250 => '51.1' },
	'assistbuttonfunction' => { 71 => 0xd },
	'attributionname' => { 402 => 'attributionName' },
	'attributionurl' => { 402 => 'attributionURL' },
	'audio' => { 274 => 0x20 },
	'audiobitrate' => { 58 => 0x6c },
	'audiochannels' => { 58 => 0x70 },
	'audiochanneltype' => { 429 => 'audioChannelType' },
	'audiocompression' => { 135 => 'Compression' },
	'audiocompressor' => { 429 => 'audioCompressor' },
	'audioduration' => { 114 => 0x99 },
	'audiomoddate' => { 429 => 'audioModDate' },
	'audiooutcue' => { 114 => 0x9a },
	'audiosamplerate' => { 58 => 0x6e, 429 => 'audioSampleRate' },
	'audiosampletype' => { 429 => 'audioSampleType' },
	'audiosamplingrate' => { 114 => 0x97 },
	'audiosamplingresolution' => { 114 => 0x98 },
	'audiotype' => { 114 => 0x96 },
	'author' => { 137 => 'Author', 262 => 'Author', 266 => 'Author', 323 => 'Author', 399 => 'author', 416 => 'Author', 427 => 'Author' },
	'authorsposition' => { 417 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 73 => 0x51c },
	'autoaperture' => { 298 => '0.1' },
	'autobracket' => { 341 => 0x19 },
	'autobracketing' => { 111 => 0x1100, 307 => 0x18, 332 => 0x1007 },
	'autobracketingmode' => { 249 => '12.3' },
	'autobracketingset' => { 249 => '12.1' },
	'autobracketmodem' => { 239 => '21.2', 240 => '13.3', 242 => '13.2', 246 => '26.2', 250 => '13.3' },
	'autobracketorder' => { 161 => 0x43, 239 => '21.3', 240 => '13.2', 242 => '13.1', 246 => '26.3', 247 => '12.2', 248 => '2.2', 249 => '12.2', 250 => '13.2', 251 => '13.2' },
	'autobracketset' => { 239 => '21.1', 240 => '13.1', 243 => '11.1', 244 => '12.1', 245 => '12.1', 246 => '26.1', 247 => '12.1', 248 => '2.1', 250 => '13.1', 251 => '13.1' },
	'autobrightness' => { 405 => 'AutoBrightness' },
	'autocontrast' => { 405 => 'AutoContrast' },
	'autodistortioncontrol' => { 180 => 0x4 },
	'autodynamicrange' => { 111 => 0x140b },
	'autoexposure' => { 405 => 'AutoExposure' },
	'autoexposurebracketing' => { 67 => 0x10 },
	'autoflashisosensitivity' => { 242 => '38.5' },
	'autofocus' => { 256 => 0x209 },
	'autofp' => { 248 => '7.3', 251 => '31.4' },
	'autoiso' => { 67 => 0x1, 102 => 0x3008, 241 => '1.1', 248 => '1.1' },
	'autoisomax' => { 241 => '1.2', 248 => '1.2' },
	'autoisominshutterspeed' => { 241 => '1.3', 248 => '1.3' },
	'autolateralca' => { 405 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 54 => 0x2, 73 => 0x204, 92 => 0x20500, 98 => 0x6f },
	'autolightingoptimizeron' => { 92 => '0x20500.0', 98 => 0x6e },
	'autoportraitframed' => { 361 => 0x2016 },
	'autoredeye' => { 232 => 0xfe28a44f },
	'autorotate' => { 67 => 0x1b },
	'autoshadows' => { 405 => 'AutoShadows' },
	'autowhiteversion' => { 405 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 194 => 0x82 },
	'avaperturesetting' => { 288 => 0x13 },
	'averageblacklevel' => { 38 => 0xe7, 40 => 0xfb, 41 => 0x114, 42 => 0x146 },
	'averagelv' => { 164 => 0x38 },
	'avsettingwithoutlens' => { 73 => 0x707 },
	'azimuth' => { 145 => 'Azimuth' },
	'babyage' => { 274 => [0x8010,0x33] },
	'babyname' => { 274 => 0x66 },
	'backgroundalpha' => { 424 => 'bgalpha' },
	'baseexposurecompensation' => { 288 => 0x15 },
	'baseiso' => { 67 => 0x2, 86 => 0x101c, 120 => 0x903, 276 => 0x312a, 386 => 0x6 },
	'baselineexposure' => { 106 => 0xc62a },
	'baselineexposureoffset' => { 106 => 0xc7a5 },
	'baselinenoise' => { 106 => 0xc62b },
	'baselinesharpness' => { 106 => 0xc62c },
	'baseurl' => { 427 => 'BaseURL' },
	'batterylevel' => { 349 => 0x51, 353 => 0xc, 354 => 0x4, 355 => 0x4, 387 => 0x7 },
	'batterylevelgrip1' => { 387 => 0x6 },
	'batterylevelgrip2' => { 387 => 0x8 },
	'batteryorder' => { 239 => '12.5', 246 => '13.2', 247 => '2.1', 250 => '3.1' },
	'batterystate' => { 161 => 0x60, 349 => 0x50, 355 => 0x14 },
	'batterytemperature' => { 353 => 0x1, 355 => 0x2, 387 => 0x5 },
	'batteryunknown' => { 353 => 0x2, 355 => 0x0 },
	'batteryvoltage' => { 120 => 0x408, 328 => 0x2a, 353 => 0x8 },
	'batteryvoltage1' => { 355 => 0x6 },
	'batteryvoltage2' => { 355 => 0x8 },
	'bayergreensplit' => { 106 => 0xc62d },
	'bayerpattern' => { 119 => 0xf902, 165 => 0x17 },
	'beatspliceparams' => { 429 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 429 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 429 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 429 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 429 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 429 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 239 => '13.1', 240 => '5.4', 241 => '0.1', 243 => '2.1', 244 => '3.1', 245 => '3.1', 246 => '10.1', 248 => '0.1', 250 => '5.5', 251 => '4.1' },
	'beeppitch' => { 247 => '3.1' },
	'beepvolume' => { 247 => '4.5' },
	'bestqualityscale' => { 106 => 0xc65c },
	'bestshotmode' => { 102 => 0x3007 },
	'bitdepth' => { 142 => 'BitDepth', 165 => 0x11, 201 => 0x41 },
	'bitspercomponent' => { 116 => 0x87 },
	'bitspersample' => { 106 => 0x102, 425 => 'BitsPerSample' },
	'blacklevel' => { 106 => 0xc61a, 194 => 0x3d, 258 => [0x401,0x1012], 316 => 0x21d },
	'blacklevel1' => { 278 => 0x8 },
	'blacklevel2' => { 257 => 0x600, 261 => 0x600, 278 => 0x9 },
	'blacklevel3' => { 278 => 0xa },
	'blacklevelblue' => { 278 => 0x1e },
	'blackleveldata' => { 316 => 0x223 },
	'blackleveldeltah' => { 106 => 0xc61b },
	'blackleveldeltav' => { 106 => 0xc61c },
	'blacklevelgreen' => { 278 => 0x1d },
	'blacklevelred' => { 278 => 0x1c },
	'blacklevelrepeatdim' => { 106 => 0xc619 },
	'blackpoint' => { 307 => 0x200 },
	'blacks2012' => { 405 => 'Blacks2012' },
	'bleachbypasstoning' => { 307 => 0x7f },
	'blockshotafresponse' => { 242 => '1.5' },
	'blogtitle' => { 419 => 'blogTitle' },
	'blogurl' => { 419 => 'blogURL' },
	'bluebalance' => { 178 => 0x271, 258 => 0x1018, 278 => 0x12, 307 => 0x1b },
	'bluecurvelimits' => { 97 => 0x1fe },
	'bluecurvepoints' => { 96 => 0x79, 97 => 0x1d4 },
	'bluehsl' => { 92 => [0x20914,0x20915] },
	'bluehue' => { 405 => 'BlueHue' },
	'bluesaturation' => { 405 => 'BlueSaturation' },
	'blurcontrol' => { 307 => 0x82 },
	'blurwarning' => { 111 => 0x1300 },
	'bodybatteryadload' => { 286 => 0x3 },
	'bodybatteryadnoload' => { 286 => 0x2 },
	'bodybatterystate' => { 286 => '1.1' },
	'bodybatteryvoltage1' => { 286 => 0x2 },
	'bodybatteryvoltage2' => { 286 => 0x4 },
	'bodybatteryvoltage3' => { 286 => 0x6 },
	'bodybatteryvoltage4' => { 286 => 0x8 },
	'bodyfirmware' => { 333 => 0x0 },
	'bodyfirmwareversion' => { 254 => 0x104, 255 => 0x100, 258 => 0x104 },
	'bodyserialnumber' => { 333 => 0x10 },
	'bookedition' => { 419 => 'bookEdition' },
	'bracketmode' => { 49 => 0x3 },
	'bracketsequence' => { 102 => 0x301d },
	'bracketsettings' => { 274 => 0x45 },
	'bracketshotnumber' => { 49 => 0x5, 288 => 0x9, 360 => 0x2b },
	'bracketshotnumber2' => { 360 => 0x2d },
	'bracketstep' => { 158 => 0xe },
	'bracketvalue' => { 49 => 0x4 },
	'brightness' => { 106 => 0xfe53, 136 => 'Brightness', 154 => 'Brightness', 158 => 0x2c, 196 => 0x34, 197 => 0x39, 328 => 0x25, 349 => 0x22, 361 => 0x2007, 405 => 'Brightness' },
	'brightnessadj' => { 97 => 0x114, 225 => 0x0, 235 => 0x2d, 390 => 0x8018 },
	'brightnessvalue' => { 106 => 0x9203, 164 => [0x691,0x49c3], 258 => 0x1003, 365 => 0x1e, 368 => 0x1140, 369 => 0x1140, 370 => 0x111c, 371 => 0x1198, 372 => 0x1174, 373 => 0x102c, 374 => 0x224, 375 => 0x224, 409 => 'BrightnessValue' },
	'bulbduration' => { 67 => 0x18 },
	'burstmode' => { 122 => 0xa, 274 => 0x2a },
	'burstmode2' => { 122 => 0x18 },
	'burstshot' => { 341 => 0x34 },
	'burstspeed' => { 274 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 73 => 0x70a },
	'bwfilter' => { 158 => 0x2a, 166 => 0x39 },
	'bwmode' => { 258 => 0x203 },
	'by-line' => { 114 => 0x50 },
	'by-linetitle' => { 114 => 0x55 },
	'bytecount' => { 419 => 'byteCount' },
	'calibration' => { 341 => [0x24,0x30] },
	'calibrationilluminant1' => { 106 => 0xc65a },
	'calibrationilluminant2' => { 106 => 0xc65b },
	'cameraangle' => { 429 => 'cameraAngle' },
	'cameracalibration1' => { 106 => 0xc623 },
	'cameracalibration2' => { 106 => 0xc624 },
	'cameracalibrationsig' => { 106 => 0xc6f3 },
	'cameracolorcalibration01' => { 33 => 0x0, 39 => 0xba },
	'cameracolorcalibration02' => { 33 => 0x4, 39 => 0xbf },
	'cameracolorcalibration03' => { 33 => 0x8, 39 => 0xc4 },
	'cameracolorcalibration04' => { 33 => 0xc, 39 => 0xc9 },
	'cameracolorcalibration05' => { 33 => 0x10, 39 => 0xce },
	'cameracolorcalibration06' => { 33 => 0x14, 39 => 0xd3 },
	'cameracolorcalibration07' => { 33 => 0x18, 39 => 0xd8 },
	'cameracolorcalibration08' => { 33 => 0x1c, 39 => 0xdd },
	'cameracolorcalibration09' => { 33 => 0x20, 39 => 0xe2 },
	'cameracolorcalibration10' => { 33 => 0x24, 39 => 0xe7 },
	'cameracolorcalibration11' => { 33 => 0x28, 39 => 0xec },
	'cameracolorcalibration12' => { 33 => 0x2c, 39 => 0xf1 },
	'cameracolorcalibration13' => { 33 => 0x30, 39 => 0xf6 },
	'cameracolorcalibration14' => { 33 => 0x34, 39 => 0xfb },
	'cameracolorcalibration15' => { 33 => 0x38, 39 => 0x100 },
	'camerae-mountversion' => { 389 => 0xb },
	'cameraid' => { 258 => 0x209, 340 => 0x209 },
	'cameraiso' => { 31 => 0x10 },
	'cameralabel' => { 106 => 0xc7a1, 429 => 'cameraLabel' },
	'cameramodel' => { 316 => 0x410, 429 => 'cameraModel' },
	'cameramodelid' => { 154 => 'CameraModelID' },
	'cameramove' => { 429 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 274 => 0x8f, 311 => 0x1, 316 => 0x100, 355 => [0x16,0x18], 378 => 0x28, 379 => 0x24, 380 => 0x29 },
	'cameraowner' => { 123 => 0xc353 },
	'cameraparameters' => { 258 => 0x2050 },
	'camerapicturestyle' => { 26 => 0xaf },
	'cameraprofile' => { 405 => 'CameraProfile' },
	'cameraprofiledigest' => { 405 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 98 => 0xe1 },
	'camerarawcontrast' => { 98 => 0xe3 },
	'camerarawhighlightpoint' => { 98 => 0xe6 },
	'camerarawlinear' => { 98 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 98 => 0xe8 },
	'camerarawoutputshadowpoint' => { 98 => 0xe9 },
	'camerarawsaturation' => { 98 => 0xe2 },
	'camerarawshadowpoint' => { 98 => 0xe7 },
	'camerarawsharpness' => { 98 => 0xe5 },
	'cameraserialnumber' => { 106 => 0xc62f, 156 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 253 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 30 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 67 => 0xc, 120 => 0x406, 257 => 0x1306, 270 => 0x320, 276 => 0x3402, 307 => 0x47, 338 => 0x43, 382 => 0x5 },
	'cameratemperature4' => { 312 => 0x14 },
	'cameratemperature5' => { 312 => 0x16 },
	'cameratemperaturerangemax' => { 108 => 0x5 },
	'cameratemperaturerangemin' => { 108 => 0x6 },
	'cameratype' => { 67 => 0x1a, 258 => 0x207 },
	'cameratype2' => { 254 => 0x100 },
	'canondr4' => { 107 => 'CanonDR4' },
	'canonexposuremode' => { 31 => 0x14 },
	'canonfiledescription' => { 86 => 0x805 },
	'canonfilelength' => { 55 => 0xe },
	'canonfirmwareversion' => { 55 => 0x7, 86 => 0x80b },
	'canonflashinfo' => { 86 => 0x1028 },
	'canonflashmode' => { 31 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 31 => 0xa },
	'canonimagetype' => { 55 => 0x6, 86 => 0x815 },
	'canonmodelid' => { 55 => 0x10, 86 => 0x1834 },
	'canonvrd' => { 107 => 'CanonVRD' },
	'caption' => { 399 => 'caption' },
	'caption-abstract' => { 114 => 0x78 },
	'captionsauthornames' => { 408 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 408 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 417 => 'CaptionWriter' },
	'captureframerate' => { 102 => 0x4001 },
	'capturesoftware' => { 394 => 'CaptureSoftware' },
	'cardshutterlock' => { 161 => 0x49 },
	'casioimagesize' => { 102 => 0x9 },
	'catalogsets' => { 114 => 0xff, 393 => 'CatalogSets', 397 => 'CatalogSets' },
	'categories' => { 55 => 0x23, 399 => 'categories' },
	'category' => { 114 => 0xf, 252 => 0x30, 417 => 'Category' },
	'cbcrgain' => { 338 => 0xa036 },
	'cbcrgaindefault' => { 338 => 0xa035 },
	'cbcrmatrix' => { 338 => 0xa034 },
	'cbcrmatrixdefault' => { 338 => 0xa033 },
	'ccdboardversion' => { 270 => 0x331 },
	'ccdscanmode' => { 258 => 0x1039 },
	'ccdsensitivity' => { 222 => 0x6 },
	'ccdversion' => { 270 => 0x330 },
	'cellglobalid' => { 403 => 'cgi' },
	'celllength' => { 106 => 0x109 },
	'cellr' => { 403 => 'r' },
	'celltowerid' => { 403 => 'cellid' },
	'cellwidth' => { 106 => 0x108 },
	'centerafarea' => { 248 => '15.1' },
	'centerfocuspoint' => { 251 => '2.2' },
	'centerweightedareasize' => { 239 => '7.1', 240 => '8.1', 242 => '8.1', 246 => '5.1', 247 => '7.1', 248 => '6.3', 250 => '8.1', 251 => '8.1' },
	'certificate' => { 433 => 'Certificate' },
	'cfapattern' => { 106 => 0xa302, 409 => 'CFAPattern' },
	'cfapattern2' => { 106 => 0x828e },
	'cfapatterncolumns' => { 409 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 409 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 409 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 106 => 0x828d },
	'channel' => { 419 => 'channel' },
	'channela-lang' => { 419 => [\'channel','channelA-lang'] },
	'channelchannel' => { 419 => [\'channel','channelChannel'] },
	'channels' => { 135 => 'Channels' },
	'channelsubchannel1' => { 419 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 419 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 419 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 419 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 92 => 0x10101, 97 => 0x26a },
	'checkmark2' => { 98 => 0x8e },
	'childfontfiles' => { 434 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 239 => '10.3', 240 => '11.2' },
	'chromablurradius' => { 106 => 0xc631 },
	'chromaticaberration' => { 92 => 0x20703, 98 => 0x66, 338 => 0xa051 },
	'chromaticaberrationb' => { 405 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 92 => 0x20708, 98 => 0x6b },
	'chromaticaberrationcorr' => { 69 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 297 => 0x1 },
	'chromaticaberrationon' => { 92 => '0x20703.0', 98 => 0x62 },
	'chromaticaberrationr' => { 405 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 92 => 0x20707, 98 => 0x6a },
	'chromaticaberrationsetting' => { 70 => 0x6 },
	'chrominancenoisereduction' => { 92 => 0x20601, 98 => 0x5e, 341 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 98 => 0x60 },
	'circgradbasedcorractive' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 405 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 405 => 'CircularGradientBasedCorrections' },
	'city' => { 114 => 0x5a, 141 => 'City', 274 => 0x6d, 417 => 'City' },
	'city2' => { 274 => 0x80 },
	'clarity' => { 197 => 0x35, 405 => 'Clarity' },
	'clarity2012' => { 405 => 'Clarity2012' },
	'classifystate' => { 114 => 0xe1 },
	'clearretouch' => { 274 => 0x7c },
	'clearretouchvalue' => { 274 => 0xa3 },
	'client' => { 429 => 'client' },
	'clientname' => { 411 => 'ClientName' },
	'clmodeshootingspeed' => { 239 => '10.2', 240 => '11.3', 242 => '11.2', 246 => '11.2', 247 => '10.2', 250 => '11.2', 251 => '11.1' },
	'cmcontrast' => { 261 => 0x2022 },
	'cmexposurecompensation' => { 261 => 0x2000 },
	'cmhue' => { 261 => 0x2021 },
	'cmsaturation' => { 261 => 0x2020 },
	'cmsharpness' => { 261 => 0x2023 },
	'cmwhitebalance' => { 261 => 0x2001 },
	'cmwhitebalancecomp' => { 261 => 0x2002 },
	'cmwhitebalancegraypoint' => { 261 => 0x2010 },
	'codec' => { 149 => 'Codec' },
	'codedcharacterset' => { 115 => 0x5a },
	'collectionname' => { 150 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 150 => 'Collections', 399 => 'collections' },
	'collectionuri' => { 150 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 418 => 'color' },
	'coloraberrationcontrol' => { 232 => 0xc89224b },
	'coloradjustment' => { 341 => 0x14 },
	'coloradjustmentmode' => { 340 => 0x210 },
	'coloranta' => { 434 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 434 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 434 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 434 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 434 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 434 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 434 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 434 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 434 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 434 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 434 => 'Colorants' },
	'colorantswatchname' => { 434 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 434 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 434 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 434 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 136 => 'ColorBalance' },
	'colorbalanceadj' => { 232 => 0x76a43202 },
	'colorbalanceblue' => { 158 => 0x1e },
	'colorbalancegreen' => { 158 => 0x1d },
	'colorbalancered' => { 158 => 0x1c },
	'colorbalanceversion' => { 179 => 0x0 },
	'colorblur' => { 98 => 0x65 },
	'colorbluron' => { 92 => 0x20704 },
	'colorbooster' => { 232 => 0x5f0e7d23 },
	'colorboostlevel' => { 226 => 0x1 },
	'colorboosttype' => { 226 => 0x0 },
	'colorclass' => { 318 => 0xde, 319 => 'ColorClass' },
	'colorcompensationfilter' => { 161 => [0x3a,0x5f], 163 => 0x111, 361 => 0xb022 },
	'colorcompensationfiltercustom' => { 349 => 0xd, 350 => 0xc },
	'colorcompensationfilterset' => { 349 => 0x8, 350 => 0x7, 351 => 0x18, 365 => 0xf },
	'colorcontrol' => { 258 => 0x102b },
	'colorcorrection' => { 390 => 0x8015 },
	'colordataversion' => { 37 => 0x0, 38 => 0x0, 40 => 0x0, 41 => 0x0, 42 => 0x0 },
	'coloreffect' => { 274 => 0x28 },
	'colorfilter' => { 101 => 0x17, 102 => 0x3017, 158 => 0x29, 166 => [0x38,0x4d,0x4f], 314 => 0x17 },
	'colorgain' => { 201 => 0x51 },
	'colorhue' => { 92 => 0x20900, 194 => 0x8d },
	'colorimetricreference' => { 106 => 0xc6bf },
	'colorlabel' => { 408 => 'ColorLabel' },
	'colormatrix' => { 257 => 0x200, 258 => 0x1011, 338 => 0xa030 },
	'colormatrix1' => { 106 => 0xc621, 316 => 0x106 },
	'colormatrix2' => { 106 => 0xc622, 261 => 0x200, 316 => 0x226 },
	'colormatrixa' => { 307 => 0x203 },
	'colormatrixadobergb' => { 338 => 0xa032 },
	'colormatrixb' => { 307 => 0x204 },
	'colormatrixnumber' => { 258 => 0x1019 },
	'colormatrixsrgb' => { 338 => 0xa031 },
	'colormode' => { 102 => 0x3015, 111 => 0x1210, 122 => 0x66, 158 => 0x28, 161 => 0x16, 163 => 0x101, 164 => 0x36, 166 => 0x7, 194 => 0x3, 222 => 0x4, 274 => 0x32, 341 => 0x2c, 361 => 0xb029, 417 => 'ColorMode' },
	'colormoirereduction' => { 233 => 0x15 },
	'colormoirereductionmode' => { 233 => 0x5 },
	'colornoisereduction' => { 390 => 0x8029, 405 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 405 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 233 => 0x18 },
	'colornoisereductionsharpness' => { 233 => 0x1c },
	'colornoisereductionsmoothness' => { 405 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 110 => 0x2 },
	'colorprofile' => { 158 => 0x33 },
	'colorrepresentation' => { 116 => 0x3c },
	'colorsaturationadj' => { 92 => 0x20305 },
	'colorsequence' => { 116 => 0x41 },
	'colorspace' => { 43 => 0x3, 55 => 0xb4, 86 => 0x10b4, 106 => 0xa001, 142 => 'ColorSpace', 159 => 0x2f, 160 => 0x25, 161 => 0x17, 194 => 0x1e, 253 => 0x507, 307 => 0x37, 338 => 0xa011, 341 => 0xb, 349 => 0x1b, 350 => 0x83, 351 => 0xe, 365 => 0x6, 409 => 'ColorSpace' },
	'colortempasshot' => { 34 => 0x4, 35 => 0x1d, 36 => 0x26, 37 => 0x43, 40 => 0x43, 41 => 0x43, 42 => 0x43 },
	'colortempauto' => { 34 => 0x9, 35 => 0x22, 36 => 0x1c, 37 => 0x48, 40 => 0x48, 41 => 0x48, 42 => 0x48 },
	'colortempcloudy' => { 34 => 0x22, 35 => 0x31, 36 => 0x35, 37 => 0x5c, 40 => 0x75, 41 => 0x8e, 42 => 0x93, 307 => 0x55 },
	'colortempcustom' => { 37 => 0x84 },
	'colortempcustom1' => { 35 => 0x45 },
	'colortempcustom2' => { 35 => 0x4a },
	'colortempdaylight' => { 34 => 0x18, 35 => 0x27, 36 => 0x2b, 37 => 0x52, 40 => 0x6b, 41 => 0x84, 42 => 0x89, 307 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 55 => 0xae, 65 => 0x9, 86 => 0x10ae, 111 => 0x1005, 120 => 0x846, 136 => 'ColorTemperature', 159 => [0x6e,0x49], 160 => 0x3f, 161 => [0x39,0x5e], 163 => 0x10b, 166 => [0x3c,0x4c,0x4e], 270 => 0x321, 307 => 0x50, 332 => 0x1308, 361 => 0xb021, 405 => 'Temperature' },
	'colortemperatureadj' => { 390 => 0x8013 },
	'colortemperaturebg' => { 258 => 0x1013 },
	'colortemperaturecustom' => { 349 => 0xc, 350 => 0xb },
	'colortemperaturerg' => { 258 => 0x1014 },
	'colortemperatureset' => { 349 => 0x7, 350 => 0x6 },
	'colortemperaturesetting' => { 161 => 0x25, 351 => 0x17, 365 => 0xe },
	'colortempflash' => { 34 => 0x36, 35 => 0x40, 36 => 0x49, 37 => 0x70, 40 => 0x89, 41 => 0xa2, 42 => 0xa7, 307 => 0x5a },
	'colortempflashdata' => { 37 => 0x24a },
	'colortempfluorescent' => { 34 => 0x2c, 35 => 0x3b, 36 => 0x3f, 37 => 0x66, 40 => 0x7f, 41 => 0x98, 42 => 0x9d },
	'colortempfluorescentd' => { 307 => 0x57 },
	'colortempfluorescentn' => { 307 => 0x58 },
	'colortempfluorescentw' => { 307 => 0x59 },
	'colortempkelvin' => { 34 => 0x31, 36 => 0x44, 37 => 0x6b, 40 => 0x84, 41 => 0x9d, 42 => 0xa2, 274 => 0x44, 332 => 0x1307 },
	'colortempmeasured' => { 34 => 0xe, 37 => 0x4d, 40 => 0x4d, 41 => 0x4d, 42 => 0x4d },
	'colortemppc1' => { 36 => 0x94, 37 => 0x75 },
	'colortemppc2' => { 36 => 0x99, 37 => 0x7a },
	'colortemppc3' => { 36 => 0x9e, 37 => 0x7f },
	'colortempshade' => { 34 => 0x1d, 35 => 0x2c, 36 => 0x30, 37 => 0x57, 40 => 0x70, 41 => 0x89, 42 => 0x8e, 307 => 0x54 },
	'colortemptungsten' => { 34 => 0x27, 35 => 0x36, 36 => 0x3a, 37 => 0x61, 40 => 0x7a, 41 => 0x93, 42 => 0x98, 307 => 0x56 },
	'colortempunknown' => { 34 => 0x13, 36 => 0x21, 40 => 0x52, 41 => 0x52, 42 => 0x52 },
	'colortempunknown10' => { 34 => 0x63, 36 => 0x76, 40 => 0xa2, 41 => 0x7f, 42 => 0x7f },
	'colortempunknown11' => { 34 => 0x68, 36 => 0x7b, 40 => 0xa7, 41 => 0xa7, 42 => 0x84 },
	'colortempunknown12' => { 34 => 0x6d, 36 => 0x80, 40 => 0xac, 41 => 0xac, 42 => 0xac },
	'colortempunknown13' => { 34 => 0x72, 36 => 0x85, 40 => 0xb1, 41 => 0xb1, 42 => 0xb1 },
	'colortempunknown14' => { 36 => 0x8a, 40 => 0xb6, 41 => 0xb6, 42 => 0xb6 },
	'colortempunknown15' => { 36 => 0x8f, 40 => 0xbb, 41 => 0xbb, 42 => 0xbb },
	'colortempunknown16' => { 36 => 0xa3, 41 => 0xc0, 42 => 0xc0 },
	'colortempunknown17' => { 41 => 0xc5, 42 => 0xc5 },
	'colortempunknown18' => { 41 => 0xca, 42 => 0xca },
	'colortempunknown19' => { 41 => 0xcf, 42 => 0xcf },
	'colortempunknown2' => { 34 => 0x3b, 36 => 0x4e, 40 => 0x57, 41 => 0x57, 42 => 0x57 },
	'colortempunknown20' => { 41 => 0xd4, 42 => 0xd4 },
	'colortempunknown21' => { 42 => 0xd9 },
	'colortempunknown22' => { 42 => 0xde },
	'colortempunknown23' => { 42 => 0xe3 },
	'colortempunknown24' => { 42 => 0xe8 },
	'colortempunknown25' => { 42 => 0xed },
	'colortempunknown26' => { 42 => 0xf2 },
	'colortempunknown27' => { 42 => 0xf7 },
	'colortempunknown28' => { 42 => 0xfc },
	'colortempunknown29' => { 42 => 0x101 },
	'colortempunknown3' => { 34 => 0x40, 36 => 0x53, 40 => 0x5c, 41 => 0x5c, 42 => 0x5c },
	'colortempunknown30' => { 42 => 0x106 },
	'colortempunknown4' => { 34 => 0x45, 36 => 0x58, 40 => 0x61, 41 => 0x61, 42 => 0x61 },
	'colortempunknown5' => { 34 => 0x4a, 36 => 0x5d, 40 => 0x66, 41 => 0x66, 42 => 0x66 },
	'colortempunknown6' => { 34 => 0x4f, 36 => 0x62, 40 => 0x8e, 41 => 0x6b, 42 => 0x6b },
	'colortempunknown7' => { 34 => 0x54, 36 => 0x67, 40 => 0x93, 41 => 0x70, 42 => 0x70 },
	'colortempunknown8' => { 34 => 0x59, 36 => 0x6c, 40 => 0x98, 41 => 0x75, 42 => 0x75 },
	'colortempunknown9' => { 34 => 0x5e, 36 => 0x71, 40 => 0x9d, 41 => 0x7a, 42 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 31 => 0x2a, 43 => 0x2 },
	'colortoneadj' => { 92 => 0x20304, 97 => 0x11e },
	'colortoneauto' => { 62 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 61 => 0x6c, 62 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 61 => 0x3c, 62 => 0x3c },
	'colortonemonochrome' => { 61 => 0x84, 62 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 61 => 0x54, 62 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 61 => 0x24, 62 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 61 => 0xc, 62 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 61 => 0x9c, 62 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 61 => 0xb4, 62 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 61 => 0xcc, 62 => 0xe4 },
	'commanddials' => { 248 => '5.1' },
	'commanddialsaperturesetting' => { 239 => '17.3', 240 => '18.3', 242 => '18.3', 246 => '33.3', 247 => '17.3', 250 => '18.3' },
	'commanddialschangemainsub' => { 239 => '17.2', 240 => '18.1', 242 => '18.1', 246 => '33.2', 247 => '17.2', 250 => '18.1' },
	'commanddialsmenuandplayback' => { 239 => '17.4', 240 => '18.2', 242 => '18.2', 246 => '33.4', 247 => '17.4', 250 => '18.2' },
	'commanddialsreverserotation' => { 239 => '17.1', 240 => '6.4', 242 => '6.2', 243 => '16.2', 244 => '17.2', 246 => '33.1', 247 => '17.1', 250 => '6.2', 251 => '18.1' },
	'commanderchannel' => { 248 => '10.2', 249 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 248 => '13.1', 249 => '31.1' },
	'commandergroupa_ttlcomp' => { 251 => '32.1' },
	'commandergroupamanualoutput' => { 248 => '13.2', 249 => '28.2' },
	'commandergroupamode' => { 248 => '11.2', 249 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 248 => '14.1', 249 => '32.1' },
	'commandergroupb_ttlcomp' => { 251 => '33.1' },
	'commandergroupbmanualoutput' => { 248 => '14.2', 249 => '29.2' },
	'commandergroupbmode' => { 248 => '11.3', 249 => '29.1' },
	'commanderinternalflash' => { 248 => '11.1', 249 => '27.1' },
	'commanderinternalmanualoutput' => { 248 => '12.2', 249 => '27.2' },
	'commanderinternalttlchannel' => { 246 => '18.2' },
	'commanderinternalttlcomp' => { 248 => '12.1', 249 => '30.2', 251 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 246 => '20.1', 247 => '26.1' },
	'commanderinternalttlcompgroupa' => { 246 => '21.1', 247 => '27.1' },
	'commanderinternalttlcompgroupb' => { 246 => '22.1', 247 => '28.1' },
	'comment' => { 0 => 0x2, 107 => 'Comment', 137 => 'Comment', 266 => 'Comment' },
	'compass' => { 335 => 0x4 },
	'complianceprofile' => { 419 => 'complianceProfile' },
	'componentsconfiguration' => { 106 => 0x9101, 142 => 'Components', 409 => 'ComponentsConfiguration' },
	'componentversion' => { 86 => 0x80c },
	'composer' => { 429 => 'composer' },
	'compositionadjust' => { 306 => '0.1' },
	'compositionadjustrotation' => { 306 => 0x7 },
	'compositionadjustx' => { 306 => 0x5 },
	'compositionadjusty' => { 306 => 0x6 },
	'compressedbitsperpixel' => { 106 => 0x9102, 409 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 163 => 0x40, 258 => 0x40 },
	'compression' => { 106 => 0x103, 425 => 'Compression' },
	'compressionfactor' => { 253 => 0x50d },
	'compressionratio' => { 142 => 'Compression', 258 => 0x1034 },
	'confidencelevel' => { 400 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 97 => 0x266, 318 => 0xd6 },
	'constrainedcropwidth' => { 97 => 0x262, 318 => 0xd5 },
	'contact' => { 114 => 0x76 },
	'contactinfo' => { 418 => 'contactInfo' },
	'contentlocationcode' => { 114 => 0x1a },
	'contentlocationname' => { 114 => 0x1b },
	'contenttype' => { 419 => 'contentType' },
	'continuousbracketing' => { 161 => 0x20 },
	'continuousdrive' => { 31 => 0x5 },
	'continuousshootingspeed' => { 73 => 0x610 },
	'continuousshotlimit' => { 73 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 31 => 0xd, 101 => 0xc, 102 => [0x3012,0x20], 106 => [0xa408,0xfe54], 111 => [0x1004,0x1006], 136 => 'Contrast', 154 => 'Contrast', 158 => 0x20, 159 => 0x31, 160 => 0x27, 161 => 0x19, 166 => 0x2, 196 => 0x33, 197 => 0x37, 258 => 0x1029, 274 => 0x39, 276 => 0x300a, 307 => 0x20, 314 => 0xc, 328 => 0x24, 332 => 0x1012, 341 => 0xd, 349 => 0x1d, 350 => 0x1a, 361 => 0x2004, 405 => 'Contrast', 409 => 'Contrast' },
	'contrast2012' => { 405 => 'Contrast2012' },
	'contrastadj' => { 92 => 0x20303, 97 => 0x115, 235 => 0x2c, 390 => 0x8017 },
	'contrastauto' => { 62 => 0x90 },
	'contrastcurve' => { 194 => 0x8c },
	'contrastdetectaf' => { 170 => 0x4 },
	'contrastdetectafarea' => { 307 => 0x231 },
	'contrastdetectafinfocus' => { 170 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 61 => 0x60, 62 => 0x60 },
	'contrasthighlight' => { 307 => 0x6d },
	'contrasthighlightshadowadj' => { 307 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 61 => 0x30, 62 => 0x30 },
	'contrastmode' => { 274 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 61 => 0x78, 62 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 61 => 0x48, 62 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 61 => 0x18, 62 => 0x18 },
	'contrastsetting' => { 253 => 0x505, 261 => 0x1012, 351 => 0x10, 365 => 0x8 },
	'contrastshadow' => { 307 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 61 => 0x0, 62 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 61 => 0x90, 62 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 61 => 0xa8, 62 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 61 => 0xc0, 62 => 0xd8 },
	'contributedmedia' => { 429 => 'contributedMedia' },
	'contributedmediaduration' => { 429 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 429 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 429 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 429 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 429 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 429 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 429 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 429 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 429 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 429 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 406 => 'contributor' },
	'contributors' => { 137 => 'Contributors' },
	'controldialset' => { 161 => 0x46 },
	'controlledvocabularyterm' => { 415 => 'CVterm' },
	'controllerboardversion' => { 270 => 0x332 },
	'controlmode' => { 67 => 0x12 },
	'conversionlens' => { 254 => 0x403, 274 => 0x35 },
	'converter' => { 106 => 0xfe4d, 222 => 0xb, 405 => 'Converter' },
	'converttograyscale' => { 405 => 'ConvertToGrayscale' },
	'cookingequipment' => { 421 => 'cookingEquipment' },
	'cookingmethod' => { 421 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 106 => 0x8298, 137 => 'Copyright', 266 => 'Copyright', 307 => 0x22f, 323 => 'Copyright', 416 => 'Copyright', 422 => 'copyright', 425 => 'Copyright', 429 => 'copyright' },
	'copyrightflag' => { 321 => 0x40a },
	'copyrightnotice' => { 114 => 0x74 },
	'copyrightowner' => { 263 => 'CopyrightOwner' },
	'copyrightownerid' => { 263 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 263 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 263 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 263 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 263 => 'CopyrightStatus' },
	'copyrightyear' => { 419 => 'copyrightYear' },
	'coringfilter' => { 257 => 0x310, 258 => 0x102d, 261 => 0x310 },
	'coringvalues' => { 257 => 0x311, 261 => 0x311 },
	'corporateentity' => { 419 => 'corporateEntity' },
	'country' => { 141 => 'Country', 274 => 0x69, 417 => 'Country' },
	'country-primarylocationcode' => { 114 => 0x64 },
	'country-primarylocationname' => { 114 => 0x65 },
	'countrycode' => { 193 => 0x5, 319 => 'CountryCode', 414 => 'CountryCode' },
	'course' => { 421 => 'course' },
	'coverage' => { 406 => 'coverage' },
	'coverdate' => { 419 => 'coverDate' },
	'coverdisplaydate' => { 419 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 307 => 0x28 },
	'crc32' => { 407 => 'crc32' },
	'createdate' => { 106 => 0x9004, 137 => 'CreateDate', 262 => 'CreationDate', 266 => 'create-date', 323 => 'CreationDate', 325 => 0x1, 427 => 'CreateDate' },
	'creationdate' => { 416 => 'CreationDate', 419 => 'creationDate' },
	'creationtime' => { 266 => 'Creation Time' },
	'creativestyle' => { 349 => 0x1a, 350 => 0x18, 360 => 0x41, 361 => 0xb020, 386 => 0x4a },
	'creativestylesetting' => { 351 => 0xf, 365 => 0x7 },
	'creativestylewaschanged' => { 390 => 0x8001 },
	'creator' => { 262 => 'Creator', 323 => 'Creator', 406 => 'creator', 416 => 'Creator' },
	'creatoraddress' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 156 => 'CreatorAppId' },
	'creatorcity' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 414 => 'CreatorContactInfo' },
	'creatorcountry' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 156 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 427 => 'CreatorTool' },
	'creatorworkemail' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 414 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 114 => 0x6e, 417 => 'Credit' },
	'creditline' => { 422 => 'creditLine' },
	'creditlinereq' => { 432 => 'CreditLineReq' },
	'creditlinerequired' => { 263 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x0, 97 => 0x244 },
	'cropangle' => { 405 => 'CropAngle' },
	'cropaspectratio' => { 92 => 0x30101, 97 => 0x260 },
	'cropaspectratiocustom' => { 92 => 0x30102 },
	'cropbottom' => { 110 => 0x9, 227 => 0x36, 278 => 0x31, 318 => 0xdc, 405 => 'CropBottom' },
	'cropbottommargin' => { 45 => 0x3 },
	'cropcircleactive' => { 98 => 0xd6 },
	'cropcircleradius' => { 98 => 0xd9 },
	'cropcirclex' => { 98 => 0xd7 },
	'cropcircley' => { 98 => 0xd8 },
	'cropconstraintowarp' => { 405 => 'CropConstrainToWarp' },
	'croph' => { 398 => 'CropH' },
	'cropheight' => { 90 => 0x6, 97 => 0x24c, 257 => 0x615, 261 => 0x615, 405 => 'CropHeight' },
	'crophispeed' => { 194 => 0x1b },
	'cropleft' => { 97 => 0x246, 110 => 0x6, 227 => 0x1e, 257 => 0x612, 261 => 0x612, 278 => 0x30, 318 => 0xd9, 405 => 'CropLeft' },
	'cropleftmargin' => { 45 => 0x0 },
	'cropmode35mm' => { 332 => 0x1018 },
	'croporiginalheight' => { 90 => 0xb },
	'croporiginalwidth' => { 90 => 0xa },
	'cropoutputheight' => { 227 => 0xce },
	'cropoutputheightinches' => { 227 => 0x96 },
	'cropoutputpixels' => { 227 => 0xd6 },
	'cropoutputresolution' => { 227 => 0xb6 },
	'cropoutputscale' => { 227 => 0xbe },
	'cropoutputwidth' => { 227 => 0xc6 },
	'cropoutputwidthinches' => { 227 => 0x8e },
	'croppedareaimageheightpixels' => { 394 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 394 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 394 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 394 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 332 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 332 => 0x1603 },
	'cropright' => { 110 => 0x8, 227 => 0x2e, 278 => 0x32, 318 => 0xdb, 405 => 'CropRight' },
	'croprightmargin' => { 45 => 0x1 },
	'croprotatedoriginalheight' => { 90 => 0x2 },
	'croprotatedoriginalwidth' => { 90 => 0x1 },
	'croprotation' => { 90 => 0x8, 110 => 0xb },
	'cropscaledresolution' => { 227 => 0x9e },
	'cropsourceresolution' => { 227 => 0xae },
	'croptop' => { 97 => 0x248, 110 => 0x7, 227 => 0x26, 257 => 0x613, 261 => 0x613, 278 => 0x2f, 318 => 0xda, 405 => 'CropTop' },
	'croptopmargin' => { 45 => 0x2 },
	'cropunit' => { 405 => 'CropUnit' },
	'cropunits' => { 405 => 'CropUnits' },
	'cropw' => { 398 => 'CropW' },
	'cropwidth' => { 90 => 0x5, 97 => 0x24a, 257 => 0x614, 261 => 0x614, 405 => 'CropWidth' },
	'cropx' => { 90 => 0x3, 398 => 'CropX' },
	'cropy' => { 90 => 0x4, 398 => 'CropY' },
	'crossprocess' => { 307 => 0x7b },
	'crossprocessparams' => { 307 => 0x235 },
	'cuisine' => { 421 => 'cuisine' },
	'currenticcprofile' => { 106 => 0xc691 },
	'currentpreprofilematrix' => { 106 => 0xc692 },
	'currentversion' => { 390 => 0xd000 },
	'curve0x' => { 398 => 'Curve0x' },
	'curve0y' => { 398 => 'Curve0y' },
	'curve1x' => { 398 => 'Curve1x' },
	'curve1y' => { 398 => 'Curve1y' },
	'curve2x' => { 398 => 'Curve2x' },
	'curve2y' => { 398 => 'Curve2y' },
	'curve3x' => { 398 => 'Curve3x' },
	'curve3y' => { 398 => 'Curve3y' },
	'curve4x' => { 398 => 'Curve4x' },
	'curve4y' => { 398 => 'Curve4y' },
	'curves' => { 232 => 0x76a43201 },
	'custom1' => { 263 => 'Custom1' },
	'custom10' => { 263 => 'Custom10' },
	'custom2' => { 263 => 'Custom2' },
	'custom3' => { 263 => 'Custom3' },
	'custom4' => { 263 => 'Custom4' },
	'custom5' => { 263 => 'Custom5' },
	'custom6' => { 263 => 'Custom6' },
	'custom7' => { 263 => 'Custom7' },
	'custom8' => { 263 => 'Custom8' },
	'custom9' => { 263 => 'Custom9' },
	'customcolortone' => { 98 => 0x4c },
	'customcontrast' => { 98 => 0x4e },
	'customcontrols' => { 73 => 0x70c },
	'customdefaultunsharpfineness' => { 98 => 0xbe },
	'customdefaultunsharpstrength' => { 98 => 0xbc },
	'customdefaultunsharpthreshold' => { 98 => 0xc0 },
	'customlinear' => { 98 => 0x4f },
	'customoutputhighlightpoint' => { 98 => 0x53 },
	'customoutputshadowpoint' => { 98 => 0x54 },
	'custompicturestyle' => { 92 => 0x10021 },
	'custompicturestyledata' => { 92 => 0xf0500 },
	'custompicturestylefilename' => { 55 => 0x4010 },
	'customrawhighlight' => { 98 => 0x7c },
	'customrawhighlightpoint' => { 98 => 0x51 },
	'customrawshadow' => { 98 => 0x85 },
	'customrawshadowpoint' => { 98 => 0x52 },
	'customrendered' => { 106 => 0xa401, 409 => 'CustomRendered' },
	'customsaturation' => { 98 => 0x4d, 253 => 0x503 },
	'customsettingsalldefault' => { 239 => '0.2', 246 => '0.2' },
	'customsettingsbank' => { 239 => '0.1', 240 => '0.1', 242 => '0.1', 246 => '0.1', 250 => '0.2' },
	'customsharpness' => { 98 => 0x50 },
	'customunsharpmaskfineness' => { 98 => 0xb8 },
	'customunsharpmaskstrength' => { 98 => 0xb6 },
	'customunsharpmaskthreshold' => { 98 => 0xba },
	'customwb_rblevels' => { 365 => 0x1a },
	'customwb_rgblevels' => { 350 => 0x8, 351 => 0x19 },
	'customwbbluelevel' => { 161 => 0x36 },
	'customwberror' => { 161 => 0x37 },
	'customwbgreenlevel' => { 161 => 0x35 },
	'customwbredlevel' => { 161 => 0x34 },
	'customwbsetting' => { 161 => 0x26 },
	'd-lightinghq' => { 232 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 228 => 0x2 },
	'd-lightinghqhighlight' => { 228 => 0x1 },
	'd-lightinghqselected' => { 232 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 228 => 0x0 },
	'd-lightinghs' => { 232 => 0xce5554aa },
	'd-lightinghsadjustment' => { 229 => 0x0 },
	'd-lightinghscolorboost' => { 229 => 0x1 },
	'd-rangeoptimizerhighlight' => { 390 => 0x8024 },
	'd-rangeoptimizermode' => { 390 => 0x8022 },
	'd-rangeoptimizershadow' => { 390 => 0x802d },
	'd-rangeoptimizervalue' => { 390 => 0x8023 },
	'd810meteringmode' => { 220 => 0x175e },
	'datacompressionmethod' => { 116 => 0x6e },
	'dataimprint' => { 158 => 0x34 },
	'datascaling' => { 307 => 0x3d },
	'date' => { 307 => 0x6, 406 => 'date' },
	'dateacquired' => { 156 => 'DateAcquired' },
	'datecreated' => { 114 => 0x37, 417 => 'DateCreated' },
	'datedisplayformat' => { 224 => 0x3 },
	'dateidentified' => { 105 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 243 => '4.2' },
	'daterecieved' => { 419 => 'dateRecieved' },
	'datesent' => { 115 => 0x46 },
	'datestampmode' => { 55 => 0x1c },
	'datetime' => { 399 => 'datetime', 425 => 'DateTime' },
	'datetimedigitized' => { 409 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 89 => 0x0, 106 => 0x9003, 134 => 0x14, 137 => 'OriginalDate', 328 => 0xb, 409 => 'DateTimeOriginal' },
	'datetimestamp' => { 122 => 0x64 },
	'datetimeutc' => { 253 => 0x908 },
	'daylightsavings' => { 68 => 0x3, 224 => 0x2 },
	'dccontinent' => { 105 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 105 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 105 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 105 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 105 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 105 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 105 => 'Event' },
	'dcfootprintspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 105 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 105 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 105 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 105 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 105 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 105 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 105 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 105 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 105 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 105 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 105 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 105 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 145 => 'Declination' },
	'decposition' => { 158 => 0x32 },
	'defaultautogray' => { 405 => 'DefaultAutoGray' },
	'defaultautotone' => { 405 => 'DefaultAutoTone' },
	'defaultblackrender' => { 106 => 0xc7a6 },
	'defaultcroporigin' => { 106 => 0xc61f },
	'defaultcropsize' => { 106 => 0xc620 },
	'defaulteraseoption' => { 73 => 0x813 },
	'defaultscale' => { 106 => 0xc61e },
	'defaultsspecifictoiso' => { 405 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 405 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 106 => 0xc7b5 },
	'defringe' => { 405 => 'Defringe' },
	'defringegreenamount' => { 405 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 405 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 405 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 405 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 405 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 405 => 'DefringePurpleHueLo' },
	'dehaze' => { 405 => 'Dehaze' },
	'deletedimagecount' => { 194 => 0xa6, 202 => 0x6e },
	'deprecatedon' => { 402 => 'deprecatedOn' },
	'derivedfrom' => { 430 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 430 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 430 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 430 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 430 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 430 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 430 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 430 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 430 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 430 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 430 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 430 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 430 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 430 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 430 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 430 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 430 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 430 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 266 => 'Description', 406 => 'description', 427 => 'Description' },
	'destination' => { 115 => 0x5 },
	'destinationcity' => { 307 => 0x24, 313 => 0x3 },
	'destinationcitycode' => { 314 => 0x1001 },
	'destinationdst' => { 307 => 0x26, 313 => '0.3' },
	'developmentdynamicrange' => { 111 => 0x1403 },
	'device' => { 419 => 'device' },
	'devicesettingdescription' => { 409 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 409 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 409 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 409 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 338 => 0x2 },
	'dialdirectiontvav' => { 73 => 0x706 },
	'dietaryneeds' => { 421 => 'dietaryNeeds' },
	'diffractioncorrection' => { 297 => 0x3 },
	'digitalcreationdate' => { 114 => 0x3e },
	'digitalcreationtime' => { 114 => 0x3f },
	'digitaldeehighlightadj' => { 201 => 0x202 },
	'digitaldeeshadowadj' => { 201 => 0x200 },
	'digitaldeethreshold' => { 201 => 0x201 },
	'digitalfilter' => { 341 => 0x59 },
	'digitalfilter01' => { 294 => 0x5 },
	'digitalfilter02' => { 294 => 0x16 },
	'digitalfilter03' => { 294 => 0x27 },
	'digitalfilter04' => { 294 => 0x38 },
	'digitalfilter05' => { 294 => 0x49 },
	'digitalfilter06' => { 294 => 0x5a },
	'digitalfilter07' => { 294 => 0x6b },
	'digitalfilter08' => { 294 => 0x7c },
	'digitalfilter09' => { 294 => 0x8d },
	'digitalfilter10' => { 294 => 0x9e },
	'digitalfilter11' => { 294 => 0xaf },
	'digitalfilter12' => { 294 => 0xc0 },
	'digitalfilter13' => { 294 => 0xd1 },
	'digitalfilter14' => { 294 => 0xe2 },
	'digitalfilter15' => { 294 => 0xf3 },
	'digitalfilter16' => { 294 => 0x104 },
	'digitalfilter17' => { 294 => 0x115 },
	'digitalfilter18' => { 294 => 0x126 },
	'digitalfilter19' => { 294 => 0x137 },
	'digitalfilter20' => { 294 => 0x148 },
	'digitalgain' => { 65 => 0xb },
	'digitalgem' => { 186 => 0x0 },
	'digitalice' => { 201 => 0x100 },
	'digitalimageguid' => { 415 => 'DigImageGUID' },
	'digitalroc' => { 199 => 0x0 },
	'digitalsourcefiletype' => { 415 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 415 => 'DigitalSourceType' },
	'digitalzoom' => { 31 => 0xc, 101 => 0xa, 122 => 0x68, 136 => 'DigitalZoom', 158 => 0xc, 194 => 0x86, 222 => 0xa, 258 => 0x204, 307 => 0x1e, 314 => 0xa, 340 => 0x204, 378 => 0x12, 379 => 0x12 },
	'digitalzoomon' => { 340 => 0x21b },
	'digitalzoomratio' => { 106 => 0xa404, 370 => 0x200, 372 => 0x21c, 409 => 'DigitalZoomRatio' },
	'director' => { 429 => 'director' },
	'directorphotography' => { 429 => 'directorPhotography' },
	'directory' => { 107 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 182 => 0x3 },
	'disclaimer' => { 266 => 'Disclaimer' },
	'discnumber' => { 429 => 'discNumber' },
	'dishtype' => { 421 => 'dishType' },
	'displayallafpoints' => { 73 => 0x514 },
	'displayaperture' => { 31 => 0x23 },
	'displayedunitsx' => { 322 => 0x2 },
	'displayedunitsy' => { 322 => 0x6 },
	'displayname' => { 418 => 'displayName' },
	'distance1' => { 122 => 0x28 },
	'distance2' => { 122 => 0x2c },
	'distance3' => { 122 => 0x30 },
	'distance4' => { 122 => 0x34 },
	'distortion' => { 338 => 0xa050 },
	'distortioncontrol' => { 202 => 0x10 },
	'distortioncorrection' => { 92 => 0x20705, 98 => 0x67, 253 => 0x50b, 277 => '7.1', 297 => 0x0, 385 => 0x601, 386 => 0x5b },
	'distortioncorrection2' => { 257 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 401 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 92 => '0x20705.0', 98 => 0x63 },
	'distortioncorrectionsetting' => { 361 => 0x2013 },
	'distortioneffect' => { 92 => 0x20709 },
	'distortionn' => { 277 => 0xc },
	'distortionparam02' => { 277 => 0x2 },
	'distortionparam04' => { 277 => 0x4 },
	'distortionparam08' => { 277 => 0x8 },
	'distortionparam09' => { 277 => 0x9 },
	'distortionparam11' => { 277 => 0xb },
	'distortionscale' => { 277 => 0x5 },
	'distributor' => { 419 => 'distributor' },
	'distributorproductid' => { 418 => 'distributorProductID' },
	'dloon' => { 92 => '0x20706.0', 98 => 0xdc },
	'dlosetting' => { 92 => 0x20706, 98 => 0xdd },
	'dlosettingapplied' => { 91 => 0x4 },
	'dloshootingdistance' => { 98 => 0xde },
	'dloversion' => { 91 => 0x5 },
	'dmcomment' => { 429 => 'comment' },
	'dngadobedata' => { 106 => 0xc634 },
	'dngbackwardversion' => { 106 => 0xc613 },
	'dngignoresidecars' => { 405 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 106 => 0xc630 },
	'dngprivatedata' => { 106 => 0xc634 },
	'dngversion' => { 106 => 0xc612 },
	'document' => { 266 => 'Document' },
	'documentancestors' => { 417 => 'DocumentAncestors' },
	'documenthistory' => { 114 => 0xe7 },
	'documentid' => { 430 => 'DocumentID' },
	'documentname' => { 106 => 0x10d },
	'documentnotes' => { 114 => 0xe6 },
	'doi' => { 419 => 'doi' },
	'dpp' => { 399 => 'dpp' },
	'dr4cameramodel' => { 93 => 0x3 },
	'drivemode' => { 102 => 0x3103, 158 => 0x6, 161 => 0x1e, 164 => 0xe, 253 => 0x600, 307 => 0x34, 332 => 0x1002, 341 => 0x3, 349 => 0x4, 350 => 0x7e, 351 => 0x34 },
	'drivemode2' => { 161 => 0xa, 288 => 0x7, 360 => 0xe, 365 => 0x1 },
	'drivemodesetting' => { 351 => 0x4 },
	'dspfirmwareversion' => { 307 => 0x27 },
	'duration' => { 58 => 0x6a, 135 => 'Duration', 149 => 'Duration', 421 => 'duration', 429 => 'duration' },
	'durationscale' => { 429 => [\'duration','durationScale'] },
	'durationvalue' => { 429 => [\'duration','durationValue'] },
	'dustremovaldata' => { 55 => 0x97 },
	'dynamicafarea' => { 239 => '1.4', 246 => '1.4' },
	'dynamicareaafdisplay' => { 240 => '46.1', 242 => '47.1', 250 => '47.1' },
	'dynamicrange' => { 111 => 0x1400 },
	'dynamicrangeexpansion' => { 307 => 0x69, 332 => 0x100e },
	'dynamicrangemax' => { 97 => 0x7c },
	'dynamicrangemin' => { 97 => 0x7a },
	'dynamicrangeoptimizer' => { 161 => 0x15, 361 => [0xb025,0xb04f], 368 => 0x1144, 369 => [0x1144,0x324], 370 => [0x1120,0x300], 371 => [0x119c,0x37c], 372 => [0x1178,0x328], 373 => [0x1030,0x50], 374 => [0x228,0x50], 375 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 360 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 349 => 0x19, 350 => 0x17, 351 => 0xd, 360 => 0x79, 365 => 0x5 },
	'dynamicrangeoptimizermode' => { 164 => 0x15, 349 => 0x18, 350 => 0x16, 360 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 161 => 0x27, 351 => 0xc, 365 => 0x4 },
	'dynamicrangesetting' => { 111 => 0x1402 },
	'e-dialinprogram' => { 288 => '1.3' },
	'earliestageorloweststage' => { 105 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 251 => '6.1' },
	'easyexposurecompensation' => { 239 => '6.4', 240 => '6.5', 242 => '6.3', 246 => '4.4', 247 => '5.2', 250 => '6.3' },
	'easymode' => { 31 => 0xb },
	'edgenoisereduction' => { 233 => 0x4, 390 => 0x8028 },
	'edition' => { 419 => 'edition' },
	'editorialupdate' => { 114 => 0x8 },
	'editstatus' => { 114 => 0x7, 319 => 'EditStatus', 399 => 'EditStatus' },
	'editversionname' => { 232 => 0x3d136244 },
	'effectivelv' => { 307 => 0x2d },
	'effectivemaxaperture' => { 190 => 0x12, 191 => 0x13 },
	'eissn' => { 419 => 'eIssn' },
	'electronicfront-curtainshutter' => { 242 => '5.2', 250 => '5.3' },
	'elevation' => { 145 => 'Elevation' },
	'email' => { 137 => 'EMail' },
	'embargodate' => { 422 => 'embargoDate' },
	'embdencrightsexpr' => { 415 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 415 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 415 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 415 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 417 => 'EmbeddedXMPDigest' },
	'emissivity' => { 108 => 0x3 },
	'encryptionkey' => { 338 => 0xa020 },
	'endingpage' => { 419 => 'endingPage' },
	'enduser' => { 263 => 'EndUser' },
	'enduserid' => { 263 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 263 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 429 => 'engineer' },
	'enhancedarktones' => { 225 => 0x8 },
	'enhancement' => { 101 => 0x16, 102 => 0x3016 },
	'enhancer' => { 257 => 0x300 },
	'enhancervalues' => { 257 => 0x301 },
	'envelopenumber' => { 115 => 0x28 },
	'envelopepriority' => { 115 => 0x3c },
	'enveloperecordversion' => { 115 => 0x0 },
	'epsonimageheight' => { 258 => 0x20c },
	'epsonimagewidth' => { 258 => 0x20b },
	'epsonsoftware' => { 258 => 0x20d },
	'equipmentinstitution' => { 392 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 392 => 'EquipmentManufacturer' },
	'equipmentversion' => { 254 => 0x0 },
	'ettlii' => { 73 => 0x304, 74 => 0xd, 75 => 0xe, 76 => 0x7, 77 => 0x7, 78 => 0xe },
	'event' => { 393 => 'Event', 397 => 'Event', 415 => 'Event', 419 => 'event' },
	'eventalias' => { 418 => 'eventAlias' },
	'eventday' => { 105 => [\'Event','EventDay'] },
	'eventearliestdate' => { 105 => [\'Event','EventEarliestDate'] },
	'eventend' => { 418 => 'eventEnd' },
	'eventenddayofyear' => { 105 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 105 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 105 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 105 => [\'Event','EventHabitat'] },
	'eventid' => { 105 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 105 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 105 => [\'Event','EventMonth'] },
	'eventnumber' => { 328 => 0x9 },
	'eventremarks' => { 105 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 105 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 105 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 418 => 'eventStart' },
	'eventstartdayofyear' => { 105 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 418 => 'eventSubtype' },
	'eventtime' => { 105 => [\'Event','EventEventTime'] },
	'eventtype' => { 418 => 'eventType' },
	'eventverbatimeventdate' => { 105 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 105 => [\'Event','EventYear'] },
	'evsteps' => { 288 => '1.2', 290 => 0x0 },
	'evstepsize' => { 243 => '5.1', 244 => '6.1', 245 => '6.1', 248 => '0.7' },
	'exclusivityenddate' => { 422 => 'exclusivityEndDate' },
	'excursiontolerance' => { 116 => 0x82 },
	'exif' => { 107 => 'EXIF' },
	'exifbyteorder' => { 107 => 'ExifByteOrder' },
	'exifcamerainfo' => { 114 => 0xe8 },
	'exifimageheight' => { 106 => 0xa003, 409 => 'PixelYDimension' },
	'exifimagewidth' => { 106 => 0xa002, 409 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 107 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 106 => 0x9000, 409 => 'ExifVersion' },
	'exitpupilposition' => { 190 => 0x4, 191 => 0x4 },
	'expirationdate' => { 114 => 0x25, 422 => 'expirationDate' },
	'expirationtime' => { 114 => 0x26 },
	'exposure' => { 106 => 0xfe51, 405 => 'Exposure' },
	'exposure2012' => { 405 => 'Exposure2012' },
	'exposureadj' => { 230 => 0x0 },
	'exposureadj2' => { 230 => 0x12 },
	'exposureadjust' => { 341 => 0xc },
	'exposurebracketingindicatorlast' => { 161 => 0x52 },
	'exposurebracketshotnumber' => { 164 => 0x2d, 360 => 0x2f },
	'exposurebracketstepsize' => { 288 => 0x8 },
	'exposurebracketvalue' => { 194 => 0x19 },
	'exposurecompensation' => { 67 => 0x6, 82 => 0x0, 106 => 0x9204, 122 => 0x24, 136 => 'ExposureComp', 154 => 'ExposureCompensation', 158 => 0xd, 159 => 0x53, 160 => 0x1e, 164 => 0x49c0, 258 => 0x1006, 307 => 0x16, 316 => 0x402, 338 => 0xa013, 341 => [0xc,0x35,0x4d], 368 => 0x114c, 369 => 0x114c, 370 => 0x1128, 372 => 0x1180, 373 => 0x1038, 374 => 0x230, 375 => 0x230, 409 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 365 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 161 => 0x47, 164 => 0x2a },
	'exposurecompensationset' => { 349 => 0x3, 350 => 0x3, 351 => 0x3, 365 => 0x1e },
	'exposurecompensationsetting' => { 161 => 0x1 },
	'exposurecompstepsize' => { 239 => '6.3', 240 => '7.3', 242 => '7.3', 246 => '4.3', 250 => '7.3' },
	'exposurecontrolstep' => { 247 => '6.1' },
	'exposurecontrolstepsize' => { 239 => '6.2', 240 => '7.1', 242 => '7.1', 246 => '4.2', 250 => '7.1', 251 => '7.1' },
	'exposurecount' => { 111 => 0x1032 },
	'exposuredelaymode' => { 239 => '10.1', 240 => '11.1', 242 => '11.1', 243 => '9.1', 244 => '10.1', 245 => '10.1', 246 => '10.4', 247 => '10.1', 248 => '6.4', 250 => '11.1', 251 => '11.2' },
	'exposuredifference' => { 194 => 0xe },
	'exposureindex' => { 106 => 0xa215, 409 => 'ExposureIndex' },
	'exposureindicator' => { 161 => 0x50 },
	'exposurelevelincrements' => { 71 => 0x6, 72 => 0x6, 73 => 0x101, 74 => 0x5, 75 => 0x6, 76 => 0x5, 77 => 0x5, 78 => 0x6, 79 => 0x4, 349 => 0x58, 350 => 0x58 },
	'exposurelockused' => { 394 => 'ExposureLockUsed' },
	'exposuremode' => { 106 => 0xa402, 136 => 'ExposureMode', 158 => 0x1, 159 => 0xa, 160 => 0x0, 161 => 0x0, 164 => 0x34, 253 => 0x200, 272 => 0x40d, 341 => 0x8, 361 => 0xb041, 409 => 'ExposureMode' },
	'exposuremodeinmanual' => { 73 => 0x10b },
	'exposureprogram' => { 106 => 0x8822, 332 => 0x1001, 342 => [0x17e,0x43], 349 => 0x3c, 350 => 0x3c, 351 => 0x5, 355 => 0x14, 360 => 0x3f, 365 => 0x2, 368 => 0x1175, 369 => 0x1179, 370 => 0x1155, 371 => 0x11d1, 372 => 0x11ad, 373 => 0x1065, 374 => 0x25d, 375 => 0x25d, 386 => 0x48, 409 => 'ExposureProgram' },
	'exposureshift' => { 253 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 67 => 0x16, 106 => 0x829a, 119 => 0xfd05, 122 => 0x20, 124 => 0xfa24, 126 => 0xf104, 129 => 0x12, 131 => 0x38, 134 => 0x10, 136 => 'ExposureTime', 158 => 0x9, 159 => 0x35, 160 => 0x48, 161 => 0x8, 164 => 0x49b8, 307 => 0x12, 338 => 0xa018, 341 => [0x32,0x4a], 349 => 0x0, 350 => 0x0, 365 => [0x21,0x23,0x27], 386 => 0x10, 409 => 'ExposureTime' },
	'exposuretime2' => { 341 => [0x33,0x4b] },
	'exposuretuning' => { 194 => 0x1c },
	'exposurevalue' => { 120 => 0x3 },
	'exposurewarning' => { 111 => 0x1302 },
	'exrauto' => { 111 => 0x1033 },
	'exrmode' => { 111 => 0x1034 },
	'extendedwbdetect' => { 253 => 0x902 },
	'extender' => { 254 => 0x301 },
	'extenderfirmwareversion' => { 254 => 0x304 },
	'extendermagnification' => { 138 => 'Magnification' },
	'extendermake' => { 138 => 'Make' },
	'extendermodel' => { 138 => 'Model', 254 => 0x303 },
	'extenderserialnumber' => { 138 => 'SerialNumber', 254 => 0x302 },
	'extenderstatus' => { 305 => 0x3 },
	'externalflash' => { 256 => 0x1201 },
	'externalflashae1' => { 258 => 0x101f },
	'externalflashae1_0' => { 258 => 0x101b },
	'externalflashae2' => { 258 => 0x1020 },
	'externalflashae2_0' => { 258 => 0x101c },
	'externalflashbounce' => { 256 => 0x1204, 258 => 0x1026, 295 => 0x1a },
	'externalflashcompensation' => { 185 => 0x1b },
	'externalflashexposurecomp' => { 194 => 0x17, 295 => 0x19 },
	'externalflashfirmware' => { 183 => 0x6, 184 => 0x6, 185 => 0x6 },
	'externalflashflags' => { 183 => 0x8, 184 => 0x8, 185 => 0x8 },
	'externalflashguidenumber' => { 256 => 0x1203, 295 => '24.1' },
	'externalflashgvalue' => { 258 => 0x1025 },
	'externalflashmode' => { 258 => 0x1028, 295 => 0x2 },
	'externalflashzoom' => { 256 => 0x1205, 258 => 0x1027 },
	'externalsensorbrightnessvalue' => { 270 => 0x311, 276 => 0x3408 },
	'extrainfoversion' => { 353 => 0x1a },
	'eyestartaf' => { 161 => 0x40 },
	'face10position' => { 99 => 0x3f4, 100 => 0x1ec, 181 => 0x28, 292 => 0x12 },
	'face10size' => { 293 => 0x12 },
	'face11position' => { 181 => 0x2c, 292 => 0x14 },
	'face11size' => { 293 => 0x14 },
	'face12position' => { 181 => 0x30, 292 => 0x16 },
	'face12size' => { 293 => 0x16 },
	'face13position' => { 292 => 0x18 },
	'face13size' => { 293 => 0x18 },
	'face14position' => { 292 => 0x1a },
	'face14size' => { 293 => 0x1a },
	'face15position' => { 292 => 0x1c },
	'face15size' => { 293 => 0x1c },
	'face16position' => { 292 => 0x1e },
	'face16size' => { 293 => 0x1e },
	'face17position' => { 292 => 0x20 },
	'face17size' => { 293 => 0x20 },
	'face18position' => { 292 => 0x22 },
	'face18size' => { 293 => 0x22 },
	'face19position' => { 292 => 0x24 },
	'face19size' => { 293 => 0x24 },
	'face1position' => { 46 => 0x8, 99 => 0xd, 100 => 0x18, 181 => 0x4, 268 => 0x1, 292 => 0x0, 329 => 0xbc, 356 => 0x1, 357 => 0x0, 358 => 0x0, 359 => 0x5b },
	'face1size' => { 293 => 0x0 },
	'face20position' => { 292 => 0x26 },
	'face20size' => { 293 => 0x26 },
	'face21position' => { 292 => 0x28 },
	'face21size' => { 293 => 0x28 },
	'face22position' => { 292 => 0x2a },
	'face22size' => { 293 => 0x2a },
	'face23position' => { 292 => 0x2c },
	'face23size' => { 293 => 0x2c },
	'face24position' => { 292 => 0x2e },
	'face24size' => { 293 => 0x2e },
	'face25position' => { 292 => 0x30 },
	'face25size' => { 293 => 0x30 },
	'face26position' => { 292 => 0x32 },
	'face26size' => { 293 => 0x32 },
	'face27position' => { 292 => 0x34 },
	'face27size' => { 293 => 0x34 },
	'face28position' => { 292 => 0x36 },
	'face28size' => { 293 => 0x36 },
	'face29position' => { 292 => 0x38 },
	'face29size' => { 293 => 0x38 },
	'face2position' => { 46 => 0xa, 99 => 0x7c, 100 => 0x4c, 181 => 0x8, 268 => 0x5, 292 => 0x2, 329 => 0xc8, 356 => 0x6, 357 => 0x20, 358 => 0x25, 359 => 0x65 },
	'face2size' => { 293 => 0x2 },
	'face30position' => { 292 => 0x3a },
	'face30size' => { 293 => 0x3a },
	'face31position' => { 292 => 0x3c },
	'face31size' => { 293 => 0x3c },
	'face32position' => { 292 => 0x3e },
	'face32size' => { 293 => 0x3e },
	'face3position' => { 46 => 0xc, 99 => 0xeb, 100 => 0x80, 181 => 0xc, 268 => 0x9, 292 => 0x4, 329 => 0xd4, 356 => 0xb, 357 => 0x40, 358 => 0x4a, 359 => 0x6f },
	'face3size' => { 293 => 0x4 },
	'face4position' => { 46 => 0xe, 99 => 0x15a, 100 => 0xb4, 181 => 0x10, 268 => 0xd, 292 => 0x6, 329 => 0xe0, 356 => 0x10, 357 => 0x60, 358 => 0x6f, 359 => 0x79 },
	'face4size' => { 293 => 0x6 },
	'face5position' => { 46 => 0x10, 99 => 0x1c9, 100 => 0xe8, 181 => 0x14, 268 => 0x11, 292 => 0x8, 329 => 0xec, 356 => 0x15, 357 => 0x80, 358 => 0x94 },
	'face5size' => { 293 => 0x8 },
	'face6position' => { 46 => 0x12, 99 => 0x238, 100 => 0x11c, 181 => 0x18, 292 => 0xa, 329 => 0xf8, 356 => 0x1a, 357 => 0xa0, 358 => 0xb9 },
	'face6size' => { 293 => 0xa },
	'face7position' => { 46 => 0x14, 99 => 0x2a7, 100 => 0x150, 181 => 0x1c, 292 => 0xc, 329 => 0x104, 356 => 0x1f, 357 => 0xc0, 358 => 0xde },
	'face7size' => { 293 => 0xc },
	'face8position' => { 46 => 0x16, 99 => 0x316, 100 => 0x184, 181 => 0x20, 292 => 0xe, 329 => 0x110, 356 => 0x24, 357 => 0xe0, 358 => 0x103 },
	'face8size' => { 293 => 0xe },
	'face9position' => { 46 => 0x18, 99 => 0x385, 100 => 0x1b8, 181 => 0x24, 292 => 0x10 },
	'face9size' => { 293 => 0x10 },
	'facedetect' => { 307 => 0x76, 338 => 0x100 },
	'facedetectarea' => { 257 => 0x1201 },
	'facedetectframecrop' => { 257 => 0x1207 },
	'facedetectframesize' => { 46 => 0x3, 99 => 0x1, 100 => 0x4, 181 => 0x1, 257 => 0x1203, 307 => 0x77, 329 => 0xb6 },
	'facedetection' => { 351 => 0x30, 365 => 0x19 },
	'faceid' => { 400 => 'FaceID' },
	'faceinfounknown' => { 102 => 0x2089 },
	'facename' => { 338 => 0x123 },
	'faceorientation' => { 100 => 0x8 },
	'faceposition' => { 291 => 0x2, 339 => 0x4 },
	'facepositions' => { 111 => 0x4103 },
	'facerecognition' => { 338 => 0x120 },
	'facesdetected' => { 46 => 0x2, 47 => 0x2, 48 => 0x3, 99 => 0x0, 100 => 0x2, 102 => 0x211c, 111 => 0x4100, 181 => 0x3, 257 => 0x1200, 274 => 0x3f, 291 => 0x0, 329 => 0xb5, 339 => 0x0, 356 => 0x0, 359 => 0x3, 367 => 0x30 },
	'facesrecognized' => { 269 => 0x0 },
	'facewidth' => { 47 => 0x1 },
	'faithfuloutputhighlightpoint' => { 98 => 0x38 },
	'faithfuloutputshadowpoint' => { 98 => 0x39 },
	'faithfulrawcolortone' => { 98 => 0x31 },
	'faithfulrawcontrast' => { 98 => 0x33 },
	'faithfulrawhighlight' => { 98 => 0x79 },
	'faithfulrawhighlightpoint' => { 98 => 0x36 },
	'faithfulrawlinear' => { 98 => 0x34 },
	'faithfulrawsaturation' => { 98 => 0x32 },
	'faithfulrawshadow' => { 98 => 0x82 },
	'faithfulrawshadowpoint' => { 98 => 0x37 },
	'faithfulrawsharpness' => { 98 => 0x35 },
	'faithfulunsharpmaskfineness' => { 98 => 0xac },
	'faithfulunsharpmaskstrength' => { 98 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 98 => 0xae },
	'femicroadjustment' => { 73 => 0x111 },
	'ffid' => { 407 => 'ffid' },
	'field' => { 418 => 'field' },
	'fieldcount' => { 258 => 0x103f },
	'filecreatedate' => { 107 => 'FileCreateDate' },
	'filedatarate' => { 429 => 'fileDataRate' },
	'fileformat' => { 84 => 0x0, 115 => 0x14, 341 => [0x22,0x26], 361 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 275 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 107 => 'FileModifyDate' },
	'filename' => { 107 => 'FileName' },
	'filenameasdelivered' => { 263 => 'FileNameAsDelivered' },
	'filenumber' => { 49 => 0x1, 55 => 0x8, 86 => 0x1817, 103 => 'FileNumber', 182 => 0x4 },
	'filenumbermemory' => { 158 => 0x1a },
	'filenumbersequence' => { 239 => '12.2', 243 => '3.1', 244 => '4.1', 245 => '4.1', 246 => '11.1', 247 => '4.3', 251 => '5.2' },
	'filepermissions' => { 107 => 'FilePermissions' },
	'filesource' => { 106 => 0xa300, 111 => 0x8000, 409 => 'FileSource' },
	'fileversion' => { 115 => 0x16 },
	'fillflashautoreduction' => { 71 => 0xe, 72 => 0xe, 79 => 0xa },
	'filllight' => { 405 => 'FillLight' },
	'fillorder' => { 106 => 0x10a },
	'filmmode' => { 111 => 0x1401, 272 => 0x412, 274 => 0x42 },
	'filmtype' => { 201 => 0x2 },
	'filtereffect' => { 49 => 0xe, 196 => 0x37, 197 => 0x3f },
	'filtereffectauto' => { 62 => 0xa0 },
	'filtereffectfaithful' => { 61 => 0x70, 62 => 0x70 },
	'filtereffectlandscape' => { 61 => 0x40, 62 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 61 => 0x88, 62 => 0x88 },
	'filtereffectneutral' => { 61 => 0x58, 62 => 0x58 },
	'filtereffectportrait' => { 61 => 0x28, 62 => 0x28 },
	'filtereffectstandard' => { 61 => 0x10, 62 => 0x10 },
	'filtereffectuserdef1' => { 61 => 0xa0, 62 => 0xb8 },
	'filtereffectuserdef2' => { 61 => 0xb8, 62 => 0xd0 },
	'filtereffectuserdef3' => { 61 => 0xd0, 62 => 0xe8 },
	'finderdisplayduringexposure' => { 72 => 0x1 },
	'finesharpness' => { 307 => 0x70 },
	'finetuneoptcenterweighted' => { 239 => '7.2', 240 => '9.1', 242 => '9.1', 250 => '9.1', 251 => '9.1' },
	'finetuneopthighlightweighted' => { 242 => '46.1', 250 => '46.1' },
	'finetuneoptmatrixmetering' => { 239 => '8.1', 240 => '8.2', 242 => '8.2', 246 => '6.1', 250 => '8.2', 251 => '8.2' },
	'finetuneoptspotmetering' => { 239 => '8.2', 240 => '9.2', 242 => '9.2', 246 => '6.2', 250 => '9.2', 251 => '9.2' },
	'firmware' => { 258 => 0x405, 341 => [0x17,0x3b,0x57], 401 => 'Firmware' },
	'firmwaredate' => { 101 => 0x15, 102 => 0x2001, 328 => 0x4 },
	'firmwareid' => { 165 => 0x0 },
	'firmwarename' => { 338 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 55 => 0x1e, 330 => 0x0 },
	'firmwarerevision2' => { 330 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 120 => 0xce5, 134 => 0x57, 136 => 'FirmwareVersion', 274 => 0x2, 276 => 0x3109, 307 => 0x230, 332 => 0x2 },
	'firmwareversions' => { 316 => 0x301 },
	'firstphotodate' => { 394 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 263 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 114 => 0x16, 399 => 'FixtureIdentifier' },
	'flash' => { 103 => 'Flash', 106 => 0x9209, 159 => 0x1f, 160 => 0x15, 409 => 'Flash' },
	'flashaction' => { 349 => 0x3e, 350 => 0x3e, 361 => 0x2017, 365 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 349 => 0x4c, 350 => 0x4c, 365 => 0x77 },
	'flashactionexternal' => { 365 => [0x78,0x7c] },
	'flashactivity' => { 31 => 0x1c },
	'flashbatterylevel' => { 37 => 0x249 },
	'flashbias' => { 274 => 0x24 },
	'flashbits' => { 31 => 0x1d },
	'flashbuttonfunction' => { 73 => 0x70e },
	'flashchargelevel' => { 258 => 0x1010 },
	'flashcolorfilter' => { 185 => 0x10 },
	'flashcommandermode' => { 183 => '9.1', 184 => '9.1', 185 => '9.1' },
	'flashcompensation' => { 183 => 0xa, 184 => 0xa, 185 => 0xa, 401 => 'FlashCompensation' },
	'flashcontrol' => { 349 => 0x23, 350 => 0x1f, 351 => 0x21 },
	'flashcontrolbuilt-in' => { 246 => '16.1', 247 => '23.1', 249 => '23.1', 250 => '24.1' },
	'flashcontrolmode' => { 183 => '9.2', 184 => '9.2', 185 => '9.2', 253 => 0x404 },
	'flashcurtain' => { 274 => 0x48 },
	'flashdefault' => { 161 => 0x42 },
	'flashdevice' => { 258 => 0x1005 },
	'flashdistance' => { 102 => 0x2034 },
	'flashenergy' => { 106 => 0xa20b, 409 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 194 => 0x18 },
	'flashexposurecomp' => { 67 => 0xf, 111 => 0x1011, 139 => 'ExposureComp', 158 => 0x23, 163 => 0x104, 164 => 0x49c1, 194 => 0x12, 253 => 0x401, 258 => 0x1023, 307 => 0x4d, 332 => 0x100b, 341 => [0x3a,0x56], 361 => 0x104 },
	'flashexposurecomp2' => { 219 => 0x4d2 },
	'flashexposurecomp3' => { 185 => 0x1d },
	'flashexposurecomp4' => { 185 => 0x27 },
	'flashexposurecomparea' => { 240 => '38.4', 242 => '38.4', 250 => '38.4' },
	'flashexposurecompset' => { 161 => 0x10, 281 => 0xe, 349 => 0x14, 350 => 0x12, 351 => 0x23, 365 => 0x1f },
	'flashexposurecompset2' => { 365 => [0x26,0x2c] },
	'flashexposureindicator' => { 161 => 0x54 },
	'flashexposureindicatorlast' => { 161 => 0x56 },
	'flashexposureindicatornext' => { 161 => 0x55 },
	'flashexposurelock' => { 49 => 0x19 },
	'flashfired' => { 122 => 0x5d, 139 => 'Fired', 158 => 0x14, 218 => '590.3', 274 => 0x8007, 409 => [\'Flash','FlashFired'] },
	'flashfiring' => { 73 => 0x306, 74 => 0x6, 75 => 0x7, 78 => 0x7 },
	'flashfirmwareversion' => { 254 => 0x1002 },
	'flashfocallength' => { 183 => 0xb, 184 => 0xc, 185 => 0xc },
	'flashfunction' => { 164 => 0x31, 409 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 183 => 0xe, 184 => 0xf, 185 => 0xf },
	'flashgroupacompensation' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupacontrolmode' => { 183 => 0xf, 184 => '16.1', 185 => '17.1' },
	'flashgroupaoutput' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupbcompensation' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupbcontrolmode' => { 183 => 0x10, 184 => '17.1', 185 => '18.1' },
	'flashgroupboutput' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupccompensation' => { 184 => 0x14, 185 => 0x15 },
	'flashgroupccontrolmode' => { 184 => '17.2', 185 => '18.2' },
	'flashgroupcoutput' => { 184 => 0x14, 185 => 0x15 },
	'flashguidenumber' => { 67 => 0xd, 83 => 0x0, 139 => 'GuideNumber' },
	'flashintensity' => { 101 => [0x19,0x5], 253 => 0x405 },
	'flashlevel' => { 241 => 0x9, 361 => 0xb048 },
	'flashmake' => { 139 => 'Make' },
	'flashmanufacturer' => { 156 => 'FlashManufacturer' },
	'flashmetering' => { 158 => 0x3f, 161 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 307 => 0x20a },
	'flashmode' => { 101 => 0x4, 122 => 0x5c, 139 => 'Mode', 158 => 0x2, 159 => 0x20, 160 => 0x16, 161 => 0xf, 194 => 0x87, 253 => 0x400, 258 => 0x1004, 307 => 0xc, 314 => 0x4, 331 => 0x20, 332 => 0x100a, 340 => 0x225, 349 => 0x13, 350 => 0x7f, 351 => 0x20, 365 => 0x10, 368 => 0x1138, 369 => 0x1138, 370 => 0x1114, 371 => 0x1190, 372 => 0x116c, 373 => 0x1024, 374 => 0x21c, 375 => 0x21c, 409 => [\'Flash','FlashMode'] },
	'flashmodel' => { 139 => 'Model', 156 => 'FlashModel', 254 => 0x1001 },
	'flashoptions' => { 288 => 0x2 },
	'flashoptions2' => { 288 => 0x10 },
	'flashoutput' => { 37 => 0x248, 67 => 0x21, 183 => 0xa, 184 => 0xa, 185 => 0xa },
	'flashpixversion' => { 106 => 0xa000, 409 => 'FlashpixVersion' },
	'flashredeyemode' => { 409 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 253 => 0x403 },
	'flashreturn' => { 409 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 139 => 'SerialNumber', 254 => 0x1003 },
	'flashsetting' => { 194 => 0x8 },
	'flashshutterspeed' => { 239 => '20.2', 240 => '23.2', 242 => '23.2', 246 => '15.2', 247 => '22.2', 248 => '7.2', 249 => '22.2', 250 => '23.2', 251 => '23.1' },
	'flashsource' => { 183 => 0x4, 184 => 0x4, 185 => 0x4 },
	'flashstatus' => { 295 => 0x0, 365 => [0x82,0x86], 377 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 351 => [0x87,0x287] },
	'flashstatusexternal' => { 351 => [0x88,0x288] },
	'flashsyncspeed' => { 239 => '20.1', 240 => '23.1', 242 => '23.1', 246 => '15.1', 247 => '22.1', 249 => '22.1', 250 => '23.1' },
	'flashsyncspeedav' => { 71 => 0x3, 73 => 0x10f, 74 => 0x2, 75 => 0x3, 76 => 0x2, 77 => 0x2, 78 => 0x3, 79 => 0x6 },
	'flashthreshold' => { 83 => 0x1 },
	'flashtype' => { 139 => 'Type', 161 => 0x59, 194 => 0x9, 254 => 0x1000 },
	'flashwarning' => { 247 => '30.1', 248 => '7.1', 251 => '31.1', 274 => 0x62 },
	'flexiblespotposition' => { 361 => 0x201d },
	'flickerreduce' => { 340 => 0x218 },
	'flickerreduction' => { 212 => 0xe84 },
	'flickerreductionindicator' => { 212 => 0x5e2 },
	'fliphorizontal' => { 232 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 67 => 0x15, 106 => 0x829d, 119 => 0xfd04, 122 => 0x1e, 124 => 0xfa23, 126 => 0xf103, 129 => 0x13, 131 => 0x3c, 134 => 0xc, 143 => 'FNumber', 158 => 0xa, 159 => 0x36, 160 => 0x47, 161 => 0x9, 164 => 0x49c7, 307 => 0x13, 338 => 0xa019, 341 => [0x31,0x49], 349 => 0x1, 350 => 0x1, 365 => [0x20,0x22,0x26], 409 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 51 => 0x1, 102 => 0x1d, 106 => 0x920a, 129 => 0x1d, 143 => 'FocalLength', 158 => 0x12, 190 => 0xa, 191 => 0xb, 307 => 0x1d, 316 => 0x403, 332 => 0x1500, 348 => 0xe, 372 => 0x1278, 373 => 0x1134, 374 => 0x32c, 375 => 0x32c, 409 => 'FocalLength' },
	'focallength2' => { 365 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 106 => 0xa405, 338 => 0xa01a, 409 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 348 => 0x10 },
	'focalplaneafpointarea' => { 376 => 0x2 },
	'focalplaneafpointlocation1' => { 376 => 0x6 },
	'focalplaneafpointlocation10' => { 376 => 0x2a },
	'focalplaneafpointlocation11' => { 376 => 0x2e },
	'focalplaneafpointlocation12' => { 376 => 0x32 },
	'focalplaneafpointlocation13' => { 376 => 0x36 },
	'focalplaneafpointlocation14' => { 376 => 0x3a },
	'focalplaneafpointlocation15' => { 376 => 0x3e },
	'focalplaneafpointlocation2' => { 376 => 0xa },
	'focalplaneafpointlocation3' => { 376 => 0xe },
	'focalplaneafpointlocation4' => { 376 => 0x12 },
	'focalplaneafpointlocation5' => { 376 => 0x16 },
	'focalplaneafpointlocation6' => { 376 => 0x1a },
	'focalplaneafpointlocation7' => { 376 => 0x1e },
	'focalplaneafpointlocation8' => { 376 => 0x22 },
	'focalplaneafpointlocation9' => { 376 => 0x26 },
	'focalplaneafpointsused' => { 376 => 0x1 },
	'focalplanediagonal' => { 254 => 0x103, 258 => 0x205 },
	'focalplaneresolutionunit' => { 106 => 0xa210, 409 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 106 => 0xa20e, 409 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 51 => 0x2 },
	'focalplanexunknown' => { 51 => 0x2 },
	'focalplaneyresolution' => { 106 => 0xa20f, 409 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 51 => 0x3 },
	'focalplaneyunknown' => { 51 => 0x3 },
	'focaltype' => { 9 => 0x2d, 51 => 0x0 },
	'focalunits' => { 31 => 0x19 },
	'focus' => { 222 => 0x8 },
	'focusarea' => { 158 => 0x31 },
	'focusareaselection' => { 248 => '15.2' },
	'focuscontinuous' => { 31 => 0x20 },
	'focusdisplayaiservoandmf' => { 73 => 0x515 },
	'focusdistance' => { 143 => 'FocusDistance', 158 => 0x13, 164 => 0x49bb, 190 => 0x9, 191 => 0xa, 256 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 49 => 0x15, 67 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 49 => 0x14, 67 => 0x13 },
	'focusholdbutton' => { 161 => 0x44 },
	'focusinfoversion' => { 256 => 0x0 },
	'focusingscreen' => { 72 => 0x0, 73 => 0x80b, 78 => 0x0 },
	'focuslocation' => { 361 => 0x2027 },
	'focuslocked' => { 157 => 0x14 },
	'focusmode' => { 31 => 0x7, 101 => 0x3, 102 => [0x3003,0xd], 111 => 0x1021, 122 => 0x38, 136 => 'FocusMode', 158 => 0x30, 160 => 0xe, 161 => 0xc, 194 => 0x7, 253 => 0x301, 258 => 0x100b, 274 => 0x7, 307 => 0xd, 314 => 0x3, 332 => 0x1006, 342 => [0xb,0x5], 348 => [0x15,0x1d], 349 => 0x4d, 350 => 0x4d, 361 => [0xb042,0xb04e,0x201b], 365 => 0x13, 381 => 0x16 },
	'focusmode2' => { 288 => '3.1', 365 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 241 => '10.1', 346 => 0x14, 347 => 0x15, 349 => 0x10, 350 => 0xf, 351 => 0x6 },
	'focusmodeswitch' => { 161 => 0x58, 349 => 0x2e },
	'focuspixel' => { 111 => 0x1023 },
	'focuspointwrap' => { 239 => '2.2', 240 => '2.2', 242 => '2.1', 246 => '2.2', 247 => '1.2', 250 => '2.2', 251 => '2.5' },
	'focusposition' => { 190 => 0x8, 191 => 0x8, 307 => 0x10, 360 => 0x9bb },
	'focusposition2' => { 365 => [0x29,0x2b,0x2f], 381 => 0x2d, 384 => 0x20 },
	'focusprocess' => { 253 => 0x302 },
	'focusrange' => { 31 => 0x12, 258 => 0x100a },
	'focusrangeindex' => { 298 => '3.1' },
	'focussetting' => { 341 => 0x6 },
	'focusstatus' => { 348 => 0x19, 349 => 0x53, 350 => 0x53 },
	'focusstepcount' => { 256 => 0x301, 258 => 0x100e },
	'focusstepinfinity' => { 256 => 0x303, 258 => 0x103b },
	'focusstepnear' => { 256 => 0x304, 258 => 0x103c },
	'focustrackinglockon' => { 239 => ['1.5','4.1'], 240 => '1.4', 246 => '3.1', 247 => '0.4', 250 => '1.4' },
	'focuswarning' => { 111 => 0x1301 },
	'foldername' => { 158 => 0x27 },
	'foldernumber' => { 349 => 0x9a, 351 => [0x402,0x114,0x316] },
	'fontcomposite' => { 434 => [\'Fonts','FontsComposite'] },
	'fontface' => { 434 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 434 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 434 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 434 => [\'Fonts','FontsFontName'] },
	'fonts' => { 434 => 'Fonts' },
	'fonttype' => { 434 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 434 => [\'Fonts','FontsVersionString'] },
	'for' => { 323 => 'For' },
	'format' => { 406 => 'format', 427 => 'Format' },
	'forwardlock' => { 424 => 'forwardlock' },
	'forwardmatrix1' => { 106 => 0xc714 },
	'forwardmatrix2' => { 106 => 0xc715 },
	'framecount' => { 58 => [0x2,0x4] },
	'frameheight' => { 111 => 0x3822 },
	'framenum' => { 318 => 0xd7 },
	'framenumber' => { 111 => 0x8003, 164 => 0x3c, 307 => 0x29 },
	'framerate' => { 58 => [0x1,0x6], 106 => 0xc764, 111 => 0x3820 },
	'framewidth' => { 111 => 0x3821 },
	'framing' => { 418 => 'framing' },
	'freebytes' => { 86 => 0x1 },
	'freememorycardimages' => { 159 => [0x37,0x54], 160 => [0x2d,0x4a], 161 => 0x32 },
	'fujiflashmode' => { 111 => 0x1010 },
	'fullimagesize' => { 361 => 0xb02b },
	'fullpanoheightpixels' => { 394 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 394 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 332 => 0x100d },
	'fullsizeimage' => { 142 => 'data' },
	'fullsizeimagename' => { 142 => '1Name' },
	'fullsizeimagetype' => { 142 => '0Type' },
	'func1button' => { 242 => '14.1' },
	'func1buttonplusdials' => { 242 => '42.1' },
	'func2button' => { 242 => '80.1' },
	'funcbutton' => { 239 => ['14.1','15.1'], 240 => '14.1', 246 => '28.1', 247 => '13.1', 250 => '14.1', 251 => '14.1' },
	'funcbuttonplusdials' => { 239 => ['14.2','15.2'], 240 => '14.2', 246 => '31.1', 250 => '42.1' },
	'functionbutton' => { 245 => '13.1', 248 => '5.2' },
	'gainbase' => { 257 => 0x610 },
	'gaincontrol' => { 106 => 0xa407, 409 => 'GainControl' },
	'gamma' => { 106 => 0xa500, 410 => 'Gamma' },
	'gammablackpoint' => { 94 => 0xc },
	'gammacolortone' => { 94 => 0x3 },
	'gammacompensatedvalue' => { 116 => 0x91 },
	'gammacontrast' => { 94 => 0x2 },
	'gammacurveoutputrange' => { 94 => 0xf },
	'gammahighlight' => { 94 => 0xa },
	'gammalinear' => { 92 => 0x20200 },
	'gammamidpoint' => { 94 => 0xe },
	'gammasaturation' => { 94 => 0x4 },
	'gammashadow' => { 94 => 0x9 },
	'gammasharpnessstrength' => { 94 => 0x8 },
	'gammaunsharpmaskfineness' => { 94 => 0x6 },
	'gammaunsharpmaskstrength' => { 94 => 0x5 },
	'gammaunsharpmaskthreshold' => { 94 => 0x7 },
	'gammawhitepoint' => { 94 => 0xd },
	'geimagesize' => { 111 => 0x1304 },
	'gemake' => { 112 => 0x300 },
	'gemodel' => { 112 => 0x207 },
	'genre' => { 419 => 'genre', 429 => 'genre' },
	'geography' => { 420 => 'geography' },
	'geologicalcontext' => { 105 => 'GeologicalContext' },
	'geologicalcontextbed' => { 105 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 105 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 105 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 105 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 105 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 107 => 'Geosync' },
	'geotag' => { 107 => 'Geotag' },
	'geotiffasciiparams' => { 106 => 0x87b1 },
	'geotiffdirectory' => { 106 => 0x87af },
	'geotiffdoubleparams' => { 106 => 0x87b0 },
	'geotime' => { 107 => 'Geotime' },
	'globalaltitude' => { 321 => 0x419 },
	'globalangle' => { 321 => 0x40d },
	'good' => { 429 => 'good' },
	'googleplusuploadcode' => { 106 => 0x9009 },
	'gpsaltitude' => { 113 => 0x6, 140 => 'Altitude', 409 => 'GPSAltitude' },
	'gpsaltituderef' => { 113 => 0x5, 409 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 113 => 0x1c, 409 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 113 => 0x1d },
	'gpsdatetime' => { 140 => 'DateTime', 409 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 113 => 0x18, 140 => 'Bearing', 409 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 113 => 0x17, 409 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 113 => 0x1a, 140 => 'Distance', 409 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 113 => 0x19, 409 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 113 => 0x14, 409 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 113 => 0x13 },
	'gpsdestlongitude' => { 113 => 0x16, 409 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 113 => 0x15 },
	'gpsdifferential' => { 113 => 0x1e, 140 => 'Differential', 409 => 'GPSDifferential' },
	'gpsdop' => { 113 => 0xb, 409 => 'GPSDOP' },
	'gpshpositioningerror' => { 113 => 0x1f, 409 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 113 => 0x11, 409 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 113 => 0x10, 409 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 113 => 0x2, 140 => 'Latitude', 409 => 'GPSLatitude' },
	'gpslatituderef' => { 113 => 0x1 },
	'gpslongitude' => { 113 => 0x4, 140 => 'Longitude', 409 => 'GPSLongitude' },
	'gpslongituderef' => { 113 => 0x3 },
	'gpsmapdatum' => { 113 => 0x12, 140 => 'Datum', 409 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 113 => 0xa, 140 => 'MeasureMode', 409 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 113 => 0x1b, 409 => 'GPSProcessingMethod' },
	'gpssatellites' => { 113 => 0x8, 140 => 'Satellites', 409 => 'GPSSatellites' },
	'gpsspeed' => { 113 => 0xd, 140 => 'Speed', 409 => 'GPSSpeed' },
	'gpsspeedref' => { 113 => 0xc, 409 => 'GPSSpeedRef' },
	'gpsstatus' => { 113 => 0x9, 409 => 'GPSStatus' },
	'gpstimestamp' => { 113 => 0x7 },
	'gpstrack' => { 113 => 0xf, 140 => 'Heading', 409 => 'GPSTrack' },
	'gpstrackref' => { 113 => 0xe, 409 => 'GPSTrackRef' },
	'gpsversionid' => { 113 => 0x0, 409 => 'GPSVersionID' },
	'gradation' => { 253 => 0x50f },
	'gradientbasedcorractive' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 405 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 405 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 405 => 'GrainAmount' },
	'grainfrequency' => { 405 => 'GrainFrequency' },
	'grainsize' => { 405 => 'GrainSize' },
	'graymixeraqua' => { 405 => 'GrayMixerAqua' },
	'graymixerblue' => { 405 => 'GrayMixerBlue' },
	'graymixergreen' => { 405 => 'GrayMixerGreen' },
	'graymixermagenta' => { 405 => 'GrayMixerMagenta' },
	'graymixerorange' => { 405 => 'GrayMixerOrange' },
	'graymixerpurple' => { 405 => 'GrayMixerPurple' },
	'graymixerred' => { 405 => 'GrayMixerRed' },
	'graymixeryellow' => { 405 => 'GrayMixerYellow' },
	'graypoint' => { 390 => 0x8021 },
	'grayresponseunit' => { 106 => 0x122 },
	'greencurvelimits' => { 97 => 0x1c4 },
	'greencurvepoints' => { 96 => 0x53, 97 => 0x19a },
	'greenhsl' => { 92 => 0x20912 },
	'greenhue' => { 405 => 'GreenHue' },
	'greensaturation' => { 405 => 'GreenSaturation' },
	'griddisplay' => { 239 => '13.3', 240 => '4.3', 242 => '4.2', 243 => '2.2', 246 => '10.5', 247 => '3.4', 248 => '6.1', 250 => '4.4', 251 => '4.2' },
	'gripbatteryadload' => { 286 => 0x5 },
	'gripbatteryadnoload' => { 286 => 0x4 },
	'gripbatterystate' => { 286 => '1.2' },
	'groupareaafillumination' => { 240 => '46.4', 242 => '47.4', 250 => '47.4' },
	'halftonehints' => { 106 => 0x141 },
	'hardlink' => { 107 => 'HardLink' },
	'hasalternative' => { 419 => 'hasAlternative' },
	'hascorrection' => { 419 => 'hasCorrection' },
	'hascorrectiona-lang' => { 419 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 419 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 419 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 405 => 'HasCrop' },
	'hasextendedxmp' => { 431 => 'HasExtendedXMP' },
	'hassettings' => { 405 => 'HasSettings' },
	'hastranslation' => { 419 => 'hasTranslation' },
	'hasvisibleoverprint' => { 434 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 434 => 'HasVisibleTransparency' },
	'hdr' => { 52 => 0x1, 187 => 0x4, 274 => 0x9e, 307 => 0x85, 361 => 0x200a },
	'hdreffect' => { 52 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 187 => 0x0 },
	'hdrlevel' => { 187 => 0x5, 351 => 0x2e, 365 => 0x17 },
	'hdrlevel2' => { 187 => 0x7 },
	'hdrsetting' => { 351 => 0x2d, 365 => 0x16, 368 => 0x1148, 369 => 0x1148, 370 => 0x1124, 371 => 0x11a0, 372 => 0x117c, 373 => 0x1034, 374 => 0x22c, 375 => 0x22c },
	'hdrsmoothing' => { 187 => 0x6 },
	'headline' => { 114 => 0x69, 417 => 'Headline' },
	'hierarchicalkeywords' => { 151 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 151 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 151 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 151 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 151 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 396 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 278 => 0x1a },
	'highisomultipliergreen' => { 278 => 0x19 },
	'highisomultiplierred' => { 278 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 54 => 0x5, 73 => 0x202, 111 => 0x100e, 194 => 0xb1, 307 => 0x71, 349 => 0x2c, 350 => 0x26, 351 => 0x26, 361 => 0x2009, 365 => 0x12, 386 => 0x42 },
	'highisonoisereduction2' => { 361 => 0xb050 },
	'highlight' => { 341 => 0xf },
	'highlightadj' => { 92 => 0x2030c },
	'highlightcolordistortreduct' => { 390 => 0x8026 },
	'highlightprotection' => { 231 => 0x6 },
	'highlightrecovery' => { 405 => 'HighlightRecovery' },
	'highlights' => { 398 => 'Highlights' },
	'highlights2012' => { 405 => 'Highlights2012' },
	'highlighttone' => { 111 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 54 => 0x3, 73 => 0x203 },
	'highlowkeyadj' => { 307 => 0x6c },
	'highspeedsync' => { 161 => 0x5, 349 => 0x2, 350 => 0x2 },
	'histogramxml' => { 232 => 0x83a1a25 },
	'history' => { 417 => 'History', 430 => 'History' },
	'historyaction' => { 430 => [\'History','HistoryAction'] },
	'historychanged' => { 430 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 430 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 430 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 430 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 430 => [\'History','HistoryWhen'] },
	'hometowncity' => { 102 => 0x3006, 307 => 0x23, 313 => 0x2 },
	'hometowncitycode' => { 314 => 0x1000 },
	'hometowndst' => { 307 => 0x25, 313 => '0.2' },
	'hostcomputer' => { 106 => 0x13c },
	'hue' => { 166 => 0x3b, 197 => 0x3d, 307 => 0x67 },
	'hueadj' => { 235 => 0x2f, 390 => 0x8019 },
	'hueadjust' => { 332 => 0x1016 },
	'hueadjustment' => { 159 => 0x4a, 160 => 0x40, 194 => 0x92, 196 => 0x36 },
	'hueadjustmentaqua' => { 405 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 405 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 405 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 405 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 405 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 405 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 405 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 405 => 'HueAdjustmentYellow' },
	'huesetting' => { 261 => 0x1011 },
	'icc_profile' => { 107 => 'ICC_Profile' },
	'iccprofilename' => { 417 => 'ICCProfile' },
	'idccreativestyle' => { 390 => 0x8000 },
	'idcpreviewlength' => { 390 => 0x202 },
	'idcpreviewstart' => { 390 => 0x201 },
	'identification' => { 105 => 'Identification' },
	'identificationid' => { 105 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 105 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 105 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 105 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 105 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 105 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 406 => 'identifier', 427 => 'Identifier' },
	'illumination' => { 248 => '0.5' },
	'imageadjustment' => { 194 => 0x80, 222 => 0x5 },
	'imagealterationconstraints' => { 263 => 'ImageAlterationConstraints' },
	'imagearea' => { 206 => 0x10, 209 => 0x10 },
	'imageareaoffset' => { 307 => 0x38 },
	'imageauthentication' => { 194 => 0x20 },
	'imageboundary' => { 194 => 0x16 },
	'imagecount' => { 111 => 0x1438, 194 => 0xa5, 363 => 0x11b, 377 => [0x32,0x3a] },
	'imagecount2' => { 377 => [0x4c,0x58] },
	'imagecount3' => { 377 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 263 => 'ImageCreator' },
	'imagecreatorid' => { 263 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 263 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 263 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 194 => 0xa2 },
	'imagedescription' => { 106 => 0x10e, 425 => 'ImageDescription' },
	'imageduplicationconstraints' => { 263 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 232 => 0xfe443a45 },
	'imageeditcount' => { 307 => 0x41 },
	'imageediting' => { 307 => 0x32 },
	'imageeffects' => { 332 => 0x1010 },
	'imagefileconstraints' => { 263 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 263 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 263 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 111 => 0x1436 },
	'imageheight' => { 106 => 0x101, 165 => 0xc, 316 => 0x10d, 425 => 'ImageLength' },
	'imagehistory' => { 106 => 0x9213, 408 => 'ImageHistory' },
	'imageidnumber' => { 270 => 0x340 },
	'imagenumber' => { 106 => 0x9211, 136 => 'ImageNumber', 159 => 0xae, 160 => 0x5e, 316 => 0x113, 349 => 0x9b, 351 => [0x400,'276.1',0x314], 401 => 'ImageNumber' },
	'imagenumber2' => { 160 => 0x62 },
	'imageoptimization' => { 194 => 0xa9 },
	'imageorientation' => { 114 => 0x83 },
	'imageprocessing' => { 194 => 0x1a },
	'imageprocessingversion' => { 257 => 0x0 },
	'imagequality' => { 136 => 'ImageQuality', 208 => '723.2', 209 => '732.2', 218 => '708.1', 274 => 0x1 },
	'imagequality2' => { 253 => 0x603 },
	'imageref' => { 413 => 'ImageRef' },
	'imagereview' => { 241 => '0.4', 248 => '0.4' },
	'imagereviewmonitorofftime' => { 240 => '21.1', 242 => '21.1', 250 => '21.1' },
	'imagereviewtime' => { 239 => '25.1', 241 => '2.1', 243 => '19.1', 244 => '20.1', 245 => '20.1', 246 => '9.2', 247 => '20.1', 251 => '21.2' },
	'imagesize' => { 142 => 'ImageSize' },
	'imagesizerestriction' => { 422 => 'imageSizeRestriction' },
	'imagesourcedata' => { 106 => 0x935c },
	'imagestabilization' => { 31 => 0x22, 102 => 0x3020, 111 => 0x1422, 136 => 'ImageStabilization', 159 => 0xbd, 160 => 0x71, 161 => 0x57, 162 => 0x0, 163 => [0x18,0x107,0x113], 164 => 0x49c2, 194 => 0xac, 253 => 0x604, 256 => 0x1600, 274 => 0x1a, 354 => 0x12, 355 => 0x11, 361 => 0xb026 },
	'imagestabilization2' => { 353 => 0xa },
	'imagestabilizationsetting' => { 164 => 0x14, 349 => 0x3d, 350 => 0x3d, 360 => 0x14 },
	'imagestyle' => { 349 => 0x2d, 350 => 0x27 },
	'imagesupplier' => { 263 => 'ImageSupplier' },
	'imagesupplierid' => { 263 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 263 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 263 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 108 => 0x1 },
	'imagetemperaturemin' => { 108 => 0x2 },
	'imagetone' => { 307 => 0x4f },
	'imagetype' => { 114 => 0x82, 263 => 'ImageType' },
	'imageuniqueid' => { 55 => 0x28, 106 => 0xa420, 409 => 'ImageUniqueID' },
	'imagewidth' => { 106 => 0x100, 165 => 0xe, 316 => 0x10c, 425 => 'ImageWidth' },
	'incrementaltemperature' => { 405 => 'IncrementalTemperature' },
	'incrementaltint' => { 405 => 'IncrementalTint' },
	'industry' => { 419 => 'industry', 420 => 'industry' },
	'infobuttonwhenshooting' => { 73 => 0x409 },
	'infraredilluminator' => { 328 => 0x28 },
	'ingredientexclusion' => { 421 => 'ingredientExclusion' },
	'ingredients' => { 430 => 'Ingredients' },
	'ingredientsalternatepaths' => { 430 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 430 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 430 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 430 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 430 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 430 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 430 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 430 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 430 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 430 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 430 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 430 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 430 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 430 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 430 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 430 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 430 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 73 => 0x51e },
	'initialhorizontalfovdegrees' => { 394 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 394 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 394 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 394 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 239 => '4.4' },
	'initialzoomsetting' => { 239 => '9.3', 246 => '27.3' },
	'inkset' => { 106 => 0x14c },
	'inputprofile' => { 120 => 0x1389 },
	'instanceid' => { 430 => 'InstanceID' },
	'instantplaybacksetup' => { 161 => 0x3e },
	'instantplaybacktime' => { 161 => 0x3d },
	'instructions' => { 417 => 'Instructions' },
	'instrument' => { 429 => 'instrument' },
	'intellectualgenre' => { 414 => 'IntellectualGenre' },
	'intelligentauto' => { 361 => 0xb052 },
	'intelligentcontrast' => { 44 => 0x4 },
	'intelligentd-range' => { 274 => 0x79 },
	'intelligentexposure' => { 274 => 0x5d },
	'intelligentresolution' => { 274 => 0x70 },
	'interchangecolorspace' => { 116 => 0x40 },
	'internalflash' => { 158 => 0x2b, 239 => '23.1', 241 => '8.1', 243 => '22.1', 245 => '23.1', 248 => '8.1', 251 => '24.1', 256 => 0x1208 },
	'internalflashae1' => { 258 => 0x1021 },
	'internalflashae1_0' => { 258 => 0x101d },
	'internalflashae2' => { 258 => 0x1022 },
	'internalflashae2_0' => { 258 => 0x101e },
	'internalflashmode' => { 295 => 0x1 },
	'internalflashstrength' => { 295 => 0x3 },
	'internalflashtable' => { 258 => 0x1024 },
	'internallensserialnumber' => { 338 => 0xa005 },
	'internalndfilter' => { 274 => 0x9d },
	'internalserialnumber' => { 55 => 0x96, 66 => 0x9, 111 => 0x10, 164 => 0x49dc, 252 => 0x18, 254 => 0x102, 274 => 0x25, 287 => 0x4, 332 => 0x5, 377 => [0x7c,0x88,0xf0] },
	'interopindex' => { 106 => 0x1, 410 => 'InteroperabilityIndex' },
	'interopversion' => { 106 => 0x2 },
	'intervallength' => { 158 => 0x10 },
	'intervalmode' => { 158 => 0x26 },
	'intervalnumber' => { 158 => 0x11 },
	'introtime' => { 429 => 'introTime' },
	'introtimescale' => { 429 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 429 => [\'introTime','introTimeValue'] },
	'iptc' => { 107 => 'IPTC' },
	'iptc-naa' => { 106 => 0x83bb, 278 => 0x83bb },
	'iptcbitspersample' => { 116 => 0x56 },
	'iptcdigest' => { 321 => 0x425 },
	'iptcimageheight' => { 116 => 0x1e },
	'iptcimagerotation' => { 116 => 0x66 },
	'iptcimagewidth' => { 116 => 0x14 },
	'iptclastedited' => { 415 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 116 => 0xa },
	'iptcpixelheight' => { 116 => 0x32 },
	'iptcpixelwidth' => { 116 => 0x28 },
	'isalternativeof' => { 419 => 'isAlternativeOf' },
	'isbn' => { 419 => 'isbn' },
	'iscorrectionof' => { 419 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 98 => 0x3 },
	'ismergedhdr' => { 401 => 'IsMergedHDR' },
	'ismergedpanorama' => { 401 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 101 => 0x14, 102 => [0x3014,0x14], 106 => 0x8827, 119 => 0xfd06, 120 => 0x1784, 122 => 0x60, 124 => [0xfa2e,0xfa46], 125 => [0x27,0x28], 126 => 0xf105, 129 => 0x14, 131 => 0x4e, 134 => 0x34, 136 => 'ISO', 158 => 0x8, 164 => 0x49ba, 188 => 0x0, 194 => 0x2, 278 => 0x17, 307 => [0x8b,0x14], 314 => 0x14, 316 => 0x105, 338 => 0xa014, 360 => 0x6f, 365 => [0x1f,0x21,0x25], 409 => 'ISOSpeedRatings' },
	'iso2' => { 188 => 0x6, 203 => 0x265, 204 => 0x25c, 205 => 0x265, 206 => 0x221, 207 => 0x25d, 208 => 0x256, 209 => 0x25d, 213 => 0x2b5, 216 => 0x265, 221 => 0x2b5 },
	'isoauto' => { 288 => '14.4' },
	'isoautoparameters' => { 307 => 0x7a },
	'isodisplay' => { 242 => '4.1', 243 => '2.3', 244 => '3.3', 245 => '3.3', 247 => '3.3', 250 => '4.3', 251 => '4.3' },
	'isoexpansion' => { 73 => 0x103, 74 => 0x7, 75 => 0x8, 78 => 0x8, 188 => 0x4 },
	'isoexpansion2' => { 188 => 0xa },
	'isofloor' => { 288 => 0x6 },
	'isoselection' => { 194 => 0xf },
	'isosensitivitystep' => { 247 => '6.2' },
	'isosetting' => { 122 => 0x5e, 136 => 'ISOSetting', 158 => 0x24, 159 => 0x26, 160 => 0x1c, 161 => 0x13, 166 => 0x6, 194 => 0x13, 288 => '17.3', 331 => 0x27, 349 => 0x16, 350 => 0x14, 351 => 0x2, 360 => 0x6d },
	'isospeed' => { 106 => 0x8833, 410 => 'ISOSpeed' },
	'isospeedexpansion' => { 72 => 0x3 },
	'isospeedincrements' => { 73 => 0x102 },
	'isospeedlatitudeyyy' => { 106 => 0x8834, 410 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 106 => 0x8835, 410 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 73 => 0x103 },
	'isostepsize' => { 239 => '6.1', 240 => '7.2', 242 => '7.2', 246 => '4.1', 250 => '7.2' },
	'isovalue' => { 258 => 0x1001 },
	'issn' => { 419 => 'issn' },
	'issueidentifier' => { 419 => 'issueIdentifier' },
	'issuename' => { 419 => 'issueName' },
	'issueteaser' => { 419 => 'issueTeaser' },
	'issuetype' => { 419 => 'issueType' },
	'istranslationof' => { 419 => 'isTranslationOf' },
	'jobid' => { 114 => 0xb8 },
	'jobname' => { 411 => 'JobName' },
	'jobref' => { 428 => 'JobRef' },
	'jobrefid' => { 428 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 428 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 428 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 411 => 'JobStatus' },
	'jpeghandling' => { 405 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 276 => 0x3034, 361 => 0xb047 },
	'jpegsize' => { 276 => 0x303a },
	'jpgfromraw' => { 86 => 0x2007, 103 => 'JpgFromRaw', 278 => 0x2e },
	'jpgfromrawlength' => { 106 => [0x117,0x202] },
	'jpgfromrawstart' => { 106 => [0x111,0x201] },
	'jpgrecordedpixels' => { 288 => '14.1' },
	'jurisdiction' => { 402 => 'jurisdiction' },
	'kelvinwb_01' => { 296 => 0x5 },
	'kelvinwb_02' => { 296 => 0x9 },
	'kelvinwb_03' => { 296 => 0xd },
	'kelvinwb_04' => { 296 => 0x11 },
	'kelvinwb_05' => { 296 => 0x15 },
	'kelvinwb_06' => { 296 => 0x19 },
	'kelvinwb_07' => { 296 => 0x1d },
	'kelvinwb_08' => { 296 => 0x21 },
	'kelvinwb_09' => { 296 => 0x25 },
	'kelvinwb_10' => { 296 => 0x29 },
	'kelvinwb_11' => { 296 => 0x2d },
	'kelvinwb_12' => { 296 => 0x31 },
	'kelvinwb_13' => { 296 => 0x35 },
	'kelvinwb_14' => { 296 => 0x39 },
	'kelvinwb_15' => { 296 => 0x3d },
	'kelvinwb_16' => { 296 => 0x41 },
	'kelvinwb_daylight' => { 296 => 0x1 },
	'key' => { 429 => 'key' },
	'keyword' => { 419 => 'keyword' },
	'keywordinfo' => { 151 => 'Keywords' },
	'keywords' => { 114 => 0x19, 137 => 'Keywords', 262 => 'Keywords', 323 => 'Keywords', 399 => 'keywords', 416 => 'Keywords', 427 => 'Keywords' },
	'killdate' => { 419 => 'killDate' },
	'killdatea-platform' => { 419 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 419 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 119 => 0xf908, 122 => 0xe, 124 => [0xfa1e,0xfa52], 130 => 0x70 },
	'kodakimagewidth' => { 119 => 0xf907, 122 => 0xc, 124 => [0xfa1d,0xfa51], 130 => 0x6c },
	'kodakinfotype' => { 119 => 0xfa00 },
	'kodaklook' => { 120 => 0xe4c },
	'kodaklookprofile' => { 120 => 0x138a },
	'kodakmaker' => { 130 => 0x8 },
	'kodakmodel' => { 122 => 0x0, 130 => 0x28 },
	'label' => { 266 => 'Label', 427 => 'Label' },
	'labelname1' => { 413 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 413 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 274 => 0x6f },
	'landscapeoutputhighlightpoint' => { 98 => 0x26 },
	'landscapeoutputshadowpoint' => { 98 => 0x27 },
	'landscaperawcolortone' => { 98 => 0x1f },
	'landscaperawcontrast' => { 98 => 0x21 },
	'landscaperawhighlight' => { 98 => 0x77 },
	'landscaperawhighlightpoint' => { 98 => 0x24 },
	'landscaperawlinear' => { 98 => 0x22 },
	'landscaperawsaturation' => { 98 => 0x20 },
	'landscaperawshadow' => { 98 => 0x80 },
	'landscaperawshadowpoint' => { 98 => 0x25 },
	'landscaperawsharpness' => { 98 => 0x23 },
	'landscapeunsharpmaskfineness' => { 98 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 98 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 98 => 0xa2 },
	'language' => { 406 => 'language' },
	'languageidentifier' => { 114 => 0x87 },
	'largestvalidinteriorrectheight' => { 394 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 394 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 394 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 394 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 158 => 0x1b },
	'lastkeywordiptc' => { 156 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 156 => 'LastKeywordXMP' },
	'lastphotodate' => { 394 => 'LastPhotoDate' },
	'lasturl' => { 430 => 'LastURL' },
	'lateralchromaticaberration' => { 361 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 401 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 105 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 105 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 105 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 298 => 0x2 },
	'lc10' => { 298 => 0xb },
	'lc11' => { 298 => 0xc },
	'lc12' => { 298 => 0xd },
	'lc14' => { 298 => 0xf },
	'lc15' => { 298 => 0x10 },
	'lc3' => { 298 => 0x4 },
	'lc4' => { 298 => 0x5 },
	'lc5' => { 298 => 0x6 },
	'lc6' => { 298 => 0x7 },
	'lc7' => { 298 => 0x8 },
	'lc8' => { 298 => 0x9 },
	'lcddisplayatpoweron' => { 73 => 0x811, 77 => 0xa },
	'lcddisplayreturntoshoot' => { 78 => 0x12 },
	'lcdillumination' => { 239 => '17.5', 240 => '5.2', 242 => '5.1', 246 => '10.3', 247 => '4.2', 250 => '5.2', 251 => '5.4' },
	'lcdilluminationduringbulb' => { 73 => 0x408 },
	'lcdpanels' => { 72 => 0x8 },
	'lcheditor' => { 232 => 0x8ae85e },
	'legacyiptcdigest' => { 417 => 'LegacyIPTCDigest' },
	'legalcode' => { 402 => 'legalcode' },
	'lens' => { 106 => 0xfdea, 194 => 0x84, 401 => 'Lens' },
	'lensafstopbutton' => { 71 => 0x11, 72 => 0x13, 73 => 0x506, 74 => 0x10, 75 => 0x12, 78 => 0x13, 79 => 0x9 },
	'lensaperturerange' => { 341 => [0x30,0x48] },
	'lenscorrectionsettings' => { 408 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 401 => 'LensDistortInfo' },
	'lensdistortionparams' => { 258 => 0x206 },
	'lensdrivenoaf' => { 73 => 0x505 },
	'lense-mountversion' => { 351 => 0x3f0, 389 => 0xd },
	'lensfirmware' => { 333 => 0x20, 338 => 0xa004 },
	'lensfirmwareversion' => { 254 => 0x204, 274 => 0x60, 351 => 0x3f4, 389 => 0x15 },
	'lensfocallength' => { 92 => 0xf0512, 298 => 0x9 },
	'lensfocalrange' => { 341 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 240 => '55.1', 242 => '52.1', 250 => '52.1' },
	'lensformat' => { 372 => 0x1891, 374 => 0x18bd, 375 => 0x18ed, 377 => 0x106, 385 => 0x603, 386 => 0x5d },
	'lensfstops' => { 189 => 0x7, 190 => 0xc, 191 => 0xd, 194 => 0x8b, 298 => '0.3' },
	'lensid' => { 401 => 'LensID' },
	'lensidnumber' => { 189 => 0x6, 190 => 0xb, 191 => 0xc },
	'lensinfo' => { 106 => 0xa432, 304 => 0x2a, 401 => 'LensInfo', 410 => 'LensSpecification' },
	'lenskind' => { 298 => 0x1 },
	'lensmake' => { 106 => 0xa433, 143 => 'Make', 410 => 'LensMake' },
	'lensmanualdistortionamount' => { 405 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 156 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 341 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 55 => 0x95, 106 => 0xa434, 143 => 'Model', 156 => 'LensModel', 192 => 0x18a, 254 => 0x203, 272 => 0x303, 304 => 0xc, 316 => 0x412, 410 => 'LensModel' },
	'lensmount' => { 351 => 0x99, 372 => 0x1892, 374 => 0x18be, 375 => 0x18ee, 377 => 0x105, 385 => 0x604, 386 => 0x5e },
	'lensmount2' => { 389 => 0x8 },
	'lensparameters' => { 369 => 0x1a23, 372 => 0x1870, 374 => 0x189c, 375 => 0x18cc, 385 => 0x6ca, 386 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 405 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 405 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 405 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 405 => 'LensProfileEnable' },
	'lensprofilefilename' => { 405 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 405 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 405 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 405 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 405 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 405 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 405 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 405 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 405 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 405 => 'LensProfileName' },
	'lensprofilesetup' => { 405 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 405 => 'LensProfileVignettingScale' },
	'lensproperties' => { 254 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 29 => 0x16b, 53 => 0x0, 106 => 0xa435, 143 => 'SerialNumber', 254 => 0x202, 274 => 0x52, 333 => 0x30, 401 => 'LensSerialNumber', 410 => 'LensSerialNumber' },
	'lensshutterlock' => { 161 => 0x4a },
	'lensspec' => { 346 => 0x0, 347 => 0x0, 348 => 0x0, 361 => 0xb02a },
	'lensspecfeatures' => { 377 => [0x115,0x116] },
	'lenstemperature' => { 258 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 31 => 0x16, 163 => 0x10c, 164 => 0x49bd, 194 => 0x83, 254 => 0x201, 267 => 0x16, 270 => 0x310, 273 => 0x303, 274 => 0x51, 276 => 0x3405, 299 => 0x0, 300 => 0x0, 301 => 0x1, 302 => 0x1, 303 => 0x1, 305 => 0x0, 338 => 0xa003, 341 => 0x27, 361 => 0xb027, 372 => 0x1896, 374 => 0x18c2, 375 => 0x18f2, 377 => 0x109, 385 => 0x608, 386 => 0x62 },
	'lenstype2' => { 351 => 0x3f7, 372 => 0x1893, 374 => 0x18bf, 375 => 0x18ef, 377 => 0x107, 385 => 0x605, 386 => 0x60 },
	'lenstype3' => { 389 => 0x9 },
	'lenszoomposition' => { 383 => 0x19, 384 => 0x1e, 386 => [0x342,0x35a] },
	'levelindicator' => { 281 => 0x15 },
	'levelorientation' => { 306 => 0x0 },
	'license' => { 402 => 'license' },
	'licensee' => { 263 => 'Licensee' },
	'licenseeid' => { 263 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 263 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 263 => 'LicenseeImageNotes' },
	'licenseename' => { 263 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 263 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 263 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 263 => 'LicenseeTransactionID' },
	'licenseid' => { 263 => 'LicenseID' },
	'licensestartdate' => { 263 => 'LicenseStartDate' },
	'licensetransactiondate' => { 263 => 'LicenseTransactionDate' },
	'licensetype' => { 407 => 'licensetype' },
	'licensor' => { 263 => 'Licensor' },
	'licensorcity' => { 263 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 263 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 263 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 263 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 263 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 263 => 'LicensorImageID' },
	'licensorname' => { 263 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 263 => 'LicensorNotes' },
	'licensorpostalcode' => { 263 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 263 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 263 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 263 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 263 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 263 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 263 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 263 => 'LicensorTransactionID' },
	'licensorurl' => { 263 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 258 => 0x1009 },
	'lightingmode' => { 102 => 0x302a },
	'lightreading' => { 307 => 0x15 },
	'lightsource' => { 106 => 0x9208, 194 => 0x90, 261 => 0x1000, 409 => 'LightSource' },
	'lightsourcespecial' => { 340 => 0x21d },
	'lightswitch' => { 250 => '0.1', 251 => '0.1' },
	'lightvaluecenter' => { 258 => 0x103d },
	'lightvalueperiphery' => { 258 => 0x103e },
	'limitafareamodeselection' => { 240 => '51.1', 242 => '49.1', 250 => '49.1' },
	'linearitylimitblue' => { 278 => 0x10 },
	'linearitylimitgreen' => { 278 => 0xf },
	'linearitylimitred' => { 278 => 0xe },
	'linearityuppermargin' => { 38 => [0x2ba,0x2d1,0x2d5], 40 => 0x1e5, 41 => [0x1fe,0x2de], 42 => [0x232,0x310] },
	'linearizationtable' => { 106 => 0xc618 },
	'linearresponselimit' => { 106 => 0xc62e },
	'link' => { 419 => 'link' },
	'linkaetoafpoint' => { 288 => '14.2' },
	'linkedencodedrightsexpr' => { 415 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 415 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 415 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 415 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 105 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 243 => '32.1', 251 => '34.1' },
	'liveviewafareamode' => { 247 => '34.1' },
	'liveviewafmethod' => { 365 => 0x20 },
	'liveviewafmode' => { 247 => '34.2' },
	'liveviewafsetting' => { 351 => 0x36 },
	'liveviewbuttonoptions' => { 240 => '50.2', 242 => '48.2', 250 => '48.2' },
	'liveviewexposuresimulation' => { 73 => 0x810 },
	'liveviewfocusmode' => { 351 => [0x8b,0x28b] },
	'liveviewmetering' => { 351 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 240 => '21.2', 242 => '21.2', 244 => '20.2', 245 => '20.2', 247 => '20.2', 250 => '21.2' },
	'liveviewshooting' => { 49 => 0x13 },
	'localcaption' => { 114 => 0x79 },
	'localizedcameramodel' => { 106 => 0xc615 },
	'locallocationname' => { 338 => 0x30 },
	'location' => { 193 => 0x9, 274 => 0x67, 397 => 'Location', 414 => 'Location', 418 => 'location', 419 => 'location' },
	'locationareacode' => { 403 => 'lac' },
	'locationcreated' => { 415 => 'LocationCreated' },
	'locationcreatedcity' => { 415 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 415 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 415 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 415 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 415 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 415 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 415 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 193 => 0x0 },
	'locationname' => { 338 => 0x31 },
	'locationshown' => { 415 => 'LocationShown' },
	'locationshowncity' => { 415 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 415 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 415 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 415 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 415 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 415 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 415 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 73 => 0x709 },
	'logcomment' => { 429 => 'logComment' },
	'longexposurenoisereduction' => { 54 => 0x4, 73 => 0x201, 74 => 0x1, 75 => 0x2, 76 => 0x1, 77 => 0x1, 78 => 0x2, 79 => 0x1, 274 => 0x49, 349 => 0x2b, 350 => 0x25, 351 => 0x25, 361 => 0x2008, 365 => 0x11, 386 => 0x44 },
	'longexposurenoisereduction2' => { 49 => 0x8 },
	'loop' => { 429 => 'loop' },
	'lowestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 405 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 405 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 405 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 405 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 405 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 405 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 405 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 405 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 97 => 0x150 },
	'luminancecurvepoints' => { 97 => 0x126 },
	'luminancenoisereduction' => { 92 => 0x20600, 98 => 0x5f, 341 => 0x1b },
	'luminancenoisereductioncontrast' => { 405 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 405 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 98 => 0x6d },
	'luminancesmoothing' => { 405 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 73 => [0x40b,0x40c] },
	'lyrics' => { 429 => 'lyrics' },
	'm16cversion' => { 270 => 0x333 },
	'macatom' => { 404 => 'macAtom' },
	'macatomapplicationcode' => { 404 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 404 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 404 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 111 => 0x1020, 112 => 0x202, 258 => 0x202, 331 => 0x21, 340 => 0x202, 361 => 0xb040 },
	'macroled' => { 256 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 49 => 0x10 },
	'macromode' => { 31 => 0x1, 158 => 0xb, 253 => 0x300, 274 => 0x1c, 332 => 0x1009 },
	'magentahsl' => { 92 => 0x20917 },
	'magicfilter' => { 253 => 0x52c },
	'magnifiedview' => { 75 => 0x11, 77 => 0x9 },
	'maindialexposurecomp' => { 248 => '0.6' },
	'mainingredient' => { 421 => 'mainIngredient' },
	'make' => { 87 => 0x0, 106 => 0x10f, 136 => 'Make', 266 => 'Make', 278 => 0x10f, 418 => 'make', 425 => 'Make' },
	'makernote' => { 409 => 'MakerNote' },
	'makernoteapple' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecanon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteflir' => { 104 => 'MakN', 106 => 0x927c },
	'makernotefujifilm' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehasselblad' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteisl' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvc' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvctext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak10' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak11' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak7' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8c' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak9' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodakunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekyocera' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica3' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica4' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica5' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica7' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica8' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica9' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotemotorola' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenintendo' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteoffset' => { 340 => 0xff },
	'makernoteolympus' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteolympus2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax6' => { 104 => 'MakN', 106 => 0x927c },
	'makernotephaseone' => { 104 => 'MakN', 106 => 0x927c },
	'makernotereconyx' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericohtext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesafety' => { 106 => 0xc635 },
	'makernotesamsung1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyo' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyoc4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyopatch' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesigma' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonyericsson' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonysrf' => { 104 => 'MakN', 106 => 0x927c },
	'makernotetype' => { 332 => 0x1 },
	'makernoteunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknownbinary' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknowntext' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteversion' => { 163 => 0x0, 194 => 0x1, 258 => 0x0, 274 => 0x8000, 336 => 0x0, 338 => 0x1, 341 => [0x1d,0x1f], 352 => 0x2000 },
	'managedfrom' => { 430 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 430 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 430 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 430 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 430 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 430 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 430 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 430 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 430 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 430 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 430 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 430 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 430 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 430 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 430 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 430 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 430 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 430 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 430 => 'Manager' },
	'managervariant' => { 430 => 'ManagerVariant' },
	'manageto' => { 430 => 'ManageTo' },
	'manageui' => { 430 => 'ManageUI' },
	'manifest' => { 430 => 'Manifest' },
	'manifestlinkform' => { 430 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 430 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 430 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 430 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 430 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 430 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 430 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 430 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 430 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 430 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 430 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 430 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 430 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 430 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 430 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 430 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 430 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 430 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 430 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 430 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 430 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 430 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 253 => 0x900, 274 => 0x86 },
	'manometerreading' => { 253 => 0x901 },
	'manualafpointselectpattern' => { 73 => 0x513 },
	'manualflash' => { 256 => 0x1209 },
	'manualflashoutput' => { 31 => 0x29, 241 => '8.2', 243 => '22.2', 244 => '23.1', 245 => '23.2', 246 => '16.2', 247 => '23.2', 248 => '8.2', 249 => '23.2', 251 => '24.2', 332 => 0x100c },
	'manualflashstrength' => { 253 => 0x406 },
	'manualfocusdistance' => { 194 => 0x85, 258 => 0x100c, 340 => 0x223 },
	'manualtv' => { 72 => 0x5, 73 => 0x705 },
	'manufacturedate' => { 168 => 0x6705, 287 => 0x1 },
	'manufacturedate1' => { 334 => 0x4 },
	'manufacturedate2' => { 334 => 0x5 },
	'manufacturer' => { 418 => 'manufacturer' },
	'marked' => { 416 => 'Marked', 433 => 'Marked' },
	'markers' => { 429 => 'markers' },
	'markerscomment' => { 429 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 429 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 429 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 429 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 429 => [\'markers','markersCuePointType'] },
	'markersduration' => { 429 => [\'markers','markersDuration'] },
	'markerslocation' => { 429 => [\'markers','markersLocation'] },
	'markersname' => { 429 => [\'markers','markersName'] },
	'markersprobability' => { 429 => [\'markers','markersProbability'] },
	'markersspeaker' => { 429 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 429 => [\'markers','markersStartTime'] },
	'markerstarget' => { 429 => [\'markers','markersTarget'] },
	'markerstype' => { 429 => [\'markers','markersType'] },
	'maskedareas' => { 106 => 0xc68e },
	'masterdocumentid' => { 114 => 0xb9 },
	'mastergain' => { 201 => 0x50 },
	'matrixmetering' => { 240 => '50.1', 242 => '48.1', 250 => '48.1' },
	'maxaperture' => { 31 => 0x1a, 126 => 0x6103, 143 => 'MaxAperture', 158 => 0x17, 164 => 0x49c5, 254 => 0x20a, 298 => '14.1', 377 => 0x0 },
	'maxapertureatmaxfocal' => { 111 => 0x1407, 143 => 'MaxApertureAtMaxFocal', 189 => 0xb, 190 => 0x10, 191 => 0x11, 254 => 0x206 },
	'maxapertureatminfocal' => { 111 => 0x1406, 189 => 0xa, 190 => 0xf, 191 => 0x10, 254 => 0x205 },
	'maxaperturevalue' => { 106 => 0x9205, 316 => 0x414, 409 => 'MaxApertureValue' },
	'maxavailheight' => { 415 => 'MaxAvailHeight' },
	'maxavailwidth' => { 415 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 239 => 0xb, 240 => 0xc, 242 => '12.1', 246 => 0xc, 247 => 0xb, 250 => '12.1' },
	'maxfaces' => { 257 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 31 => 0x17, 111 => 0x1405, 143 => 'MaxFocalLength', 189 => 0x9, 190 => 0xe, 191 => 0xf, 254 => 0x208, 372 => 0x127c, 373 => 0x1138, 374 => 0x330, 375 => 0x330 },
	'maximumdensityrange' => { 116 => 0x8c },
	'maxpagesize' => { 434 => 'MaxPageSize' },
	'maxpagesizeh' => { 434 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 434 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 434 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 106 => 0x119 },
	'maxstorage' => { 424 => 'maxstorage' },
	'mb-d10batteries' => { 239 => '12.6' },
	'mb-d10batterytype' => { 246 => '13.3' },
	'mb-d11batterytype' => { 247 => '2.3' },
	'mb-d12batterytype' => { 250 => '3.2' },
	'mb-d80batteries' => { 248 => '6.5' },
	'mb-d80batterytype' => { 251 => '3.2' },
	'mcuversion' => { 189 => 0xc, 190 => 0x11, 191 => 0x12 },
	'md5digest' => { 144 => 'zmd5' },
	'meal' => { 421 => 'meal' },
	'measuredev' => { 26 => 0x9, 67 => 0x3, 86 => 0x1814, 136 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 67 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 164 => 0x690, 270 => 0x312, 276 => 0x3407 },
	'measuredrggb' => { 56 => 0x1 },
	'measuredrggbdata' => { 37 => 0x287 },
	'measurementaccuracy' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 105 => 'MeasurementOrFact' },
	'measurementremarks' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 263 => 'MediaConstraints' },
	'mediacreatedate' => { 324 => 0x1 },
	'mediamodifydate' => { 324 => 0x2 },
	'mediasummarycode' => { 263 => 'MediaSummaryCode' },
	'memoaudioquality' => { 73 => 0x812 },
	'memorycardconfiguration' => { 355 => 0x16 },
	'memorycardnumber' => { 182 => 0x2 },
	'menubuttondisplayposition' => { 71 => 0xb, 74 => 0xa, 75 => 0xb, 78 => 0xb },
	'menubuttonreturn' => { 79 => 0xb },
	'menumonitorofftime' => { 239 => '26.1', 240 => '22.1', 242 => '22.1', 246 => '8.2', 247 => '21.1', 250 => '22.1', 251 => '22.1' },
	'metadatadate' => { 427 => 'MetadataDate' },
	'metadatamoddate' => { 429 => 'metadataModDate' },
	'metaversion' => { 367 => 0x34 },
	'meterinfo1row1' => { 362 => 0x0 },
	'meterinfo1row2' => { 362 => 0x6c },
	'meterinfo1row3' => { 362 => 0xd8 },
	'meterinfo1row4' => { 362 => 0x144 },
	'meterinfo1row5' => { 362 => 0x1b0 },
	'meterinfo1row6' => { 362 => 0x21c },
	'meterinfo1row7' => { 362 => 0x288 },
	'meterinfo2row1' => { 362 => 0x2f4 },
	'meterinfo2row2' => { 362 => 0x378 },
	'meterinfo2row3' => { 362 => 0x3fc },
	'meterinfo2row4' => { 362 => 0x480 },
	'meterinfo2row5' => { 362 => 0x504 },
	'meterinfo2row6' => { 362 => 0x588 },
	'meterinfo2row7' => { 362 => 0x60c },
	'meterinfo2row8' => { 362 => 0x690 },
	'meterinfo2row9' => { 362 => 0x714 },
	'metering' => { 241 => '6.1' },
	'meteringmode' => { 31 => 0x11, 106 => 0x9207, 122 => 0x1c, 158 => 0x7, 159 => 0x25, 161 => 0x12, 253 => 0x202, 307 => 0x17, 341 => 0x9, 349 => 0x15, 350 => 0x13, 351 => 0x7, 365 => 0x3, 368 => 0x1174, 369 => 0x1178, 370 => 0x1154, 371 => 0x11d0, 372 => 0x11ac, 373 => 0x1064, 374 => 0x25c, 375 => 0x25c, 409 => 'MeteringMode' },
	'meteringmode2' => { 288 => '2.1' },
	'meteringmode3' => { 288 => '16.1' },
	'meteringoffscaleindicator' => { 161 => 0x53 },
	'meteringtime' => { 239 => '22.2', 241 => '3.2', 243 => '17.1', 244 => '18.1', 246 => '7.3', 247 => '18.1', 248 => '3.2', 251 => '19.1' },
	'mieversion' => { 144 => '0Vers' },
	'minaperture' => { 31 => 0x1b, 143 => 'MinAperture', 298 => '0.2', 377 => 0x1 },
	'minaperturevalue' => { 316 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 31 => 0x18, 111 => 0x1404, 143 => 'MinFocalLength', 189 => 0x8, 190 => 0xd, 191 => 0xe, 254 => 0x207, 372 => 0x127a, 373 => 0x1136, 374 => 0x32e, 375 => 0x32e },
	'minfocusdistance' => { 298 => 0x3 },
	'minoltadate' => { 158 => 0x15 },
	'minoltaimagesize' => { 158 => 0x4, 159 => 0xc, 160 => 0x2, 163 => 0x103 },
	'minoltamodelid' => { 158 => 0x25 },
	'minoltaquality' => { 158 => 0x5, 159 => 0xd, 160 => 0x3, 163 => [0x102,0x103] },
	'minoltatime' => { 158 => 0x16 },
	'minormodelagedisclosure' => { 263 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 106 => 0x118 },
	'mirrorlockup' => { 71 => 0xc, 72 => 0xc, 73 => 0x60f, 74 => 0xb, 75 => 0xc, 76 => 0x6, 77 => 0x6, 78 => 0xc, 79 => 0x3 },
	'mobilecountrycode' => { 403 => 'mcc' },
	'mobilenetworkcode' => { 403 => 'mnc' },
	'moddate' => { 266 => 'modify-date', 416 => 'ModDate' },
	'modedialposition' => { 355 => 0x14 },
	'model' => { 87 => 0x6, 106 => 0x110, 136 => 'Model', 266 => 'Model', 278 => 0x110, 418 => 'model', 425 => 'Model' },
	'modelage' => { 415 => 'ModelAge' },
	'modelid' => { 252 => 0x0 },
	'modelingflash' => { 239 => '21.4', 240 => '31.1', 242 => '31.1', 246 => '26.4', 247 => '30.2', 248 => '7.4', 249 => '30.1', 250 => '31.1', 251 => '31.3' },
	'modelreleaseid' => { 263 => 'ModelReleaseID' },
	'modelreleasestatus' => { 263 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 378 => 0x52, 379 => 0x46, 380 => 0x53 },
	'modelyear' => { 418 => 'modelYear' },
	'modificationdate' => { 419 => 'modificationDate' },
	'modifiedcolortemp' => { 57 => 0x9 },
	'modifieddigitalgain' => { 57 => 0xb },
	'modifiedparamflag' => { 50 => 0x1 },
	'modifiedpicturestyle' => { 57 => 0xa },
	'modifiedsaturation' => { 253 => 0x504 },
	'modifiedsensorbluelevel' => { 57 => 0x5 },
	'modifiedsensorredlevel' => { 57 => 0x4 },
	'modifiedsharpness' => { 57 => 0x2 },
	'modifiedsharpnessfreq' => { 57 => 0x3 },
	'modifiedtonecurve' => { 57 => 0x1 },
	'modifiedwhitebalance' => { 57 => 0x8 },
	'modifiedwhitebalanceblue' => { 57 => 0x7 },
	'modifiedwhitebalancered' => { 57 => 0x6 },
	'modifydate' => { 106 => 0x132, 137 => 'ModifyDate', 262 => 'ModDate', 264 => 'tIME', 323 => 'ModDate', 325 => 0x2, 427 => 'ModifyDate' },
	'moirefilter' => { 106 => 0xfe58, 405 => 'MoireFilter' },
	'monitordisplayoff' => { 161 => 0x4c },
	'monitorofftime' => { 239 => '18.2', 241 => '3.1', 248 => '3.1' },
	'monochromecontrast' => { 98 => 0x3c },
	'monochromefiltereffect' => { 92 => 0x20307, 98 => 0x3a, 307 => 0x73 },
	'monochromelinear' => { 98 => 0x3d },
	'monochromeoutputhighlightpoint' => { 98 => 0x41 },
	'monochromeoutputshadowpoint' => { 98 => 0x42 },
	'monochromerawhighlight' => { 98 => 0x7a },
	'monochromerawhighlightpoint' => { 98 => 0x3f },
	'monochromerawshadow' => { 98 => 0x83 },
	'monochromerawshadowpoint' => { 98 => 0x40 },
	'monochromesharpness' => { 98 => 0x3e },
	'monochrometoning' => { 307 => 0x74 },
	'monochrometoningeffect' => { 92 => 0x20306, 98 => 0x3b },
	'monochromeunsharpmaskfineness' => { 98 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 98 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 98 => 0xb4 },
	'monthdaycreated' => { 122 => 0x12, 131 => 0xe },
	'moonphase' => { 328 => 0x12 },
	'morepermissions' => { 402 => 'morePermissions' },
	'motionsensitivity' => { 328 => 0x29 },
	'movieaelockbuttonassignment' => { 250 => '40.1' },
	'moviefunctionbutton' => { 240 => '41.1', 250 => '41.1' },
	'moviefunctionbuttonplusdials' => { 240 => '52.1' },
	'moviepreviewbutton' => { 240 => '41.2', 242 => ['41.1','41.2'], 250 => '41.2' },
	'moviepreviewbuttonplusdials' => { 240 => '52.2' },
	'movieshutterbutton' => { 240 => '38.3', 242 => '38.3', 250 => '38.3' },
	'moviesubselectorassignment' => { 240 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 240 => '53.1' },
	'multiburstimageheight' => { 361 => 0x1002 },
	'multiburstimagewidth' => { 361 => 0x1001 },
	'multiburstmode' => { 361 => 0x1000 },
	'multicontrollerwhilemetering' => { 73 => 0x517 },
	'multiexposure' => { 59 => 0x1 },
	'multiexposureautogain' => { 195 => 0x3 },
	'multiexposurecontrol' => { 59 => 0x2 },
	'multiexposuremode' => { 195 => 0x1 },
	'multiexposureshots' => { 59 => 0x3, 195 => 0x2 },
	'multiframenoisereduction' => { 351 => 0x35, 361 => 0x200b, 365 => 0x15 },
	'multifunctionlock' => { 73 => 0x70f },
	'multipleexposuremode' => { 257 => 0x101c },
	'multipleexposureset' => { 288 => '10.1' },
	'multisample' => { 201 => 0x40 },
	'multiselector' => { 239 => '9.4', 240 => '10.3', 242 => '10.3', 246 => '27.4', 250 => '10.3' },
	'multiselectorliveview' => { 239 => '4.3', 242 => '37.1', 250 => '37.1' },
	'multiselectorliveviewmode' => { 211 => 0x18c2 },
	'multiselectorplaybackmode' => { 239 => ['13.5','9.2'], 240 => '10.2', 242 => '10.2', 246 => '27.2', 250 => '10.2' },
	'multiselectorshootmode' => { 239 => '9.1', 240 => '10.1', 242 => '10.1', 246 => '27.1', 250 => '10.1' },
	'mycolormode' => { 60 => 0x2 },
	'nationalcatalognumber' => { 419 => 'nationalCatalogNumber' },
	'nativedigest' => { 409 => 'NativeDigest', 425 => 'NativeDigest' },
	'ncdfileinfo' => { 120 => 0x414 },
	'ndfilter' => { 67 => 0x1c, 253 => 0x204, 332 => 0x1019 },
	'nefbitdepth' => { 194 => 0xe22 },
	'nefcompression' => { 194 => 0x93 },
	'neflinearizationtable' => { 194 => 0x96 },
	'negativecachelargepreviewsize' => { 405 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 405 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 405 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 307 => 0x88 },
	'neutraloutputhighlightpoint' => { 98 => 0x2f },
	'neutraloutputshadowpoint' => { 98 => 0x30 },
	'neutralrawcolortone' => { 98 => 0x28 },
	'neutralrawcontrast' => { 98 => 0x2a },
	'neutralrawhighlight' => { 98 => 0x78 },
	'neutralrawhighlightpoint' => { 98 => 0x2d },
	'neutralrawlinear' => { 98 => 0x2b },
	'neutralrawsaturation' => { 98 => 0x29 },
	'neutralrawshadow' => { 98 => 0x81 },
	'neutralrawshadowpoint' => { 98 => 0x2e },
	'neutralrawsharpness' => { 98 => 0x2c },
	'neutralunsharpmaskfineness' => { 98 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 98 => 0xa8 },
	'neutraunsharpmaskstrength' => { 98 => 0xa4 },
	'newrawimagedigest' => { 106 => 0xc7a7 },
	'newsphotoversion' => { 116 => 0x0 },
	'nickname' => { 427 => 'Nickname' },
	'nikoncapturedata' => { 194 => 0xe01 },
	'nikoncaptureeditversions' => { 194 => 0xe13 },
	'nikoncaptureoutput' => { 194 => 0xe1e },
	'nikoncaptureversion' => { 194 => 0xe09 },
	'nikoniccprofile' => { 194 => 0xe1d },
	'nikonimagesize' => { 208 => '723.1', 209 => '732.1', 218 => 0x2c4 },
	'noisefilter' => { 253 => 0x527 },
	'noiseprofile' => { 106 => 0xc761 },
	'noisereduction' => { 111 => 0x100b, 159 => 0xb0, 160 => 0x60, 161 => 0x3f, 194 => 0x95, 232 => 0x753dcbc0, 233 => 0x17, 253 => 0x50a, 258 => 0x103a, 274 => 0x2d, 307 => 0x49, 332 => 0x100f, 334 => 0x2a },
	'noisereduction2' => { 257 => 0x1010 },
	'noisereductionapplied' => { 106 => 0xc6f7 },
	'noisereductionintensity' => { 233 => 0x9 },
	'noisereductionmethod' => { 233 => 0x11 },
	'noisereductionmode' => { 390 => 0x801e },
	'noisereductionsharpness' => { 233 => 0xd },
	'noisereductionvalue' => { 390 => 0x8027 },
	'nomemorycard' => { 239 => '22.1', 240 => '4.2', 241 => '0.3', 243 => '2.4', 244 => '3.2', 245 => '3.2', 246 => '33.7', 247 => '3.2', 248 => '0.3', 250 => '4.2', 251 => '4.5' },
	'nominalmaxaperture' => { 298 => 0xa },
	'nominalminaperture' => { 298 => '10.1' },
	'normalwhitelevel' => { 38 => [0x2b8,0x2cf,0x2d3], 40 => 0x1e3, 41 => [0x1fc,0x2dc], 42 => [0x230,0x30e] },
	'notes' => { 391 => 'Notes', 399 => 'notes' },
	'npages' => { 434 => 'NPages' },
	'nrwdata' => { 194 => 0x14 },
	'nullrecord' => { 86 => 0x0 },
	'number' => { 419 => 'number' },
	'numberofbeats' => { 429 => 'numberOfBeats' },
	'numberoffocuspoints' => { 242 => '1.2', 245 => '0.2', 247 => '0.3' },
	'numfacepositions' => { 268 => 0x0 },
	'numindexentries' => { 116 => 0x54 },
	'numwbentries' => { 279 => 0x0, 280 => 0x0 },
	'object' => { 419 => 'object' },
	'objectattributereference' => { 114 => 0x4 },
	'objectcycle' => { 114 => 0x4b, 399 => 'ObjectCycle' },
	'objectdescription' => { 418 => 'objectDescription' },
	'objectdistance' => { 101 => 0x6, 102 => 0x2022 },
	'objectname' => { 114 => 0x5 },
	'objectpreviewdata' => { 114 => 0xca },
	'objectpreviewfileformat' => { 114 => 0xc8 },
	'objectpreviewfileversion' => { 114 => 0xc9 },
	'objectsubtype' => { 418 => 'objectSubtype' },
	'objecttype' => { 418 => 'objectType' },
	'objecttypereference' => { 114 => 0x3 },
	'occurrence' => { 105 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 105 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 105 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 105 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 105 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 105 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 105 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 105 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 105 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 105 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 105 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 105 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 105 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 105 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 105 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 105 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 105 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 105 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 105 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 105 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 105 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 105 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 105 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 105 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 409 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 409 => [\'OECF','OECFNames'] },
	'oecfrows' => { 409 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 409 => [\'OECF','OECFValues'] },
	'offsaledate' => { 419 => 'offSaleDate' },
	'offsaledatea-platform' => { 419 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 419 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 106 => 0xea1d },
	'okbutton' => { 247 => '15.1', 251 => '16.1' },
	'oldsubfiletype' => { 106 => 0xff },
	'olympusimageheight' => { 258 => 0x102f },
	'olympusimagewidth' => { 258 => 0x102e },
	'onetouchwb' => { 258 => 0x302 },
	'onsaledate' => { 419 => 'onSaleDate' },
	'onsaledatea-platform' => { 419 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 419 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 419 => 'onSaleDay' },
	'onsaledaya-platform' => { 419 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 419 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 124 => 0xfa3d, 126 => [0x6006,0xf006], 127 => 0x1000, 128 => 0xf, 131 => 0x1e, 143 => 'OpticalZoom' },
	'opticalzoomcode' => { 67 => 0xa },
	'opticalzoommode' => { 274 => 0x34 },
	'opticalzoomon' => { 340 => 0x219 },
	'optionenddate' => { 422 => 'optionEndDate' },
	'opto-electricconvfactor' => { 409 => 'OECF' },
	'orangehsl' => { 92 => 0x20911 },
	'ordernumber' => { 111 => 0x8002 },
	'organisationinimagecode' => { 415 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 415 => 'OrganisationInImageName' },
	'organization' => { 419 => 'organization' },
	'orientation' => { 106 => 0x112, 278 => 0x112, 418 => 'orientation', 425 => 'Orientation' },
	'orientation2' => { 365 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 73 => 0x516 },
	'originalbestqualitysize' => { 106 => 0xc792 },
	'originaldecisiondata' => { 103 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 55 => 0x83 },
	'originaldefaultcropsize' => { 106 => 0xc793 },
	'originaldefaultfinalsize' => { 106 => 0xc791 },
	'originaldirectory' => { 272 => 0x408 },
	'originaldocumentid' => { 430 => 'OriginalDocumentID' },
	'originalfilename' => { 86 => 0x816, 120 => 0x3e9, 132 => 0x20, 272 => 0x407, 395 => 'OriginalFilename' },
	'originalimageheight' => { 69 => 0xc, 110 => 0x1 },
	'originalimagewidth' => { 69 => 0xb, 110 => 0x0 },
	'originalrawfiledata' => { 106 => 0xc68c },
	'originalrawfiledigest' => { 106 => 0xc71d },
	'originalrawfilename' => { 106 => 0xc68b },
	'originaltransmissionreference' => { 114 => 0x67 },
	'originatingprogram' => { 114 => 0x41, 399 => 'OriginatingProgram' },
	'originplatform' => { 419 => 'originPlatform' },
	'os' => { 407 => 'os' },
	'otherconditions' => { 263 => 'OtherConditions' },
	'otherconstraints' => { 263 => 'OtherConstraints' },
	'otherimage' => { 103 => 'OtherImage' },
	'otherimageinfo' => { 263 => 'OtherImageInfo' },
	'otherimagelength' => { 106 => 0x202 },
	'otherimagestart' => { 106 => 0x201 },
	'otherlicensedocuments' => { 263 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 263 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 263 => 'OtherLicenseRequirements' },
	'outcue' => { 429 => 'outCue' },
	'outcuescale' => { 429 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 429 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 173 => 0x3 },
	'outputimagewidth' => { 173 => 0x2 },
	'outputprofile' => { 120 => 0x138b },
	'outputresolution' => { 173 => 0x4 },
	'owner' => { 433 => 'Owner' },
	'ownerid' => { 114 => 0xbc },
	'ownername' => { 14 => 0x10f, 55 => 0x9, 86 => 0x810, 106 => [0xa430,0xfde8], 136 => 'OwnerName', 401 => 'OwnerName', 410 => 'CameraOwnerName' },
	'padding' => { 106 => 0xea1c },
	'pagecount' => { 419 => 'pageCount' },
	'pageimage' => { 427 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 427 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 427 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 427 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 427 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 427 => 'PageInfo' },
	'pagename' => { 106 => 0x11d },
	'pagenumber' => { 106 => 0x129 },
	'pageprogressiondirection' => { 419 => 'pageProgressionDirection' },
	'pagerange' => { 419 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 405 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 405 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 274 => 0x26 },
	'panasonicimageheight' => { 274 => 0x4c },
	'panasonicimagewidth' => { 274 => 0x4b },
	'panasonicrawversion' => { 278 => 0x1 },
	'panasonictitle' => { 106 => 0xc6d2 },
	'panasonictitle2' => { 106 => 0xc6d3 },
	'panoramacropbottom' => { 366 => 0x7 },
	'panoramacropleft' => { 366 => 0x4 },
	'panoramacropright' => { 366 => 0x6 },
	'panoramacroptop' => { 366 => 0x5 },
	'panoramadirection' => { 63 => 0x5, 366 => 0x3 },
	'panoramaframeheight' => { 366 => 0x9 },
	'panoramaframenumber' => { 63 => 0x2 },
	'panoramaframewidth' => { 366 => 0x8 },
	'panoramafullheight' => { 366 => 0x2 },
	'panoramafullwidth' => { 366 => 0x1 },
	'panoramamode' => { 122 => 0x3c, 253 => 0x601 },
	'panoramasize3d' => { 351 => 0x38 },
	'panoramasourceheight' => { 366 => 0xb },
	'panoramasourcewidth' => { 366 => 0xa },
	'panoramicstitchcameramotion' => { 154 => 'PanoramicStitchCameraMotion', 155 => 0x1 },
	'panoramicstitchmaptype' => { 154 => 'PanoramicStitchMapType', 155 => 0x2 },
	'panoramicstitchphi0' => { 154 => 'PanoramicStitchPhi0', 155 => 0x5 },
	'panoramicstitchphi1' => { 154 => 'PanoramicStitchPhi1', 155 => 0x6 },
	'panoramicstitchtheta0' => { 154 => 'PanoramicStitchTheta0', 155 => 0x3 },
	'panoramicstitchtheta1' => { 154 => 'PanoramicStitchTheta1', 155 => 0x4 },
	'panoramicstitchversion' => { 155 => 0x0 },
	'pantry' => { 430 => 'Pantry' },
	'parallax' => { 111 => 0xb211, 252 => 0x28 },
	'parametricdarks' => { 405 => 'ParametricDarks' },
	'parametrichighlights' => { 405 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 405 => 'ParametricHighlightSplit' },
	'parametriclights' => { 405 => 'ParametricLights' },
	'parametricmidtonesplit' => { 405 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 405 => 'ParametricShadows' },
	'parametricshadowsplit' => { 405 => 'ParametricShadowSplit' },
	'parentmeid' => { 395 => 'ParentMEID' },
	'parentreference1' => { 413 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 413 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 429 => 'partOfCompilation' },
	'patientbirthdate' => { 392 => 'PatientDOB' },
	'patientid' => { 392 => 'PatientID' },
	'patientname' => { 392 => 'PatientName' },
	'patientsex' => { 392 => 'PatientSex' },
	'pdfversion' => { 416 => 'PDFVersion' },
	'pentaximagesize' => { 307 => 0x9 },
	'pentaxmodelid' => { 287 => 0x0, 307 => 0x5 },
	'pentaxmodeltype' => { 307 => 0x1 },
	'pentaxversion' => { 307 => 0x0 },
	'people' => { 393 => 'People', 397 => 'People' },
	'perchannelblacklevel' => { 37 => 0xc4, 38 => [0x2b4,0x2cb,0x2cf], 39 => 0x108, 40 => 0x1df, 41 => [0x1f8,0x2d8], 42 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 390 => 0x8030 },
	'peripheralillumcentralvalue' => { 390 => 0x8031 },
	'peripheralillumination' => { 92 => 0x20702, 98 => 0x68 },
	'peripheralilluminationcorr' => { 54 => 0x1, 297 => 0x2 },
	'peripheralilluminationon' => { 92 => '0x20702.0', 98 => 0x64 },
	'peripheralillumperiphvalue' => { 390 => 0x8032 },
	'peripherallighting' => { 69 => 0x2 },
	'peripherallightingsetting' => { 70 => 0x5 },
	'peripherallightingvalue' => { 69 => 0x6 },
	'permissions' => { 422 => 'permissions' },
	'permits' => { 402 => 'permits' },
	'person' => { 419 => 'person' },
	'personality' => { 395 => 'Personality' },
	'personinimage' => { 415 => 'PersonInImage' },
	'personinimagecharacteristic' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 415 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 415 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 405 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 405 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 405 => 'PerspectiveRotate' },
	'perspectivescale' => { 405 => 'PerspectiveScale' },
	'perspectiveupright' => { 405 => 'PerspectiveUpright' },
	'perspectivevertical' => { 405 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 81 => 0x1 },
	'pf10retainprogramshift' => { 81 => 0xb },
	'pf13drivepriority' => { 81 => 0xe },
	'pf14disablefocussearch' => { 81 => 0xf },
	'pf15disableafassistbeam' => { 81 => 0x10 },
	'pf16autofocuspointshoot' => { 81 => 0x11 },
	'pf17disableafpointsel' => { 81 => 0x12 },
	'pf18enableautoafpointsel' => { 81 => 0x13 },
	'pf19continuousshootspeed' => { 81 => 0x14 },
	'pf19shootingspeedhigh' => { 80 => 0xa },
	'pf19shootingspeedlow' => { 80 => 0x9 },
	'pf1disableshootingmodes' => { 81 => 0x2 },
	'pf1value' => { 80 => 0x1 },
	'pf20limitcontinousshots' => { 81 => 0x15 },
	'pf20maxcontinousshots' => { 80 => 0xb },
	'pf21enablequietoperation' => { 81 => 0x16 },
	'pf23felocktime' => { 80 => 0xd },
	'pf23postreleasetime' => { 80 => 0xe },
	'pf23settimerlengths' => { 81 => 0x18 },
	'pf23shutterbuttontime' => { 80 => 0xc },
	'pf24lightlcdduringbulb' => { 81 => 0x19 },
	'pf25aemode' => { 80 => 0xf },
	'pf25afmode' => { 80 => 0x12 },
	'pf25afpointsel' => { 80 => 0x13 },
	'pf25colormatrix' => { 80 => 0x17 },
	'pf25defaultclearsettings' => { 81 => 0x1a },
	'pf25drivemode' => { 80 => 0x11 },
	'pf25imagesize' => { 80 => 0x14 },
	'pf25meteringmode' => { 80 => 0x10 },
	'pf25parameters' => { 80 => 0x16 },
	'pf25wbmode' => { 80 => 0x15 },
	'pf26shortenreleaselag' => { 81 => 0x1b },
	'pf27reversedialrotation' => { 81 => 0x1c },
	'pf27value' => { 80 => 0x18 },
	'pf28noquickdialexpcomp' => { 81 => 0x1d },
	'pf29quickdialswitchoff' => { 81 => 0x1e },
	'pf2disablemeteringmodes' => { 81 => 0x3 },
	'pf2value' => { 80 => 0x2 },
	'pf30enlargementmode' => { 81 => 0x1f },
	'pf31originaldecisiondata' => { 81 => 0x20 },
	'pf3manualexposuremetering' => { 81 => 0x4 },
	'pf3value' => { 80 => 0x3 },
	'pf4exposuretimelimits' => { 81 => 0x5 },
	'pf4exposuretimemax' => { 80 => 0x5 },
	'pf4exposuretimemin' => { 80 => 0x4 },
	'pf5aperturelimits' => { 81 => 0x6 },
	'pf5aperturemax' => { 80 => 0x7 },
	'pf5aperturemin' => { 80 => 0x6 },
	'pf6presetshootingmodes' => { 81 => 0x7 },
	'pf7bracketcontinuousshoot' => { 81 => 0x8 },
	'pf8bracketshots' => { 80 => 0x8 },
	'pf8setbracketshots' => { 81 => 0x9 },
	'pf9changebracketsequence' => { 81 => 0xa },
	'phasedetectaf' => { 170 => 0x6 },
	'phonenumber' => { 137 => 'Phone' },
	'photoeffect' => { 31 => 0x28 },
	'photoeffecthistoryxml' => { 232 => 0xe9651831 },
	'photoeffects' => { 232 => 0xab5eca5e },
	'photoeffectsblue' => { 234 => 0x8 },
	'photoeffectsgreen' => { 234 => 0x6 },
	'photoeffectsred' => { 234 => 0x4 },
	'photoeffectstype' => { 234 => 0x0 },
	'photographicsensitivity' => { 410 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 239 => '17.6', 246 => '33.6' },
	'photometricinterpretation' => { 106 => 0x106, 425 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 212 => 0xe7d },
	'photoshootingmenubankimagearea' => { 212 => '3716.1' },
	'photoshopbgrthumbnail' => { 321 => 0x409 },
	'photoshopquality' => { 320 => 0x0 },
	'photoshopthumbnail' => { 321 => 0x40c },
	'photostyle' => { 274 => 0x89 },
	'picklabel' => { 408 => 'PickLabel' },
	'pictinfo' => { 340 => 0x208 },
	'picturecontrol' => { 232 => 0xe2173c47 },
	'picturecontrolactive' => { 235 => 0x0 },
	'picturecontroladjust' => { 196 => 0x30, 197 => 0x30 },
	'picturecontrolbase' => { 196 => 0x18, 197 => 0x18 },
	'picturecontroldata' => { 194 => [0xbd,0x23] },
	'picturecontrolmode' => { 235 => 0x13 },
	'picturecontrolname' => { 196 => 0x4, 197 => 0x4 },
	'picturecontrolquickadjust' => { 196 => 0x31, 197 => 0x31 },
	'pictureeffect' => { 361 => 0x200e },
	'pictureeffect2' => { 368 => 0x1163, 369 => 0x1167, 370 => 0x1143, 371 => 0x11bf, 372 => 0x119b, 373 => 0x1053, 374 => 0x24b, 375 => 0x24b, 386 => 0x46 },
	'picturefinish' => { 159 => 0x71 },
	'picturemode' => { 111 => 0x1031, 253 => 0x520, 307 => [0xb,0x33], 341 => 0x3d },
	'picturemode2' => { 288 => 0x0 },
	'picturemodebwfilter' => { 253 => 0x525 },
	'picturemodecontrast' => { 253 => 0x523 },
	'picturemodeeffect' => { 253 => 0x52d },
	'picturemodehue' => { 253 => 0x522 },
	'picturemodesaturation' => { 253 => 0x521 },
	'picturemodesharpness' => { 253 => 0x524 },
	'picturemodetone' => { 253 => 0x526 },
	'pictureprofile' => { 368 => [0x115e,0x115f], 369 => [0x1162,0x1163], 370 => [0x113e,0x113f], 371 => [0x11ba,0x11bb], 372 => [0x1196,0x1197], 373 => [0x104e,0x104f], 374 => [0x246,0x247], 375 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 65 => 0xa, 92 => 0x20301, 98 => 0x2 },
	'picturewizard' => { 338 => 0x21 },
	'picturewizardcolor' => { 337 => 0x1 },
	'picturewizardcontrast' => { 337 => 0x4 },
	'picturewizardmode' => { 337 => 0x0 },
	'picturewizardsaturation' => { 337 => 0x2 },
	'picturewizardsharpness' => { 337 => 0x3 },
	'pipelineversion' => { 154 => 'PipelineVersion' },
	'pitch' => { 240 => '4.1', 250 => '4.1' },
	'pitchangle' => { 211 => 0x350f, 253 => 0x904, 274 => 0x91, 306 => 0x2 },
	'pixelshiftresolution' => { 308 => 0x0 },
	'pixelsperunitx' => { 265 => 0x0 },
	'pixelsperunity' => { 265 => 0x4 },
	'pixelunits' => { 265 => 0x8 },
	'planarconfiguration' => { 106 => 0x11c, 425 => 'PlanarConfiguration' },
	'platenames' => { 434 => 'PlateNames' },
	'platform' => { 419 => 'platform' },
	'playbackmenustime' => { 243 => '20.1', 244 => '21.1', 245 => '21.1' },
	'playbackmonitorofftime' => { 239 => '25.2', 240 => '36.1', 242 => '36.1', 246 => '8.1', 247 => '35.1', 250 => '36.1', 251 => '21.1' },
	'playbackzoom' => { 240 => '37.1' },
	'playdisplay' => { 161 => 0x4e },
	'plusversion' => { 263 => 'Version' },
	'pmversion' => { 319 => 'PMVersion' },
	'pngwarning' => { 266 => 'Warning' },
	'poilevel' => { 193 => 0x8 },
	'portraitoutputhighlightpoint' => { 98 => 0x1d },
	'portraitoutputshadowpoint' => { 98 => 0x1e },
	'portraitrawcolortone' => { 98 => 0x16 },
	'portraitrawcontrast' => { 98 => 0x18 },
	'portraitrawhighlight' => { 98 => 0x76 },
	'portraitrawhighlightpoint' => { 98 => 0x1b },
	'portraitrawlinear' => { 98 => 0x19 },
	'portraitrawsaturation' => { 98 => 0x17 },
	'portraitrawshadow' => { 98 => 0x7f },
	'portraitrawshadowpoint' => { 98 => 0x1c },
	'portraitrawsharpness' => { 98 => 0x1a },
	'portraitrefiner' => { 102 => 0x302b },
	'portraitunsharpmaskfineness' => { 98 => 0x9a },
	'portraitunsharpmaskstrength' => { 98 => 0x98 },
	'portraitunsharpmaskthreshold' => { 98 => 0x9c },
	'poseheadingdegrees' => { 394 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 394 => 'PosePitchDegrees' },
	'poserolldegrees' => { 394 => 'PoseRollDegrees' },
	'positiondescriptor' => { 418 => 'positionDescriptor' },
	'postalcode' => { 141 => 'PostalCode' },
	'postcropvignetteamount' => { 405 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 405 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 405 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 405 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 405 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 405 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 359 => 0xb },
	'potentialface2position' => { 359 => 0x15 },
	'potentialface3position' => { 359 => 0x1f },
	'potentialface4position' => { 359 => 0x29 },
	'potentialface5position' => { 359 => 0x33 },
	'potentialface6position' => { 359 => 0x3d },
	'potentialface7position' => { 359 => 0x47 },
	'potentialface8position' => { 359 => 0x51 },
	'powersource' => { 286 => '0.1' },
	'poweruptime' => { 194 => 0xb6 },
	'precaptureframes' => { 258 => 0x300 },
	'predictor' => { 106 => 0x13d },
	'preflashreturnstrength' => { 209 => 0x28a },
	'prefs' => { 114 => 0xdd, 319 => 'Prefs' },
	'preservedfilename' => { 430 => 'PreservedFileName' },
	'presetwhitebalance' => { 161 => 0x24, 390 => 0x8002 },
	'presetwhitebalanceadj' => { 390 => 0x8014 },
	'previewapplicationname' => { 106 => 0xc716 },
	'previewapplicationversion' => { 106 => 0xc717 },
	'previewbutton' => { 239 => ['14.1','15.1'], 240 => '15.1', 242 => '15.1', 246 => '29.1', 247 => '14.1', 250 => '15.1' },
	'previewbuttonplusdials' => { 239 => ['14.2','15.2'], 240 => '15.2', 242 => '43.1', 246 => '31.2', 250 => '43.1' },
	'previewcolorspace' => { 106 => 0xc71a },
	'previewcropbottom' => { 318 => 0xef },
	'previewcropleft' => { 318 => 0xec },
	'previewcropright' => { 318 => 0xee },
	'previewcroptop' => { 318 => 0xed },
	'previewdate' => { 326 => 0x0 },
	'previewdatetime' => { 106 => 0xc71b },
	'previewimage' => { 102 => 0x2000, 103 => 'PreviewImage', 107 => 'PreviewImage', 109 => 0x4, 146 => 'data', 163 => 0x81, 258 => 0x280, 273 => 0x300, 361 => 0x2001 },
	'previewimageborders' => { 307 => 0x3e },
	'previewimageheight' => { 64 => 0x4, 124 => 0xfa58 },
	'previewimagelength' => { 64 => 0x2, 102 => 0x3, 106 => [0x117,0x202], 163 => 0x89, 198 => 0x202, 253 => 0x102, 258 => 0x1037, 307 => 0x3, 331 => 0x1e, 336 => 0x3, 341 => [0x1b,0x1d], 352 => 0x202 },
	'previewimagename' => { 146 => '1Name' },
	'previewimagesize' => { 102 => 0x2, 129 => 0x2, 146 => 'ImageSize', 307 => 0x2, 341 => [0x1c,0x1e], 361 => 0xb02c },
	'previewimagestart' => { 64 => 0x5, 102 => 0x4, 106 => [0x111,0x201], 163 => 0x88, 198 => 0x201, 253 => 0x101, 258 => 0x1036, 307 => 0x4, 331 => 0x1c, 336 => 0x2, 341 => [0x1a,0x1c], 352 => 0x201 },
	'previewimagetype' => { 146 => '0Type' },
	'previewimagevalid' => { 253 => 0x100, 258 => 0x1035 },
	'previewimagewidth' => { 64 => 0x3, 124 => 0xfa57 },
	'previewquality' => { 64 => 0x1 },
	'previewsettingsdigest' => { 106 => 0xc719 },
	'previewsettingsname' => { 106 => 0xc718 },
	'primaryafpoint' => { 170 => 0x7 },
	'primarychromaticities' => { 106 => 0x13f, 425 => 'PrimaryChromaticities' },
	'printim' => { 106 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 161 => 0x1d, 349 => 0x28 },
	'privatertkinfo' => { 396 => 'privateRTKInfo' },
	'processingsoftware' => { 106 => 0xb },
	'processversion' => { 405 => 'ProcessVersion' },
	'producer' => { 262 => 'Producer', 416 => 'Producer' },
	'productcode' => { 419 => 'productCode' },
	'productid' => { 115 => 0x32, 418 => 'productID' },
	'productidtype' => { 418 => 'productIDType' },
	'productinimage' => { 415 => 'ProductInImage' },
	'productinimagedescription' => { 415 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 415 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 415 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 287 => 0x2 },
	'productorserviceconstraints' => { 263 => 'ProductOrServiceConstraints' },
	'profession' => { 419 => 'profession' },
	'profilecalibrationsig' => { 106 => 0xc6f4 },
	'profilecopyright' => { 106 => 0xc6fe },
	'profileembedpolicy' => { 106 => 0xc6fd },
	'profilehuesatmapdata1' => { 106 => 0xc6fa },
	'profilehuesatmapdata2' => { 106 => 0xc6fb },
	'profilehuesatmapdims' => { 106 => 0xc6f9 },
	'profilehuesatmapencoding' => { 106 => 0xc7a3 },
	'profilelooktabledata' => { 106 => 0xc726 },
	'profilelooktabledims' => { 106 => 0xc725 },
	'profilelooktableencoding' => { 106 => 0xc7a4 },
	'profilename' => { 106 => 0xc6f8 },
	'profiletonecurve' => { 106 => 0xc6fc },
	'programiso' => { 274 => 0x3c },
	'programline' => { 288 => '1.1' },
	'programmode' => { 166 => 0x5 },
	'programshift' => { 194 => 0xd },
	'programversion' => { 114 => 0x46 },
	'prohibits' => { 402 => 'prohibits' },
	'projectiontype' => { 394 => 'ProjectionType' },
	'projectname' => { 429 => 'projectName' },
	'projectref' => { 429 => 'projectRef' },
	'projectrefpath' => { 429 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 429 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 263 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 263 => 'PropertyReleaseStatus' },
	'province-state' => { 114 => 0x5f },
	'publicationdate' => { 419 => 'publicationDate' },
	'publicationdatea-platform' => { 419 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 419 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 419 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 419 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 419 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 419 => 'publicationName' },
	'publisher' => { 406 => 'publisher' },
	'publishingfrequency' => { 419 => 'publishingFrequency' },
	'pulldown' => { 429 => 'pullDown' },
	'purplehsl' => { 92 => 0x20916 },
	'quality' => { 0 => 0x1, 31 => 0x3, 101 => 0x2, 102 => 0x3002, 111 => 0x1000, 122 => 0x9, 194 => 0x4, 222 => 0x3, 258 => 0x201, 270 => 0x300, 307 => 0x8, 314 => 0x2, 341 => 0x16, 349 => 0x56, 350 => 0x56, 351 => 0xb, 361 => 0x102 },
	'quality2' => { 368 => 0x1170, 369 => 0x1174, 370 => 0x1150, 372 => 0x11a8, 373 => 0x1060, 374 => 0x258, 375 => 0x258, 378 => 0x29, 379 => 0x25, 380 => 0x2a },
	'qualitymode' => { 102 => 0x8 },
	'quantizationmethod' => { 116 => 0x78 },
	'quickadjust' => { 235 => 0x2a },
	'quickcontroldialinmeter' => { 73 => 0x703 },
	'quickfix' => { 232 => 0x416391c6 },
	'quickshot' => { 340 => 0x213 },
	'rangefinder' => { 243 => '4.1', 244 => '5.1', 245 => '5.1' },
	'rasterizedcaption' => { 114 => 0x7d },
	'rating' => { 106 => 0x4746, 111 => 0x1431, 318 => 0xdf, 361 => 0x2002, 399 => 'rating', 407 => 'rating', 419 => 'rating', 427 => 'Rating' },
	'ratingpercent' => { 106 => 0x4749, 156 => 'Rating' },
	'rawandjpgrecording' => { 71 => 0x8, 163 => 0x109, 288 => 0xd },
	'rawbrightnessadj' => { 92 => 0x20001, 97 => 0x38 },
	'rawcoloradj' => { 97 => 0x2e },
	'rawcompressionmode' => { 338 => 0x45 },
	'rawcropbottom' => { 318 => 0xd4 },
	'rawcropleft' => { 318 => 0xd1 },
	'rawcropright' => { 318 => 0xd3 },
	'rawcroptop' => { 318 => 0xd2 },
	'rawcustomsaturation' => { 97 => 0x30 },
	'rawcustomtone' => { 97 => 0x34 },
	'rawdata' => { 338 => 0xa048 },
	'rawdatauniqueid' => { 106 => 0xc65d },
	'rawdepth' => { 165 => 0x10 },
	'rawdevartfilter' => { 260 => 0x121 },
	'rawdevautogradation' => { 260 => 0x119 },
	'rawdevcolorspace' => { 259 => 0x108, 260 => 0x109 },
	'rawdevcontrastvalue' => { 259 => 0x106, 260 => 0x105 },
	'rawdeveditstatus' => { 259 => 0x10b },
	'rawdevelopmentprocess' => { 307 => 0x62 },
	'rawdevengine' => { 259 => 0x109, 260 => 0x10b },
	'rawdevexposurebiasvalue' => { 259 => 0x100, 260 => 0x100 },
	'rawdevgradation' => { 260 => 0x112 },
	'rawdevgraypoint' => { 259 => 0x103, 260 => 0x104 },
	'rawdevmemorycoloremphasis' => { 259 => 0x105, 260 => 0x108 },
	'rawdevnoisereduction' => { 259 => 0x10a, 260 => 0x10a },
	'rawdevpicturemode' => { 260 => 0x10c },
	'rawdevpm_bwfilter' => { 260 => 0x110 },
	'rawdevpmcontrast' => { 260 => 0x10e },
	'rawdevpmnoisefilter' => { 260 => 0x120 },
	'rawdevpmpicturetone' => { 260 => 0x111 },
	'rawdevpmsaturation' => { 260 => 0x10d },
	'rawdevpmsharpness' => { 260 => 0x10f },
	'rawdevsaturation3' => { 260 => 0x113 },
	'rawdevsaturationemphasis' => { 259 => 0x104, 260 => 0x107 },
	'rawdevsettings' => { 259 => 0x10c },
	'rawdevsharpnessvalue' => { 259 => 0x107, 260 => 0x106 },
	'rawdevversion' => { 259 => 0x0, 260 => 0x0 },
	'rawdevwbfineadjustment' => { 259 => 0x102, 260 => 0x103 },
	'rawdevwhitebalance' => { 260 => 0x101 },
	'rawdevwhitebalancevalue' => { 259 => 0x101, 260 => 0x102 },
	'rawfile' => { 106 => 0xfe4c },
	'rawfilename' => { 405 => 'RawFileName' },
	'rawformat' => { 316 => 0x10e },
	'rawimagecenter' => { 194 => 0x99 },
	'rawimagedigest' => { 106 => 0xc71c },
	'rawimagesize' => { 307 => 0x39 },
	'rawinfoversion' => { 261 => 0x0 },
	'rawjpgheight' => { 88 => 0x4 },
	'rawjpgquality' => { 49 => 0x6, 88 => 0x1 },
	'rawjpgsize' => { 49 => 0x7, 88 => 0x2 },
	'rawjpgwidth' => { 88 => 0x3 },
	'rawmeasuredrggb' => { 36 => 0x26a, 38 => 0x280, 40 => 0x194, 41 => [0x1ad,0x26b] },
	'rawrppused' => { 399 => 'rawrppused' },
	'rawtopreviewgain' => { 106 => 0xc7a8 },
	'reardisplay' => { 239 => '12.3', 240 => '6.2' },
	'recipeendingpage' => { 421 => 'recipeEndingPage' },
	'recipepagerange' => { 421 => 'recipePageRange' },
	'recipesource' => { 421 => 'recipeSource' },
	'recipestartingpage' => { 421 => 'recipeStartingPage' },
	'recipetitle' => { 421 => 'recipeTitle' },
	'recognizedface1age' => { 269 => 0x20 },
	'recognizedface1name' => { 269 => 0x4 },
	'recognizedface1position' => { 269 => 0x18 },
	'recognizedface2age' => { 269 => 0x50 },
	'recognizedface2name' => { 269 => 0x34 },
	'recognizedface2position' => { 269 => 0x48 },
	'recognizedface3age' => { 269 => 0x80 },
	'recognizedface3name' => { 269 => 0x64 },
	'recognizedface3position' => { 269 => 0x78 },
	'recognizedfaceflags' => { 274 => 0x63 },
	'recommendedexposureindex' => { 106 => 0x8832, 410 => 'RecommendedExposureIndex' },
	'record' => { 105 => 'Record' },
	'recordbasisofrecord' => { 105 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 105 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 105 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 105 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 105 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 105 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 161 => 0x4d },
	'recorddynamicproperties' => { 105 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 86 => 0x1804 },
	'recordinformationwithheld' => { 105 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 332 => 0x1000 },
	'recordingmode' => { 101 => 0x1, 314 => 0x1 },
	'recordinstitutioncode' => { 105 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 105 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 31 => 0x9, 102 => 0x3000 },
	'recordownerinstitutioncode' => { 105 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 340 => 0x217 },
	'redbalance' => { 178 => 0x270, 258 => 0x1017, 278 => 0x11, 307 => 0x1c },
	'redcurvelimits' => { 97 => 0x18a },
	'redcurvepoints' => { 96 => 0x2d, 97 => 0x160 },
	'redeyecorrection' => { 236 => 0x0 },
	'redeyeinfo' => { 405 => 'RedEyeInfo' },
	'redeyereduction' => { 161 => 0x41, 349 => 0x6a, 351 => 0x28 },
	'redhsl' => { 92 => 0x20910 },
	'redhue' => { 405 => 'RedHue' },
	'redsaturation' => { 405 => 'RedSaturation' },
	'reductionmatrix1' => { 106 => 0xc625 },
	'reductionmatrix2' => { 106 => 0xc626 },
	'reelname' => { 106 => 0xc789 },
	'reference1' => { 413 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 413 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 106 => 0x214, 425 => 'ReferenceBlackWhite' },
	'referencedate' => { 114 => 0x2f },
	'referencenumber' => { 114 => 0x32 },
	'references' => { 137 => 'References' },
	'referenceservice' => { 114 => 0x2d },
	'regionappliedtodimensions' => { 152 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 152 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 152 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 152 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 152 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 152 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 152 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 152 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 152 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 152 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 152 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 152 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 263 => 'RegionConstraints' },
	'regiondescription' => { 152 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 152 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 152 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 152 => 'Regions' },
	'regioninfodateregionsvalid' => { 153 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 153 => 'RegionInfo' },
	'regioninforegions' => { 153 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 152 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 152 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 153 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 152 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 152 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 152 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 415 => 'RegistryId' },
	'registryitemid' => { 415 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 415 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 135 => 'data' },
	'relatedaudiofilename' => { 135 => '1Name' },
	'relatedaudiofiletype' => { 135 => '0Type' },
	'relatedimagefileformat' => { 106 => 0x1000 },
	'relatedimageheight' => { 106 => 0x1002 },
	'relatedimagewidth' => { 106 => 0x1001 },
	'relatedresourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 106 => 0xa004, 409 => 'RelatedSoundFile' },
	'relatedvideofile' => { 149 => 'data' },
	'relatedvideofilename' => { 149 => '1Name' },
	'relatedvideofiletype' => { 149 => '0Type' },
	'relation' => { 406 => 'relation' },
	'relationshipaccordingto' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 429 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 429 => 'relativeTimestamp' },
	'relativetimestampscale' => { 429 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 429 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 239 => '17.8', 240 => '18.5', 242 => '18.4', 246 => '33.8', 247 => '17.6', 250 => '18.5' },
	'releasedate' => { 114 => 0x1e, 399 => 'ReleaseDate', 429 => 'releaseDate' },
	'releasemode' => { 102 => 0x3001, 361 => 0xb049 },
	'releasemode2' => { 368 => 0x112c, 369 => [0x112c,0x8], 370 => [0x1108,0x8], 371 => [0x1184,0x8], 372 => [0x1160,0x8], 373 => [0x4,0x1018], 374 => [0x4,0x210], 375 => [0x4,0x210], 377 => [0x67,0x73,0x3f,0x4b], 378 => 0x10, 379 => 0x10, 380 => 0x9, 386 => 0x34 },
	'releasemode3' => { 368 => 0x1128, 369 => 0x1128, 370 => 0x1104, 371 => 0x1180, 372 => 0x115c, 373 => 0x1014, 374 => 0x20c, 375 => 0x20c },
	'releasesetting' => { 86 => 0x1016 },
	'releasetime' => { 114 => 0x23, 399 => 'ReleaseTime' },
	'remoteonduration' => { 241 => '3.4', 243 => '17.2', 244 => '18.2', 245 => '18.2', 247 => '18.2', 248 => '4.3', 251 => '19.2' },
	'renditionclass' => { 430 => 'RenditionClass' },
	'renditionof' => { 430 => 'RenditionOf' },
	'renditionofalternatepaths' => { 430 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 430 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 430 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 430 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 430 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 430 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 430 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 430 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 430 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 430 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 430 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 430 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 430 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 430 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 430 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 430 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 430 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 430 => 'RenditionParams' },
	'repeatingflashcount' => { 183 => 0xd, 184 => 0xe, 185 => 0xe, 246 => '17.2', 247 => '24.2', 248 => '9.2', 249 => '24.2', 251 => '25.2' },
	'repeatingflashcountbuilt-in' => { 219 => 0x4db },
	'repeatingflashcountexternal' => { 219 => 0x4c3 },
	'repeatingflashoutput' => { 246 => '17.1', 247 => '24.1', 248 => '9.1', 249 => '24.1', 251 => '25.1' },
	'repeatingflashoutputexternal' => { 219 => 0x4c0 },
	'repeatingflashrate' => { 183 => 0xc, 184 => 0xd, 185 => 0xd, 246 => '18.1', 247 => '25.1', 248 => '10.1', 249 => '25.1', 251 => '26.1' },
	'repeatingflashratebuilt-in' => { 219 => 0x4da },
	'repeatingflashrateexternal' => { 219 => 0x4c2 },
	'requires' => { 402 => 'requires' },
	'resampleparams' => { 429 => 'resampleParams' },
	'resampleparamsquality' => { 429 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 340 => 0x21e },
	'resolution' => { 142 => 'Resolution' },
	'resolutionmode' => { 341 => 0x4 },
	'resolutionunit' => { 106 => 0x128, 117 => 0x2, 425 => 'ResolutionUnit' },
	'resourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 105 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 73 => 0x612 },
	'restrictions' => { 422 => 'restrictions' },
	'retouchareafeather' => { 405 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 405 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 405 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 405 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 405 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 405 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 405 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 405 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 405 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 405 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 405 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 405 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 405 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 405 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 405 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 405 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 405 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 405 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 405 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 405 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 405 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 405 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 405 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 405 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 405 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 405 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 405 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 405 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 405 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 405 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 405 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 405 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 405 => 'RetouchAreas' },
	'retouchareaseed' => { 405 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 405 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 405 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 405 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 194 => 0x9e },
	'retouchinfo' => { 405 => 'RetouchInfo' },
	'retouchnefprocessing' => { 200 => 0x5 },
	'retractlensonpoweroff' => { 73 => 0x814 },
	'reuse' => { 263 => 'Reuse' },
	'reuseallowed' => { 432 => 'ReuseAllowed' },
	'reuseprohibited' => { 422 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 245 => '5.2' },
	'reverseindicators' => { 239 => '12.1', 240 => '6.1', 242 => '6.1', 243 => '4.3', 244 => '5.2', 245 => '5.4', 246 => '33.5', 247 => '5.1', 250 => '6.1', 251 => '6.2' },
	'reverseshutterspeedaperture' => { 245 => '5.3' },
	'revision' => { 407 => 'revision' },
	'rgbcurvelimits' => { 97 => 0x238 },
	'rgbcurvepoints' => { 96 => 0x7, 97 => 0x20e },
	'richtextcomment' => { 412 => 'RichTextComment' },
	'ricohdate' => { 331 => 0x6 },
	'ricohimageheight' => { 331 => 0x2 },
	'ricohimagewidth' => { 331 => 0x0 },
	'rightascension' => { 145 => 'RightAscension' },
	'rights' => { 406 => 'rights' },
	'rightsagent' => { 422 => 'rightsAgent' },
	'rightsowner' => { 422 => 'rightsOwner' },
	'rollangle' => { 211 => 0x350b, 253 => 0x903, 274 => 0x90, 306 => 0x1 },
	'romoperationmode' => { 86 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 85 => 0x3, 92 => 0x10002, 97 => 0x26e, 110 => 0x4, 145 => 'Rotation', 159 => [0x65,0x50], 160 => 0x46, 161 => 0x5a, 164 => 0x10, 218 => '590.1', 232 => 0x76a43207, 274 => 0x30, 288 => '17.2', 318 => 0xd8, 349 => 0x3f, 350 => 0x3f, 360 => 0x10 },
	'routedto' => { 411 => 'RoutedTo' },
	'routing' => { 323 => 'Routing' },
	'routingnotes' => { 411 => 'RoutingNotes' },
	'rowsperstrip' => { 106 => 0x116 },
	'rpp' => { 399 => 'rpp' },
	'safetyshift' => { 73 => 0x108 },
	'safetyshiftinavortv' => { 71 => 0x10, 72 => 0x10, 74 => 0xf, 75 => 0x10, 78 => 0x10 },
	'sameexposurefornewaperture' => { 73 => 0x112 },
	'samplebits' => { 135 => 'SampleBits' },
	'samplepagerange' => { 419 => 'samplePageRange' },
	'samplerate' => { 135 => 'SampleRate' },
	'samplesperpixel' => { 106 => 0x115, 425 => 'SamplesPerPixel' },
	'samplestructure' => { 116 => 0x5a },
	'samsungmodelid' => { 338 => 0x3 },
	'sanyoquality' => { 340 => 0x201 },
	'sanyothumbnail' => { 340 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 31 => 0xe, 43 => 0x1, 101 => 0xd, 102 => [0x3013,0x1f], 106 => [0xa409,0xfe55], 111 => 0x1003, 136 => 'Saturation', 158 => 0x1f, 159 => 0x32, 160 => 0x28, 161 => 0x1a, 166 => 0x1, 194 => [0x94,0xaa], 196 => 0x35, 197 => 0x3b, 274 => 0x40, 276 => 0x300d, 307 => 0x1f, 314 => 0xd, 328 => 0x27, 331 => 0x28, 332 => 0x1013, 341 => 0x10, 349 => 0x1e, 350 => 0x1b, 361 => 0x2005, 405 => 'Saturation', 409 => 'Saturation' },
	'saturationadj' => { 92 => 0x20901, 97 => 0x116, 231 => 0x1, 235 => 0x2e, 390 => 0x8016 },
	'saturationadjustmentaqua' => { 405 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 405 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 405 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 405 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 405 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 405 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 405 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 405 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 62 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 61 => 0x68, 62 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 61 => 0x38, 62 => 0x38 },
	'saturationmonochrome' => { 61 => 0x80, 62 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 61 => 0x50, 62 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 61 => 0x20, 62 => 0x20 },
	'saturationsetting' => { 261 => 0x1010, 351 => 0x11, 365 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 61 => 0x8, 62 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 61 => 0x98, 62 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 61 => 0xb0, 62 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 61 => 0xc8, 62 => 0xe0 },
	'saveid' => { 430 => 'SaveID' },
	'scaletype' => { 429 => 'scaleType' },
	'scanimageenhancer' => { 201 => 0x60 },
	'scanningdirection' => { 116 => 0x64 },
	'scene' => { 414 => 'Scene', 429 => 'scene' },
	'scenearea' => { 256 => 0x211, 258 => 0x1031 },
	'sceneassist' => { 194 => 0x9c },
	'scenecapturetype' => { 106 => 0xa406, 409 => 'SceneCaptureType' },
	'scenedetect' => { 256 => 0x210, 258 => 0x1030 },
	'scenedetectdata' => { 256 => 0x212, 258 => 0x1033 },
	'scenemode' => { 124 => 0xfa02, 163 => 0x100, 194 => 0x8f, 253 => 0x509, 258 => 0x403, 274 => 0x8001, 282 => 0xf, 361 => 0xb023 },
	'scenemodeused' => { 126 => [0x6002,0xf002] },
	'sceneselect' => { 340 => 0x21f },
	'scenetype' => { 106 => 0xa301, 409 => 'SceneType' },
	'screentips' => { 239 => '12.7', 240 => '5.3', 246 => '13.1', 247 => '4.4', 250 => '5.4', 251 => '5.1' },
	'season' => { 418 => 'season' },
	'section' => { 419 => 'section' },
	'securityclassification' => { 106 => 0x9212 },
	'selectableafpoint' => { 73 => 0x509 },
	'selectafareaselectmode' => { 73 => 0x512 },
	'selftimer' => { 31 => 0x2, 274 => 0x2e, 340 => 0x214, 368 => 0x1134, 369 => 0x1134, 370 => 0x1110, 371 => 0x118c, 372 => 0x1168, 373 => 0x1020, 374 => 0x218, 375 => 0x218 },
	'selftimer2' => { 67 => 0x1d },
	'selftimerinterval' => { 247 => '19.2' },
	'selftimermode' => { 106 => 0x882b },
	'selftimershotcount' => { 240 => '20.2', 242 => '20.3', 243 => '18.2', 244 => '19.2', 245 => '19.2', 247 => '19.3', 250 => '20.3', 251 => '20.2' },
	'selftimershotinterval' => { 240 => '20.3', 242 => '20.2', 250 => '20.2' },
	'selftimertime' => { 86 => 0x1806, 161 => 0x1f, 239 => '18.1', 240 => '20.1', 241 => '3.3', 242 => '20.1', 243 => '18.1', 244 => '19.1', 245 => '19.1', 246 => '7.2', 247 => '19.1', 248 => '3.3', 250 => '20.1', 251 => '20.1' },
	'sellingagency' => { 419 => 'sellingAgency' },
	'seminfo' => { 106 => 0x8546 },
	'sensingmethod' => { 106 => 0xa217, 409 => 'SensingMethod' },
	'sensitivityadjust' => { 307 => 0x40 },
	'sensitivitysteps' => { 288 => ['14.3','17.4'], 290 => 0x1 },
	'sensitivitytype' => { 106 => 0x8830, 410 => 'SensitivityType' },
	'sensor' => { 168 => 0x665e },
	'sensorareas' => { 338 => 0xa010 },
	'sensorbitdepth' => { 276 => 0x312d },
	'sensorbluelevel' => { 65 => 0x5 },
	'sensorcalibration' => { 257 => 0x805 },
	'sensorcleaning' => { 79 => 0xd },
	'sensorfullheight' => { 119 => 0xf904 },
	'sensorfullwidth' => { 119 => 0xf903 },
	'sensorheight' => { 119 => 0xf901, 124 => 0xfa21, 165 => 0x8, 276 => 0x312c, 316 => 0x109, 332 => 0x1602 },
	'sensorleftmargin' => { 316 => 0x10a },
	'sensorpixelsize' => { 194 => 0x9a },
	'sensorredlevel' => { 65 => 0x4 },
	'sensorserialnumber' => { 120 => 0x9ce },
	'sensorsize' => { 136 => 'SensorSize', 307 => 0x35 },
	'sensortemperature' => { 256 => 0x1500, 258 => 0x1007, 312 => 0xc, 316 => 0x210, 341 => [0x39,0x55] },
	'sensortemperature2' => { 312 => 0xe, 316 => 0x211 },
	'sensortopmargin' => { 316 => 0x10b },
	'sensorwidth' => { 119 => 0xf900, 124 => 0xfa20, 165 => 0xa, 276 => 0x312b, 316 => 0x108, 332 => 0x1601 },
	'sequence' => { 328 => 0x7 },
	'sequencefilenumber' => { 369 => 0x4, 370 => 0x4, 371 => 0x4, 372 => 0x4, 378 => 0xc, 379 => 0xc, 380 => 0x1a },
	'sequenceimagenumber' => { 369 => 0x0, 370 => 0x0, 371 => 0x0, 372 => 0x0, 378 => 0x8, 379 => 0x8, 380 => 0x12, 386 => 0x24 },
	'sequencelength' => { 378 => 0x22, 379 => 0x1e, 380 => [0x16,0x1e] },
	'sequencename' => { 418 => 'sequenceName' },
	'sequencenumber' => { 67 => 0x9, 102 => 0x301c, 111 => 0x1101, 122 => 0x1d, 219 => 0x51c, 274 => 0x2b, 351 => [0x10c,0x30c], 361 => 0xb04a, 418 => 'sequenceNumber' },
	'sequenceshotinterval' => { 340 => 0x224 },
	'sequencetotalnumber' => { 418 => 'sequenceTotalNumber' },
	'sequentialshot' => { 340 => 0x20e },
	'serialnumber' => { 55 => 0xc, 86 => 0x180b, 106 => [0xa431,0xfde9], 119 => 0xfa04, 121 => 0xfa00, 123 => 0xc354, 124 => 0xfa19, 133 => 0x0, 136 => 'SerialNumber', 194 => [0xa0,0x1d], 254 => 0x101, 258 => [0x404,0x101a], 270 => 0x303, 276 => 0x3103, 307 => 0x229, 316 => 0x102, 317 => 0x407, 328 => 0x15, 332 => 0x5, 341 => 0x2, 401 => 'SerialNumber', 410 => 'BodySerialNumber' },
	'serialnumberformat' => { 55 => 0x15, 86 => 0x183b },
	'seriesdatetime' => { 392 => 'SeriesDateTime' },
	'seriesdescription' => { 392 => 'SeriesDescription' },
	'seriesmodality' => { 392 => 'SeriesModality' },
	'seriesnumber' => { 392 => 'SeriesNumber', 419 => 'seriesNumber' },
	'seriestitle' => { 419 => 'seriesTitle' },
	'serviceidentifier' => { 115 => 0x1e },
	'servingsize' => { 421 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 76 => 0x0, 77 => 0x0 },
	'setbuttonwhenshooting' => { 71 => 0x1, 73 => 0x704, 79 => 0xc },
	'setfunctionwhenshooting' => { 74 => 0x0, 75 => 0x1, 78 => 0x1 },
	'setting' => { 418 => 'setting' },
	'shadingcompensation' => { 253 => 0x50c, 274 => 0x8a },
	'shadingcompensation2' => { 257 => 0x1012 },
	'shadow' => { 341 => 0xe },
	'shadowadj' => { 92 => 0x2030b },
	'shadowcorrection' => { 307 => 0x79 },
	'shadowprotection' => { 231 => 0x0 },
	'shadows' => { 106 => 0xfe52, 398 => 'Shadows', 405 => 'Shadows' },
	'shadows2012' => { 405 => 'Shadows2012' },
	'shadowscale' => { 106 => 0xc633 },
	'shadowtint' => { 405 => 'ShadowTint' },
	'shadowtone' => { 111 => 0x1040 },
	'shakereduction' => { 309 => 0x1, 310 => 0x1 },
	'sharpendetail' => { 405 => 'SharpenDetail' },
	'sharpenedgemasking' => { 405 => 'SharpenEdgeMasking' },
	'sharpening' => { 276 => 0x300b },
	'sharpeningadj' => { 235 => 0x2b },
	'sharpenradius' => { 405 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 31 => 0xf, 65 => 0x2, 101 => 0xb, 102 => [0x3011,0x21], 106 => [0xa40a,0xfe56], 111 => 0x1001, 122 => 0x6b, 131 => 0x37, 136 => 'Sharpness', 158 => 0x21, 159 => 0x30, 160 => 0x26, 161 => 0x18, 166 => 0x3, 194 => 0x6, 196 => 0x32, 197 => 0x33, 258 => 0x100f, 274 => 0x41, 307 => 0x21, 314 => 0xb, 328 => 0x26, 331 => 0x22, 332 => [0x1003,0x1014], 341 => 0x11, 349 => 0x1c, 350 => 0x19, 361 => 0x2006, 386 => 0x52, 405 => 'Sharpness', 409 => 'Sharpness' },
	'sharpnessadj' => { 92 => 0x20310, 97 => 0x25a, 390 => 0x801a },
	'sharpnessadjon' => { 92 => '0x20310.0' },
	'sharpnessauto' => { 62 => 0x94 },
	'sharpnessfactor' => { 258 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 61 => 0x64, 62 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 65 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 61 => 0x34, 62 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 61 => 0x7c, 62 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 61 => 0x4c, 62 => 0x4c },
	'sharpnessovershoot' => { 390 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 61 => 0x1c, 62 => 0x1c },
	'sharpnesssetting' => { 253 => 0x506, 261 => 0x1013, 351 => 0x12, 365 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 61 => 0x4, 62 => 0x4 },
	'sharpnessstrength' => { 92 => 0x20311 },
	'sharpnessthreshold' => { 390 => 0x801d },
	'sharpnessundershoot' => { 390 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 61 => 0x94, 62 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 61 => 0xac, 62 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 61 => 0xc4, 62 => 0xdc },
	'shootid' => { 418 => 'shootID' },
	'shootingdistance' => { 92 => 0x20701 },
	'shootinginfodisplay' => { 239 => '13.2', 240 => '5.1', 246 => '10.2', 247 => '4.1', 250 => '5.1', 251 => '5.3' },
	'shootinginfomonitorofftime' => { 239 => '26.2', 240 => '22.2', 242 => '22.2', 246 => '9.1', 247 => '21.2', 250 => '22.2', 251 => '22.2' },
	'shootingmode' => { 136 => 'ShootingMode', 194 => 0x89, 274 => 0x1f },
	'shootingmodesetting' => { 241 => '5.1' },
	'shortdescription' => { 407 => 'shortdescription' },
	'shortdocumentid' => { 114 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 73 => 0x80d },
	'shotdate' => { 429 => 'shotDate' },
	'shotday' => { 429 => 'shotDay' },
	'shotlocation' => { 429 => 'shotLocation' },
	'shotname' => { 429 => 'shotName' },
	'shotnumber' => { 429 => 'shotNumber' },
	'shotnumbersincepowerup' => { 364 => 0x44e, 378 => 0x1a, 379 => 0x16, 380 => 0xa },
	'shotnumbersincepowerup2' => { 351 => 0x200 },
	'shotsize' => { 429 => 'shotSize' },
	'shutter-aelock' => { 71 => 0x4, 73 => 0x701, 74 => 0x3, 75 => 0x4, 76 => 0x3, 77 => 0x3, 78 => 0x4, 79 => 0x2 },
	'shutteraelbutton' => { 72 => 0x4 },
	'shutterbuttonafonbutton' => { 73 => 0x701 },
	'shuttercount' => { 10 => 0x176, 49 => 0x1, 194 => 0xa7, 202 => [0x6a,0x157,0x24d], 203 => 0x286, 204 => 0x279, 205 => 0x284, 206 => 0x242, 207 => 0x280, 208 => 0x276, 209 => [0x27d,0x27f], 210 => 0x246, 213 => 0x2d6, 214 => 0x321, 215 => 0xbd8, 216 => 0x287, 217 => 0x320, 218 => 0x24a, 219 => 0x5fb, 221 => 0x2d5, 307 => 0x5d, 360 => 0x846, 363 => [0x125,0x14a] },
	'shuttercurtainsync' => { 71 => 0xf, 72 => 0xf, 73 => 0x305, 74 => 0xe, 75 => 0xf, 76 => 0x8, 77 => 0x8, 78 => 0xf, 79 => 0x8 },
	'shuttermode' => { 122 => 0x1b },
	'shutterreleasebuttonae-l' => { 239 => '17.7', 240 => '18.4', 242 => '78.4', 243 => '16.1', 244 => '17.1', 245 => '17.1', 246 => '7.1', 247 => '17.5', 250 => '18.4', 251 => '18.2' },
	'shutterreleasemethod' => { 86 => 0x1010 },
	'shutterreleasenocfcard' => { 71 => 0x2, 72 => 0x2, 79 => 0xf },
	'shutterreleasetiming' => { 86 => 0x1011 },
	'shutterreleasewithoutlens' => { 73 => 0x711 },
	'shutterspeedlock' => { 240 => '38.1', 242 => '38.1', 250 => '38.1' },
	'shutterspeedrange' => { 73 => 0x10c },
	'shutterspeedsetting' => { 161 => 0x6, 349 => 0x2f, 350 => 0x28, 351 => 0x0 },
	'shutterspeedvalue' => { 82 => 0x1, 106 => 0x9201, 258 => 0x1000, 316 => 0x400, 409 => 'ShutterSpeedValue' },
	'shuttertype' => { 111 => 0x1050, 274 => 0x9f },
	'sidecarforextension' => { 417 => 'SidecarForExtension' },
	'similarityindex' => { 114 => 0xe4 },
	'singleframebracketing' => { 161 => 0x21 },
	'skilllevel' => { 421 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 307 => 0x20b },
	'slideshowname' => { 418 => 'slideshowName' },
	'slideshownumber' => { 418 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 418 => 'slideshowTotalNumber' },
	'slowshutter' => { 67 => 0x8 },
	'slowsync' => { 111 => 0x1030 },
	'smartrange' => { 338 => 0xa012 },
	'smileshutter' => { 351 => 0x31 },
	'smileshuttermode' => { 351 => 0x27 },
	'smoothness' => { 106 => 0xfe57, 405 => 'Smoothness' },
	'snapshots' => { 399 => 'Snapshots' },
	'softskineffect' => { 361 => 0x200f },
	'software' => { 106 => 0x131, 137 => 'Software', 266 => 'Software', 316 => 0x203, 341 => 0x18, 425 => 'Software' },
	'softwareversion' => { 340 => 0x207 },
	'sonydatetime' => { 367 => 0x6, 369 => 0x1b6, 370 => 0x210, 371 => 0x1fe, 372 => 0x22c },
	'sonydatetime2' => { 377 => [0x51,0x5d] },
	'sonyexposuretime' => { 377 => 0x46 },
	'sonyexposuretime2' => { 386 => 0xe },
	'sonyfnumber' => { 377 => [0x3c,0x48], 386 => 0x14 },
	'sonyimageheight' => { 367 => 0x1a, 378 => 0x44, 379 => 0x3f, 380 => 0x47 },
	'sonyimagesize' => { 161 => 0x3b, 349 => 0x54, 350 => 0x54, 351 => 0x9 },
	'sonyimagewidth' => { 367 => 0x1c },
	'sonyiso' => { 369 => 0x1218, 370 => 0x11f4, 371 => 0x1270, 372 => [0x1254,0x1258,0x1280], 373 => 0x113c, 374 => 0x344, 375 => 0x346, 386 => 0x4 },
	'sonymaxaperturevalue' => { 386 => 0x16 },
	'sonymodelid' => { 361 => 0xb001 },
	'sonyquality' => { 161 => 0x3c },
	'source' => { 114 => 0x73, 266 => 'Source', 406 => 'source', 407 => 'source', 417 => 'Source' },
	'sourcedirectoryindex' => { 294 => 0x0 },
	'sourcefileindex' => { 294 => 0x2 },
	'sourcephotoscount' => { 394 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 409 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 409 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 409 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 409 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 409 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 429 => 'speakerPlacement' },
	'specialeffectlevel' => { 102 => 0x3030 },
	'specialeffectmode' => { 102 => 0x2076 },
	'specialeffectsetting' => { 102 => 0x3031 },
	'specialinstructions' => { 114 => 0x28 },
	'specialmode' => { 258 => 0x200, 340 => 0x200 },
	'specialoccasion' => { 421 => 'specialOccasion' },
	'spectralsensitivity' => { 106 => 0x8824, 409 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 38 => [0x2b9,0x2d0,0x2d4], 40 => 0x1e4, 41 => [0x1fd,0x2dd], 42 => [0x231,0x30f] },
	'splitcolumn' => { 316 => 0x222 },
	'splittoningbalance' => { 405 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 405 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 405 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 405 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 405 => 'SplitToningShadowSaturation' },
	'sport' => { 419 => 'sport' },
	'spotfocuspointx' => { 158 => 0x2d },
	'spotfocuspointy' => { 158 => 0x2e },
	'spotmeteringmode' => { 31 => 0x27 },
	'spotmeterlinktoafpoint' => { 73 => 0x107 },
	'sractive' => { 288 => '17.1' },
	'srawquality' => { 31 => 0x2e },
	'srfocallength' => { 309 => 0x3 },
	'srhalfpresstime' => { 309 => 0x2 },
	'srresult' => { 309 => 0x0, 310 => 0x0 },
	'stackedimage' => { 253 => 0x804 },
	'standardoutputhighlightpoint' => { 98 => 0x14 },
	'standardoutputsensitivity' => { 106 => 0x8831, 410 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 98 => 0x15 },
	'standardrawcolortone' => { 98 => 0xd },
	'standardrawcontrast' => { 98 => 0xf },
	'standardrawhighlight' => { 98 => 0x75 },
	'standardrawhighlightpoint' => { 98 => 0x12 },
	'standardrawlinear' => { 98 => 0x10 },
	'standardrawsaturation' => { 98 => 0xe },
	'standardrawshadow' => { 98 => 0x7e },
	'standardrawshadowpoint' => { 98 => 0x13 },
	'standardrawsharpness' => { 98 => 0x11 },
	'standardunsharpmaskfineness' => { 98 => 0x94 },
	'standardunsharpmaskstrength' => { 98 => 0x92 },
	'standardunsharpmaskthreshold' => { 98 => 0x96 },
	'standbytimer' => { 240 => '19.1', 242 => '19.1', 245 => '18.1', 250 => '19.1' },
	'startingpage' => { 419 => 'startingPage' },
	'startmovieshooting' => { 73 => 0x70d },
	'starttimecode' => { 429 => 'startTimecode' },
	'starttimecodetimeformat' => { 429 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 429 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 429 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 429 => 'startTimeSampleSize' },
	'starttimescale' => { 429 => 'startTimeScale' },
	'state' => { 141 => 'State', 274 => 0x6b, 417 => 'State' },
	'status' => { 393 => 'Status', 397 => 'Status' },
	'stitchingsoftware' => { 394 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 368 => 0x113e, 369 => 0x113e, 370 => 0x111a, 371 => 0x1196, 372 => 0x1172, 373 => 0x102a, 374 => 0x222, 375 => 0x222, 386 => 0xa },
	'storagemethod' => { 165 => 0x12 },
	'storebyorientation' => { 240 => '46.3', 242 => '47.3', 250 => '47.3' },
	'straightenangle' => { 232 => 0x2fc08431 },
	'streamtype' => { 154 => 'StreamType' },
	'stretchmode' => { 429 => 'stretchMode' },
	'studydatetime' => { 392 => 'StudyDateTime' },
	'studydescription' => { 392 => 'StudyDescription' },
	'studyid' => { 392 => 'StudyID' },
	'studyphysician' => { 392 => 'StudyPhysician' },
	'sub-location' => { 114 => 0x5c },
	'subfiledata' => { 144 => 'data' },
	'subfiledirectory' => { 144 => '1Directory' },
	'subfilemimetype' => { 144 => '2MIME' },
	'subfilename' => { 144 => '1Name' },
	'subfileresource' => { 144 => 'rsrc' },
	'subfiletype' => { 106 => 0xfe, 144 => '0Type' },
	'subject' => { 262 => 'Subject', 323 => 'Subject', 406 => 'subject', 416 => 'Subject', 430 => 'subject' },
	'subjectarea' => { 106 => 0x9214, 409 => 'SubjectArea' },
	'subjectcode' => { 414 => 'SubjectCode' },
	'subjectdistance' => { 106 => 0x9206, 122 => 0x3e, 409 => 'SubjectDistance' },
	'subjectdistancerange' => { 106 => 0xa40c, 409 => 'SubjectDistanceRange' },
	'subjectlocation' => { 106 => 0xa214, 409 => 'SubjectLocation' },
	'subjectmotion' => { 242 => '78.2' },
	'subjectprogram' => { 158 => 0x22 },
	'subjectreference' => { 114 => 0xc },
	'sublabels4' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 413 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 413 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 106 => 0x9290 },
	'subsectimedigitized' => { 106 => 0x9292 },
	'subsectimeoriginal' => { 106 => 0x9291 },
	'subsection1' => { 419 => 'subsection1' },
	'subsection2' => { 419 => 'subsection2' },
	'subsection3' => { 419 => 'subsection3' },
	'subsection4' => { 419 => 'subsection4' },
	'subselector' => { 240 => '49.1', 242 => '71.1' },
	'subselectorassignment' => { 240 => '48.1' },
	'subselectorcenter' => { 242 => '72.1' },
	'subselectorplusdials' => { 240 => '49.2', 242 => '73.1' },
	'subtitle' => { 419 => 'subtitle' },
	'subversionfilename' => { 413 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 413 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 413 => 'SubVersions' },
	'superimposeddisplay' => { 71 => 0xa, 73 => 0x510, 74 => 0x9, 75 => 0xa, 78 => 0xa, 79 => 0xe },
	'supermacro' => { 55 => 0x1a },
	'supplementalcategories' => { 114 => 0x14, 417 => 'SupplementalCategories' },
	'supplementaltype' => { 116 => 0x37 },
	'supplementdisplayid' => { 419 => 'supplementDisplayID' },
	'supplementstartingpage' => { 419 => 'supplementStartingPage' },
	'supplementtitle' => { 419 => 'supplementTitle' },
	'svisosetting' => { 288 => 0x14 },
	'swatchcoloranta' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgreen' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 434 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 434 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 434 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 434 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 434 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 274 => 0x93, 351 => 0x33 },
	'sweeppanoramafieldofview' => { 274 => 0x94 },
	'sweeppanoramasize' => { 351 => 0x32 },
	'switchtoregisteredafpoint' => { 72 => 0x12, 73 => 0x50a },
	'syncreleasemode' => { 242 => '77.1' },
	'system' => { 316 => 0x204 },
	'tagged' => { 318 => 0xdd, 319 => 'Tagged', 399 => 'tagged' },
	'tagslist' => { 408 => 'TagsList' },
	'tagstructure' => { 413 => 'TagStructure' },
	'takenumber' => { 429 => 'takeNumber' },
	'tapename' => { 429 => 'tapeName' },
	'targetaperture' => { 67 => 0x4 },
	'targetcompressionratio' => { 84 => 0x1 },
	'targetdistancesetting' => { 86 => 0x1807 },
	'targetexposuretime' => { 67 => 0x5 },
	'targetimagetype' => { 86 => 0x100a },
	'targetprinter' => { 106 => 0x151 },
	'taxon' => { 105 => 'Taxon' },
	'taxonacceptednameusage' => { 105 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 105 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 105 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 105 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 105 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 105 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 105 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 105 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 105 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 105 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 105 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 105 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 105 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 105 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 105 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 105 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 105 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 105 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 105 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 105 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 105 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 105 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 105 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 105 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 105 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 105 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 105 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 105 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 105 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 105 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 105 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 105 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 105 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 419 => 'teaser' },
	'teleconverter' => { 163 => 0x105, 361 => 0x105 },
	'tempo' => { 429 => 'tempo' },
	'termsandconditionstext' => { 263 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 263 => 'TermsAndConditionsURL' },
	'testname' => { 107 => 'TestName' },
	'textencoding' => { 193 => 0x4 },
	'textlayername' => { 417 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 417 => 'TextLayers' },
	'textlayertext' => { 417 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 274 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 242 => '1.3' },
	'three-dtrackingwatcharea' => { 242 => '78.1' },
	'thresholding' => { 106 => 0x107 },
	'thumbnailfilename' => { 86 => 0x817 },
	'thumbnailformat' => { 427 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 124 => 0xfa55, 427 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 86 => 0x2008, 103 => 'ThumbnailImage', 109 => 0x3, 147 => 'data', 258 => 0x100, 427 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 147 => '1Name' },
	'thumbnailimagesize' => { 147 => 'ImageSize' },
	'thumbnailimagetype' => { 147 => '0Type' },
	'thumbnailimagevalidarea' => { 55 => 0x13 },
	'thumbnaillength' => { 106 => 0x202 },
	'thumbnailoffset' => { 106 => 0x201 },
	'thumbnails' => { 427 => 'Thumbnails' },
	'thumbnailwidth' => { 124 => 0xfa54, 427 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 419 => 'ticker' },
	'tiffhandling' => { 405 => 'TIFFHandling' },
	'tiffmeteringimage' => { 164 => 0x104c, 360 => 0x1110 },
	'tilelength' => { 106 => 0x143 },
	'tilewidth' => { 106 => 0x142 },
	'time' => { 120 => 0x401, 307 => 0x7 },
	'timecodes' => { 106 => 0xc763 },
	'timecreated' => { 114 => 0x3c, 122 => 0x14, 131 => 0x10, 319 => 'TimeCreated' },
	'timeperiod' => { 419 => 'timePeriod' },
	'timerfunctionbutton' => { 241 => '5.2', 243 => '12.1', 244 => '13.1' },
	'timerlength' => { 73 => 0x80c },
	'timerrecording' => { 274 => 0x96 },
	'timescaleparams' => { 429 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 429 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 429 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 429 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 115 => 0x50 },
	'timesignature' => { 429 => 'timeSignature' },
	'timesincepoweron' => { 274 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 252 => 0x8, 266 => 'TimeStamp', 400 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 68 => 0x1, 224 => 0x0, 335 => 0xa },
	'timezonecity' => { 68 => 0x2 },
	'timezonecode' => { 89 => 0x1 },
	'timezoneinfo' => { 89 => 0x2 },
	'timezoneoffset' => { 106 => 0x882a },
	'tint' => { 405 => 'Tint' },
	'title' => { 137 => 'Title', 262 => 'Title', 266 => 'Title', 274 => 0x65, 323 => 'Title', 406 => 'title', 416 => 'Title', 427 => 'Title' },
	'tonecomp' => { 194 => 0x81 },
	'tonecurve' => { 65 => 0x1, 307 => 0x402, 405 => 'ToneCurve' },
	'tonecurveactive' => { 97 => 0x110 },
	'tonecurveadobergb' => { 338 => 0xa043 },
	'tonecurveadobergbdefault' => { 338 => 0xa041 },
	'tonecurveblue' => { 405 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 390 => 0x9003 },
	'tonecurvebluey' => { 390 => 0x9007 },
	'tonecurvebrightness' => { 92 => 0x20410 },
	'tonecurvebrightnessx' => { 390 => 0x9000 },
	'tonecurvebrightnessy' => { 390 => 0x9004 },
	'tonecurvecolorspace' => { 96 => 0x0 },
	'tonecurvecontrast' => { 92 => 0x20411 },
	'tonecurvefilename' => { 120 => 0x1391 },
	'tonecurvegreen' => { 405 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 390 => 0x9002 },
	'tonecurvegreeny' => { 390 => 0x9006 },
	'tonecurveinputrange' => { 96 => 0x3 },
	'tonecurveinterpolation' => { 97 => 0x159 },
	'tonecurvemode' => { 97 => 0x113 },
	'tonecurvename' => { 405 => 'ToneCurveName' },
	'tonecurvename2012' => { 405 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 92 => '0x20400.1' },
	'tonecurveoutputrange' => { 96 => 0x5 },
	'tonecurveproperty' => { 97 => 0x3c },
	'tonecurvepv2012' => { 405 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 405 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 405 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 405 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 405 => 'ToneCurveRed' },
	'tonecurveredx' => { 390 => 0x9001 },
	'tonecurveredy' => { 390 => 0x9005 },
	'tonecurves' => { 307 => 0x403 },
	'tonecurveshape' => { 96 => 0x1 },
	'tonecurvesrgb' => { 338 => 0xa042 },
	'tonecurvesrgbdefault' => { 338 => 0xa040 },
	'tonecurvex' => { 96 => 0xa },
	'tonecurvey' => { 96 => 0xb },
	'tonelevel' => { 253 => 0x52e },
	'tonemapstrength' => { 405 => 'ToneMapStrength' },
	'toningeffect' => { 49 => 0xf, 194 => 0xb3, 196 => 0x38, 197 => 0x40, 332 => 0x1015 },
	'toningeffectauto' => { 62 => 0xa4 },
	'toningeffectfaithful' => { 61 => 0x74, 62 => 0x74 },
	'toningeffectlandscape' => { 61 => 0x44, 62 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 61 => 0x8c, 62 => 0x8c },
	'toningeffectneutral' => { 61 => 0x5c, 62 => 0x5c },
	'toningeffectportrait' => { 61 => 0x2c, 62 => 0x2c },
	'toningeffectstandard' => { 61 => 0x14, 62 => 0x14 },
	'toningeffectuserdef1' => { 61 => 0xa4, 62 => 0xbc },
	'toningeffectuserdef2' => { 61 => 0xbc, 62 => 0xd4 },
	'toningeffectuserdef3' => { 61 => 0xd4, 62 => 0xec },
	'toningsaturation' => { 196 => 0x39, 197 => 0x41 },
	'totalzoom' => { 122 => 0x62 },
	'touchae' => { 274 => 0xab },
	'trackcreatedate' => { 327 => 0x1 },
	'trackmodifydate' => { 327 => 0x2 },
	'tracknumber' => { 429 => 'trackNumber' },
	'tracks' => { 429 => 'Tracks' },
	'tracksframerate' => { 429 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 429 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 429 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 429 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 429 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 429 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 429 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 429 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 429 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 429 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 429 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 429 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 429 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 429 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 429 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 429 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 429 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 144 => 'zmie' },
	'transferfunction' => { 106 => 0x12d, 425 => 'TransferFunction' },
	'transform' => { 274 => [0x8012,0x59] },
	'transmissionreference' => { 417 => 'TransmissionReference' },
	'trapped' => { 262 => 'Trapped', 416 => 'Trapped' },
	'trashbuttonfunction' => { 73 => 0x710 },
	'travelday' => { 274 => 0x36 },
	'triggermode' => { 328 => 0x6 },
	'tstop' => { 106 => 0xc772 },
	'ttl_da_adown' => { 295 => 0x5 },
	'ttl_da_aup' => { 295 => 0x4 },
	'ttl_da_bdown' => { 295 => 0x7 },
	'ttl_da_bup' => { 295 => 0x6 },
	'tungstenawb' => { 285 => 0x1 },
	'tvexposuretimesetting' => { 288 => 0x12 },
	'type' => { 406 => 'type', 424 => 'type' },
	'typestatus' => { 105 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 106 => 0xc614 },
	'uniquedocumentid' => { 114 => 0xbb },
	'uniqueobjectname' => { 115 => 0x64 },
	'unknownblock' => { 307 => 0x405 },
	'unknownblock1' => { 257 => 0x635 },
	'unknownblock2' => { 257 => 0x636 },
	'unknownblock3' => { 257 => 0x1103 },
	'unknownblock4' => { 257 => 0x1104 },
	'unknowncontrast' => { 98 => 0x45 },
	'unknowndate' => { 316 => 0x212 },
	'unknownev' => { 120 => 0x1 },
	'unknownlinear' => { 98 => 0x46 },
	'unknownnumber' => { 86 => 0x180b },
	'unknownoutputhighlightpoint' => { 98 => 0x4a },
	'unknownoutputshadowpoint' => { 98 => 0x4b },
	'unknownrawhighlight' => { 98 => 0x7b },
	'unknownrawhighlightpoint' => { 98 => 0x48 },
	'unknownrawshadow' => { 98 => 0x84 },
	'unknownrawshadowpoint' => { 98 => 0x49 },
	'unknownsharpness' => { 98 => 0x47 },
	'unknowntemperature' => { 108 => 0x4 },
	'unsharp1color' => { 237 => 0x13 },
	'unsharp1halowidth' => { 237 => 0x19 },
	'unsharp1intensity' => { 237 => 0x17 },
	'unsharp1threshold' => { 237 => 0x1b },
	'unsharp2color' => { 237 => 0x2e },
	'unsharp2halowidth' => { 237 => 0x34 },
	'unsharp2intensity' => { 237 => 0x32 },
	'unsharp2threshold' => { 237 => 0x36 },
	'unsharp3color' => { 237 => 0x49 },
	'unsharp3halowidth' => { 237 => 0x4f },
	'unsharp3intensity' => { 237 => 0x4d },
	'unsharp3threshold' => { 237 => 0x51 },
	'unsharp4color' => { 237 => 0x64 },
	'unsharp4halowidth' => { 237 => 0x6a },
	'unsharp4intensity' => { 237 => 0x68 },
	'unsharp4threshold' => { 237 => 0x6c },
	'unsharpcount' => { 237 => 0x0 },
	'unsharpmask' => { 98 => 0x90, 232 => 0x76a43200 },
	'unsharpmaskfineness' => { 92 => 0x20309 },
	'unsharpmaskstrength' => { 92 => 0x20308 },
	'unsharpmaskthreshold' => { 92 => 0x2030a },
	'uprightcentermode' => { 405 => 'UprightCenterMode' },
	'uprightcenternormx' => { 405 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 405 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 405 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 405 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 405 => 'UprightFocalMode' },
	'uprightpreview' => { 405 => 'UprightPreview' },
	'uprighttransform_0' => { 405 => 'UprightTransform_0' },
	'uprighttransform_1' => { 405 => 'UprightTransform_1' },
	'uprighttransform_2' => { 405 => 'UprightTransform_2' },
	'uprighttransform_3' => { 405 => 'UprightTransform_3' },
	'uprighttransform_4' => { 405 => 'UprightTransform_4' },
	'uprighttransformcount' => { 405 => 'UprightTransformCount' },
	'uprightversion' => { 405 => 'UprightVersion' },
	'urgency' => { 114 => 0xa, 417 => 'Urgency' },
	'url' => { 137 => 'URL', 266 => 'URL', 321 => 0x40b, 419 => 'url' },
	'url_list' => { 321 => 0x41e },
	'urla-platform' => { 419 => [\'url','urlA-platform'] },
	'urlurl' => { 419 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 73 => 0x10a },
	'usableshootingmodes' => { 73 => 0x109 },
	'usage' => { 420 => 'usage' },
	'usageterms' => { 433 => 'UsageTerms' },
	'useguidelines' => { 402 => 'useGuidelines' },
	'usepanoramaviewer' => { 394 => 'UsePanoramaViewer' },
	'usercomment' => { 86 => 0x805, 106 => 0x9286, 409 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 61 => 0xd8, 62 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 61 => 0xda, 62 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 61 => 0xdc, 62 => 0xf4 },
	'userfields' => { 397 => 'UserFields' },
	'userlabel' => { 328 => 0x2b },
	'userprofile' => { 270 => 0x302, 276 => 0x3038 },
	'usmlenselectronicmf' => { 72 => 0x7, 73 => 0x501 },
	'uspsnumber' => { 419 => 'uspsNumber' },
	'utmeasting' => { 148 => 'Easting' },
	'utmmapdatum' => { 148 => 'Datum' },
	'utmnorthing' => { 148 => 'Northing' },
	'utmzone' => { 148 => 'Zone' },
	'uv-irfiltercorrection' => { 270 => 0x325 },
	'validbits' => { 257 => 0x611, 258 => 0x102c },
	'validpixeldepth' => { 261 => 0x611 },
	'variousmodes' => { 122 => 0x26 },
	'variousmodes2' => { 122 => 0x3a },
	'variprogram' => { 194 => 0xab },
	'version' => { 111 => 0x0, 323 => 'Version', 405 => 'Version' },
	'versioncreatedate' => { 390 => 0xd100 },
	'versionid' => { 430 => 'VersionID' },
	'versionidentifier' => { 419 => 'versionIdentifier' },
	'versionmodifydate' => { 390 => 0xd101 },
	'versions' => { 430 => 'Versions' },
	'versionscomments' => { 430 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 430 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 430 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 430 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 430 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 430 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 430 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 430 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 430 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 430 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 430 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 239 => '3.2', 240 => '47.2' },
	'verticalfuncbutton' => { 240 => '42.2' },
	'verticalfuncbuttonplusdials' => { 240 => '43.1' },
	'verticalmultiselector' => { 240 => '42.1', 242 => '66.1' },
	'vfdisplayillumination' => { 73 => [0x510,0x51d] },
	'vibrance' => { 398 => 'Vibrance', 405 => 'Vibrance' },
	'vibrationreduction' => { 202 => [0x75,0x82,0x1ae], 210 => '586.1', 218 => '590.2', 223 => 0x4 },
	'videoalphamode' => { 429 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 429 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 429 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 429 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 58 => 0x74 },
	'videocolorspace' => { 429 => 'videoColorSpace' },
	'videocompressor' => { 429 => 'videoCompressor' },
	'videofieldorder' => { 429 => 'videoFieldOrder' },
	'videoframerate' => { 429 => 'videoFrameRate' },
	'videoframesize' => { 429 => 'videoFrameSize' },
	'videoframesizeh' => { 429 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 429 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 429 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 429 => 'videoModDate' },
	'videopixelaspectratio' => { 429 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 429 => 'videoPixelDepth' },
	'videoquality' => { 102 => 0x4003 },
	'viewfinderdisplay' => { 239 => '12.4', 240 => '6.3' },
	'viewfinderwarning' => { 239 => '13.4', 247 => '3.5', 248 => '6.2', 251 => '4.4' },
	'viewfinderwarnings' => { 73 => 0x40a },
	'viewinfoduringexposure' => { 73 => 0x407 },
	'viewingmode' => { 351 => 0x2f, 365 => 0x18 },
	'viewingmode2' => { 351 => [0x85,0x285] },
	'viewpoint' => { 418 => 'viewpoint' },
	'vignetteamount' => { 405 => 'VignetteAmount' },
	'vignettecontrol' => { 194 => 0x2a, 232 => 0x76a43205 },
	'vignettecontrolintensity' => { 232 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 401 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 405 => 'VignetteMidpoint' },
	'vignetting' => { 332 => 0x1011, 338 => 0xa052 },
	'vignettingcorrection' => { 338 => 0xa053, 361 => 0x2011 },
	'vignettingsetting' => { 338 => 0xa054 },
	'visualtechnique' => { 418 => 'visualTechnique' },
	'voicememo' => { 340 => 0x216 },
	'volume' => { 419 => 'volume' },
	'vr_0x66' => { 202 => 0x66 },
	'vrdoffset' => { 55 => 0xd0 },
	'vrmode' => { 223 => 0x6 },
	'wb_bluelevel3500k' => { 164 => 0x19a },
	'wb_bluelevel6500k' => { 164 => 0x18a },
	'wb_bluelevelcustom' => { 164 => 0x18e },
	'wb_bluelevelscloudy' => { 164 => 0x106 },
	'wb_bluelevelsdaylight' => { 164 => 0xea },
	'wb_bluelevelsflash' => { 164 => 0x122 },
	'wb_bluelevelsfluorescent' => { 164 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 164 => 0x254 },
	'wb_bluelevelsshade' => { 164 => 0x176 },
	'wb_bluelevelstungsten' => { 164 => 0xce },
	'wb_gbrglevels' => { 164 => 0xae, 167 => 0x4 },
	'wb_glevel' => { 257 => 0x11f },
	'wb_glevel3000k' => { 257 => 0x113 },
	'wb_glevel3300k' => { 257 => 0x114 },
	'wb_glevel3600k' => { 257 => 0x115 },
	'wb_glevel3900k' => { 257 => 0x116 },
	'wb_glevel4000k' => { 257 => 0x117 },
	'wb_glevel4300k' => { 257 => 0x118 },
	'wb_glevel4500k' => { 257 => 0x119 },
	'wb_glevel4800k' => { 257 => 0x11a },
	'wb_glevel5300k' => { 257 => 0x11b },
	'wb_glevel6000k' => { 257 => 0x11c },
	'wb_glevel6600k' => { 257 => 0x11d },
	'wb_glevel7500k' => { 257 => 0x11e },
	'wb_grbglevels' => { 177 => 0x0 },
	'wb_rbgglevels' => { 174 => 0x0 },
	'wb_rblevels' => { 194 => 0xc, 257 => 0x100 },
	'wb_rblevels1' => { 279 => 0x2 },
	'wb_rblevels2' => { 279 => 0x5 },
	'wb_rblevels3' => { 279 => 0x8 },
	'wb_rblevels3000k' => { 257 => 0x102 },
	'wb_rblevels3300k' => { 257 => 0x103 },
	'wb_rblevels3500k' => { 164 => 0x430 },
	'wb_rblevels3600k' => { 257 => 0x104 },
	'wb_rblevels3900k' => { 257 => 0x105 },
	'wb_rblevels4' => { 279 => 0xb },
	'wb_rblevels4000k' => { 257 => 0x106 },
	'wb_rblevels4300k' => { 257 => 0x107 },
	'wb_rblevels4500k' => { 257 => 0x108 },
	'wb_rblevels4800k' => { 257 => 0x109 },
	'wb_rblevels5' => { 279 => 0xe },
	'wb_rblevels5300k' => { 257 => 0x10a },
	'wb_rblevels6' => { 279 => 0x11 },
	'wb_rblevels6000k' => { 257 => 0x10b },
	'wb_rblevels6500k' => { 164 => 0x420 },
	'wb_rblevels6600k' => { 257 => 0x10c },
	'wb_rblevels7' => { 279 => 0x14 },
	'wb_rblevels7500k' => { 257 => 0x10d },
	'wb_rblevelsauto' => { 261 => 0x110 },
	'wb_rblevelscloudy' => { 164 => 0x3f0, 166 => 0x10, 261 => 0x121 },
	'wb_rblevelscoolwhitef' => { 164 => 0x308, 166 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 261 => 0x132 },
	'wb_rblevelscustom' => { 164 => 0x424 },
	'wb_rblevelscwb1' => { 257 => 0x10e },
	'wb_rblevelscwb2' => { 257 => 0x10f },
	'wb_rblevelscwb3' => { 257 => 0x110 },
	'wb_rblevelscwb4' => { 257 => 0x111 },
	'wb_rblevelsdaylight' => { 164 => [0x3ec,0x528], 166 => 0xc },
	'wb_rblevelsdaylightf' => { 166 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 261 => 0x130 },
	'wb_rblevelsdaywhitef' => { 166 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 261 => 0x131 },
	'wb_rblevelseveningsunlight' => { 261 => 0x124 },
	'wb_rblevelsfineweather' => { 261 => 0x122 },
	'wb_rblevelsflash' => { 164 => [0x3f4,0x304], 166 => 0x18 },
	'wb_rblevelsshade' => { 164 => 0x418, 166 => 0x20, 261 => 0x120 },
	'wb_rblevelstungsten' => { 164 => 0x3e8, 166 => 0x8, 261 => 0x123 },
	'wb_rblevelsunknown' => { 166 => 0x1c },
	'wb_rblevelsused' => { 261 => 0x100 },
	'wb_rblevelswhitef' => { 166 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 261 => 0x133 },
	'wb_redlevel3500k' => { 164 => 0x198 },
	'wb_redlevel6500k' => { 164 => 0x188 },
	'wb_redlevelcustom' => { 164 => 0x18c },
	'wb_redlevelscloudy' => { 164 => 0xf8 },
	'wb_redlevelsdaylight' => { 164 => 0xdc },
	'wb_redlevelsflash' => { 164 => 0x114 },
	'wb_redlevelsfluorescent' => { 164 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 164 => 0x1be },
	'wb_redlevelsshade' => { 164 => 0x168 },
	'wb_redlevelstungsten' => { 164 => 0xc0 },
	'wb_rgbglevels' => { 176 => 0x0 },
	'wb_rgblevels' => { 164 => [0x546,0x96], 271 => 0xd, 272 => 0x413, 276 => 0x3036, 316 => 0x107, 368 => 0x117c, 369 => 0x1180, 370 => 0x115c, 371 => 0x11d8, 372 => 0x11b4, 373 => 0x106c, 374 => 0x264, 375 => 0x264 },
	'wb_rgblevels1' => { 280 => 0x2 },
	'wb_rgblevels2' => { 280 => 0x6 },
	'wb_rgblevels3' => { 280 => 0xa },
	'wb_rgblevels4' => { 280 => 0xe },
	'wb_rgblevels5' => { 280 => 0x12 },
	'wb_rgblevels6' => { 280 => 0x16 },
	'wb_rgblevels7' => { 280 => 0x1a },
	'wb_rggbblacklevels' => { 32 => 0x25 },
	'wb_rggblevels' => { 167 => 0x4, 175 => 0x0 },
	'wb_rggblevelsasshot' => { 34 => 0x0, 35 => 0x19, 36 => 0x22, 37 => 0x3f, 40 => 0x3f, 41 => 0x3f, 42 => 0x3f },
	'wb_rggblevelsauto' => { 32 => 0x1, 34 => 0x5, 35 => 0x1e, 36 => 0x18, 37 => 0x44, 40 => 0x44, 41 => 0x44, 42 => 0x44, 338 => 0xa022 },
	'wb_rggblevelsblack' => { 338 => 0xa028 },
	'wb_rggblevelscloudy' => { 32 => 0xd, 34 => 0x1e, 35 => 0x2d, 36 => 0x31, 37 => 0x58, 40 => 0x71, 41 => 0x8a, 42 => 0x8f, 307 => 0x20f, 315 => 0x14 },
	'wb_rggblevelscustom' => { 32 => 0x1d, 37 => 0x80 },
	'wb_rggblevelscustom1' => { 35 => 0x41 },
	'wb_rggblevelscustom2' => { 35 => 0x46 },
	'wb_rggblevelsdaylight' => { 32 => 0x5, 34 => 0x14, 35 => 0x23, 36 => 0x27, 37 => 0x4e, 40 => 0x67, 41 => 0x80, 42 => 0x85, 307 => 0x20d, 315 => 0x2 },
	'wb_rggblevelsflash' => { 32 => 0x19, 34 => 0x32, 35 => 0x3c, 36 => 0x45, 37 => 0x6c, 40 => 0x85, 41 => 0x9e, 42 => 0xa3, 307 => 0x214, 315 => 0x41 },
	'wb_rggblevelsfluorescent' => { 32 => 0x15, 34 => 0x28, 35 => 0x37, 36 => 0x3b, 37 => 0x62, 40 => 0x7b, 41 => 0x94, 42 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 307 => 0x211, 315 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 315 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 307 => 0x212, 315 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 307 => 0x213, 315 => 0x38 },
	'wb_rggblevelsilluminator1' => { 338 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 338 => 0xa024 },
	'wb_rggblevelskelvin' => { 32 => 0x21, 34 => 0x2d, 36 => 0x40, 37 => 0x67, 40 => 0x80, 41 => 0x99, 42 => 0x9e },
	'wb_rggblevelsmeasured' => { 34 => 0xa, 37 => 0x49, 40 => 0x49, 41 => 0x49, 42 => 0x49 },
	'wb_rggblevelspc1' => { 36 => 0x90, 37 => 0x71 },
	'wb_rggblevelspc2' => { 36 => 0x95, 37 => 0x76 },
	'wb_rggblevelspc3' => { 36 => 0x9a, 37 => 0x7b },
	'wb_rggblevelsshade' => { 32 => 0x9, 34 => 0x19, 35 => 0x28, 36 => 0x2c, 37 => 0x53, 40 => 0x6c, 41 => 0x85, 42 => 0x8a, 307 => 0x20e, 315 => 0xb },
	'wb_rggblevelstungsten' => { 32 => 0x11, 34 => 0x23, 35 => 0x32, 36 => 0x36, 37 => 0x5d, 40 => 0x76, 41 => 0x8f, 42 => 0x94, 307 => 0x210, 315 => 0x1d },
	'wb_rggblevelsuncorrected' => { 338 => 0xa021 },
	'wb_rggblevelsunknown' => { 34 => 0xf, 36 => 0x1d, 40 => 0x4e, 41 => 0x4e, 42 => 0x4e, 315 => 0x53 },
	'wb_rggblevelsunknown10' => { 34 => 0x5f, 36 => 0x72, 40 => 0x9e, 41 => 0x7b, 42 => 0x7b },
	'wb_rggblevelsunknown11' => { 34 => 0x64, 36 => 0x77, 40 => 0xa3, 41 => 0xa3, 42 => 0x80 },
	'wb_rggblevelsunknown12' => { 34 => 0x69, 36 => 0x7c, 40 => 0xa8, 41 => 0xa8, 42 => 0xa8 },
	'wb_rggblevelsunknown13' => { 34 => 0x6e, 36 => 0x81, 40 => 0xad, 41 => 0xad, 42 => 0xad },
	'wb_rggblevelsunknown14' => { 36 => 0x86, 40 => 0xb2, 41 => 0xb2, 42 => 0xb2 },
	'wb_rggblevelsunknown15' => { 36 => 0x8b, 40 => 0xb7, 41 => 0xb7, 42 => 0xb7 },
	'wb_rggblevelsunknown16' => { 36 => 0x9f, 41 => 0xbc, 42 => 0xbc },
	'wb_rggblevelsunknown17' => { 41 => 0xc1, 42 => 0xc1 },
	'wb_rggblevelsunknown18' => { 41 => 0xc6, 42 => 0xc6 },
	'wb_rggblevelsunknown19' => { 41 => 0xcb, 42 => 0xcb },
	'wb_rggblevelsunknown2' => { 34 => 0x37, 36 => 0x4a, 40 => 0x53, 41 => 0x53, 42 => 0x53 },
	'wb_rggblevelsunknown20' => { 41 => 0xd0, 42 => 0xd0 },
	'wb_rggblevelsunknown21' => { 42 => 0xd5 },
	'wb_rggblevelsunknown22' => { 42 => 0xda },
	'wb_rggblevelsunknown23' => { 42 => 0xdf },
	'wb_rggblevelsunknown24' => { 42 => 0xe4 },
	'wb_rggblevelsunknown25' => { 42 => 0xe9 },
	'wb_rggblevelsunknown26' => { 42 => 0xee },
	'wb_rggblevelsunknown27' => { 42 => 0xf3 },
	'wb_rggblevelsunknown28' => { 42 => 0xf8 },
	'wb_rggblevelsunknown29' => { 42 => 0xfd },
	'wb_rggblevelsunknown3' => { 34 => 0x3c, 36 => 0x4f, 40 => 0x58, 41 => 0x58, 42 => 0x58 },
	'wb_rggblevelsunknown30' => { 42 => 0x102 },
	'wb_rggblevelsunknown4' => { 34 => 0x41, 36 => 0x54, 40 => 0x5d, 41 => 0x5d, 42 => 0x5d },
	'wb_rggblevelsunknown5' => { 34 => 0x46, 36 => 0x59, 40 => 0x62, 41 => 0x62, 42 => 0x62 },
	'wb_rggblevelsunknown6' => { 34 => 0x4b, 36 => 0x5e, 40 => 0x8a, 41 => 0x67, 42 => 0x67 },
	'wb_rggblevelsunknown7' => { 34 => 0x50, 36 => 0x63, 40 => 0x8f, 41 => 0x6c, 42 => 0x6c },
	'wb_rggblevelsunknown8' => { 34 => 0x55, 36 => 0x68, 40 => 0x94, 41 => 0x71, 42 => 0x71 },
	'wb_rggblevelsunknown9' => { 34 => 0x5a, 36 => 0x6d, 40 => 0x99, 41 => 0x76, 42 => 0x76 },
	'wb_rggblevelsuserselected' => { 315 => 0x5c },
	'wbadjblueamber' => { 92 => 0x20106 },
	'wbadjbluebalance' => { 238 => 0x8 },
	'wbadjcolortemp' => { 92 => 0x20102, 97 => 0x1a },
	'wbadjlighting' => { 238 => 0x14 },
	'wbadjmagentagreen' => { 92 => 0x20105 },
	'wbadjmode' => { 238 => 0x10 },
	'wbadjredbalance' => { 238 => 0x0 },
	'wbadjrggblevels' => { 92 => 0x20125, 97 => 0x6 },
	'wbadjtemperature' => { 238 => 0x18 },
	'wbadjtint' => { 238 => 0x25 },
	'wbbluelevel' => { 270 => 0x324, 274 => 0x8006, 278 => 0x26 },
	'wbbracketmode' => { 49 => 0x9 },
	'wbbracketshotnumber' => { 164 => 0x2b, 332 => 0x101a },
	'wbbracketvalueab' => { 49 => 0xc },
	'wbbracketvaluegm' => { 49 => 0xd },
	'wbfinetuneactive' => { 97 => 0x24 },
	'wbfinetunesaturation' => { 97 => 0x28 },
	'wbfinetunetone' => { 97 => 0x2c },
	'wbgreenlevel' => { 270 => 0x323, 274 => 0x8005, 278 => 0x25 },
	'wbmediaimagesizesetting' => { 73 => 0x708 },
	'wbmode' => { 166 => 0x4, 258 => 0x1015 },
	'wbredlevel' => { 270 => 0x322, 274 => 0x8004, 278 => 0x24 },
	'wbscale' => { 167 => 0x0 },
	'wbshiftab' => { 65 => 0xc, 274 => 0x46, 289 => 0x10 },
	'wbshiftab_gm' => { 361 => 0x2014 },
	'wbshiftab_gm_precise' => { 361 => 0x2026 },
	'wbshiftgm' => { 65 => 0xd, 274 => 0x47, 289 => 0x11 },
	'wbtype1' => { 279 => 0x1, 280 => 0x1 },
	'wbtype2' => { 279 => 0x4, 280 => 0x5 },
	'wbtype3' => { 279 => 0x7, 280 => 0x9 },
	'wbtype4' => { 279 => 0xa, 280 => 0xd },
	'wbtype5' => { 279 => 0xd, 280 => 0x11 },
	'wbtype6' => { 279 => 0x10, 280 => 0x15 },
	'wbtype7' => { 279 => 0x13, 280 => 0x19 },
	'webstatement' => { 433 => 'WebStatement' },
	'what' => { 405 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 65 => 0x8, 67 => 0x7, 101 => 0x7, 102 => [0x19,0x2012], 106 => [0xa403,0xfe4e], 111 => 0x1002, 120 => 0x3fc, 121 => 0xfa0d, 122 => 0x40, 158 => 0x3, 159 => 0xe, 160 => 0x4, 161 => 0xb, 163 => 0x115, 194 => 0x5, 222 => 0x7, 270 => 0x304, 274 => 0x3, 276 => 0x3033, 307 => 0x19, 314 => 0x7, 331 => 0x26, 332 => 0x1003, 341 => [0x3c,0x7,0x58], 349 => 0xf, 350 => 0xe, 361 => [0x115,0xb054], 405 => 'WhiteBalance', 409 => 'WhiteBalance' },
	'whitebalance0' => { 154 => 'WhiteBalance0' },
	'whitebalance1' => { 154 => 'WhiteBalance1' },
	'whitebalance2' => { 154 => 'WhiteBalance2', 253 => 0x500 },
	'whitebalanceadj' => { 92 => 0x20101, 97 => 0x18, 232 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 285 => 0x0 },
	'whitebalancebias' => { 102 => 0x2011, 258 => 0x304, 274 => 0x23 },
	'whitebalanceblue' => { 65 => 0x7 },
	'whitebalancebracket' => { 253 => 0x502, 258 => 0x303 },
	'whitebalancebracketing' => { 161 => 0x22, 164 => 0x2c, 360 => 0x2c },
	'whitebalancecomp' => { 261 => 0x1001 },
	'whitebalancefinetune' => { 111 => 0x100a, 161 => 0x38, 163 => 0x112, 194 => 0xb, 332 => 0x1004, 349 => 0x6, 350 => 0x5, 361 => 0x112 },
	'whitebalancemode' => { 307 => 0x1a },
	'whitebalancered' => { 65 => 0x6 },
	'whitebalanceset' => { 288 => 0xa },
	'whitebalancesetting' => { 161 => 0x23, 349 => 0x5, 350 => 0x4, 351 => 0x16, 365 => 0xd },
	'whitebalancetemperature' => { 253 => 0x501 },
	'whiteboard' => { 258 => 0x301 },
	'whitelevel' => { 106 => 0xc61d, 307 => 0x7e },
	'whitepoint' => { 106 => 0x13e, 307 => 0x201, 425 => 'WhitePoint' },
	'whites2012' => { 405 => 'Whites2012' },
	'wideadapter' => { 332 => 0x1017 },
	'widefocuszone' => { 158 => 0x2f },
	'widerange' => { 340 => 0x20f },
	'windowsatom' => { 404 => 'windowsAtom' },
	'windowsatomextension' => { 404 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 404 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 404 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 419 => 'wordCount' },
	'workcolorspace' => { 92 => 0x10200, 97 => 0x270 },
	'worktodo' => { 411 => 'WorkToDo' },
	'worldtimelocation' => { 274 => 0x3a, 307 => 0x22, 313 => '0.1' },
	'writer-editor' => { 114 => 0x7a },
	'x3filllight' => { 341 => 0x12 },
	'xml' => { 118 => 'xml ' },
	'xmp' => { 95 => 0xffff00f6, 107 => 'XMP' },
	'xmptoolkit' => { 426 => 'xmptk' },
	'xpauthor' => { 106 => 0x9c9d },
	'xpcomment' => { 106 => 0x9c9c },
	'xpkeywords' => { 106 => 0x9c9e },
	'xposition' => { 106 => 0x11e },
	'xpsubject' => { 106 => 0x9c9f },
	'xptitle' => { 106 => 0x9c9b },
	'xresolution' => { 106 => 0x11a, 117 => 0x3, 322 => 0x0, 425 => 'XResolution' },
	'xyresolution' => { 110 => 0x3 },
	'yawangle' => { 211 => 0x3513 },
	'ycbcrcoefficients' => { 106 => 0x211, 425 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 106 => 0x213, 425 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 106 => 0x212, 425 => 'YCbCrSubSampling' },
	'yearcreated' => { 122 => 0x10, 131 => 0xc },
	'yield' => { 421 => 'yield' },
	'yposition' => { 106 => 0x11f },
	'yresolution' => { 106 => 0x11b, 117 => 0x5, 322 => 0x4, 425 => 'YResolution' },
	'zonematching' => { 163 => 0x10a, 166 => [0x3a,0x4a], 361 => 0xb024 },
	'zonematchingmode' => { 161 => 0x14 },
	'zonematchingon' => { 160 => 0x75 },
	'zonematchingvalue' => { 349 => 0x1f },
	'zoomedpreviewlength' => { 258 => 0xf05 },
	'zoomedpreviewsize' => { 258 => 0xf06 },
	'zoomedpreviewstart' => { 258 => 0xf04 },
	'zoomsourcewidth' => { 31 => 0x24 },
	'zoomstepcount' => { 256 => 0x300, 258 => 0x100d },
	'zoomtargetwidth' => { 31 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName || $field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
