/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class ClassLoaderFactory {
    private static Log log = LogFactory.getLog(ClassLoaderFactory.class);
    protected static final Integer IS_DIR = new Integer(0);
    protected static final Integer IS_JAR = new Integer(1);
    protected static final Integer IS_GLOB = new Integer(2);
    protected static final Integer IS_URL = new Integer(3);

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        return ClassLoaderFactory.createClassLoader(unpacked, packed, null, parent);
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                file = new File(file.getCanonicalPath() + File.separator);
                URL url = file.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory " + url));
                }
                set.add(url);
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase();
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + file.getAbsolutePath()));
                    }
                    URL url = file.toURI().toURL();
                    set.add(url);
                }
            }
        }
        URL[] array = set.toArray(new URL[set.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        return classLoader;
    }

    public static ClassLoader createClassLoader(String[] locations, Integer[] types, ClassLoader parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (locations != null && types != null && locations.length == types.length) {
            for (int i = 0; i < locations.length; ++i) {
                URL url;
                File directory;
                String location = locations[i];
                if (types[i] == IS_URL) {
                    URL url2 = new URL(location);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including URL " + url2));
                    }
                    set.add(url2);
                    continue;
                }
                if (types[i] == IS_DIR) {
                    directory = new File(location);
                    if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), IS_DIR)) continue;
                    url = directory.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including directory " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (types[i] == IS_JAR) {
                    File file = new File(location);
                    if (!ClassLoaderFactory.validateFile(file = file.getCanonicalFile(), IS_JAR)) continue;
                    url = file.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (types[i] != IS_GLOB) continue;
                directory = new File(location);
                if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), IS_GLOB)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory glob " + directory.getAbsolutePath()));
                }
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase();
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (!ClassLoaderFactory.validateFile(file = file.getCanonicalFile(), IS_JAR)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    Including glob jar file " + file.getAbsolutePath()));
                    }
                    URL url3 = file.toURI().toURL();
                    set.add(url3);
                }
            }
        }
        URL[] array = set.toArray(new URL[set.size()]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < array.length; ++i) {
                log.debug((Object)("  location " + i + " is " + array[i]));
            }
        }
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        return classLoader;
    }

    private static boolean validateFile(File file, Integer type) throws IOException {
        if (type == IS_DIR || type == IS_GLOB) {
            if (!(file.exists() && file.isDirectory() && file.canRead())) {
                String msg = "Problem with directory [" + file + "], exists: [" + file.exists() + "], isDirectory: [" + file.isDirectory() + "], canRead: [" + file.canRead() + "]";
                File home = new File(Bootstrap.getCatalinaHome());
                home = home.getCanonicalFile();
                File base = new File(Bootstrap.getCatalinaBase());
                base = base.getCanonicalFile();
                File defaultValue = new File(base, "lib");
                if (!home.getPath().equals(base.getPath()) && file.getPath().equals(defaultValue.getPath()) && !file.exists()) {
                    log.debug((Object)msg);
                } else {
                    log.warn((Object)msg);
                }
                return false;
            }
        } else if (!(type != IS_JAR || file.exists() && file.canRead())) {
            log.warn((Object)("Problem with JAR file [" + file + "], exists: [" + file.exists() + "], canRead: [" + file.canRead() + "]"));
            return false;
        }
        return true;
    }
}

