/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.jts;

import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.io.PolyshapeReader;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JtsPolyshapeReader
extends PolyshapeReader {
    protected final JtsSpatialContext ctx;

    public JtsPolyshapeReader(JtsSpatialContext ctx, SpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
    }

    @Override
    protected Shape makeCollection(List<? extends Shape> shapes) {
        Class<?> last = null;
        ArrayList<Object> geoms = new ArrayList<Object>(shapes.size());
        for (Shape shape : shapes) {
            if (last != null && last != shape.getClass()) {
                return super.makeCollection(shapes);
            }
            if (shape instanceof JtsGeometry) {
                geoms.add(((JtsGeometry)shape).getGeom());
            } else if (shape instanceof JtsPoint) {
                geoms.add(((JtsPoint)shape).getGeom());
            } else {
                return super.makeCollection(shapes);
            }
            last = shape.getClass();
        }
        Geometry result = this.ctx.getGeometryFactory().buildGeometry(geoms);
        if (result.getClass().equals(GeometryCollection.class)) {
            return super.makeCollection(shapes);
        }
        return this.ctx.makeShape(result);
    }

    protected CoordinateSequence coordseq(List<double[]> list) {
        CoordinateSequence seq = PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(list.size(), 2);
        for (int i = 0; i < list.size(); ++i) {
            double[] point = list.get(i);
            seq.setOrdinate(i, 0, point[0]);
            seq.setOrdinate(i, 1, point[1]);
        }
        return seq;
    }

    @Override
    protected Shape readPolygon(PolyshapeReader.XReader reader) throws IOException {
        GeometryFactory gf = this.ctx.getGeometryFactory();
        List<double[]> outer = reader.readPoints();
        LinearRing shell = gf.createLinearRing(this.coordseq(outer));
        LinearRing[] holes = null;
        if (!reader.isDone() && reader.peek() == 40) {
            ArrayList<LinearRing> list = new ArrayList<LinearRing>();
            while (reader.isEvent() && reader.peek() == 40) {
                reader.readKey();
                list.add(gf.createLinearRing(this.coordseq(reader.readPoints())));
            }
            holes = list.toArray(new LinearRing[list.size()]);
        }
        return this.ctx.makeShapeFromGeometry((Geometry)gf.createPolygon(shell, holes));
    }
}

