/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.morelikethis.MoreLikeThisFetchService;
import org.elasticsearch.search.internal.SearchContext;

public class MoreLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "mlt";
    private MoreLikeThisFetchService fetchService = null;

    @Inject(optional=true)
    public void setFetchService(@Nullable MoreLikeThisFetchService fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this", "moreLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        boolean useDefaultField;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        ArrayList<String> likeTexts = new ArrayList<String>();
        ArrayList<String> unlikeTexts = new ArrayList<String>();
        ArrayList<MoreLikeThisQueryBuilder.Item> likeItems = new ArrayList<MoreLikeThisQueryBuilder.Item>();
        ArrayList<MoreLikeThisQueryBuilder.Item> unlikeItems = new ArrayList<MoreLikeThisQueryBuilder.Item>();
        List<String> moreLikeFields = null;
        Object analyzer = null;
        boolean include = false;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.LIKE)) {
                    MoreLikeThisQueryParser.parseLikeField(parseContext, likeTexts, likeItems);
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.UNLIKE)) {
                    MoreLikeThisQueryParser.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.LIKE_TEXT)) {
                    likeTexts.add(parser.text());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MAX_QUERY_TERMS)) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MIN_TERM_FREQ)) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MIN_DOC_FREQ)) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MAX_DOC_FREQ)) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MIN_WORD_LENGTH)) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MAX_WORD_LENGTH)) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.ANALYZER)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.MINIMUM_SHOULD_MATCH)) {
                    mltQuery.setMinimumShouldMatch(parser.text());
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.BOOST_TERMS)) {
                    float boostFactor = parser.floatValue();
                    if (boostFactor == 0.0f) continue;
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(boostFactor);
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.INCLUDE)) {
                    include = parser.booleanValue();
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.FAIL_ON_UNSUPPORTED_FIELD)) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.FIELDS)) {
                    moreLikeFields = new LinkedList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String field = parser.text();
                        MappedFieldType fieldType = parseContext.fieldMapper(field);
                        moreLikeFields.add(fieldType == null ? field : fieldType.names().indexName());
                    }
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.LIKE)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryParser.parseLikeField(parseContext, likeTexts, likeItems);
                    }
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.UNLIKE)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryParser.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                    }
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.IDS)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException("ids array element should only contain ids");
                        }
                        likeItems.add(new MoreLikeThisQueryBuilder.Item(null, null, parser.text()));
                    }
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.DOCS)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new IllegalArgumentException("docs array element should include an object");
                        }
                        likeItems.add(MoreLikeThisQueryBuilder.Item.parse(parser, parseContext.parseFieldMatcher(), new MoreLikeThisQueryBuilder.Item()));
                    }
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, Field.STOP_WORDS)) {
                    HashSet stopWords = Sets.newHashSet();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        stopWords.add(parser.text());
                    }
                    mltQuery.setStopWords(stopWords);
                    continue;
                }
                throw new QueryParsingException(parseContext, "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (parseContext.parseFieldMatcher().match(currentFieldName, Field.LIKE)) {
                MoreLikeThisQueryParser.parseLikeField(parseContext, likeTexts, likeItems);
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, Field.UNLIKE)) {
                MoreLikeThisQueryParser.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                continue;
            }
            throw new QueryParsingException(parseContext, "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (likeTexts.isEmpty() && likeItems.isEmpty()) {
            throw new QueryParsingException(parseContext, "more_like_this requires 'like' to be specified", new Object[0]);
        }
        if (moreLikeFields != null && moreLikeFields.isEmpty()) {
            throw new QueryParsingException(parseContext, "more_like_this requires 'fields' to be non-empty", new Object[0]);
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer((Analyzer)analyzer);
        boolean bl = useDefaultField = moreLikeFields == null;
        if (useDefaultField) {
            moreLikeFields = Collections.singletonList(parseContext.defaultField());
        }
        MoreLikeThisQueryParser.removeUnsupportedFields(moreLikeFields, analyzer, failOnUnsupportedField);
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(Strings.EMPTY_ARRAY));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, mltQuery);
        }
        if (!likeTexts.isEmpty()) {
            mltQuery.setLikeText(likeTexts);
        }
        if (!unlikeTexts.isEmpty()) {
            mltQuery.setUnlikeText(unlikeTexts);
        }
        if (!likeItems.isEmpty()) {
            return this.handleItems(parseContext, mltQuery, likeItems, unlikeItems, include, moreLikeFields, useDefaultField);
        }
        return mltQuery;
    }

    private static void parseLikeField(QueryParseContext parseContext, List<String> texts, List<MoreLikeThisQueryBuilder.Item> items) throws IOException {
        XContentParser parser = parseContext.parser();
        if (parser.currentToken().isValue()) {
            texts.add(parser.text());
        } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            items.add(MoreLikeThisQueryBuilder.Item.parse(parser, parseContext.parseFieldMatcher(), new MoreLikeThisQueryBuilder.Item()));
        } else {
            throw new IllegalArgumentException("Content of 'like' parameter should either be a string or an object");
        }
    }

    private static List<String> removeUnsupportedFields(List<String> moreLikeFields, Analyzer analyzer, boolean failOnUnsupportedField) throws IOException {
        Iterator<String> it = moreLikeFields.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            if (Analysis.generatesCharacterTokenStream(analyzer, fieldName)) continue;
            if (failOnUnsupportedField) {
                throw new IllegalArgumentException("more_like_this doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            it.remove();
        }
        return moreLikeFields;
    }

    private Query handleItems(QueryParseContext parseContext, MoreLikeThisQuery mltQuery, List<MoreLikeThisQueryBuilder.Item> likeItems, List<MoreLikeThisQueryBuilder.Item> unlikeItems, boolean include, List<String> moreLikeFields, boolean useDefaultField) throws IOException {
        MultiTermVectorsResponse unlikeResponses;
        Fields[] unlikeFields;
        for (MoreLikeThisQueryBuilder.Item item : likeItems) {
            MoreLikeThisQueryParser.setDefaultIndexTypeFields(parseContext, item, moreLikeFields, useDefaultField);
        }
        for (MoreLikeThisQueryBuilder.Item item : unlikeItems) {
            MoreLikeThisQueryParser.setDefaultIndexTypeFields(parseContext, item, moreLikeFields, useDefaultField);
        }
        MultiTermVectorsResponse responses = this.fetchService.fetchResponse(likeItems, SearchContext.current());
        mltQuery.setLikeText(MoreLikeThisFetchService.getFieldsFor(responses));
        if (!unlikeItems.isEmpty() && (unlikeFields = MoreLikeThisFetchService.getFieldsFor(unlikeResponses = this.fetchService.fetchResponse(unlikeItems, SearchContext.current()))).length > 0) {
            mltQuery.setUnlikeText(unlikeFields);
        }
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add((Query)mltQuery, BooleanClause.Occur.SHOULD);
        if (!include) {
            MoreLikeThisQueryParser.handleExclude(boolQuery, likeItems);
        }
        return boolQuery;
    }

    private static void setDefaultIndexTypeFields(QueryParseContext parseContext, MoreLikeThisQueryBuilder.Item item, List<String> moreLikeFields, boolean useDefaultField) {
        if (item.index() == null) {
            item.index(parseContext.index().name());
        }
        if (item.type() == null) {
            if (parseContext.queryTypes().size() > 1) {
                throw new QueryParsingException(parseContext, "ambiguous type for item with id: " + item.id() + " and index: " + item.index(), new Object[0]);
            }
            item.type(parseContext.queryTypes().iterator().next());
        }
        if ((item.fields() == null || item.fields().length == 0) && item.doc() == null) {
            if (useDefaultField) {
                item.fields("*");
            } else {
                item.fields(moreLikeFields.toArray(new String[moreLikeFields.size()]));
            }
        }
    }

    private static void handleExclude(BooleanQuery boolQuery, List<MoreLikeThisQueryBuilder.Item> likeItems) {
        ArrayList<BytesRef> uids = new ArrayList<BytesRef>();
        for (MoreLikeThisQueryBuilder.Item item : likeItems) {
            if (item.doc() != null) continue;
            uids.add(Uid.createUidAsBytes(item.type(), item.id()));
        }
        if (!uids.isEmpty()) {
            TermsQuery query = new TermsQuery("_uid", uids.toArray(new BytesRef[0]));
            boolQuery.add((Query)query, BooleanClause.Occur.MUST_NOT);
        }
    }

    public static interface Field {
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField LIKE = new ParseField("like", new String[0]);
        public static final ParseField UNLIKE = new ParseField("unlike", new String[0]);
        public static final ParseField LIKE_TEXT = new ParseField("like_text", new String[0]).withAllDeprecated("like");
        public static final ParseField IDS = new ParseField("ids", new String[0]).withAllDeprecated("like");
        public static final ParseField DOCS = new ParseField("docs", new String[0]).withAllDeprecated("like");
        public static final ParseField MAX_QUERY_TERMS = new ParseField("max_query_terms", new String[0]);
        public static final ParseField MIN_TERM_FREQ = new ParseField("min_term_freq", new String[0]);
        public static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
        public static final ParseField MAX_DOC_FREQ = new ParseField("max_doc_freq", new String[0]);
        public static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", "min_word_len");
        public static final ParseField MAX_WORD_LENGTH = new ParseField("max_word_length", "max_word_len");
        public static final ParseField STOP_WORDS = new ParseField("stop_words", new String[0]);
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
        public static final ParseField BOOST_TERMS = new ParseField("boost_terms", new String[0]);
        public static final ParseField INCLUDE = new ParseField("include", new String[0]);
        public static final ParseField FAIL_ON_UNSUPPORTED_FIELD = new ParseField("fail_on_unsupported_field", new String[0]);
    }
}

