/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class RestGetSourceAction
extends BaseRestHandler {
    @Inject
    public RestGetSourceAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_source", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.operationThreaded(true);
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", null));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
            try {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse(channel, validationError));
            }
            catch (IOException e) {
                this.logger.error("Failed to send failure response", e, new Object[0]);
            }
        }
        client.get(getRequest, (ActionListener<GetResponse>)new RestResponseListener<GetResponse>(channel){

            @Override
            public RestResponse buildResponse(GetResponse response) throws Exception {
                XContentBuilder builder = this.channel.newBuilder(response.getSourceInternal(), false);
                if (!response.isExists()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                builder.rawValue(response.getSourceInternal());
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

