/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.ClassChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.FileUtils;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;
    private final FileOperations fileOperations;

    public RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter, FileOperations fileOperations) {
        this.sourceToNameConverter = sourceToNameConverter;
        this.fileOperations = fileOperations;
    }

    public RecompilationSpec provideRecompilationSpec(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, JarClasspathSnapshot jarClasspathSnapshot) {
        RecompilationSpec spec = new RecompilationSpec();
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(previousCompilation, this.sourceToNameConverter);
        ClassChangeProcessor classChangeProcessor = new ClassChangeProcessor(previousCompilation);
        JarChangeProcessor jarChangeProcessor = new JarChangeProcessor(this.fileOperations, jarClasspathSnapshot, previousCompilation);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, classChangeProcessor, jarChangeProcessor);
        inputs.outOfDate((Action)action);
        if (action.spec.getFullRebuildCause() != null) {
            return action.spec;
        }
        inputs.removed((Action)action);
        return action.spec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputChangeAction
    implements Action<InputFileDetails> {
        private final RecompilationSpec spec;
        private final JavaChangeProcessor javaChangeProcessor;
        private final ClassChangeProcessor classChangeProcessor;
        private final JarChangeProcessor jarChangeProcessor;

        public InputChangeAction(RecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, ClassChangeProcessor classChangeProcessor, JarChangeProcessor jarChangeProcessor) {
            this.spec = spec;
            this.javaChangeProcessor = javaChangeProcessor;
            this.classChangeProcessor = classChangeProcessor;
            this.jarChangeProcessor = jarChangeProcessor;
        }

        public void execute(InputFileDetails input) {
            if (this.spec.getFullRebuildCause() != null) {
                return;
            }
            if (FileUtils.hasExtension((File)input.getFile(), (String)".java")) {
                this.javaChangeProcessor.processChange(input, this.spec);
            } else if (FileUtils.hasExtension((File)input.getFile(), (String)".class")) {
                this.classChangeProcessor.processChange(input, this.spec);
            } else if (FileUtils.hasExtension((File)input.getFile(), (String)".jar")) {
                this.jarChangeProcessor.processChange(input, this.spec);
            }
        }
    }
}

