/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public class ErrorHandlingArtifactResolver
implements ArtifactResolver {
    private final ArtifactResolver resolver;

    public ErrorHandlingArtifactResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        try {
            this.resolver.resolveModuleArtifacts(component, artifactType, result);
        }
        catch (Throwable t) {
            result.failed(new ArtifactResolveException(component.getComponentId(), t));
        }
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage usage, BuildableArtifactSetResolveResult result) {
        try {
            this.resolver.resolveModuleArtifacts(component, usage, result);
        }
        catch (Throwable t) {
            result.failed(new ArtifactResolveException(component.getComponentId(), t));
        }
    }

    public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        try {
            this.resolver.resolveArtifact(artifact, moduleSource, result);
        }
        catch (Throwable t) {
            result.failed(new ArtifactResolveException(artifact.getId(), t));
        }
    }
}

