/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.BuildLogger;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionLogger;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.DependencyResolutionLogger;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NestedBuildTracker;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildProgressFilter;
import org.gradle.internal.progress.BuildProgressLogger;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;
import org.gradle.profile.ProfileEventAdapter;
import org.gradle.profile.ReportGeneratingProfileListener;
import org.gradle.util.DeprecationLogger;

public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final ServiceRegistry sharedServices;
    private final NestedBuildTracker tracker;
    private final BuildProgressLogger buildProgressLogger;

    public DefaultGradleLauncherFactory(ServiceRegistry sharedServices) {
        this.sharedServices = sharedServices;
        this.tracker = new NestedBuildTracker();
        ListenerManager listenerManager = (ListenerManager)sharedServices.get(ListenerManager.class);
        this.buildProgressLogger = new BuildProgressLogger((ProgressLoggerFactory)sharedServices.get(ProgressLoggerFactory.class));
        listenerManager.addListener((Object)new BuildProgressFilter(this.buildProgressLogger));
        listenerManager.useLogger((Object)new DependencyResolutionLogger((ProgressLoggerFactory)sharedServices.get(ProgressLoggerFactory.class)));
    }

    public void addListener(Object listener) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).addListener(listener);
    }

    public void removeListener(Object listener) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).removeListener(listener);
    }

    public GradleLauncher newInstance(StartParameter startParameter) {
        return this.newInstance(startParameter, this.sharedServices);
    }

    public GradleLauncher newInstance(StartParameter startParameter, ServiceRegistry parentRegistry) {
        BuildEventConsumer buildEventConsumer;
        BuildCancellationToken cancellationToken;
        DefaultBuildRequestMetaData requestMetaData;
        if (this.tracker.getCurrentBuild() != null) {
            ServiceRegistry services = this.tracker.getCurrentBuild().getServices();
            requestMetaData = new DefaultBuildRequestMetaData((BuildClientMetaData)services.get(BuildClientMetaData.class), System.currentTimeMillis());
            cancellationToken = (BuildCancellationToken)services.get(BuildCancellationToken.class);
            buildEventConsumer = (BuildEventConsumer)services.get(BuildEventConsumer.class);
        } else {
            requestMetaData = new DefaultBuildRequestMetaData(System.currentTimeMillis());
            cancellationToken = new DefaultBuildCancellationToken();
            buildEventConsumer = new NoOpBuildEventConsumer();
        }
        BuildScopeServices buildScopeServices = BuildScopeServices.singleSession(parentRegistry, startParameter);
        return this.doNewInstance(startParameter, cancellationToken, requestMetaData, buildEventConsumer, buildScopeServices);
    }

    public GradleLauncher newInstance(StartParameter startParameter, BuildRequestContext requestContext, ServiceRegistry parentRegistry) {
        assert (this.tracker.getCurrentBuild() == null);
        if (!(parentRegistry instanceof BuildSessionScopeServices)) {
            throw new IllegalArgumentException("Service registry must be of build session scope");
        }
        BuildScopeServices buildScopeServices = BuildScopeServices.forSession((BuildSessionScopeServices)parentRegistry);
        DefaultGradleLauncher launcher = this.doNewInstance(startParameter, requestContext.getCancellationToken(), requestContext, requestContext.getEventConsumer(), buildScopeServices);
        DeploymentRegistry deploymentRegistry = (DeploymentRegistry)parentRegistry.get(DeploymentRegistry.class);
        deploymentRegistry.onNewBuild(launcher.getGradle());
        return launcher;
    }

    private DefaultGradleLauncher doNewInstance(StartParameter startParameter, BuildCancellationToken cancellationToken, BuildRequestMetaData requestMetaData, BuildEventConsumer buildEventConsumer, BuildScopeServices serviceRegistry) {
        serviceRegistry.add(BuildRequestMetaData.class, requestMetaData);
        serviceRegistry.add(BuildClientMetaData.class, requestMetaData.getClient());
        serviceRegistry.add(BuildEventConsumer.class, buildEventConsumer);
        serviceRegistry.add(BuildCancellationToken.class, cancellationToken);
        ListenerManager listenerManager = (ListenerManager)serviceRegistry.get(ListenerManager.class);
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)serviceRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.setLevelInternal(startParameter.getLogLevel());
        loggingManager.addStandardOutputListener((StandardOutputListener)listenerManager.getBroadcaster(StandardOutputListener.class));
        loggingManager.addStandardErrorListener((StandardOutputListener)listenerManager.getBroadcaster(StandardOutputListener.class));
        LoggerProvider loggerProvider = this.tracker.getCurrentBuild() == null ? this.buildProgressLogger : LoggerProvider.NO_OP;
        listenerManager.useLogger((Object)new TaskExecutionLogger((ProgressLoggerFactory)serviceRegistry.get(ProgressLoggerFactory.class), loggerProvider));
        if (this.tracker.getCurrentBuild() == null) {
            listenerManager.useLogger((Object)new BuildLogger(Logging.getLogger(BuildLogger.class), (StyledTextOutputFactory)serviceRegistry.get(StyledTextOutputFactory.class), startParameter, requestMetaData));
        }
        listenerManager.addListener((Object)this.tracker);
        listenerManager.addListener(serviceRegistry.get(ProfileEventAdapter.class));
        if (startParameter.isProfile()) {
            listenerManager.addListener((Object)new ReportGeneratingProfileListener());
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener((Object)usageLocationReporter);
        DeprecationLogger.useLocationReporter((UsageLocationReporter)usageLocationReporter);
        GradleInternal gradle = (GradleInternal)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultGradle.class, new Object[]{this.tracker.getCurrentBuild(), startParameter, serviceRegistry.get(ServiceRegistryFactory.class)});
        return new DefaultGradleLauncher(gradle, (InitScriptHandler)serviceRegistry.get(InitScriptHandler.class), (SettingsLoader)serviceRegistry.get(SettingsLoader.class), (BuildConfigurer)serviceRegistry.get(BuildConfigurer.class), (ExceptionAnalyser)serviceRegistry.get(ExceptionAnalyser.class), loggingManager, gradle.getBuildListenerBroadcaster(), (ModelConfigurationListener)listenerManager.getBroadcaster(ModelConfigurationListener.class), (BuildCompletionListener)listenerManager.getBroadcaster(BuildCompletionListener.class), (BuildOperationExecutor)serviceRegistry.get(BuildOperationExecutor.class), (BuildConfigurationActionExecuter)gradle.getServices().get(BuildConfigurationActionExecuter.class), (BuildExecuter)gradle.getServices().get(BuildExecuter.class), serviceRegistry);
    }
}

