/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;

public class Clock {
    private long start;
    private TimeProvider timeProvider;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;

    public Clock() {
        this((TimeProvider)new TrueTimeProvider());
    }

    public Clock(long start) {
        this((TimeProvider)new TrueTimeProvider(), start);
    }

    protected Clock(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.reset();
    }

    protected Clock(TimeProvider timeProvider, long start) {
        this.timeProvider = timeProvider;
        this.start = start;
    }

    public String getTime() {
        long timeInMs = this.getTimeInMs();
        return Clock.prettyTime(timeInMs);
    }

    public long getTimeInMs() {
        return Math.max(this.timeProvider.getCurrentTime() - this.start, 0L);
    }

    public void reset() {
        this.start = this.timeProvider.getCurrentTime();
    }

    public long getStartTime() {
        return this.start;
    }

    public static String prettyTime(long timeInMs) {
        StringBuilder result = new StringBuilder();
        if (timeInMs > 3600000L) {
            result.append(timeInMs / 3600000L).append(" hrs ");
        }
        if (timeInMs > 60000L) {
            result.append(timeInMs % 3600000L / 60000L).append(" mins ");
        }
        result.append((double)(timeInMs % 60000L) / 1000.0).append(" secs");
        return result.toString();
    }
}

