/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class HistogramRed
extends AbstractRed {
    boolean[] computed;
    int tallied = 0;
    int[] bins = new int[256];

    public HistogramRed(CachableRed cachableRed) {
        super(cachableRed, null);
        int n = this.getNumXTiles() * this.getNumYTiles();
        this.computed = new boolean[n];
    }

    public void tallyTile(Raster raster) {
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int[] nArray = null;
        for (int i = n2; i < n2 + n4; ++i) {
            nArray = raster.getPixels(n, i, n3, 1, nArray);
            for (int j = 0; j < 3 * n3; ++j) {
                int n5 = nArray[j++] * 5;
                n5 += nArray[j++] * 9;
                int n6 = (n5 += nArray[j++] * 2) >> 4;
                this.bins[n6] = this.bins[n6] + 1;
            }
        }
        ++this.tallied;
    }

    public int[] getHistogram() {
        if (this.tallied == this.computed.length) {
            return this.bins;
        }
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        int n = cachableRed.getMinTileY();
        int n2 = cachableRed.getNumXTiles();
        int n3 = cachableRed.getMinTileX();
        for (int i = 0; i < cachableRed.getNumYTiles(); ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = j + n3 + i * n2;
                if (this.computed[n4]) continue;
                Raster raster = cachableRed.getTile(j + n3, i + n);
                this.tallyTile(raster);
                this.computed[n4] = true;
            }
        }
        return this.bins;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getTile(int n, int n2) {
        int n3 = n2 - this.getMinTileY();
        int n4 = n - this.getMinTileX();
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Raster raster = cachableRed.getTile(n, n2);
        int n5 = n4 + n3 * this.getNumXTiles();
        if (this.computed[n5]) {
            return raster;
        }
        this.tallyTile(raster);
        this.computed[n5] = true;
        return raster;
    }
}

