/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class Tile {
    public static final BufferedImage LOADING_IMAGE = Tile.loadImage("images/hourglass.png");
    public static final BufferedImage ERROR_IMAGE = Tile.loadImage("images/error.png");
    protected TileSource source;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected volatile boolean loaded;
    protected volatile boolean loading;
    protected volatile boolean error;
    protected String error_message;
    protected Map<String, String> metadata;

    public Tile(TileSource tileSource, int n, int n2, int n3) {
        this(tileSource, n, n2, n3, LOADING_IMAGE);
    }

    public Tile(TileSource tileSource, int n, int n2, int n3, BufferedImage bufferedImage) {
        this.source = tileSource;
        this.xtile = n;
        this.ytile = n2;
        this.zoom = n3;
        this.image = bufferedImage;
        this.key = Tile.getTileKey(tileSource, n, n2, n3);
    }

    private static BufferedImage loadImage(String string) {
        try {
            return ImageIO.read(JMapViewer.class.getResourceAsStream(string));
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void loadPlaceholderFromCache(TileCache tileCache) {
        final CachedCallable<BufferedImage> cachedCallable = new CachedCallable<BufferedImage>(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                return new BufferedImage(Tile.this.source.getTileSize(), Tile.this.source.getTileSize(), 1);
            }
        });
        for (int i = 1; i < 5; ++i) {
            int n;
            int n2;
            int n3;
            int n4 = this.zoom + i;
            if (i < 3 && n4 <= 22) {
                n3 = 1 << i;
                n2 = this.xtile << i;
                n = this.ytile << i;
                final double d = 1.0 / (double)n3;
                CachedCallable<Graphics2D> cachedCallable2 = new CachedCallable<Graphics2D>(new Callable<Graphics2D>(){

                    @Override
                    public Graphics2D call() throws Exception {
                        Graphics2D graphics2D = (Graphics2D)((BufferedImage)cachedCallable.call()).getGraphics();
                        graphics2D.setTransform(AffineTransform.getScaleInstance(d, d));
                        return graphics2D;
                    }
                });
                int n5 = 0;
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        Tile tile = tileCache.getTile(this.source, n2 + j, n + k, n4);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++n5;
                        tile.paint(cachedCallable2.call(), j * this.source.getTileSize(), k * this.source.getTileSize());
                    }
                }
                if (n5 == n3 * n3) {
                    this.image = cachedCallable.call();
                    return;
                }
            }
            if ((n3 = this.zoom - i) < 0) continue;
            n2 = this.xtile >> i;
            n = this.ytile >> i;
            final int n6 = 1 << i;
            final double d = n6;
            CachedCallable<Graphics2D> cachedCallable3 = new CachedCallable<Graphics2D>(new Callable<Graphics2D>(){

                @Override
                public Graphics2D call() throws Exception {
                    Graphics2D graphics2D = (Graphics2D)((BufferedImage)cachedCallable.call()).getGraphics();
                    AffineTransform affineTransform = new AffineTransform();
                    int n = Tile.this.xtile % n6 * Tile.this.source.getTileSize();
                    int n2 = Tile.this.ytile % n6 * Tile.this.source.getTileSize();
                    affineTransform.setTransform(d, 0.0, 0.0, d, -n, -n2);
                    graphics2D.setTransform(affineTransform);
                    return graphics2D;
                }
            });
            Tile tile = tileCache.getTile(this.source, n2, n, n3);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(cachedCallable3.call(), 0, 0);
            this.image = cachedCallable.call();
            return;
        }
    }

    public TileSource getSource() {
        return this.source;
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void loadImage(InputStream inputStream) throws IOException {
        this.image = ImageIO.read(inputStream);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public String getUrl() throws IOException {
        return this.source.getTileUrl(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, n, n2, null);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, n, n2, n3, n4, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.xtile;
        n = 31 * n + this.ytile;
        n = 31 * n + this.zoom;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tile tile = (Tile)object;
        if (this.xtile != tile.xtile) {
            return false;
        }
        if (this.ytile != tile.ytile) {
            return false;
        }
        if (this.zoom != tile.zoom) {
            return false;
        }
        return this.getTileSource().equals(tile.getTileSource());
    }

    public static String getTileKey(TileSource tileSource, int n, int n2, int n3) {
        return n3 + "/" + n + "/" + n2 + "@" + tileSource.getName();
    }

    public String getStatus() {
        if (this.error) {
            return "error";
        }
        if (this.loaded) {
            return "loaded";
        }
        if (this.loading) {
            return "loading";
        }
        return "new";
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void setError(Exception exception) {
        this.setError(exception.toString());
    }

    public void setError(String string) {
        this.error = true;
        this.setImage(ERROR_IMAGE);
        this.error_message = string;
    }

    public void putValue(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            if (this.metadata != null) {
                this.metadata.remove(string);
            }
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(string, string2);
    }

    public String getValue(String string) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(string);
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        return this.metadata;
    }

    public void initLoading() {
        this.error = false;
        this.loading = true;
    }

    public void finishLoading() {
        this.loading = false;
        this.loaded = true;
    }

    public TileSource getTileSource() {
        return this.source;
    }

    public void loadingCanceled() {
        this.loading = false;
        this.loaded = false;
    }

    private static class CachedCallable<V>
    implements Callable<V> {
        private V result;
        private Callable<V> callable;

        CachedCallable(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public synchronized V call() {
            try {
                if (this.result == null) {
                    this.result = this.callable.call();
                }
                return this.result;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

