/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.audio.AudioPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.remotecontrol.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreference;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTestsPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener,
ExpertToggleAction.ExpertModeChangeListener,
ChangeListener {
    private final transient List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> settingsFactories = new LinkedList<PreferenceSettingFactory>();
    private static final PreferenceSettingFactory advancedPreferenceFactory = new AdvancedPreference.Factory();
    private final transient List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final transient List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    final transient List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting) {
        return this.createPreferenceTab(tabPreferenceSetting, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting, boolean bl) {
        PreferencePanel preferencePanel;
        CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting, "caller");
        JComponent jComponent = preferencePanel = new PreferencePanel(tabPreferenceSetting);
        if (bl) {
            PreferenceScrollPane preferenceScrollPane = new PreferenceScrollPane(preferencePanel);
            jComponent = preferenceScrollPane;
        }
        this.tabs.add((PreferenceTab)((Object)jComponent));
        return preferencePanel;
    }

    private void selectTabBy(TabIdentifier tabIdentifier, Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            PreferenceTab preferenceTab;
            Component component = this.getComponentAt(i);
            if (!(component instanceof PreferenceTab) || !tabIdentifier.identify((preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting(), object)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void selectTabByName(String string) {
        this.selectTabBy(new TabIdentifier(){

            @Override
            public boolean identify(TabPreferenceSetting tabPreferenceSetting, Object object) {
                return object != null && tabPreferenceSetting != null && tabPreferenceSetting.getIconName() != null && object.equals(tabPreferenceSetting.getIconName());
            }
        }, string);
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy(new TabIdentifier(){

            @Override
            public boolean identify(TabPreferenceSetting tabPreferenceSetting, Object object) {
                return tabPreferenceSetting.getClass().isAssignableFrom((Class)object);
            }
        }, clazz);
    }

    public boolean selectSubTabByPref(Class<? extends SubPreferenceSetting> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isInstance(preferenceSetting)) continue;
            SubPreferenceSetting subPreferenceSetting = (SubPreferenceSetting)preferenceSetting;
            final TabPreferenceSetting tabPreferenceSetting = subPreferenceSetting.getTabPreferenceSetting(this);
            this.selectTabBy(new TabIdentifier(){

                @Override
                public boolean identify(TabPreferenceSetting tabPreferenceSetting2, Object object) {
                    return tabPreferenceSetting2.equals(tabPreferenceSetting);
                }
            }, null);
            return tabPreferenceSetting.selectSubTab(subPreferenceSetting);
        }
        return false;
    }

    public DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public MapPreference getMapPreference() {
        return this.getSetting(MapPreference.class);
    }

    public PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public ShortcutPreference getShortcutPreference() {
        return this.getSetting(ShortcutPreference.class);
    }

    public ServerAccessPreference getServerPreference() {
        return this.getSetting(ServerAccessPreference.class);
    }

    public ValidatorPreference getValidatorPreference() {
        return this.getSetting(ValidatorPreference.class);
    }

    public void savePreferences() {
        PluginPreference pluginPreference = this.getPluginPreference();
        Set<PluginInformation> set = pluginPreference.getPluginsScheduledForUpdateOrDownload();
        PluginDownloadTask pluginDownloadTask = set != null && !set.isEmpty() ? new PluginDownloadTask((Component)this, set, I18n.tr("Download plugins", new Object[0])) : null;
        final PluginDownloadAfterTask pluginDownloadAfterTask = new PluginDownloadAfterTask(pluginPreference, pluginDownloadTask, set);
        if (pluginDownloadTask != null) {
            Main.worker.submit(pluginDownloadTask);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(pluginDownloadAfterTask);
                }
            });
        } else {
            pluginDownloadAfterTask.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
        super.getModel().addChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        ArrayList<PreferenceSettingFactory> arrayList = new ArrayList<PreferenceSettingFactory>(settingsFactories);
        arrayList.addAll(PluginHandler.getPreferenceSetting());
        arrayList.add(advancedPreferenceFactory);
        for (PreferenceSettingFactory preferenceSettingFactory : arrayList) {
            PreferenceSetting preferenceSetting;
            if (preferenceSettingFactory == null || (preferenceSetting = preferenceSettingFactory.createPreferenceSetting()) == null) continue;
            this.settings.add(preferenceSetting);
        }
        this.addGUITabs(false);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting) {
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertGUITabsForSetting(icon, tabPreferenceSetting, this.getTabCount());
        }
    }

    private void insertGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting, int n) {
        int n2 = n;
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertTab(null, icon, preferenceTab.getComponent(), tabPreferenceSetting.getTooltip(), n2++);
        }
    }

    private void addGUITabs(boolean bl) {
        boolean bl2 = ExpertToggleAction.isExpert();
        Component component = this.getSelectedComponent();
        if (bl) {
            this.removeAll();
        }
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (preferenceSetting instanceof TabPreferenceSetting) {
                TabPreferenceSetting tabPreferenceSetting = (TabPreferenceSetting)preferenceSetting;
                if (!bl2 && tabPreferenceSetting.isExpert()) continue;
                String string = tabPreferenceSetting.getIconName();
                ImageIcon imageIcon = null;
                if (string != null && !string.isEmpty()) {
                    imageIcon = ImageProvider.get("preferences", string, ImageProvider.ImageSizes.SETTINGS_TAB);
                }
                if (this.settingsInitialized.contains(tabPreferenceSetting)) {
                    this.addGUITabsForSetting(imageIcon, tabPreferenceSetting);
                    continue;
                }
                this.addTab(null, imageIcon, new PreferencePanel(tabPreferenceSetting), tabPreferenceSetting.getTooltip());
                continue;
            }
            if (preferenceSetting instanceof SubPreferenceSetting) continue;
            Main.warn("Ignoring preferences " + preferenceSetting);
        }
        try {
            if (component != null) {
                this.setSelectedComponent(component);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.warn(illegalArgumentException);
        }
    }

    @Override
    public void expertChanged(boolean bl) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (super.indexAtLocation(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y) < 0) {
            return;
        }
        int n = super.getSelectedIndex() + mouseWheelEvent.getWheelRotation();
        n = n < 0 ? 0 : n;
        n = n >= super.getTabCount() ? super.getTabCount() - 1 : n;
        super.setSelectedIndex(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        PreferenceTab preferenceTab;
        TabPreferenceSetting tabPreferenceSetting;
        int n = this.getSelectedIndex();
        Component component = this.getSelectedComponent();
        if (n > -1 && component instanceof PreferenceTab && !this.settingsInitialized.contains(tabPreferenceSetting = (preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting())) {
            try {
                this.getModel().removeChangeListener(this);
                tabPreferenceSetting.addGui(this);
                for (PreferenceSetting preferenceSetting : this.settings) {
                    SubPreferenceSetting subPreferenceSetting;
                    if (!(preferenceSetting instanceof SubPreferenceSetting) || (subPreferenceSetting = (SubPreferenceSetting)preferenceSetting).getTabPreferenceSetting(this) != tabPreferenceSetting) continue;
                    try {
                        subPreferenceSetting.addGui(this);
                    }
                    catch (SecurityException securityException) {
                        Main.error(securityException);
                    }
                    catch (RuntimeException runtimeException) {
                        BugReportExceptionHandler.handleException(runtimeException);
                    }
                    finally {
                        this.settingsInitialized.add(subPreferenceSetting);
                    }
                }
                Icon icon = this.getIconAt(n);
                this.remove(n);
                this.insertGUITabsForSetting(icon, tabPreferenceSetting, n);
                this.setSelectedIndex(n);
            }
            catch (SecurityException securityException) {
                Main.error(securityException);
            }
            catch (RuntimeException runtimeException) {
                BugReportExceptionHandler.handleException(runtimeException);
            }
            finally {
                this.settingsInitialized.add(tabPreferenceSetting);
                this.getModel().addChangeListener(this);
            }
        }
    }

    static {
        settingsFactories.add(new DisplayPreference.Factory());
        settingsFactories.add(new DrawingPreference.Factory());
        settingsFactories.add(new ColorPreference.Factory());
        settingsFactories.add(new LafPreference.Factory());
        settingsFactories.add(new LanguagePreference.Factory());
        settingsFactories.add(new ServerAccessPreference.Factory());
        settingsFactories.add(new AuthenticationPreference.Factory());
        settingsFactories.add(new ProxyPreference.Factory());
        settingsFactories.add(new OverpassServerPreference.Factory());
        settingsFactories.add(new MapPreference.Factory());
        settingsFactories.add(new ProjectionPreference.Factory());
        settingsFactories.add(new MapPaintPreference.Factory());
        settingsFactories.add(new TaggingPresetPreference.Factory());
        settingsFactories.add(new BackupPreference.Factory());
        settingsFactories.add(new PluginPreference.Factory());
        settingsFactories.add(Main.toolbar);
        settingsFactories.add(new AudioPreference.Factory());
        settingsFactories.add(new ShortcutPreference.Factory());
        settingsFactories.add(new ValidatorPreference.Factory());
        settingsFactories.add(new ValidatorTestsPreference.Factory());
        settingsFactories.add(new ValidatorTagCheckerRulesPreference.Factory());
        settingsFactories.add(new RemoteControlPreference.Factory());
        settingsFactories.add(new ImageryPreference.Factory());
    }

    private static interface TabIdentifier {
        public boolean identify(TabPreferenceSetting var1, Object var2);
    }

    public static final class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(Component component, TabPreferenceSetting tabPreferenceSetting) {
            super(component);
            this.preferenceSetting = tabPreferenceSetting;
        }

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            this(preferencePanel.getComponent(), preferencePanel.getTabPreferenceSetting());
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    public static final class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting tabPreferenceSetting) {
            super(new GridBagLayout());
            CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting);
            this.preferenceSetting = tabPreferenceSetting;
            this.buildPanel();
        }

        protected void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)new JLabel(this.preferenceSetting.getTitle()), GBC.eol().insets(0, 5, 0, 10).anchor(18));
            JLabel jLabel = new JLabel("<html>" + this.preferenceSetting.getDescription() + "</html>");
            jLabel.setFont(jLabel.getFont().deriveFont(2));
            this.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }

    private final class PluginDownloadAfterTask
    implements Runnable {
        private final PluginPreference preference;
        private final PluginDownloadTask task;
        private final Set<PluginInformation> toDownload;

        private PluginDownloadAfterTask(PluginPreference pluginPreference, PluginDownloadTask pluginDownloadTask, Set<PluginInformation> set) {
            this.preference = pluginPreference;
            this.task = pluginDownloadTask;
            this.toDownload = set;
        }

        @Override
        public void run() {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray22;
            boolean bl = false;
            for (HelpAwareOptionPane.ButtonSpec[] buttonSpecArray22 : PreferenceTabbedPane.this.settingsInitialized) {
                if (!buttonSpecArray22.ok()) continue;
                bl = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (this.task != null && !this.task.isCanceled()) {
                PluginHandler.refreshLocalUpdatedPluginInfo(this.task.getDownloadedPlugins());
                stringBuilder.append(PluginPreference.buildDownloadSummary(this.task));
            }
            if (bl) {
                stringBuilder.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                stringBuilder.append("<br/><br/>");
                stringBuilder.append(I18n.tr("Would you like to restart now?", new Object[0]));
            }
            stringBuilder.append("</html>");
            if (bl) {
                buttonSpecArray22 = RestartAction.getButtonSpecs();
                if (0 == HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuilder.toString(), I18n.tr("Restart", new Object[0]), 1, null, buttonSpecArray22, buttonSpecArray22[0], null)) {
                    Main.main.menu.restart.actionPerformed(null);
                }
            } else if (this.task != null && !this.task.isCanceled()) {
                JOptionPane.showMessageDialog(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
            }
            buttonSpecArray22 = this.preference.getNewlyActivatedPlugins();
            if (buttonSpecArray22 != null) {
                boolean bl2;
                Collection<PluginInformation> collection = null;
                if (this.task != null && !this.task.isCanceled()) {
                    collection = this.task.getDownloadedPlugins();
                }
                ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>();
                for (HelpAwareOptionPane.ButtonSpec buttonSpec : buttonSpecArray22) {
                    if (this.toDownload.contains(buttonSpec) && collection != null && !collection.contains(buttonSpec) || !((PluginInformation)((Object)buttonSpec)).canloadatruntime) continue;
                    arrayList.add((PluginInformation)((Object)buttonSpec));
                }
                HashSet hashSet = new HashSet(arrayList);
                for (PluginProxy object : PluginHandler.pluginList) {
                    hashSet.add(object.getPluginInformation());
                }
                do {
                    bl2 = false;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        if (PluginHandler.checkRequiredPluginsPreconditions(null, hashSet, (PluginInformation)iterator.next(), bl)) continue;
                        iterator.remove();
                        bl2 = true;
                    }
                } while (bl2);
                if (!arrayList.isEmpty()) {
                    PluginHandler.loadPlugins(PreferenceTabbedPane.this, arrayList, null);
                }
            }
            Main.parent.repaint();
        }
    }
}

